/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.perf.GradeModeFactory;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IRank;
import com.kingdee.eas.hr.perf.IRankGroup;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankGroupCollection;
import com.kingdee.eas.hr.perf.RankGroupFactory;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.client.AbstractRankGroupListUI;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.RankEditUI;
import com.kingdee.eas.hr.perf.client.RankGroupEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RankGroupListUI
extends AbstractRankGroupListUI {
    private static final Logger logger = CoreUIObject.getLogger(RankGroupListUI.class);
    private static final Icon ELEM_ICON = EASResource.getIcon((String)"imgTree_folder_leaf");
    private boolean serialChanged = false;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private KDTreeNode root = new KDTreeNode((Object)"");
    private RealModeIDList idList = null;
    private static final String invalidID = "%eas!%";

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemAddGroup.setAccelerator(KeyStroke.getKeyStroke("ctrl alt N"));
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.tblMain.setColumnMoveable(true);
        this.initUI();
        this.initTree();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RankFactory.getRemoteInstance();
    }

    protected ICoreBase getGroupInterface() throws Exception {
        return RankGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return RankEditUI.class.getName();
    }

    protected String getGroupEditUIName() {
        return RankGroupEditUI.class.getName();
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private void initTree() throws Exception {
        DefaultTreeModel model = (DefaultTreeModel)this.treeGroup.getModel();
        if (model.getRoot() != null) {
            this.treeGroup.removeAllChildrenFromParent((MutableTreeNode)model.getRoot());
        }
        model.setRoot((TreeNode)this.root);
        this.treeGroup.setRootVisible(false);
        IRankGroup iRankGroup = (IRankGroup)this.getGroupInterface();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("createTime");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        viewInfo.put("sorter", (Object)sorter);
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        FilterInfo filter = new FilterInfo();
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)invalidID));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add("gradeMode.id");
        sic.add("gradeMode.name");
        sic.add("gradeMode.minGrade");
        sic.add("gradeMode.maxGrade");
        RankGroupCollection groupCollection = iRankGroup.getRankGroupCollection(viewInfo);
        if (groupCollection == null || groupCollection.size() == 0) {
            return;
        }
        KDTreeNode child = null;
        RankGroupInfo childInfo = null;
        this.idList = new RealModeIDList();
        int n = groupCollection.size();
        for (int i = 0; i < n; ++i) {
            childInfo = groupCollection.get(i);
            child = new KDTreeNode((Object)childInfo);
            this.root.add((MutableTreeNode)child);
            this.idList.add(childInfo.getId().toString());
        }
        this.treeGroup.expandAllNodes(true, (TreeNode)this.root);
        this.treeGroup.setSelectionRow(0);
        this.buildListFilter();
    }

    private void fillGroupField() throws Exception {
        RankGroupInfo selectedInfo = this.getSelectedRankGroup();
        if (selectedInfo != null) {
            this.txtNumber.setText(selectedInfo.getNumber());
            this.txtName.setText(selectedInfo.getName());
            this.txtGradeMode.setText(this.getGradeModeName());
        } else {
            this.txtNumber.setText(null);
            this.txtName.setText(null);
            this.txtGradeMode.setText(null);
        }
    }

    private void refreshGroupField() throws Exception {
        RankGroupInfo newInfo;
        RankGroupInfo selectedInfo = this.getSelectedRankGroup();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("gradeMode.id");
        sic.add("gradeMode.name");
        sic.add("gradeMode.minGrade");
        sic.add("gradeMode.maxGrade");
        ObjectUuidPK pk = new ObjectUuidPK(selectedInfo.getId().toString());
        selectedInfo = newInfo = (RankGroupInfo)RankGroupFactory.getRemoteInstance().getValue((IObjectPK)pk, sic);
        if (selectedInfo != null) {
            this.txtNumber.setText(selectedInfo.getNumber());
            this.txtName.setText(selectedInfo.getName());
            this.txtGradeMode.setText(selectedInfo.getGradeMode().getName());
        }
    }

    @Override
    protected void treeGroup_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.getSelectedRankGroup() != null) {
            this.fillGroupField();
            this.buildListFilter();
        } else {
            this.fillGroupField();
        }
        this.execQuery();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        RankGroupInfo group = this.getSelectedRankGroup();
        uiContext.put((Object)"ParentNode", (Object)group);
    }

    private String getGradeModeName() throws Exception {
        RankGroupInfo group = this.getSelectedRankGroup();
        if (group == null) {
            return null;
        }
        String id = group.getGradeMode().getId().toString();
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        GradeModeInfo info = (GradeModeInfo)GradeModeFactory.getRemoteInstance().getValue((IObjectPK)pk);
        return info.toString();
    }

    private void buildListFilter() throws Exception {
        RankGroupInfo groupObject = this.getSelectedRankGroup();
        FilterInfo filter = new FilterInfo();
        String id = null;
        if (groupObject != null) {
            id = groupObject.getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)id, CompareType.EQUALS));
        FilterInfo newfilterInfo = new FilterInfo();
        newfilterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        filter.mergeFilter(newfilterInfo, "and");
        this.mainQuery.setFilter(filter);
    }

    protected void refresh(ActionEvent e) throws Exception {
        Object srcObj = null;
        Object action = null;
        if (e != null) {
            srcObj = e.getSource();
        }
        if (srcObj.equals(this.btnGroupAddNew) || srcObj.equals(this.btnGroupEdit) || srcObj.equals(this.btnGroupRemove) || srcObj.equals(this.btnGroupView) || srcObj.equals(this.menuItemAddGroup) || srcObj.equals(this.menuItemGroupEdit) || srcObj.equals(this.menuItemGroupView) || srcObj.equals(this.menuItemGropuRemove)) {
            this.initTree();
        } else {
            super.refresh(e);
        }
    }

    @Override
    public void actionMoveUP_actionPerformed(ActionEvent e) throws Exception {
        int i;
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        String id = this.getSelectedGroupKeyValue();
        if (this.isGroupUsed(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"groupUsedCanNotMove"));
            return;
        }
        KDTSelectManager kdtManager = this.tblMain.getSelectManager();
        int top = kdtManager.get().getTop();
        if (top == 0) {
            return;
        }
        this.serialChanged = true;
        int cols = this.tblMain.getColumnCount();
        ArrayList<Object> temp = new ArrayList<Object>(cols);
        IRow srcRow = this.tblMain.getRow(top);
        IRow destRow = this.tblMain.getRow(top - 1);
        ICell cell = null;
        for (i = 0; i < cols; ++i) {
            cell = destRow.getCell(i);
            temp.add(cell.getValue());
            cell.setValue(srcRow.getCell(i).getValue());
        }
        for (i = 0; i < cols; ++i) {
            srcRow.getCell(i).setValue(temp.get(i));
        }
        kdtManager.select(top - 1, 0, top - 1, cols);
        this.tblMain.validate();
        this.actionConfirm_actionPerformed(null);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        int i;
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        String id = this.getSelectedGroupKeyValue();
        if (this.isGroupUsed(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"groupUsedCanNotMove"));
            return;
        }
        KDTSelectManager kdtManager = this.tblMain.getSelectManager();
        int top = kdtManager.get().getTop();
        if (top >= this.tblMain.getRowCount() - 1) {
            return;
        }
        this.serialChanged = true;
        int cols = this.tblMain.getColumnCount();
        ArrayList<Object> temp = new ArrayList<Object>(cols);
        IRow srcRow = this.tblMain.getRow(top);
        IRow destRow = this.tblMain.getRow(top + 1);
        ICell cell = null;
        for (i = 0; i < cols; ++i) {
            cell = destRow.getCell(i);
            temp.add(cell.getValue());
            cell.setValue(srcRow.getCell(i).getValue());
        }
        for (i = 0; i < cols; ++i) {
            srcRow.getCell(i).setValue(temp.get(i));
        }
        kdtManager.select(top + 1, 0, top + 1, cols);
        this.tblMain.validate();
        this.actionConfirm_actionPerformed(null);
    }

    private void initUI() {
        JButton btnMoveUP = this.kctRank.add((Action)((Object)this.actionMoveUP));
        btnMoveUP.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionMoveUP), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        btnMoveUP.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        btnMoveUP.setToolTipText(EASResource.getString((String)RES, (String)"moveUp"));
        btnMoveUP.setText(EASResource.getString((String)RES, (String)"moveUp"));
        JButton btnMoveDown = this.kctRank.add((Action)((Object)this.actionMoveDown));
        btnMoveDown.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionMoveDown), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        btnMoveDown.setToolTipText(EASResource.getString((String)RES, (String)"moveDown"));
        btnMoveDown.setText(EASResource.getString((String)RES, (String)"moveDown"));
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        if (!this.serialChanged) {
            return;
        }
        IRow row = null;
        ICell cell = null;
        Object info = null;
        IRank iRank = (IRank)this.getBizInterface();
        String[] idList = new String[this.tblMain.getRowCount()];
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String id;
            row = this.tblMain.getRow(i);
            cell = row.getCell(this.getKeyFieldName());
            idList[i] = id = cell.getValue().toString();
        }
        iRank.updateSerial(idList);
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeGroup.getLastSelectedPathComponent();
    }

    protected RankGroupInfo getSelectedRankGroup() {
        KDTreeNode node = (KDTreeNode)this.treeGroup.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object obj = node.getUserObject();
        if (obj != null && obj instanceof RankGroupInfo) {
            return (RankGroupInfo)obj;
        }
        return null;
    }

    protected String getSelectedGroupKeyValue() {
        RankGroupInfo group = this.getSelectedRankGroup();
        if (group == null) {
            return null;
        }
        return group.getId().toString();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemAddGroup.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.menuItemGroupView.setIcon(EASResource.getIcon((String)"imgTree_view"));
        this.treeView.getControlPane().add((Component)this.btnGroupAddNew);
        this.treeView.getControlPane().add((Component)this.btnGroupView);
        this.treeView.getControlPane().add((Component)this.btnGroupEdit);
        this.treeView.getControlPane().add((Component)this.btnGroupRemove);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnGroupAddNew.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnGroupAddNew.setFactType(1);
        this.btnGroupAddNew.setText(null);
        this.btnGroupAddNew.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.btnGroupView.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnGroupView.setFactType(1);
        this.btnGroupView.setText(null);
        this.btnGroupView.setIcon(EASResource.getIcon((String)"imgTree_view"));
        this.btnGroupEdit.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnGroupEdit.setFactType(1);
        this.btnGroupEdit.setText(null);
        this.btnGroupEdit.setIcon(EASResource.getIcon((String)"imgTree_edit"));
        this.btnGroupRemove.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnGroupRemove.setFactType(1);
        this.btnGroupRemove.setText(null);
        this.btnGroupRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.btnGroupRemove.setBorderPainted(true);
    }

    private boolean isGroupUsed(String groupID) throws Exception {
        return RankGroupFactory.getRemoteInstance().isRefByOther(groupID);
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getGroupEditUIModal()).create(this.getGroupEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        RankGroupEditUI userUI = (RankGroupEditUI)uiWindow.getUIObject();
        if (this.getGroupEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory") && userUI.isSaved()) {
            this.initTree();
            int lastRowIndex = this.treeGroup.getRowCount() - 1;
            this.treeGroup.setSelectionRow(lastRowIndex);
            this.treeGroup_valueChanged(null);
        }
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedGroupKeyValue();
        if (id == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedGroupKeyValue());
        uiContext.put((Object)"IDList", (Object)this.idList);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getGroupEditUIModal()).create(this.getGroupEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedGroupKeyValue();
        if (id == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedGroupKeyValue());
        uiContext.put((Object)"IDList", (Object)this.idList);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getGroupEditUIModal()).create(this.getGroupEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedGroupKeyValue();
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IRankGroup iRankGroup = RankGroupFactory.getRemoteInstance();
        if (this.isGroupUsed(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupUsed"));
            return;
        }
        if (super.confirmRemove()) {
            iRankGroup.delete((IObjectPK)pk);
            this.refresh(e);
        }
        int lastRowIndex = this.treeGroup.getRowCount() - 1;
        this.treeGroup.setSelectionRow(lastRowIndex);
        this.treeGroup_valueChanged(null);
    }

    @Override
    protected void treeGroup_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnGroupView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedRankGroup() == null) {
            return;
        }
        String id = this.getSelectedGroupKeyValue();
        if (this.isGroupUsed(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupUsedAddNew"));
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedGroupKeyValue();
        if (id == null) {
            super.checkSelected();
            return;
        }
        if (this.isGroupUsed(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupUsedRemove"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedGroupKeyValue();
        if (id == null) {
            super.checkSelected();
            return;
        }
        if (this.isGroupUsed(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupUsedEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)invalidID));
        }
        return filter;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor iqec = super.getQueryExecutor(queryPK, viewInfo);
        iqec.option().isAutoIgnoreZero = false;
        return iqec;
    }

    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        RequestContext req = super.prepareActionAddNew(itemAction);
        req.setClassName("com.kingdee.eas.hr.perf.app.RankGroupListUIHandler");
        if (this.getSelectedRankGroup() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noGroupExist"));
            return req;
        }
        String id = this.getSelectedGroupKeyValue();
        req.put("groupID", (Object)id);
        return req;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext request = new RequestContext();
        postman.setRequestContext((Serializable)request);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("createTime");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        viewInfo.put("sorter", (Object)sorter);
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        FilterInfo filter = new FilterInfo();
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)invalidID));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add("gradeMode.id");
        sic.add("gradeMode.name");
        sic.add("gradeMode.minGrade");
        sic.add("gradeMode.maxGrade");
        request.put("groupEntityViewInfo", (Object)viewInfo);
        postman.setRequestContext((Serializable)request);
        return postman;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public boolean isPrepareActionGroupAddNew() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isPrepareActionQuery() {
        return true;
    }

    public void initUserConfig() {
    }
}

