/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.perf.EvaluResultItemEnum;
import com.kingdee.eas.hr.perf.IReferenceItem;
import com.kingdee.eas.hr.perf.ReferenceItemFactory;
import com.kingdee.eas.hr.perf.ReferenceItemInfo;
import com.kingdee.eas.hr.perf.client.AbstractReferenceItemEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ReferenceItemEditUI
extends AbstractReferenceItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReferenceItemEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final String MACHINE = "0";
    private static final String USER = "1";

    public ReferenceItemEditUI() throws Exception {
        this.comboRefType.setActionCommand(MACHINE);
        this.comboRefType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.hr.perf.EvaluResultItemEnum").toArray());
        this.comboRefType.setActionCommand(USER);
        this.comboCmpItem.setRequired(true);
        this.comboRefType.setRequired(true);
    }

    protected IObjectValue createNewData() {
        ReferenceItemInfo ret = new ReferenceItemInfo();
        ret.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReferenceItemFactory.getRemoteInstance();
    }

    private void initCmpItemComboBox(ItemDataTypeEnum dataType) throws Exception {
        this.comboCmpItem.removeAllItems();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)"FPRM"));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        CmpItemCollection cmpItemcoll = iCmpItem.getCmpItemCollection(viewInfo);
        if (cmpItemcoll != null && cmpItemcoll.size() > 0) {
            this.comboCmpItem.addItems(cmpItemcoll.toArray());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.comboRefType.setActionCommand(MACHINE);
            this.comboRefType.setSelectedItem(null);
            this.comboRefType.setActionCommand(USER);
        }
    }

    private void restoreCmpItemInfo() {
        EvaluResultItemEnum itemEnum = this.editData.getRefType();
        int n = this.comboRefType.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!itemEnum.equals((Object)((EvaluResultItemEnum)((Object)this.comboRefType.getItemAt(i))))) continue;
            this.comboRefType.setSelectedIndex(i);
            break;
        }
        CmpItemInfo cmpItem = this.editData.getCmpItem();
        if (this.comboCmpItem.getItemCount() == 0) {
            this.comboCmpItem.addItem((Object)cmpItem);
        }
        int n2 = this.comboCmpItem.getItemCount();
        for (int i = 0; i < n2; ++i) {
            if (!cmpItem.getId().equals((Object)((CmpItemInfo)this.comboCmpItem.getItemAt(i)).getId())) continue;
            this.comboCmpItem.setSelectedIndex(i);
            break;
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.comboRefType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"evaluResultItemNull"));
            this.comboRefType.requestFocus();
            SysUtil.abort();
        }
        IReferenceItem iri = ReferenceItemFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("refType", (Object)new Integer(((EvaluResultItemEnum)((Object)this.comboRefType.getSelectedItem())).getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        if (iri.exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"evaluResultItemDUP"));
            this.comboRefType.requestFocus();
            SysUtil.abort();
        }
        if (this.comboCmpItem.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"cmpItemNull"));
            this.comboCmpItem.requestFocus();
            SysUtil.abort();
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpItem.id", (Object)((CmpItemInfo)this.comboCmpItem.getSelectedItem()).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        if (iri.exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"cmpItemDUP"));
            this.comboCmpItem.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("cmpItem.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        return sic;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.restoreCmpItemInfo();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setUIEnable(false);
        } else {
            this.setUIEnable(true);
        }
    }

    private void setUIEnable(boolean status) {
        this.comboCmpItem.setEnabled(status);
        this.comboRefType.setEnabled(status);
        this.txtRemark.setEditable(status);
        this.btnSubmit.setEnabled(status);
        this.comboCmpItem.setRequired(true);
        this.comboRefType.setRequired(true);
    }

    @Override
    protected void comboRefType_actionPerformed(ActionEvent e) throws Exception {
        if (MACHINE.equals(e.getActionCommand())) {
            return;
        }
        Object obj = this.comboRefType.getSelectedItem();
        if (obj == null) {
            this.comboCmpItem.removeAllItems();
            return;
        }
        EvaluResultItemEnum itemEnum = (EvaluResultItemEnum)((Object)obj);
        ItemDataTypeEnum dataType = null;
        dataType = itemEnum.equals((Object)EvaluResultItemEnum.PERF_RANK) ? ItemDataTypeEnum.STRING : ItemDataTypeEnum.FLOAT;
        this.initCmpItemComboBox(dataType);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setUIEnable(true);
        super.actionEdit_actionPerformed(e);
        this.restoreCmpItemInfo();
    }
}

