/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.EvaluRelationCollection;
import com.kingdee.eas.hr.perf.EvaluRelationFactory;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.MDEvaluGroupCollection;
import com.kingdee.eas.hr.perf.MDEvaluGroupFactory;
import com.kingdee.eas.hr.perf.MDEvaluGroupInfo;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MDGroupObjectCollection;
import com.kingdee.eas.hr.perf.MDGroupObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PFXMLBean;
import com.kingdee.eas.hr.perf.SumItemTypeEnum;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractSIMultiDimGroupScoreUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.ViewMDGroupObjectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class SIMultiDimGroupScoreUI
extends AbstractSIMultiDimGroupScoreUI {
    private static final Logger logger = CoreUIObject.getLogger(SIMultiDimGroupScoreUI.class);
    private JButton btnViewGroupObject = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtSolutionType.setText(this.getAlias("360Evalu"));
        this.txtSumItemType.setText(SumItemTypeEnum.MultiDimGroupScore.toString());
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)Integer.toString(102)));
        viewInfo.setFilter(filter);
        this.promptSolutionPeriod.setEntityViewInfo(viewInfo);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.promptObject.setEnabled(false);
        }
        this.btnViewGroupObject = this.ctnFlow.add((Action)((Object)this.actionViewGroupObject));
        this.btnViewGroupObject.setEnabled(true);
        this.btnViewGroupObject.setIcon(EASResource.getIcon((String)"imgTbtn_forbidPerm"));
        this.btnViewGroupObject.setText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"groupObject"));
        this.btnViewGroupObject.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"groupObject"));
        this.tblMain.checkParsed();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setData();
            if (OprtState.VIEW.equals(this.getOprtState())) {
                this.tblMain.setEditable(false);
            }
        }
    }

    private void setData() throws Exception {
        HashMap map = PFXMLBean.TransXMLToMap(this.editData.getSumDetail());
        String solutionPeriodID = (String)map.get("solutionPeriodID");
        String evaluObjectID = (String)map.get("evaluObjectID");
        MultiDimentionSolutionPeriodInfo spInfo = MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID));
        this.promptSolutionPeriod.setData((Object)spInfo);
        if (evaluObjectID != null) {
            SelectorItemCollection sic = this.getMDObjectSic();
            MultiDimentionObjectInfo mdInfo = MultiDimentionObjectFactory.getRemoteInstance().getMultiDimentionObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectID), sic);
            this.promptObject.setData((Object)mdInfo);
        }
        String groupID = null;
        int rowIndex = -1;
        EvaluRelationCollection relationColl = null;
        EvaluRelationInfo relationInfo = null;
        Item item = null;
        if (evaluObjectID != null) {
            String MDEvaluGroupID = (String)map.get("MDEvaluGroupID");
            String evaluRelationID = (String)map.get("evaluRelationID");
            relationColl = this.getRelationColl(MDEvaluGroupID, evaluRelationID);
            relationInfo = relationColl.get(0);
            item = new Item(relationInfo);
            this.tblMain.getCell(0, "relation").setValue((Object)item);
        } else {
            HashMap itemMap = (HashMap)map.get("item");
            Iterator iterator = itemMap.keySet().iterator();
            while (iterator.hasNext()) {
                groupID = iterator.next().toString();
                int size = this.tblMain.getRowCount();
                for (int i = 0; i < size; ++i) {
                    if (!groupID.equals(this.tblMain.getCell(i, "id").getValue().toString())) continue;
                    rowIndex = i;
                }
                relationColl = this.getRelationColl(groupID, (String)itemMap.get(groupID));
                relationInfo = relationColl.get(0);
                item = new Item(relationInfo);
                if (rowIndex < 0) continue;
                this.tblMain.getCell(rowIndex, "relation").setValue((Object)item);
            }
        }
    }

    private SelectorItemCollection getMDObjectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.name"));
        return sic;
    }

    @Override
    protected void promptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        if (this.promptSolutionPeriod.getData() != null) {
            String solutionPeriodID = ((MultiDimentionSolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            this.promptObject.setEnabled(true);
            this.promptObject.setValue(null);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("MDSolutionPeriod.id", (Object)solutionPeriodID));
            viewInfo.setFilter(filter);
            this.promptObject.setEntityViewInfo(viewInfo);
            SelectorItemCollection sic = this.getMDObjectSic();
            this.promptObject.setSelectorCollection(sic);
            this.fillTable(solutionPeriodID, null);
        } else {
            this.promptObject.setEnabled(false);
            this.promptObject.setValue(null);
            this.tblMain.removeRows();
        }
    }

    private void fillTable(String solutionPeriodID, String groupid) throws BOSException {
        this.tblMain.removeRows();
        MDEvaluGroupCollection groupColl = this.getGroupColl(solutionPeriodID, groupid);
        if (groupColl == null || groupColl.size() < 1) {
            return;
        }
        IRow row = null;
        MDEvaluGroupInfo groupInfo = null;
        EvaluRelationCollection relationColl = null;
        Object[] itemColl = null;
        KDComboBox comboBox = null;
        KDTDefaultCellEditor editor = null;
        int size = groupColl.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            groupInfo = groupColl.get(i);
            row.getCell("id").setValue((Object)groupInfo.getId().toString());
            row.getCell("number").setValue((Object)groupInfo.getNumber());
            row.getCell("name").setValue((Object)groupInfo.getName());
            String groupID = groupInfo.getId().toString();
            relationColl = this.getRelationColl(groupID, null);
            if (relationColl == null || relationColl.size() <= 0) continue;
            itemColl = new Item[relationColl.size()];
            int relationsize = relationColl.size();
            for (int j = 0; j < relationsize; ++j) {
                itemColl[j] = new Item(relationColl.get(j));
            }
            comboBox = new KDComboBox();
            comboBox.addItems(itemColl);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            row.getCell("relation").setEditor((ICellEditor)editor);
        }
    }

    private MDEvaluGroupCollection getGroupColl(String solutionPeriodID, String groupid) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (solutionPeriodID != null) {
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        }
        if (groupid != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)groupid));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        MDEvaluGroupCollection groupColl = MDEvaluGroupFactory.getRemoteInstance().getMDEvaluGroupCollection(viewInfo);
        return groupColl;
    }

    private EvaluRelationCollection getRelationColl(String groupID, String relationID) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (groupID != null) {
            filter.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.id", (Object)groupID));
        }
        if (relationID != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)relationID));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("MDEvaluTypeEnum"));
        sic.add(new SelectorItemInfo("mdEvaluGroup.id"));
        EvaluRelationCollection relationColl = EvaluRelationFactory.getRemoteInstance().getEvaluRelationCollection(viewInfo);
        return relationColl;
    }

    @Override
    protected void promptObject_dataChanged(DataChangeEvent e) throws Exception {
        if (this.promptObject.getData() != null) {
            String objectid = ((MultiDimentionObjectInfo)this.promptObject.getData()).getId().toString();
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            String solutionPeriodID = ((MultiDimentionSolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("mdEvaluGroup.solutionPeriod.id", (Object)solutionPeriodID));
            filter.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)objectid));
            viewInfo.setFilter(filter);
            MDGroupObjectCollection coll = MDGroupObjectFactory.getRemoteInstance().getMDGroupObjectCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                String groupID = coll.get(0).getMdEvaluGroup().getId().toString();
                this.fillTable(solutionPeriodID, groupID);
            }
        } else {
            String solutionPeriodID = ((MultiDimentionSolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            if (solutionPeriodID != null) {
                this.fillTable(solutionPeriodID, null);
            }
        }
    }

    @Override
    public void actionViewGroupObject_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("mdEvaluGroupID", this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain)).getCell("id").getValue().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ViewMDGroupObjectUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.promptSolutionPeriod.getData() == null) {
            this.promptSolutionPeriod.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)this.getAlias("spNull"));
            SysUtil.abort();
        }
        if (this.tblMain.getRowCount() < 1) {
            MsgBox.showError((Component)((Object)this), (String)this.getAlias("noGroup"));
            SysUtil.abort();
        } else {
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (this.tblMain.getCell(i, "relation").getValue() != null) continue;
                this.tblMain.getSelectManager().select(i, 3, i, 3);
                MsgBox.showError((Component)((Object)this), (String)this.getAlias("itemNull"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void storeFields() {
        this.editData.setNumber(this.number);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAlias("assessType"));
        sb.append(this.getAlias("360Evalu"));
        if (this.promptSolutionPeriod.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("solutionPeriod"));
            sb.append(((MultiDimentionSolutionPeriodInfo)this.promptSolutionPeriod.getData()).getName());
        }
        if (this.promptObject.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("relatedObject"));
            sb.append(((MultiDimentionObjectInfo)this.promptObject.getData()).getPerson().getName());
        }
        sb.append("\\");
        sb.append(this.getAlias("sumItemType"));
        sb.append(SumItemTypeEnum.MultiDimGroupScore.toString());
        if (this.tblMain.getRowCount() > 0) {
            sb.append("\\");
            IRow row = null;
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.tblMain.getRow(i);
                sb.append(this.getAlias("evaluGroup"));
                sb.append(row.getCell("name").getValue());
                sb.append("[");
                sb.append(this.getAlias("sumItem"));
                sb.append(((Item)row.getCell("relation").getValue()).toString());
                sb.append("]");
                if (i >= count - 1) continue;
                sb.append(";");
            }
        }
        this.editData.setName(sb.toString());
        SumSolutionInfo solution = new SumSolutionInfo();
        solution.setId(BOSUuid.read((String)this.solutionID));
        this.editData.setSumSolution(solution);
        this.editData.setType(SumItemTypeEnum.MultiDimGroupScore);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.promptSolutionPeriod.getValue() != null) {
            map.put("solutionPeriodID", ((MultiDimentionSolutionPeriodInfo)this.promptSolutionPeriod.getValue()).getId().toString());
        }
        if (this.promptObject.getValue() != null) {
            map.put("evaluObjectID", ((MultiDimentionObjectInfo)this.promptObject.getValue()).getId().toString());
            IRow row = this.tblMain.getRow(0);
            map.put("MDEvaluGroupID", row.getCell("id").getValue().toString());
            map.put("evaluRelationID", ((Item)row.getCell("relation").getValue()).getID());
        } else if (this.tblMain.getRowCount() > 0) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            IRow row = null;
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.tblMain.getRow(i);
                itemMap.put(row.getCell("id").getValue().toString(), ((Item)row.getCell("relation").getValue()).getID());
            }
            map.put("item", itemMap);
        }
        String sumDetail = null;
        try {
            sumDetail = PFXMLBean.TransMapToXML(map);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.setSumDetail(sumDetail);
        this.editData.setCalculator("com.kingdee.eas.hr.perf.app.SumMultiDimGroupScore");
        super.storeFields();
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return this.promptSolutionPeriod.getData() != null || this.promptObject.getData() != null;
        }
        return super.isModify();
    }

    private class Item {
        private String ID;
        private String name;

        public Item() {
        }

        public Item(EvaluRelationInfo info) {
            this.ID = info.getId().toString();
            this.name = MDEvaluTypeEnum.APPOINT.equals((Object)info.getMDEvaluTypeEnum()) ? MDEvaluTypeEnum.APPOINT.toString() + "(" + info.getName() + ")" : info.getMDEvaluTypeEnum().toString();
        }

        public String getID() {
            return this.ID;
        }

        public void setID(String id) {
            this.ID = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

