/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowCollection;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeFactory;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.PFXMLBean;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumItemTypeEnum;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractSIOrgNodeScoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SIOrgNodeScoreUI
extends AbstractSIOrgNodeScoreUI {
    private static String MACHINE = "0";
    private static String USER = "1";
    private static final Logger logger = CoreUIObject.getLogger(SIOrgNodeScoreUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtSolutionType.setText(this.getAlias("orgEvalu"));
        this.txtSumItemType.setText(SumItemTypeEnum.OrgNodeScore.toString());
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filter);
        this.promptSolutionPeriod.setEntityViewInfo(viewInfo);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.promptObject.setEnabled(false);
            this.combFlow.setEnabled(false);
            this.combItem.setEnabled(false);
        }
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setData();
        }
    }

    private void setData() throws Exception {
        int i;
        HashMap map = PFXMLBean.TransXMLToMap(this.editData.getSumDetail());
        String solutionPeriodID = (String)map.get("solutionPeriodID");
        String evaluObjectID = (String)map.get("evaluObjectID");
        String evalWorkFlowID = (String)map.get("evalWorkFlowID");
        String evaluNodeID = (String)map.get("evaluNodeID");
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID));
        this.promptSolutionPeriod.setData((Object)spInfo);
        if (!StringUtils.isEmpty((String)evaluObjectID)) {
            EvaluObjectInfo eoInfo = EvaluObjectFactory.getRemoteInstance().getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectID));
            this.promptObject.setData((Object)eoInfo);
        }
        int size = this.combFlow.getItemCount();
        for (i = 0; i < size; ++i) {
            if (!evalWorkFlowID.equals(((EvalWorkFlowInfo)this.combFlow.getItemAt(i)).getId().toString())) continue;
            this.combFlow.setSelectedIndex(i);
            break;
        }
        size = this.combItem.getItemCount();
        for (i = 0; i < size; ++i) {
            if (!evaluNodeID.equals(((Item)this.combItem.getItemAt(i)).getNode().getId().toString())) continue;
            this.combItem.setSelectedIndex(i);
            break;
        }
    }

    @Override
    protected void promptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.solutionPeriodChanged(e);
    }

    private void solutionPeriodChanged(DataChangeEvent e) throws BOSException {
        if (e != null && e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        if (this.promptSolutionPeriod.getData() != null) {
            String solutionPeriodID = ((SolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            this.promptObject.setEnabled(true);
            this.promptObject.setValue(null);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
            viewInfo.setFilter(filter);
            this.promptObject.setEntityViewInfo(viewInfo);
            this.combFlow.setEnabled(true);
            filter = new FilterInfo();
            viewInfo = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            EvalWorkFlowCollection flowColl = EvalWorkFlowFactory.getRemoteInstance().getEvalWorkFlowCollection(viewInfo);
            this.combFlow.setActionCommand(MACHINE);
            this.combFlow.removeAllItems();
            if (flowColl != null && flowColl.size() > 0) {
                int size = flowColl.size();
                for (int i = 0; i < size; ++i) {
                    this.combFlow.addItem((Object)flowColl.get(i));
                }
                this.combFlow.setSelectedIndex(-1);
            }
            this.combFlow.setActionCommand(USER);
            this.combItem.setEnabled(false);
            this.combItem.removeAllItems();
        } else {
            this.promptObject.setValue(null);
            this.promptObject.setEnabled(false);
            this.combFlow.removeAllItems();
            this.combFlow.setEnabled(false);
            this.combItem.removeAllItems();
            this.combItem.setEnabled(false);
        }
    }

    @Override
    protected void promptObject_dataChanged(DataChangeEvent e) throws Exception {
        if (this.promptObject.getData() != null) {
            String objectid = ((EvaluObjectInfo)this.promptObject.getData()).getId().toString();
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            String solutionPeriodID = ((SolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)objectid));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("evalWorkFlow.id"));
            sic.add(new SelectorItemInfo("evalWorkFlow.number"));
            sic.add(new SelectorItemInfo("evalWorkFlow.name"));
            EvalWFObjectsCollection coll = EvalWFObjectsFactory.getRemoteInstance().getEvalWFObjectsCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                this.combFlow.setActionCommand(MACHINE);
                this.combFlow.removeAllItems();
                this.combFlow.addItem((Object)coll.get(0).getEvalWorkFlow());
                this.combFlow.setSelectedIndex(-1);
                this.combItem.removeAllItems();
                this.combItem.setEnabled(false);
                this.combFlow.setActionCommand(USER);
            }
        } else {
            this.solutionPeriodChanged(null);
        }
    }

    @Override
    protected void combFlow_actionPerformed(ActionEvent e) throws Exception {
        if (MACHINE.equals(e.getActionCommand())) {
            return;
        }
        this.evaluFlowChanged();
    }

    private void evaluFlowChanged() throws BOSException {
        if (this.combFlow.getSelectedItem() != null) {
            String flowID = ((EvalWorkFlowInfo)this.combFlow.getSelectedItem()).getId().toString();
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)flowID));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("nodeName"));
            sic.add(new SelectorItemInfo("nodeLevel"));
            SorterItemCollection sorter = viewInfo.getSorter();
            sorter.add(new SorterItemInfo("nodeLevel"));
            EvaluNodeCollection nodeColl = EvaluNodeFactory.getRemoteInstance().getEvaluNodeCollection(viewInfo);
            this.combItem.setEnabled(true);
            this.combItem.removeAllItems();
            if (nodeColl != null && nodeColl.size() > 0) {
                Item item = null;
                int size = nodeColl.size();
                for (int i = 0; i < size; ++i) {
                    item = new Item(nodeColl.get(i));
                    this.combItem.addItem((Object)item);
                }
                this.combItem.setSelectedIndex(-1);
            }
        } else {
            this.combItem.removeAllItems();
            this.combItem.setEnabled(false);
        }
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.promptSolutionPeriod.getData() == null) {
            this.promptSolutionPeriod.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getAlias("spNull"));
            SysUtil.abort();
        }
        if (this.promptObject.getData() == null) {
            this.promptObject.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getAlias("relatedOrgNull"));
            SysUtil.abort();
        }
        if (this.combFlow.getSelectedItem() == null) {
            this.combFlow.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getAlias("flowNull"));
            SysUtil.abort();
        }
        if (this.combItem.getSelectedItem() == null) {
            this.combItem.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.getAlias("itemNull"));
            SysUtil.abort();
        }
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return this.promptSolutionPeriod.getData() != null || this.promptObject.getData() != null || this.combFlow.getSelectedItem() != null || this.combItem.getSelectedItem() != null;
        }
        return super.isModify();
    }

    @Override
    public void storeFields() {
        this.editData.setNumber(this.number);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAlias("assessType"));
        sb.append(this.getAlias("orgEvalu"));
        if (this.promptSolutionPeriod.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("solutionPeriod"));
            sb.append(((SolutionPeriodInfo)this.promptSolutionPeriod.getData()).getName());
        }
        if (this.promptObject.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("relatedOrg"));
            sb.append(((EvaluObjectInfo)this.promptObject.getData()).getName());
        }
        if (this.combFlow.getSelectedItem() != null) {
            sb.append("\\");
            sb.append(this.getAlias("evaluFlow"));
            sb.append(this.combFlow.getSelectedItem());
        }
        sb.append("\\");
        sb.append(this.getAlias("sumItemType"));
        sb.append(SumItemTypeEnum.OrgNodeScore.toString());
        if (this.combItem.getSelectedItem() != null) {
            sb.append("\\");
            sb.append(this.getAlias("sumItem"));
            sb.append(this.combItem.getSelectedItem());
        }
        this.editData.setName(sb.toString());
        SumSolutionInfo solution = new SumSolutionInfo();
        solution.setId(BOSUuid.read((String)this.solutionID));
        this.editData.setSumSolution(solution);
        this.editData.setType(SumItemTypeEnum.OrgNodeScore);
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.promptSolutionPeriod.getValue() != null) {
            map.put("solutionPeriodID", ((SolutionPeriodInfo)this.promptSolutionPeriod.getValue()).getId().toString());
        }
        if (this.promptObject.getValue() != null) {
            map.put("evaluObjectID", ((EvaluObjectInfo)this.promptObject.getValue()).getId().toString());
        }
        if (this.combFlow.getSelectedItem() != null) {
            map.put("evalWorkFlowID", ((EvalWorkFlowInfo)this.combFlow.getSelectedItem()).getId().toString());
        }
        if (this.combItem.getSelectedItem() != null) {
            map.put("evaluNodeID", ((Item)this.combItem.getSelectedItem()).getNode().getId().toString());
        }
        String sumDetail = null;
        try {
            sumDetail = PFXMLBean.TransMapToXML(map);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.setSumDetail(sumDetail);
        this.editData.setCalculator("com.kingdee.eas.hr.perf.app.SumOrgNodeScore");
        super.storeFields();
    }

    private class Item {
        private EvaluNodeInfo node;

        public Item() {
        }

        public Item(EvaluNodeInfo evalunode) {
            this.node = evalunode;
        }

        public void setNode(EvaluNodeInfo evalunode) {
            this.node = evalunode;
        }

        public EvaluNodeInfo getNode() {
            return this.node;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"di"));
            sb.append(this.node.getNodeLevel());
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"nodeLevel"));
            sb.append(" ");
            sb.append(this.node.getNodeName());
            return sb.toString();
        }
    }
}

