/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowCollection;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.EvalWorkFlowInfo;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeFactory;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.PFXMLBean;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumItemTypeEnum;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractSIPersonNodeScoreUI;
import com.kingdee.eas.hr.perf.client.ModifyWorkFlowDefineEvaluObjectUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.ViewWorkFlowUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class SIPersonNodeScoreUI
extends AbstractSIPersonNodeScoreUI {
    private static final Logger logger = Logger.getLogger(SIPersonNodeScoreUI.class);
    private JButton btnViewWFObjects = null;
    private JButton btnViewFlow = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtSolutionType.setText(this.getAlias("personEvalu"));
        this.txtSumItemType.setText(SumItemTypeEnum.PersonNodeScore.toString());
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filter);
        this.promptSolutionPeriod.setEntityViewInfo(viewInfo);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.promptObject.setEnabled(false);
        }
        this.btnViewWFObjects = this.ctnFlow.add((Action)((Object)this.actionViewWFObjects));
        this.btnViewWFObjects.setEnabled(true);
        this.btnViewWFObjects.setIcon(EASResource.getIcon((String)"imgTbtn_flowobject"));
        this.btnViewWFObjects.setText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"WFObjects"));
        this.btnViewWFObjects.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"WFObjects"));
        this.btnViewFlow = this.ctnFlow.add((Action)((Object)this.actionViewFlow));
        this.btnViewFlow.setEnabled(true);
        this.btnViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowinfo"));
        this.btnViewFlow.setText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"flowInfo"));
        this.btnViewFlow.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"flowInfo"));
        this.tblMain.checkParsed();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setData();
            if (OprtState.VIEW.equals(this.getOprtState())) {
                this.tblMain.setEditable(false);
            }
        }
    }

    private void setData() throws Exception {
        HashMap map = PFXMLBean.TransXMLToMap(this.editData.getSumDetail());
        String solutionPeriodID = (String)map.get("solutionPeriodID");
        String evaluObjectID = (String)map.get("evaluObjectID");
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID));
        this.promptSolutionPeriod.setData((Object)spInfo);
        if (evaluObjectID != null) {
            EvaluObjectInfo eoInfo = EvaluObjectFactory.getRemoteInstance().getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectID));
            this.promptObject.setData((Object)eoInfo);
        }
        String flowID = null;
        int rowIndex = -1;
        EvaluNodeCollection nodeColl = null;
        EvaluNodeInfo nodeInfo = null;
        Item item = null;
        if (evaluObjectID != null) {
            String evalWorkFlowID = (String)map.get("evalWorkFlowID");
            int nodeLevel = Integer.parseInt((String)map.get("nodeLevel"));
            nodeColl = this.getEvaluNodeByFlowID(evalWorkFlowID, nodeLevel);
            nodeInfo = nodeColl.get(0);
            item = new Item(nodeInfo);
            this.tblMain.getCell(0, "level").setValue((Object)item);
        } else {
            HashMap itemMap = (HashMap)map.get("item");
            Iterator iterator = itemMap.keySet().iterator();
            while (iterator.hasNext()) {
                flowID = iterator.next().toString();
                int size = this.tblMain.getRowCount();
                for (int i = 0; i < size; ++i) {
                    if (!flowID.equals(this.tblMain.getCell(i, "id").getValue().toString())) continue;
                    rowIndex = i;
                }
                nodeColl = this.getEvaluNodeByFlowID(flowID, Integer.parseInt((String)itemMap.get(flowID)));
                item = null;
                int nodeSize = nodeColl.size();
                for (int j = 0; j < nodeSize; ++j) {
                    nodeInfo = nodeColl.get(j);
                    if (item == null) {
                        item = new Item(nodeInfo);
                        continue;
                    }
                    item.setConcurrence(true);
                }
                if (rowIndex < 0) continue;
                this.tblMain.getCell(rowIndex, "level").setValue((Object)item);
            }
        }
    }

    @Override
    protected void promptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        if (this.promptSolutionPeriod.getData() != null) {
            String solutionPeriodID = ((SolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            this.promptObject.setEnabled(true);
            this.promptObject.setValue(null);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
            viewInfo.setFilter(filter);
            this.promptObject.setEntityViewInfo(viewInfo);
            this.fillTable(solutionPeriodID, null);
        } else {
            this.promptObject.setValue(null);
            this.promptObject.setEnabled(false);
            this.tblMain.removeRows();
        }
    }

    @Override
    protected void promptObject_dataChanged(DataChangeEvent e) throws Exception {
        if (this.promptObject.getData() != null) {
            String objectid = ((EvaluObjectInfo)this.promptObject.getData()).getId().toString();
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            String solutionPeriodID = ((SolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)objectid));
            viewInfo.setFilter(filter);
            EvalWFObjectsCollection coll = EvalWFObjectsFactory.getRemoteInstance().getEvalWFObjectsCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                String flowID = coll.get(0).getEvalWorkFlow().getId().toString();
                this.fillTable(solutionPeriodID, flowID);
            }
        } else {
            String solutionPeriodID = ((SolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            if (solutionPeriodID != null) {
                this.fillTable(solutionPeriodID, null);
            }
        }
    }

    private void fillTable(String solutionPeriodID, String flowid) throws BOSException {
        this.tblMain.removeRows();
        EvalWorkFlowCollection flowColl = this.getEvalWorkFlow(solutionPeriodID, flowid);
        if (flowColl == null || flowColl.size() < 1) {
            return;
        }
        IRow row = null;
        EvalWorkFlowInfo flowInfo = null;
        String flowID = null;
        EvaluNodeCollection nodeColl = null;
        EvaluNodeInfo nodeInfo = null;
        Object[] itemColl = null;
        KDComboBox comboBox = null;
        KDTDefaultCellEditor editor = null;
        int size = flowColl.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            flowInfo = flowColl.get(i);
            flowID = flowInfo.getId().toString();
            row.getCell("id").setValue((Object)flowID);
            row.getCell("number").setValue((Object)flowInfo.getNumber());
            row.getCell("name").setValue((Object)flowInfo.getName());
            nodeColl = this.getEvaluNodeByFlowID(flowID, -1);
            if (nodeColl == null || nodeColl.size() <= 0) continue;
            itemColl = new Item[flowInfo.getWfLevels() + 1];
            int nodeSize = nodeColl.size();
            for (int j = 0; j < nodeSize; ++j) {
                nodeInfo = nodeColl.get(j);
                if (itemColl[nodeInfo.getNodeLevel()] == null) {
                    itemColl[nodeInfo.getNodeLevel()] = new Item(nodeInfo);
                    continue;
                }
                ((Item)itemColl[nodeInfo.getNodeLevel()]).setConcurrence(true);
            }
            comboBox = new KDComboBox();
            comboBox.addItems(itemColl);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            row.getCell("level").setEditor((ICellEditor)editor);
        }
    }

    private EvalWorkFlowCollection getEvalWorkFlow(String solutionPeriodID, String flowid) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (flowid != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)flowid));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("wfLevels"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("number"));
        EvalWorkFlowCollection flowColl = EvalWorkFlowFactory.getRemoteInstance().getEvalWorkFlowCollection(viewInfo);
        return flowColl;
    }

    private EvaluNodeCollection getEvaluNodeByFlowID(String flowID, int nodeLevel) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)flowID));
        if (nodeLevel > 0) {
            filter.getFilterItems().add(new FilterItemInfo("nodeLevel", (Object)new Integer(nodeLevel)));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("nodeName"));
        sic.add(new SelectorItemInfo("nodeLevel"));
        sic.add(new SelectorItemInfo("weight"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("nodeLevel"));
        EvaluNodeCollection nodeColl = EvaluNodeFactory.getRemoteInstance().getEvaluNodeCollection(viewInfo);
        return nodeColl;
    }

    @Override
    public void actionViewWFObjects_actionPerformed(ActionEvent e) throws Exception {
        int top;
        if (this.tblMain.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelected");
        }
        if (this.tblMain.getRow(top = this.tblMain.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelected");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", this.promptSolutionPeriod.getData());
        uiContext.put((Object)"evalWorkFlowID", (Object)this.tblMain.getRow(top).getCell("id").getValue().toString());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ModifyWorkFlowDefineEvaluObjectUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        window.show();
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        int top;
        if (this.tblMain.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelected");
        }
        if (this.tblMain.getRow(top = this.tblMain.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelected");
        }
        IRow row = this.tblMain.getRow(top);
        EvalWorkFlowInfo wfInfo = EvalWorkFlowFactory.getRemoteInstance().getEvalWorkFlowInfo((IObjectPK)new ObjectUuidPK(row.getCell("id").getValue().toString()));
        if (PFVerifyUtils.objectIsNull(wfInfo)) {
            this.showErrorMessage("evalWorkFlowNull");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"evalWorkFlowInfo", (Object)wfInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ViewWorkFlowUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.promptSolutionPeriod.getData() == null) {
            this.promptSolutionPeriod.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)this.getAlias("spNull"));
            SysUtil.abort();
        }
        if (this.tblMain.getRowCount() < 1) {
            MsgBox.showError((Component)((Object)this), (String)this.getAlias("noFlow"));
            SysUtil.abort();
        } else {
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (this.tblMain.getCell(i, "level").getValue() != null) continue;
                this.tblMain.getSelectManager().select(i, 3, i, 3);
                MsgBox.showError((Component)((Object)this), (String)this.getAlias("itemNull"));
                SysUtil.abort();
            }
        }
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return this.promptSolutionPeriod.getData() != null || this.promptObject.getData() != null;
        }
        return super.isModify();
    }

    @Override
    public void storeFields() {
        this.editData.setNumber(this.number);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAlias("assessType"));
        sb.append(this.getAlias("personEvalu"));
        if (this.promptSolutionPeriod.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("solutionPeriod"));
            sb.append(((SolutionPeriodInfo)this.promptSolutionPeriod.getData()).getName());
        }
        if (this.promptObject.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("relatedObject"));
            sb.append(((EvaluObjectInfo)this.promptObject.getData()).getName());
        }
        sb.append("\\");
        sb.append(this.getAlias("sumItemType"));
        sb.append(SumItemTypeEnum.PersonNodeScore.toString());
        if (this.tblMain.getRowCount() > 0) {
            sb.append("\\");
            IRow row = null;
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.tblMain.getRow(i);
                sb.append(this.getAlias("evaluFlow"));
                sb.append(row.getCell("name").getValue());
                sb.append("[");
                sb.append(this.getAlias("sumItem"));
                sb.append(((Item)row.getCell("level").getValue()).toString());
                sb.append("]");
                if (i >= count - 1) continue;
                sb.append(";");
            }
        }
        this.editData.setName(sb.toString());
        SumSolutionInfo solution = new SumSolutionInfo();
        solution.setId(BOSUuid.read((String)this.solutionID));
        this.editData.setSumSolution(solution);
        this.editData.setType(SumItemTypeEnum.PersonNodeScore);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.promptSolutionPeriod.getValue() != null) {
            map.put("solutionPeriodID", ((SolutionPeriodInfo)this.promptSolutionPeriod.getValue()).getId().toString());
        }
        if (this.promptObject.getValue() != null) {
            map.put("evaluObjectID", ((EvaluObjectInfo)this.promptObject.getValue()).getId().toString());
            IRow row = this.tblMain.getRow(0);
            map.put("evalWorkFlowID", row.getCell("id").getValue().toString());
            map.put("nodeLevel", new Integer(((Item)row.getCell("level").getValue()).getNodeLevel()));
        } else if (this.tblMain.getRowCount() > 0) {
            HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
            IRow row = null;
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.tblMain.getRow(i);
                itemMap.put(row.getCell("id").getValue().toString(), new Integer(((Item)row.getCell("level").getValue()).getNodeLevel()));
            }
            map.put("item", itemMap);
        }
        String sumDetail = null;
        try {
            sumDetail = PFXMLBean.TransMapToXML(map);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.setSumDetail(sumDetail);
        this.editData.setCalculator("com.kingdee.eas.hr.perf.app.SumPersonNodeScore");
        super.storeFields();
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }

    private class Item {
        private String name;
        private int nodeLevel;
        private boolean isConcurrence = false;

        public Item() {
        }

        public Item(EvaluNodeInfo evaluNode) {
            this.name = evaluNode.getNodeName();
            this.nodeLevel = evaluNode.getNodeLevel();
        }

        public boolean isConcurrence() {
            return this.isConcurrence;
        }

        public void setConcurrence(boolean isConcurrence) {
            this.isConcurrence = isConcurrence;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getNodeLevel() {
            return this.nodeLevel;
        }

        public void setNodeLevel(int nodeLevel) {
            this.nodeLevel = nodeLevel;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"di"));
            sb.append(Integer.toString(this.nodeLevel));
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"nodeLevel"));
            sb.append(" ");
            if (this.isConcurrence) {
                sb.append("(");
                sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"concurrence"));
                sb.append(")");
            } else {
                sb.append(this.name);
            }
            return sb.toString();
        }
    }
}

