/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.PFXMLBean;
import com.kingdee.eas.hr.perf.SumItemTypeEnum;
import com.kingdee.eas.hr.perf.SumPersonFactory;
import com.kingdee.eas.hr.perf.SumPersonInfo;
import com.kingdee.eas.hr.perf.SumSolutionFactory;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractSISumSumScoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SISumSumScoreUI
extends AbstractSISumSumScoreUI {
    private static final Logger logger = CoreUIObject.getLogger(SISumSumScoreUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtSolutionType.setText(this.getAlias("sumSolution"));
        this.txtSumItemType.setText(SumItemTypeEnum.SumSumScore.toString());
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"20"));
        viewInfo.setFilter(filter);
        this.promptSolution.setEntityViewInfo(viewInfo);
        this.promptSumPerson.setEnabled(false);
        this.txtItem.setText(this.getAlias("sumScore"));
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setData();
        }
    }

    private void setData() throws Exception {
        HashMap map = PFXMLBean.TransXMLToMap(this.editData.getSumDetail());
        String solutionID = (String)map.get("solutionID");
        String SumPersonID = (String)map.get("SumPersonID");
        SumSolutionInfo solutionInfo = SumSolutionFactory.getRemoteInstance().getSumSolutionInfo((IObjectPK)new ObjectUuidPK(solutionID));
        this.promptSolution.setData((Object)solutionInfo);
        if (SumPersonID != null) {
            SelectorItemCollection sic = this.getSumPersonSic();
            SumPersonInfo sPersonInfo = SumPersonFactory.getRemoteInstance().getSumPersonInfo((IObjectPK)new ObjectUuidPK(SumPersonID), sic);
            this.promptSumPerson.setData((Object)sPersonInfo);
        }
    }

    @Override
    protected void promptSolution_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        if (this.promptSolution.getData() != null) {
            String sumSolutionID = ((SumSolutionInfo)this.promptSolution.getData()).getId().toString();
            this.promptSumPerson.setEnabled(true);
            this.promptSumPerson.setValue(null);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)sumSolutionID));
            viewInfo.setFilter(filter);
            this.promptSumPerson.setEntityViewInfo(viewInfo);
            SelectorItemCollection sic = this.getSumPersonSic();
            this.promptSumPerson.setSelectorCollection(sic);
        } else {
            this.promptSumPerson.setValue(null);
            this.promptSumPerson.setEnabled(false);
        }
    }

    private SelectorItemCollection getSumPersonSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sumSolution.id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit"));
        return sic;
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.promptSolution.getData() == null) {
            this.promptSolution.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)this.getAlias("SumSolutionNull"));
            SysUtil.abort();
        }
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return this.promptSolution.getData() != null || this.promptSumPerson.getData() != null;
        }
        return super.isModify();
    }

    @Override
    public void storeFields() {
        this.editData.setNumber(this.number);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAlias("assessType"));
        sb.append(this.getAlias("sumSolution"));
        if (this.promptSolution.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("sumSolution"));
            sb.append(":");
            sb.append(((SumSolutionInfo)this.promptSolution.getData()).getName());
        }
        if (this.promptSumPerson.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("relatedSumPerson"));
            sb.append(((SumPersonInfo)this.promptSumPerson.getData()).getPerson().getName());
        }
        sb.append("\\");
        sb.append(this.getAlias("sumItemType"));
        sb.append(SumItemTypeEnum.SumSumScore.toString());
        sb.append("\\");
        sb.append(this.getAlias("sumItem"));
        sb.append(this.getAlias("sumScore"));
        this.editData.setName(sb.toString());
        SumSolutionInfo solution = new SumSolutionInfo();
        solution.setId(BOSUuid.read((String)this.solutionID));
        this.editData.setSumSolution(solution);
        this.editData.setType(SumItemTypeEnum.SumSumScore);
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.promptSolution.getValue() != null) {
            map.put("solutionID", ((SumSolutionInfo)this.promptSolution.getValue()).getId().toString());
        }
        if (this.promptSumPerson.getValue() != null) {
            map.put("SumPersonID", ((SumPersonInfo)this.promptSumPerson.getValue()).getId().toString());
        }
        String sumDetail = null;
        try {
            sumDetail = PFXMLBean.TransMapToXML(map);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.setSumDetail(sumDetail);
        this.editData.setCalculator("com.kingdee.eas.hr.perf.app.SumSumSumScore");
        super.storeFields();
    }
}

