/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.PFXMLBean;
import com.kingdee.eas.hr.perf.SumItemTypeEnum;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.SynEvaluFlowCollection;
import com.kingdee.eas.hr.perf.SynEvaluFlowFactory;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynEvaluObjectFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.hr.perf.SynFlowNodeCollection;
import com.kingdee.eas.hr.perf.SynFlowNodeFactory;
import com.kingdee.eas.hr.perf.SynFlowNodeInfo;
import com.kingdee.eas.hr.perf.SynFlowObjectCollection;
import com.kingdee.eas.hr.perf.SynFlowObjectFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractSISynNodeScoreUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.SynEvaluObjectForFlowUI;
import com.kingdee.eas.hr.perf.client.SynViewWorkFlowUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class SISynNodeScoreUI
extends AbstractSISynNodeScoreUI {
    private static final Logger logger = CoreUIObject.getLogger(SISynNodeScoreUI.class);
    private JButton btnViewWFObjects = null;
    private JButton btnViewFlow = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtSolutionType.setText(this.getAlias("synEvalu"));
        this.txtSumItemType.setText(SumItemTypeEnum.SynNodeScore.toString());
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"102"));
        viewInfo.setFilter(filter);
        this.promptSolutionPeriod.setEntityViewInfo(viewInfo);
        SelectorItemCollection sic = this.getSynSPSic();
        this.promptSolutionPeriod.setSelectorCollection(sic);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.promptObject.setEnabled(false);
        }
        this.btnViewWFObjects = this.ctnFlow.add((Action)((Object)this.actionViewWFObjects));
        this.btnViewWFObjects.setEnabled(true);
        this.btnViewWFObjects.setIcon(EASResource.getIcon((String)"imgTbtn_flowobject"));
        this.btnViewWFObjects.setText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"WFObjects"));
        this.btnViewWFObjects.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"WFObjects"));
        this.btnViewFlow = this.ctnFlow.add((Action)((Object)this.actionViewFlow));
        this.btnViewFlow.setEnabled(true);
        this.btnViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowinfo"));
        this.btnViewFlow.setText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"flowInfo"));
        this.btnViewFlow.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"flowInfo"));
        this.tblMain.checkParsed();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setData();
            if (OprtState.VIEW.equals(this.getOprtState())) {
                this.tblMain.setEditable(false);
            }
        }
    }

    private void setData() throws Exception {
        HashMap map = PFXMLBean.TransXMLToMap(this.editData.getSumDetail());
        String solutionPeriodID = (String)map.get("solutionPeriodID");
        String evaluObjectID = (String)map.get("evaluObjectID");
        SelectorItemCollection sic = this.getSynSPSic();
        SynSolutionPeriodInfo spInfo = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodID), sic);
        this.promptSolutionPeriod.setData((Object)spInfo);
        if (evaluObjectID != null) {
            sic = this.getSynEvaluObjectSic();
            SynEvaluObjectInfo objectInfo = SynEvaluObjectFactory.getRemoteInstance().getSynEvaluObjectInfo((IObjectPK)new ObjectUuidPK(evaluObjectID), sic);
            this.promptObject.setData((Object)objectInfo);
        }
        String flowID = null;
        int rowIndex = -1;
        SynFlowNodeCollection nodeColl = null;
        SynFlowNodeInfo nodeInfo = null;
        Item item = null;
        if (evaluObjectID != null) {
            String evalWorkFlowID = (String)map.get("evalWorkFlowID");
            int nodeLevel = Integer.parseInt((String)map.get("nodeLevel"));
            nodeColl = this.getFlowNodeColl(evalWorkFlowID, nodeLevel);
            nodeInfo = nodeColl.get(0);
            item = new Item(nodeInfo);
            this.tblMain.getCell(0, "level").setValue((Object)item);
        } else {
            HashMap itemMap = (HashMap)map.get("item");
            Iterator iterator = itemMap.keySet().iterator();
            while (iterator.hasNext()) {
                flowID = iterator.next().toString();
                int size = this.tblMain.getRowCount();
                for (int i = 0; i < size; ++i) {
                    if (!flowID.equals(this.tblMain.getCell(i, "id").getValue().toString())) continue;
                    rowIndex = i;
                }
                nodeColl = this.getFlowNodeColl(flowID, Integer.parseInt((String)itemMap.get(flowID)));
                item = null;
                int nodeSize = nodeColl.size();
                for (int j = 0; j < nodeSize; ++j) {
                    nodeInfo = nodeColl.get(j);
                    if (item == null) {
                        item = new Item(nodeInfo);
                        continue;
                    }
                    item.setConcurrence(true);
                }
                if (rowIndex < 0) continue;
                this.tblMain.getCell(rowIndex, "level").setValue((Object)item);
            }
        }
    }

    private SelectorItemCollection getSynSPSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("solution.id"));
        sic.add(new SelectorItemInfo("solution.hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("solution.orgUnit.id"));
        sic.add(new SelectorItemInfo("solution.inputMode"));
        return sic;
    }

    @Override
    protected void promptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        if (this.promptSolutionPeriod.getData() != null) {
            String solutionPeriodID = ((SynSolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            this.promptObject.setEnabled(true);
            this.promptObject.setValue(null);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("synSolutionPeriod.id", (Object)solutionPeriodID));
            viewInfo.setFilter(filter);
            this.promptObject.setEntityViewInfo(viewInfo);
            SelectorItemCollection sic = this.getSynEvaluObjectSic();
            this.promptObject.setSelectorCollection(sic);
            this.fillTable(solutionPeriodID, null);
        } else {
            this.promptObject.setEnabled(false);
            this.promptObject.setValue(null);
            this.tblMain.removeRows();
        }
    }

    private SelectorItemCollection getSynEvaluObjectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.name"));
        return sic;
    }

    @Override
    protected void promptObject_dataChanged(DataChangeEvent e) throws Exception {
        if (this.promptObject.getData() != null) {
            String objectid = ((SynEvaluObjectInfo)this.promptObject.getData()).getId().toString();
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            String solutionPeriodID = ((SynSolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
            filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)objectid));
            viewInfo.setFilter(filter);
            SynFlowObjectCollection coll = SynFlowObjectFactory.getRemoteInstance().getSynFlowObjectCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                String flowID = coll.get(0).getEvalWorkFlow().getId().toString();
                this.fillTable(solutionPeriodID, flowID);
            }
        } else {
            String solutionPeriodID = ((SynSolutionPeriodInfo)this.promptSolutionPeriod.getData()).getId().toString();
            if (solutionPeriodID != null) {
                this.fillTable(solutionPeriodID, null);
            }
        }
    }

    private void fillTable(String solutionPeriodID, String flowid) throws BOSException {
        this.tblMain.removeRows();
        if (solutionPeriodID == null && flowid == null) {
            return;
        }
        SynEvaluFlowCollection flowColl = this.getSynEvaluFlowColl(solutionPeriodID, flowid);
        if (flowColl == null || flowColl.size() < 1) {
            return;
        }
        IRow row = null;
        SynEvaluFlowInfo flowInfo = null;
        String flowID = null;
        SynFlowNodeCollection nodeColl = null;
        SynFlowNodeInfo nodeInfo = null;
        Object[] itemColl = null;
        KDComboBox comboBox = null;
        KDTDefaultCellEditor editor = null;
        int size = flowColl.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            flowInfo = flowColl.get(i);
            flowID = flowInfo.getId().toString();
            row.getCell("id").setValue((Object)flowID);
            row.getCell("number").setValue((Object)flowInfo.getNumber());
            row.getCell("name").setValue((Object)flowInfo.getName());
            nodeColl = this.getFlowNodeColl(flowID, -1);
            if (nodeColl == null || nodeColl.size() <= 0) continue;
            itemColl = new Item[flowInfo.getWfLevels() + 1];
            int nodeSize = nodeColl.size();
            for (int j = 0; j < nodeSize; ++j) {
                nodeInfo = nodeColl.get(j);
                if (itemColl[nodeInfo.getNodeLevel()] == null) {
                    itemColl[nodeInfo.getNodeLevel()] = new Item(nodeInfo);
                    continue;
                }
                ((Item)itemColl[nodeInfo.getNodeLevel()]).setConcurrence(true);
            }
            comboBox = new KDComboBox();
            comboBox.addItems(itemColl);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            row.getCell("level").setEditor((ICellEditor)editor);
        }
    }

    private SynFlowNodeCollection getFlowNodeColl(String flowID, int nodeLevel) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)flowID));
        if (nodeLevel > 0) {
            filter.getFilterItems().add(new FilterItemInfo("nodeLevel", (Object)new Integer(nodeLevel)));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("nodeName"));
        sic.add(new SelectorItemInfo("nodeLevel"));
        sic.add(new SelectorItemInfo("weight"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("nodeLevel"));
        SynFlowNodeCollection nodeColl = SynFlowNodeFactory.getRemoteInstance().getSynFlowNodeCollection(viewInfo);
        return nodeColl;
    }

    private SynEvaluFlowCollection getSynEvaluFlowColl(String solutionPeriodID, String flowid) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (solutionPeriodID != null) {
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        }
        if (flowid != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)flowid));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("wfLevels"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("number"));
        SynEvaluFlowCollection flowColl = SynEvaluFlowFactory.getRemoteInstance().getSynEvaluFlowCollection(viewInfo);
        return flowColl;
    }

    @Override
    public void actionViewWFObjects_actionPerformed(ActionEvent e) throws Exception {
        int top;
        if (this.tblMain.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelected");
        }
        if (this.tblMain.getRow(top = this.tblMain.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelected");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", this.promptSolutionPeriod.getData());
        uiContext.put((Object)"evalWorkFlowID", (Object)this.tblMain.getRow(top).getCell("id").getValue().toString());
        uiContext.put((Object)"view", (Object)"view");
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(SynEvaluObjectForFlowUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        int top;
        if (this.tblMain.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelected");
        }
        if (this.tblMain.getRow(top = this.tblMain.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelected");
        }
        IRow row = this.tblMain.getRow(top);
        SynEvaluFlowInfo wfInfo = SynEvaluFlowFactory.getRemoteInstance().getSynEvaluFlowInfo((IObjectPK)new ObjectUuidPK(row.getCell("id").getValue().toString()));
        if (PFVerifyUtils.objectIsNull(wfInfo)) {
            this.showErrorMessage("evalWorkFlowNull");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"evalWorkFlowInfo", (Object)wfInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(SynViewWorkFlowUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.promptSolutionPeriod.getData() == null) {
            this.promptSolutionPeriod.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)this.getAlias("spNull"));
            SysUtil.abort();
        }
        if (this.tblMain.getRowCount() < 1) {
            MsgBox.showError((Component)((Object)this), (String)this.getAlias("noFlow"));
            SysUtil.abort();
        } else {
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (this.tblMain.getCell(i, "level").getValue() != null) continue;
                this.tblMain.getSelectManager().select(i, 3, i, 3);
                MsgBox.showError((Component)((Object)this), (String)this.getAlias("itemNull"));
                SysUtil.abort();
            }
        }
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return this.promptSolutionPeriod.getData() != null || this.promptObject.getData() != null;
        }
        return super.isModify();
    }

    @Override
    public void storeFields() {
        this.editData.setNumber(this.number);
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAlias("assessType"));
        sb.append(this.getAlias("synEvalu"));
        if (this.promptSolutionPeriod.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("solutionPeriod"));
            sb.append(((SynSolutionPeriodInfo)this.promptSolutionPeriod.getData()).getName());
        }
        if (this.promptObject.getValue() != null) {
            sb.append("\\");
            sb.append(this.getAlias("relatedObject"));
            sb.append(((SynEvaluObjectInfo)this.promptObject.getData()).getPerson().getName());
        }
        sb.append("\\");
        sb.append(this.getAlias("sumItemType"));
        sb.append(SumItemTypeEnum.SynNodeScore.toString());
        if (this.tblMain.getRowCount() > 0) {
            sb.append("\\");
            IRow row = null;
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.tblMain.getRow(i);
                sb.append(this.getAlias("evaluFlow"));
                sb.append(row.getCell("name").getValue());
                sb.append("[");
                sb.append(this.getAlias("sumItem"));
                sb.append(((Item)row.getCell("level").getValue()).toString());
                sb.append("]");
                if (i >= count - 1) continue;
                sb.append(";");
            }
        }
        this.editData.setName(sb.toString());
        SumSolutionInfo solution = new SumSolutionInfo();
        solution.setId(BOSUuid.read((String)this.solutionID));
        this.editData.setSumSolution(solution);
        this.editData.setType(SumItemTypeEnum.SynNodeScore);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.promptSolutionPeriod.getValue() != null) {
            map.put("solutionPeriodID", ((SynSolutionPeriodInfo)this.promptSolutionPeriod.getValue()).getId().toString());
            if (EvaluModeEnum.RANK_GROUP.equals((Object)((SynSolutionPeriodInfo)this.promptSolutionPeriod.getValue()).getSolution().getInputMode())) {
                map.put("rank", new Boolean(true));
            } else {
                map.put("rank", new Boolean(false));
            }
        }
        if (this.promptObject.getValue() != null) {
            map.put("evaluObjectID", ((SynEvaluObjectInfo)this.promptObject.getValue()).getId().toString());
            IRow row = this.tblMain.getRow(0);
            map.put("evalWorkFlowID", row.getCell("id").getValue().toString());
            map.put("nodeLevel", new Integer(((Item)row.getCell("level").getValue()).getNodeLevel()));
        } else if (this.tblMain.getRowCount() > 0) {
            HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
            IRow row = null;
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.tblMain.getRow(i);
                itemMap.put(row.getCell("id").getValue().toString(), new Integer(((Item)row.getCell("level").getValue()).getNodeLevel()));
            }
            map.put("item", itemMap);
        }
        String sumDetail = null;
        try {
            sumDetail = PFXMLBean.TransMapToXML(map);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.setSumDetail(sumDetail);
        this.editData.setCalculator("com.kingdee.eas.hr.perf.app.SumSynNodeScore");
        super.storeFields();
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }

    private class Item {
        private String name;
        private int nodeLevel;
        private boolean isConcurrence = false;

        public Item() {
        }

        public Item(SynFlowNodeInfo flowNode) {
            this.name = flowNode.getNodeName();
            this.nodeLevel = flowNode.getNodeLevel();
        }

        public boolean isConcurrence() {
            return this.isConcurrence;
        }

        public void setConcurrence(boolean isConcurrence) {
            this.isConcurrence = isConcurrence;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getNodeLevel() {
            return this.nodeLevel;
        }

        public void setNodeLevel(int nodeLevel) {
            this.nodeLevel = nodeLevel;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"di"));
            sb.append(Integer.toString(this.nodeLevel));
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"nodeLevel"));
            sb.append(" ");
            if (this.isConcurrence) {
                sb.append("(");
                sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumClientResource", (String)"concurrence"));
                sb.append(")");
            } else {
                sb.append(this.name);
            }
            return sb.toString();
        }
    }
}

