/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.MessageString;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.WorkFlowControlEnum;
import com.kingdee.eas.hr.perf.client.AbstractSelfEvalHastenUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionF7Helper;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SelfEvalHastenUI
extends AbstractSelfEvalHastenUI {
    private String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private String resClass = "com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.";
    String solutionPeriodID;
    String evaluObjectID;
    String evaluObjectName;
    Map personMap = new HashMap();

    public SelfEvalHastenUI() throws Exception {
        this.btnAddPerson.setEnabled(true);
        this.btnSendMessage.setEnabled(true);
        this.btnSendMail.setEnabled(true);
        this.btnDeletePerson.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnSendMessage.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.btnSendMail.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnDeletePerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
    }

    @Override
    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = (MultiDimentionSolutionPeriodInfo)MultiDimentionSolutionPeriodFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.solutionPeriodID), sic);
        HashMap<String, MessageString> messageMap = new HashMap<String, MessageString>();
        int n = this.personTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object[] variables;
            String message;
            IRow row = this.personTable.getRow(i);
            if (PFVerifyUtils.objectIsNull(row.getCell("id").getValue())) continue;
            MessageString messageString = new MessageString();
            WorkFlowControlEnum role = (WorkFlowControlEnum)((Object)row.getCell("role").getValue());
            if (!WorkFlowControlEnum.UNDISPOSE.equals((Object)role)) {
                message = EASResource.getString((String)this.RES, (String)"evaluObjectEvalMessage");
                variables = new Object[]{this.evaluObjectName, solutionPeriodInfo.getName()};
            } else {
                message = EASResource.getString((String)this.RES, (String)"unDeliveredMessage");
                variables = new Object[]{solutionPeriodInfo.getName(), this.evaluObjectName};
            }
            messageString.setTitle(MessageFormat.format(message, variables));
            messageString.setSender(EASResource.getString((String)this.RES, (String)"sender"));
            messageMap.put(row.getCell("id").getValue().toString(), messageString);
        }
        EvalWorkFlowFacadeFactory.getRemoteInstance().sendMessage(messageMap);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"sendMessageSuccess"));
    }

    @Override
    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        int rowSize = this.personTable.getRowCount();
        if (rowSize <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"atleastOneEmailAddr"));
            SysUtil.abort();
        }
        StringBuffer to = new StringBuffer();
        int badEmailCount = 0;
        StringBuffer badEmailName = new StringBuffer();
        String email = null;
        IRow row = null;
        for (int i = 0; i < rowSize; ++i) {
            if (i != 0) {
                to.append(",");
            }
            if (StringUtils.isEmpty((String)(email = (String)(row = this.personTable.getRow(i)).getCell("email").getValue())) || email.indexOf("@") < 0) {
                if (badEmailCount != 0) {
                    badEmailName.append(",");
                }
                badEmailName.append(row.getCell("name").getValue().toString());
                ++badEmailCount;
                continue;
            }
            to.append(email);
        }
        if (badEmailCount > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(badEmailName);
            sb.append(EASResource.getString((String)this.RES, (String)"etc"));
            sb.append(badEmailCount);
            sb.append(EASResource.getString((String)this.RES, (String)"sendMailConfirm"));
            if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
                return;
            }
        }
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("id"));
            MultiDimentionSolutionPeriodInfo solutionPeriodInfo = (MultiDimentionSolutionPeriodInfo)MultiDimentionSolutionPeriodFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.solutionPeriodID), sic);
            String evaluObjectName = (String)this.getUIContext().get("evaluObjectName");
            Object[] variables = new Object[]{evaluObjectName, solutionPeriodInfo.getName()};
            String subject = EASResource.getString((String)this.RES, (String)"mailSubject");
            String content = EASResource.getString((String)this.RES, (String)"mailContent");
            MultiDimEvaluatorFactory.getRemoteInstance().sendMail(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString(), to.toString(), MessageFormat.format(subject, variables), MessageFormat.format(content, variables));
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SENDMAIL_FAIL")), (Throwable)err);
            SysUtil.abort();
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SENDMAIL_SUCCESS")));
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddPerson_actionPerformed(e);
        KDPromptBox promptBox = new KDPromptBox();
        EmployeeMultiF7PromptBox mBox = (EmployeeMultiF7PromptBox)EvaluSolutionF7Helper.getEmployeeF7ForNoPositionPerson((IUIObject)this);
        promptBox.setSelector((KDPromptSelector)mBox);
        promptBox.setDataBySelector();
        Object[] objs = (Object[])promptBox.getValue();
        ArrayList<String> idList = new ArrayList<String>();
        if (!PFVerifyUtils.objectIsNull(objs) && !PFVerifyUtils.objectIsNull(objs[0])) {
            int n = objs.length;
            for (int i = 0; i < n; ++i) {
                PersonInfo personInfo = (PersonInfo)objs[i];
                if (this.personMap.containsKey(personInfo.getId().toString())) continue;
                idList.add(personInfo.getId().toString());
            }
        }
        if (idList.size() > 0) {
            String[] ids = new String[idList.size()];
            int n = idList.size();
            for (int i = 0; i < n; ++i) {
                ids[i] = (String)idList.get(i);
                this.personMap.put(ids[i], WorkFlowControlEnum.ASSIGNER);
            }
            IRowSet rowSet = this.getPersonRowSetByPersonIds(ids);
            String org = null;
            String noPos = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"noPositionPerson");
            while (rowSet.next()) {
                IRow row = this.personTable.addRow();
                row.getCell("id").setValue((Object)rowSet.getString("id"));
                row.getCell("name").setValue((Object)rowSet.getString("name"));
                row.getCell("number").setValue((Object)rowSet.getString("number"));
                row.getCell("position").setValue((Object)rowSet.getString("position.name"));
                org = rowSet.getString("adminOrgUnit.displayName");
                if (org == null || "".equals(org.trim())) {
                    org = noPos;
                }
                row.getCell("orgunit").setValue((Object)org);
                row.getCell("role").setValue((Object)((WorkFlowControlEnum)((Object)this.personMap.get(rowSet.getString("id")))));
                row.getCell("email").setValue((Object)rowSet.getString("email"));
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    @Override
    public void actionDeletePerson_actionPerformed(ActionEvent e) throws Exception {
        int top;
        super.actionDeletePerson_actionPerformed(e);
        if (this.personTable.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelectedRecord");
        }
        if (this.personTable.getRow(top = this.personTable.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelectedRecord");
        }
        HashMap<Object, Object> deleteMap = new HashMap<Object, Object>();
        KDTSelectBlock sb = null;
        int size = this.personTable.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.personTable.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                deleteMap.put(this.personTable.getRow(j).getCell("id").getValue(), this.personTable.getRow(j).getCell("id").getValue());
            }
        }
        if (deleteMap.size() >= this.personMap.size()) {
            this.showErrorMessage("notDeleteAll");
        }
        int n = 0;
        for (int i = this.personTable.getRowCount() - 1; i >= n; --i) {
            IRow row = this.personTable.getRow(i);
            if (PFVerifyUtils.objectIsNull(row.getCell("id").getValue()) || !deleteMap.containsKey(row.getCell("id").getValue())) continue;
            this.personMap.remove(row.getCell("id").getValue().toString());
            this.personTable.removeRow(i);
        }
    }

    private IRowSet getPersonRowSetByPersonIds(String[] ids) throws Exception {
        if (PFVerifyUtils.objectIsNull(ids) || ids.length == 0) {
            return null;
        }
        IRowSet rowSet = null;
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<String> set = new HashSet<String>();
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            set.add(ids[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "WorkFlowControlPersonQuery"));
        iqec.setObjectView(viewInfo);
        try {
            rowSet = iqec.executeQuery();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return rowSet;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.personTable.checkParsed();
        this.solutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        this.evaluObjectID = (String)this.getUIContext().get("evaluObjectID");
        this.evaluObjectName = (String)this.getUIContext().get("evaluObjectName");
        if (PFVerifyUtils.objectIsNull(this.evaluObjectID)) {
            this.showErrorMessage("evaluobjectNotNull");
        }
        if (PFVerifyUtils.objectIsNull(this.solutionPeriodID)) {
            this.showErrorMessage("solutionperiodNotNull");
        }
        if (PFVerifyUtils.objectIsNull(this.evaluObjectName)) {
            this.showErrorMessage("evaluObjectNameNotNull");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("multiDimObject.id"));
        sic.add(new SelectorItemInfo("multiDimObject.person.id"));
        MultiDimEvaluatorInfo evalInfo = (MultiDimEvaluatorInfo)MultiDimEvaluatorFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.evaluObjectID), sic);
        String evalor = evalInfo.getMultiDimObject().getPerson().getId().toString();
        String[] ids = new String[]{evalor};
        this.personMap.put(evalor, WorkFlowControlEnum.EVALUOBJECT);
        IRowSet rowSet = this.getPersonRowSetByPersonIds(ids);
        while (rowSet.next()) {
            IRow row = this.personTable.addRow();
            row.getCell("id").setValue((Object)rowSet.getString("id"));
            row.getCell("name").setValue((Object)rowSet.getString("name"));
            row.getCell("number").setValue((Object)rowSet.getString("number"));
            row.getCell("position").setValue((Object)rowSet.getString("position.name"));
            row.getCell("JobGrade.name").setValue((Object)rowSet.getString("JobGrade.name"));
            row.getCell("orgunit").setValue((Object)rowSet.getString("adminOrgUnit.name"));
            row.getCell("role").setValue((Object)((WorkFlowControlEnum)((Object)this.personMap.get(rowSet.getString("id")))));
            row.getCell("email").setValue((Object)rowSet.getString("email"));
            row.getStyleAttributes().setLocked(true);
        }
        this.personTable.getSelectManager().setSelectMode(10);
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)this.RES, (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }
}

