/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.hr.perf.EvalRelationDetailCollection;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.IEvalRelationDetail;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractSelfEvaluatorListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;

public class SelfEvaluatorListUI
extends AbstractSelfEvaluatorListUI {
    private String currentMDID = null;
    private String currentSolutionPeriodID = null;
    protected IIDList idList = null;

    public void onLoad() throws Exception {
        this.currentMDID = (String)this.getUIContext().get("ID");
        this.currentSolutionPeriodID = (String)this.getUIContext().get("SUID");
        this.idList = (IIDList)this.getUIContext().get("IDList");
        String currentPersonID = this.getPersonIDByEvalID(this.currentMDID);
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblSelected.getStyleAttributes().setLocked(true);
        int n = this.tblSelected.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.tblSelected.getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.fillHeadInfo(currentPersonID);
        this.initScrollButtons();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        this.tblMain_doRequestRowSetForNoQueryPK(e);
    }

    @Override
    public IUIActionPostman prepareInit() {
        this.currentMDID = (String)this.getUIContext().get("ID");
        this.currentSolutionPeriodID = (String)this.getUIContext().get("SUID");
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        req.put("currentMDID", (Object)this.currentMDID);
        req.put("currentSolutionPeriodID", (Object)this.currentSolutionPeriodID);
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFirstRecord.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPreRecord.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNexeRecord.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnEndRecord.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        super.setButtonDefaultStyl(this.btnFirstRecord);
        super.setButtonDefaultStyl(this.btnPreRecord);
        super.setButtonDefaultStyl(this.btnNexeRecord);
        super.setButtonDefaultStyl(this.btnEndRecord);
    }

    private String getPersonIDByEvalID(String ID) throws Exception {
        if (ID == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("multiDimObject.id"));
        sic.add(new SelectorItemInfo("multiDimObject.person.id"));
        MultiDimEvaluatorInfo mdei = MultiDimEvaluatorFactory.getRemoteInstance().getMultiDimEvaluatorInfo((IObjectPK)new ObjectUuidPK(ID), sic);
        return mdei.getMultiDimObject().getPerson().getId().toString();
    }

    private void fillHeadInfo(String personID) throws Exception {
        PersonInfo person = (PersonInfo)PersonFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(personID));
        this.txtPersonName.setText(person.getName());
        this.txtPersonNumber.setText(person.getNumber());
        PositionInfo position = this.getPositionReferToPerson(person);
        if (position != null) {
            this.txtPosition.setText(position.getName());
            this.txtOrg.setText(position.getAdminOrgUnit().getName());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("MDSolution.id"));
        sic.add(new SelectorItemInfo("MDSolution.operateDescript"));
        if (this.currentSolutionPeriodID != null) {
            MultiDimentionSolutionPeriodInfo info = MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.currentSolutionPeriodID), sic);
            this.txtOP.setText(info.getMDSolution().getOperateDescript());
        }
    }

    private PositionInfo getPositionReferToPerson(PersonInfo person) throws Exception {
        if (person == null) {
            return null;
        }
        IPositionMember iPositionMember = PositionMemberFactory.getRemoteInstance();
        PositionInfo positionInfo = null;
        if (person.getId() == null) {
            return null;
        }
        PositionMemberCollection positionMemberCollection = iPositionMember.getPositionsByPerson(person.getId());
        positionInfo = positionMemberCollection == null || positionMemberCollection.size() == 0 ? null : positionMemberCollection.get(0).getPosition();
        return positionInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MDEvaluator.id", (Object)this.currentMDID));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)this.currentSolutionPeriodID));
        return filter;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        ev.setFilter(this.getDefaultFilterForQuery());
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        EntityViewInfo newViewInfo = new EntityViewInfo();
        newViewInfo.put("sorter", (Object)viewInfo.getSorter());
        newViewInfo.setFilter(this.getDefaultFilterForQuery());
        IQueryExecutor exec = super.getQueryExecutor(queryPK, newViewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e != null && e.getType() == 0) {
            super.tblMain_tableClicked(e);
            this.staticistic();
        } else {
            if (e != null && e.getRowIndex() == this.tblMain.getRowCount() - 1) {
                return;
            }
            String id = this.getSelectedKeyValue();
            String name = this.getSelectedRelationName();
            if (id != null) {
                this.fillSelectedTable(id, name);
            }
        }
    }

    protected String getSelectedRelationName() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("name");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private void fillSelectedTable(String relationID, String name) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalRelation.id", (Object)relationID));
        filter.getFilterItems().add(new FilterItemInfo("MDEvaluator.id", (Object)this.currentMDID));
        filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(30), CompareType.NOTEQUALS));
        viewInfo.setFilter(filter);
        SorterItemCollection sic = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("person.number");
        sic.add(item);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "SelectedEvalPersonQuery");
        IQueryExecutor exec = super.getQueryExecutor((IMetaDataPK)queryPK, viewInfo);
        this.tblSelected.removeRows();
        IRowSet rowSet = exec.executeQuery();
        IRow row = null;
        String org = null;
        String noPos = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"noPositionPerson");
        while (rowSet.next()) {
            row = this.tblSelected.addRow();
            row.getCell("id").setValue((Object)rowSet.getString("id"));
            row.getCell("number").setValue((Object)rowSet.getString("person.number"));
            row.getCell("name").setValue((Object)rowSet.getString("person.name"));
            org = rowSet.getString("adminOrgUnit.displayName");
            if (org == null || "".equals(org.trim())) {
                org = noPos;
            }
            row.getCell("orgUnit").setValue((Object)org);
            row.getCell("position").setValue((Object)rowSet.getString("position.name"));
            row.getCell("jobGrade").setValue((Object)rowSet.getString("JobGrade.name"));
            row.getCell("jobLevel").setValue((Object)rowSet.getString("JobLevel.name"));
            row.getCell("evalRelation").setValue((Object)name);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        String type = null;
        try {
            IEvalRelationDetail ierd = EvalRelationDetailFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = null;
            while (rowSet.next()) {
                type = rowSet.getString("MDEvaluTypeEnum");
                if (!MDEvaluTypeEnum.APPOINT.toString().equals(type)) {
                    rowSet.updateString("name", type);
                } else {
                    rowSet.updateString("name", rowSet.getString("name") + "(" + type + ")");
                }
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("MDEvaluator.id", (Object)this.currentMDID));
                filter.getFilterItems().add(new FilterItemInfo("evalRelation.id", (Object)rowSet.getString("id")));
                viewInfo.setFilter(filter);
                EvalRelationDetailCollection coll = ierd.getEvalRelationDetailCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    rowSet.updateString("mdEvaluGroup.number", "" + coll.get(0).getSelected());
                    continue;
                }
                rowSet.updateString("mdEvaluGroup.number", "0");
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    @Override
    public void actionEndRecord_actionPerformed(ActionEvent e) throws Exception {
        this.currentMDID = this.idList.getLastID();
        this.changeData();
    }

    @Override
    public void actionFirstRecord_actionPerformed(ActionEvent e) throws Exception {
        this.currentMDID = this.idList.getFirstID();
        this.changeData();
    }

    @Override
    public void actionNextRecord_actionPerformed(ActionEvent e) throws Exception {
        this.currentMDID = this.idList.getNextID();
        this.changeData();
    }

    @Override
    public void actionPreRecord_actionPerformed(ActionEvent e) throws Exception {
        this.currentMDID = this.idList.getPreviousID();
        this.changeData();
    }

    private void changeData() throws Exception {
        String currentPersonID = this.getPersonIDByEvalID(this.currentMDID);
        this.fillHeadInfo(currentPersonID);
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0, 0, this.tblMain.getColumnIndex("EvalRelationDetail.selected"));
        }
        this.execQuery();
        this.tblSelected.removeRows();
        this.initScrollButtons();
        this.staticistic();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0, 0, this.tblMain.getColumnIndex("EvalRelationDetail.selected"));
            this.tblMain_tableClicked(null);
        }
    }

    protected void initScrollButtons() {
        if (this.idList == null) {
            this.actionFirstRecord.setEnabled(false);
            this.actionPreRecord.setEnabled(false);
            this.actionNextRecord.setEnabled(false);
            this.actionEndRecord.setEnabled(false);
            return;
        }
        if (this.idList.getCurrentIndex() < 0 || this.idList.isBegin()) {
            this.actionFirstRecord.setEnabled(false);
            this.actionPreRecord.setEnabled(false);
        } else {
            this.actionFirstRecord.setEnabled(true);
            this.actionPreRecord.setEnabled(true);
        }
        if (this.idList.isEnd()) {
            this.actionNextRecord.setEnabled(false);
            this.actionEndRecord.setEnabled(false);
        } else {
            this.actionNextRecord.setEnabled(true);
            this.actionEndRecord.setEnabled(true);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0, 0, this.tblMain.getColumnIndex("EvalRelationDetail.selected"));
            this.tblMain_tableClicked(null);
        }
        this.staticistic();
    }

    private void staticistic() {
        if (this.tblMain.getRowCount() > 0) {
            IRow row = null;
            BigDecimal sumWeight = new BigDecimal("0.00");
            BigDecimal temp = null;
            Integer sumMinRestrict = new Integer(0);
            Integer sumPersonRestrict = new Integer(0);
            Integer tempInt0 = null;
            Integer tempInt = null;
            Integer sumSelected = new Integer(0);
            Object obj = null;
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; ++i) {
                row = this.tblMain.getRow(i);
                temp = (BigDecimal)row.getCell("weight").getValue();
                if (temp != null) {
                    sumWeight = sumWeight.add(temp);
                }
                if ((tempInt0 = (Integer)row.getCell("minRestrict").getValue()) != null) {
                    sumMinRestrict = new Integer(sumMinRestrict + tempInt0);
                }
                if ((tempInt = (Integer)row.getCell("personRestrict").getValue()) != null) {
                    sumPersonRestrict = new Integer(sumPersonRestrict + tempInt);
                }
                if ((obj = row.getCell("EvalRelationDetail.selected").getValue()) == null) continue;
                sumSelected = new Integer(sumSelected + Integer.parseInt(obj.toString()));
            }
            row = this.tblMain.addRow();
            row.getCell("weight").setValue((Object)sumWeight);
            row.getCell("minRestrict").setValue((Object)sumMinRestrict);
            row.getCell("personRestrict").setValue((Object)sumPersonRestrict);
            row.getCell("EvalRelationDetail.selected").setValue((Object)sumSelected);
            row.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isPrepareActionAddNew() {
        return false;
    }

    @Override
    public boolean isPrepareActionEdit() {
        return false;
    }

    @Override
    public boolean isPrepareActionQuery() {
        return false;
    }

    @Override
    public boolean isPrepareActionRefresh() {
        return false;
    }

    @Override
    public boolean isPrepareActionView() {
        return false;
    }
}

