/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.message.client.MessageServiceProvider;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.client.AbstractSolutionPeriodDetailOrgUnitListUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.NodeProcesserInputUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.SolutionPeriodDetailOrgUnitFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class SolutionPeriodDetailOrgUnitListUI
extends AbstractSolutionPeriodDetailOrgUnitListUI {
    private static final Logger logger = CoreUIObject.getLogger(SolutionPeriodDetailOrgUnitListUI.class);
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private CommonQueryDialog queryDlg;
    private SolutionPeriodDetailOrgUnitFilterUI filterUI;

    public void onLoad() throws Exception {
        super.onLoad();
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.setColumnMoveable(true);
        PFUtils.setTableNumberFormat(this.tblMain, "targetEvaluScore", 2);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEvaluForm.setIcon(EASResource.getIcon((String)"imgTbtn_listfile"));
        this.btnViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemEvaluForm.setIcon(EASResource.getIcon((String)"imgTbtn_listfile"));
        this.menuItemViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            BigDecimal percent = new BigDecimal("0.01");
            while (rowSet.next()) {
                rowSet.updateString("assessPeriod", EvaluSolutionHelper.getStartDate2EndDateString(rowSet.getDate("assessPeriod.startDate"), rowSet.getDate("assessPeriod.endDate")));
                rowSet.updateString("deliveredTargetNumber", rowSet.getString("isDelivered") + "/" + rowSet.getString("deliveredTargetNumber"));
                if (rowSet.getBigDecimal("deliveredTargetWeight") != null) {
                    rowSet.updateBigDecimal("deliveredTargetWeight", rowSet.getBigDecimal("deliveredTargetWeight").multiply(percent));
                }
                if (rowSet.getObject("evalWFObjects.status") != null && (Integer)rowSet.getObject("evalWFObjects.status") != 30) {
                    rowSet.updateString("rank", null);
                }
                if (rowSet.getBigDecimal("evaluResult.modifiedScore") != null) {
                    rowSet.updateBigDecimal("evaluResult.targetEvaluScore", rowSet.getBigDecimal("evaluResult.modifiedScore"));
                }
                if (((BizEnumValueDTO)rowSet.getObject("EvaluSolution.targetGradeMode")).getInt() != 101) continue;
                rowSet.updateString("evaluResult.targetEvaluScore", "");
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        super.onGetRowSet(rowSet);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        try {
            if (this.queryDlg != null) {
                return this.queryDlg;
            }
            this.queryDlg = new CommonQueryDialog();
            this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
            this.queryDlg.setHeight(350);
            this.queryDlg.setWidth(450);
            this.queryDlg.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDlg.setTitle(this.getFilterUI().getUITitle());
            this.queryDlg.setShowSorter(false);
            this.queryDlg.setUiObject((IUIObject)this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return this.queryDlg;
    }

    @Override
    public void actionEvaluForm_actionPerformed(ActionEvent e) throws Exception {
        super.actionEvaluForm_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String personId = (String)row.getCell("responserId").getValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", (Object)solutionPeriodId);
        uiContext.put((Object)"evaluObject", (Object)evaluObjectId);
        uiContext.put((Object)"evaluPersonId", (Object)personId);
        uiContext.put((Object)"type", (Object)"nodeProcesser");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(NodeProcesserInputUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public RequestContext prepareActionViewFlow(IItemAction itemAction) throws Exception {
        RequestContext req = super.prepareActionViewFlow(itemAction);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue();
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        req.put("evaluSolutionId", (Object)evaluSolutionId);
        req.put("solutionPeriodId", (Object)solutionPeriodId);
        req.put("evaluObjectId", (Object)evaluObjectId);
        return req;
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewFlow_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue();
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        if (!EvaluSolutionHelper.isExistFlow(solutionPeriodId, evaluObjectId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoFlow"));
            SysUtil.abort();
        }
        if (!this.isExistFlowInstance(evaluSolutionId)) {
            this.showWfDiagramOnNoFlow(evaluObjectId, solutionPeriodId);
        } else {
            if (solutionPeriodId == null || evaluObjectId == null) {
                return;
            }
            String assignmentID = EvalWorkFlowFacadeFactory.getRemoteInstance().getAssignmentID(solutionPeriodId, evaluObjectId);
            if (assignmentID == null) {
                this.showWfDiagramOnNoFlow(evaluObjectId, solutionPeriodId);
            } else {
                MessageServiceProvider.showWfDiagram((Component)((Object)this), (String)assignmentID);
            }
        }
    }

    private void showWfDiagramOnNoFlow(String evaluObjectID, String solutionPeriodID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("evaluObject.id", (Object)evaluObjectID);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0 AND #1");
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalWorkFlowQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        String workflowId = null;
        if (rowSet.size() != 0) {
            rowSet.next();
            workflowId = rowSet.getString("workFlowID");
            PFVerifyUtils.showWorkFlowDef((CoreUIObject)this, workflowId);
        }
    }

    private boolean isExistFlowInstance(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        EvaluSolutionInfo solutionInfo = EvaluSolutionHelper.getEvaluSolutionInfo(evaluSolutionId);
        DeliverModeEnum deliverModeEnum = solutionInfo.getDeliverMode();
        return deliverModeEnum == null || !deliverModeEnum.equals((Object)DeliverModeEnum.DIRECT_ENTER);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public SolutionPeriodDetailOrgUnitFilterUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SolutionPeriodDetailOrgUnitFilterUI();
        }
        return this.filterUI;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        this.tblMain_doRequestRowSetForNoQueryPK(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.status", (Object)new Integer(100), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("evaluSolution.solutionType", (Object)new Integer(101)));
        fi.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "orgUnit.id"));
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        return fi;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    @Override
    public boolean isPrepareActionEvaluForm() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewFlow() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

