/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluRuleInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractSolutionPeriodUI;
import com.kingdee.eas.hr.perf.client.EvaluFormSolutionUIHelper;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class SolutionPeriodUI
extends AbstractSolutionPeriodUI {
    private static final Logger logger = CoreUIObject.getLogger(SolutionPeriodUI.class);
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private String queryFullName = "com.kingdee.eas.hr.perf.app.EvaluFormSolutionQuery";
    private boolean isDelEvaluGroup = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIStatus();
        String pk = (String)this.getUIContext().get("EvaluSolutionID");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("keyEvent");
        EvaluSolutionInfo info = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(pk), selector);
        this.prmKeyState.setEnabled(info.isKeyEvent());
        this.prmKeyState.setEditable(false);
        this.prmKeyState.setRequired(info.isKeyEvent());
        this.prmKeyState.setEditFormat("$number$");
        this.prmKeyState.setDisplayFormat("$name$");
        this.prmKeyState.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(PFUtils.getHRFilter());
        this.prmtAssessPeriod.setEntityViewInfo(evi);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.prmtAssessPeriod.setEnabled(false);
            this.pkEvaluStartDate.setEnabled(false);
            this.pkEvaluEndDate.setEnabled(false);
            this.txtFormTitle.setEnabled(false);
            this.txtRemark.setEnabled(false);
            this.prmtFormSolution.setEnabled(false);
            this.txtFormMemo.setEnabled(false);
            this.prmtAchPer.setEnabled(false);
            this.prmKeyState.setEnabled(false);
            this.btn_referenceCT.setEnabled(false);
            this.btn_DelCT.setEnabled(false);
            this.btnTargetManageAttachment.setEnabled(false);
            this.btnEvaluFormAttachment.setEnabled(false);
            this.txtTargetManage.setEnabled(false);
            this.btn_DelCT.setEnabled(false);
        }
        if (this.editData != null && (this.editData.getStatus().equals((Object)SolutionPeriodStatusEnum.ON_EVALU) || this.editData.getStatus().equals((Object)SolutionPeriodStatusEnum.END_EVALU))) {
            this.btnEdit.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getUIContext().get("superOprtState"))) {
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
        this.prmtFormSolution.setVisible(false);
        this.txtCompactTemplate.setEnabled(false);
        if (this.prmtFormSolution.getValue() == null || this.txtCompactTemplate.getText().equals("")) {
            this.btn_DelCT.setEnabled(false);
        }
        EntityViewInfo view = null;
        this.prmtAchPer.setQueryInfo("com.kingdee.eas.hr.perf.app.AchieveStatisticsPeriodQuery");
        this.prmtAchPer.setEditFormat("$number$");
        this.prmtAchPer.setDisplayFormat("$name$");
        this.prmtAchPer.setCommitFormat("$number$");
        view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        view.setFilter(filter);
        this.prmtAchPer.setEntityViewInfo(view);
        this.prmKeyState.setEntityViewInfo(view);
    }

    private void initUIStatus() {
        this.prmtAssessPeriod.setRequired(true);
        this.pkEvaluStartDate.setRequired(true);
        this.pkEvaluEndDate.setRequired(true);
        this.prmtAssessPeriod.setEditable(false);
        this.prmtAchPer.setEditable(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtAssessPeriod.requestFocus(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.pkPeriodStrartDate.setValue(null);
            this.pkPeriodEndDate.setValue(null);
            this.pkEvaluStartDate.setValue(null);
            this.pkEvaluEndDate.setValue(null);
        }
    }

    protected void lockUIForViewStatus() {
        this.prmtAssessPeriod.setEnabled(false);
        this.pkEvaluStartDate.setEnabled(false);
        this.pkEvaluEndDate.setEnabled(false);
        this.txtFormTitle.setEnabled(false);
        this.txtRemark.setEnabled(false);
        this.prmtFormSolution.setEnabled(false);
        this.txtFormMemo.setEnabled(false);
        this.prmtAchPer.setEnabled(false);
        this.btn_referenceCT.setEnabled(false);
        this.btn_DelCT.setEnabled(false);
        this.btnTargetManageAttachment.setEnabled(false);
        this.btnEvaluFormAttachment.setEnabled(false);
        this.txtTargetManage.setEnabled(false);
    }

    protected void unLockUI() {
        super.unLockUI();
        this.prmtAssessPeriod.setEnabled(true);
        this.pkEvaluStartDate.setEnabled(true);
        this.pkEvaluEndDate.setEnabled(true);
        this.txtFormTitle.setEnabled(true);
        this.txtRemark.setEnabled(true);
        this.prmtFormSolution.setEnabled(true);
        this.txtFormMemo.setEnabled(true);
        this.prmtAchPer.setEnabled(true);
        this.prmKeyState.setEnabled(true);
        this.btn_referenceCT.setEnabled(true);
        this.btn_DelCT.setEnabled(true);
        this.btnTargetManageAttachment.setEnabled(true);
        this.btnEvaluFormAttachment.setEnabled(true);
        this.txtTargetManage.setEnabled(true);
    }

    @Override
    public void storeFields() {
        Date endDate;
        Date startDate;
        super.storeFields();
        StringBuffer sb = new StringBuffer();
        EvaluSolutionInfo evaluSolutionInfo = this.editData.getEvaluSolution();
        AssessPeriodInfo assessPeriod = this.editData.getAssessPeriod();
        if (assessPeriod != null) {
            sb.append(evaluSolutionInfo.getName());
            sb.append(" ");
            sb.append(EvaluSolutionHelper.getStartDate2EndDateString(assessPeriod.getStartDate(), assessPeriod.getEndDate()));
            Locale locale = PFUtils.getLocale();
            if (locale.equals(PFUtils.getSLocale())) {
                this.editData.setName(sb.toString(), locale);
                this.editData.setName(STConverter.sc2tc((String)sb.toString()), PFUtils.getTLocale());
            } else if (locale.equals(PFUtils.getTLocale())) {
                this.editData.setName(sb.toString(), locale);
                this.editData.setName(STConverter.tc2sc((String)sb.toString()), PFUtils.getSLocale());
            } else {
                this.editData.setName(sb.toString());
            }
        }
        if ((startDate = this.editData.getEvaluStartDate()) != null) {
            startDate = DateTimeUtils.truncateDate((Date)startDate);
            this.editData.setEvaluStartDate(startDate);
        }
        if ((endDate = this.editData.getEvaluEndDate()) != null) {
            endDate = DateTimeUtils.truncateDate((Date)endDate);
            this.editData.setEvaluEndDate(endDate);
        }
    }

    protected IObjectValue createNewData() {
        SolutionPeriodInfo solutionPeriodInfo = new SolutionPeriodInfo();
        solutionPeriodInfo.setStatus(SolutionPeriodStatusEnum.UN_EVALU);
        String solutionID = this.getUIContext().get("EvaluSolutionID").toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        try {
            EvaluSolutionInfo info = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(solutionID), sic);
            solutionPeriodInfo.setEvaluSolution(info);
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        solutionPeriodInfo.setFormTitle(EASResource.getString((String)this.resourcePath, (String)"DefaultFormTitle"));
        solutionPeriodInfo.setHrOrgUnit(PFUtils.getCurrentHROrgUnit());
        return solutionPeriodInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SolutionPeriodFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtAssessPeriod);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkEvaluStartDate);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkEvaluEndDate);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtCompactTemplate);
        PFVerifyUtils.verifyDateBigOrSmall((CoreUIObject)this, this.pkEvaluStartDate, this.pkEvaluEndDate);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtFormTitle);
        if (this.prmKeyState.isRequired()) {
            PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmKeyState);
        }
        this.checkPeriodHasBeenUsed();
    }

    private void checkPeriodHasBeenUsed() throws Exception {
        AssessPeriodInfo assessPeriod = (AssessPeriodInfo)this.prmtAssessPeriod.getValue();
        String editdataID = null;
        if (this.editData.getId() != null) {
            editdataID = this.editData.getId().toString();
        }
        if (EvaluSolutionHelper.checkPeriodHasBeenUsed(assessPeriod.getId().toString(), (String)this.getUIContext().get("EvaluSolutionID"), editdataID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"PeriodHasBeenUsed"));
            this.prmtAssessPeriod.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtAssessPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtAssessPeriod_dataChanged(e);
        AssessPeriodInfo assessPeriodInfo = (AssessPeriodInfo)this.prmtAssessPeriod.getData();
        if (assessPeriodInfo == null) {
            return;
        }
        Date startDate = assessPeriodInfo.getStartDate();
        Date endDate = assessPeriodInfo.getEndDate();
        this.pkPeriodStrartDate.setValue((Object)startDate);
        this.pkPeriodEndDate.setValue((Object)endDate);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("evaluSolution.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("targetManageDesAttachId"));
        sic.add(new SelectorItemInfo("evaluFormDescAttachId"));
        return sic;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected void showSubmitSuccess() {
        super.showSubmitSuccess();
        this.setSave(true);
        this.setSaved(true);
        super.initOldData((IObjectValue)this.editData);
        this.getUIWindow().close();
    }

    @Override
    protected void btn_referenceCT_actionPerformed(ActionEvent e) throws Exception {
        EvaluFormSolutionInfo info;
        super.btn_referenceCT_actionPerformed(e);
        if (this.prmtFormSolution.getValue() != null || !this.txtCompactTemplate.getText().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"SaveContractTemplateFirst"));
            SysUtil.abort();
        }
        KDCommonPromptDialog solutionPeriodF7 = new KDCommonPromptDialog();
        solutionPeriodF7.setEnabledMultiSelection(true);
        MetaDataPK queryPK = new MetaDataPK(this.queryFullName);
        QueryAgent queryAgent = new QueryAgent();
        queryAgent.setQueryInfoPK(queryPK);
        solutionPeriodF7.setQueryInfo(queryAgent.getQueryInfo());
        String evaluSolutionID = this.editData.getEvaluSolution().getId().toString();
        EvaluSolutionInfo evaluSolutionInfo = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(evaluSolutionID));
        EvaluRuleInfo evaluRuleInfo = evaluSolutionInfo.getEvaluRule();
        String evaluRuleID = "%";
        evaluRuleID = evaluRuleInfo != null ? evaluRuleID + evaluRuleInfo.getId().toString() + "%" : "";
        Set preSetEvaluFormSolutionId = EvaluFormSolutionUIHelper.getPreSetEvaluFormSolutionId();
        EntityViewInfo view = null;
        view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionState", (Object)String.valueOf(1)));
        fi.getFilterItems().add(new FilterItemInfo("meetRuleMode", (Object)evaluRuleID, CompareType.LIKE));
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)EvaluFormSolutionUIHelper.getPreSetEvaluFormSolutionId(), CompareType.INCLUDE));
        boolean isOrg = EvaluSolutionTypeEnum.ORGUNIT.equals((Object)evaluSolutionInfo.getSolutionType());
        if (isOrg) {
            fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)String.valueOf(101)));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("evaluObjectType", (Object)String.valueOf(100)));
        }
        fi.setMaskString("#0 and #1 and (#2 or #3) and #4)");
        view.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("solutionState"));
        sic.add(new SelectorItemInfo("description"));
        view.setSelector(sic);
        view.setFilter(fi);
        solutionPeriodF7.setEntityViewInfo(view);
        solutionPeriodF7.show();
        if (solutionPeriodF7.isCanceled()) {
            return;
        }
        Object obj = solutionPeriodF7.getData();
        if (!SolutionPeriodUI.objectIsNull(obj) && (info = SolutionPeriodUI.getObjectArrayIds(obj)) != null) {
            this.txtCompactTemplate.setText(info.getName());
            this.txtFormMemo.setText(info.getMemo());
            this.prmtFormSolution.setValue((Object)info);
            this.btn_DelCT.setEnabled(true);
        }
    }

    public static EvaluFormSolutionInfo getObjectArrayIds(Object obj) {
        Object[] objs;
        int n;
        int i;
        EvaluFormSolutionInfo info = null;
        if (!SolutionPeriodUI.objectIsNull(obj) && (i = 0) < (n = (objs = (Object[])obj).length)) {
            info = (EvaluFormSolutionInfo)objs[i];
        }
        return info;
    }

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof DataToken) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    @Override
    protected void btn_DelCT_actionPerformed(ActionEvent e) throws Exception {
        super.btn_DelCT_actionPerformed(e);
        int n = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmDelContractTemplate"));
        if (n == 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)this.editData.getId()));
            fi.getFilterItems().add(new FilterItemInfo("delivered", (Object)"1"));
            boolean isExist = EvaluGroupFactory.getRemoteInstance().exists(fi);
            if (isExist) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"cantDelContractTemplate"));
                SysUtil.abort();
            }
            this.txtCompactTemplate.setText(null);
            this.prmtFormSolution.setValue(null);
            this.txtFormMemo.setText(null);
            this.btn_DelCT.setEnabled(false);
        }
    }

    @Override
    protected void btnEvaluFormAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.btnEvaluFormAttachment_actionPerformed(e);
        String FEvaluFormDescAttachId = null;
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        if (this.editData == null || this.editData.getEvaluFormDescAttachId() == null) {
            SolutionPeriodInfo info = new SolutionPeriodInfo();
            BOSObjectType solutionPeriodType = info.getBOSType();
            FEvaluFormDescAttachId = BOSUuid.create((BOSObjectType)solutionPeriodType).toString();
            this.editData.setEvaluFormDescAttachId(FEvaluFormDescAttachId);
        } else {
            FEvaluFormDescAttachId = this.editData.getEvaluFormDescAttachId();
        }
        acm.showAttachmentListUIByBoID(FEvaluFormDescAttachId, (Object)this);
    }

    @Override
    protected void btnTargetManageAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.btnTargetManageAttachment_actionPerformed(e);
        String targetManageDesAttachId = null;
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        if (this.editData == null || this.editData.getTargetManageDesAttachId() == null) {
            SolutionPeriodInfo info = new SolutionPeriodInfo();
            BOSObjectType solutionPeriodType = info.getBOSType();
            targetManageDesAttachId = BOSUuid.create((BOSObjectType)solutionPeriodType).toString();
            this.editData.setTargetManageDesAttachId(targetManageDesAttachId);
        } else {
            targetManageDesAttachId = this.editData.getTargetManageDesAttachId();
        }
        acm.showAttachmentListUIByBoID(targetManageDesAttachId, (Object)this);
    }
}

