/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SumResultFactory;
import com.kingdee.eas.hr.perf.SumResultInfo;
import com.kingdee.eas.hr.perf.client.AbstractSumEvaluResultModifyUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;

public class SumEvaluResultModifyUI
extends AbstractSumEvaluResultModifyUI {
    private static final long serialVersionUID = -65534L;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final String editTitlte = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResult");
    private static final String unEditTitlte = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResultNotEdit");
    private static final String viewTitle = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResultTitle");
    private boolean onlyView = false;
    private SumResultInfo oldResult = null;

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("sumPerson.sumSolution.gradeMode.id"));
        sic.add(new SelectorItemInfo("sumPerson.sumSolution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("sumPerson.sumSolution.gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("sumPerson.sumSolution.rankGroup.id"));
        sic.add(new SelectorItemInfo("audited"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtModifiedScore.setEditable(true);
            this.txtModifyCause.setEditable(true);
            this.kDContainer1.setTitle(editTitlte);
        } else {
            this.txtModifiedScore.setEditable(false);
            if (!this.onlyView) {
                this.kDContainer1.setTitle(unEditTitlte);
            } else {
                this.kDContainer1.setTitle(viewTitle);
            }
            this.txtModifyCause.setEditable(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SumResultFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        BigDecimal maxGrade = this.editData.getSumPerson().getSumSolution().getGradeMode().getMaxGrade();
        BigDecimal minGrade = this.editData.getSumPerson().getSumSolution().getGradeMode().getMinGrade();
        BigDecimal grade = this.txtModifiedScore.getBigDecimalValue();
        if (grade != null) {
            if (grade.compareTo(maxGrade) > 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"tooLarger") + ":" + PFVerifyUtils.formatBigDecimal(maxGrade, 2)));
                SysUtil.abort();
            }
            if (grade.compareTo(minGrade) < 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"tooLess") + ":" + PFVerifyUtils.formatBigDecimal(minGrade, 2)));
                SysUtil.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.onlyView = true;
        }
        super.onLoad();
        this.txtModifiedScore.setRemoveingZeroInDispaly(false);
        this.txtModifiedScore.setRemoveingZeroInEdit(false);
        this.txtEvaluScore.setRemoveingZeroInDispaly(false);
        this.txtEvaluScore.setRemoveingZeroInEdit(false);
        this.txtEvaluScore.setEditable(false);
        if (this.editData.getSumPerson().getSumSolution().getRankGroup() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)this.editData.getSumPerson().getSumSolution().getRankGroup().getId().toString()));
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSorter().add(new SorterItemInfo("serial"));
            viewInfo.setFilter(filter);
            RankCollection rankColl = RankFactory.getRemoteInstance().getRankCollection(viewInfo);
            this.comboRank.addItems(rankColl.toArray());
            this.comboRank.setSelectedItem(null);
        }
        this.updateComboRank();
    }

    private void updateComboRank() {
        if (this.editData.getRank() != null) {
            BOSUuid id = this.editData.getRank().getId();
            int n = this.comboRank.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!id.equals((Object)((RankInfo)this.comboRank.getItemAt(i)).getId())) continue;
                this.comboRank.setSelectedIndex(i);
                break;
            }
        } else {
            this.comboRank.setSelectedItem(null);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        if (!this.onlyView && !this.editData.isAudited()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        if (!this.onlyView && !this.editData.isAudited()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        if (!this.onlyView && !this.editData.isAudited()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        if (!this.onlyView && !this.editData.isAudited()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.pickerModifyDate.setValue((Object)new Date());
            this.prmptModifier.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        }
        this.updateComboRank();
    }

    public IObjectPK runSave() throws Exception {
        Date date = this.editData.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
            this.editData.setModifyDate(date);
        }
        return super.runSave();
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setModifyDate(DateTimeUtils.truncateDate((Date)new Date()));
        this.editData.setModifier(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        this.editData.setModified(true);
        return super.runSubmit();
    }

    protected void initOldData(IObjectValue dataObject) {
        super.initOldData(dataObject);
        this.oldResult = (SumResultInfo)((SumResultInfo)dataObject).clone();
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        if (this.oldResult.getModifyScore() != null && this.editData.getModifyScore() != null ? this.oldResult.getModifyScore().compareTo(this.editData.getModifyScore()) != 0 : this.oldResult.getModifyScore() != this.editData.getModifyScore()) {
            return true;
        }
        return !this.causeEquals(this.oldResult.getModifyCause(), this.editData.getModifyCause());
    }

    private boolean causeEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return StringUtils.isEmpty((String)str2);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

