/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.ISumResult;
import com.kingdee.eas.hr.perf.NDFacadeFactory;
import com.kingdee.eas.hr.perf.SumItemCollection;
import com.kingdee.eas.hr.perf.SumItemFactory;
import com.kingdee.eas.hr.perf.SumResultFactory;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractSumResultListUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.NDBaseUI;
import com.kingdee.eas.hr.perf.client.NDCalculatorUI;
import com.kingdee.eas.hr.perf.client.NDCheckUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.RankConvertStartUI;
import com.kingdee.eas.hr.perf.client.SumEvaluResultModifyUI;
import com.kingdee.eas.hr.perf.client.SumExpUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class SumResultListUI
extends AbstractSumResultListUI {
    private static final long serialVersionUID = -61166L;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final String solutionName = "eas.hr.perf.SumEvaluResultRanking";
    private int isInfo = 0;
    private SumItemCollection items = null;
    private HashMap itemMap = new HashMap();
    private int[] itemIndexs = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnImport.setEnabled(true);
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemImport.setEnabled(true);
        this.menuItemImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.pkDateBegin.setValue(null);
        this.pkEndDate.setValue(null);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = PFUtils.getHRFilter();
        viewInfo.setFilter(filter);
        this.prmptSolution.setEntityViewInfo(viewInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("sumExp.id"));
        sic.add(new SelectorItemInfo("sumExp.text"));
        sic.add(new SelectorItemInfo("gradeMode.*"));
        sic.add(new SelectorItemInfo("assessPeriod.*"));
        this.prmptSolution.setSelectorCollection(sic);
        this.prmptSolution.setEditable(false);
        this.tHelper.setCanSetHideColumn(false);
        this.tHelper.setCanSetFrozeColumn(false);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                SumResultListUI.this.showDetailInfo();
            }
        });
    }

    private void showDetailInfo() {
        IRow row = null;
        String detail = null;
        StringTokenizer token = null;
        StringTokenizer devide = null;
        String key = null;
        String value = null;
        if (this.itemIndexs != null) {
            String error = null;
            int n = this.tblMain.getBody().size();
            for (int i = 0; i < n; ++i) {
                row = this.tblMain.getRow(i);
                detail = (String)row.getCell("detail").getValue();
                if (detail != null && !"".equals(detail.trim())) {
                    token = new StringTokenizer(detail, ";");
                    while (token.hasMoreTokens()) {
                        devide = new StringTokenizer(token.nextToken(), "=");
                        key = devide.nextToken().trim();
                        value = devide.nextToken().toString();
                        row.getCell(key).setValue((Object)value);
                    }
                }
                error = (String)row.getCell("error").getValue();
                error = this.replaceItemNumberWithTitle(error);
                row.getCell("errorAlias").setValue((Object)error);
            }
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        SumSolutionInfo info = (SumSolutionInfo)this.prmptSolution.getValue();
        if (info == null || info.getId() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"selectSumImportFA"));
            return;
        }
        if (this.confirmRestartFlow(this.isInfo)) {
            String sumSolutionID = info.getId().toString();
            ArrayList<DatataskParameter> importParam = new ArrayList<DatataskParameter>();
            DatataskParameter param = new DatataskParameter();
            param.solutionName = solutionName;
            param.alias = this.getUITitle();
            if (info.getId() != null) {
                param.putContextParam((Object)"solutionID", (Object)sumSolutionID);
            }
            importParam.add(param);
            boolean isCanceld = false;
            DatataskCaller task = new DatataskCaller();
            if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
                task.setParentComponent((Component)((Object)this));
                task.invoke(importParam, 0);
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.getStatus();
        this.getStatusInfo();
    }

    private void getStatus() {
        boolean isFlag = false;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String audited = this.tblMain.getRow(i).getCell("audited").getValue().toString();
            if ("true".equals(audited)) continue;
            isFlag = true;
            break;
        }
        if (!isFlag) {
            this.btnImport.setEnabled(false);
            this.menuItemImport.setEnabled(false);
        } else {
            this.btnImport.setEnabled(true);
            this.menuItemImport.setEnabled(true);
        }
    }

    private void getStatusInfo() {
        boolean isFlag = false;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String audited = this.tblMain.getRow(i).getCell("audited").getValue().toString();
            if (!"true".equals(audited)) continue;
            isFlag = true;
            break;
        }
        this.isInfo = !isFlag ? 1 : 0;
    }

    private boolean confirmRestartFlow(int isInfo) {
        if (isInfo == 0) {
            return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"reviewData")));
        }
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            int col = e.getColIndex();
            if (col == this.tblMain.getColumnIndex("error")) {
                return;
            }
            if (this.itemIndexs != null) {
                for (int i = 0; i < this.itemIndexs.length; ++i) {
                    if (col != this.itemIndexs[i]) continue;
                    return;
                }
            }
        }
        super.tblMain_tableClicked(e);
    }

    private String replaceItemNumberWithTitle(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(value, " ");
        StringBuffer sb = new StringBuffer();
        String chip = null;
        while (token.hasMoreTokens()) {
            chip = token.nextToken();
            if (this.itemMap.containsValue(chip)) {
                sb.append(chip);
            } else {
                sb.append((String)this.itemMap.get(chip));
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SumResultFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return SumEvaluResultModifyUI.class.getName();
    }

    @Override
    protected void chkDetail_itemStateChanged(ItemEvent e) throws Exception {
        this.renderDetailInfo();
        this.showDetailInfo();
    }

    private void renderDetailInfo() {
        if (this.itemIndexs != null) {
            int errorIndex = this.tblMain.getColumnIndex("errorAlias");
            this.tblMain.removeColumn(errorIndex);
            for (int index = this.itemIndexs.length - 1; index >= 0; --index) {
                this.tblMain.removeColumn(this.itemIndexs[index]);
            }
            this.itemIndexs = null;
        }
        if (this.chkDetail.isSelected() && this.items != null && this.items.size() > 0) {
            this.itemIndexs = new int[this.items.size()];
            int startCols = this.tblMain.getColumnIndex("score") + 1;
            IColumn column = null;
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                column = this.tblMain.addColumn(startCols + i);
                this.itemIndexs[i] = startCols + i;
                column.setKey(this.items.get(i).getNumber());
                column.getStyleAttributes().setNumberFormat("0.00");
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getHeadRow(0).getCell(startCols + i).setValue((Object)this.items.get(i).getTitle());
            }
            column = this.tblMain.addColumn(startCols + this.items.size());
            column.setKey("errorAlias");
            this.tblMain.getHeadRow(0).getCell(startCols + this.items.size()).setValue(this.tblMain.getHeadRow(0).getCell("error").getValue());
        }
    }

    @Override
    protected void prmptSolution_dataChanged(DataChangeEvent e) throws Exception {
        Object obj = this.prmptSolution.getValue();
        this.itemMap.clear();
        if (obj == null) {
            this.items = null;
            this.txtGradeMode.setText(null);
            this.pkDateBegin.setValue(null);
            this.pkEndDate.setValue(null);
        } else {
            SumSolutionInfo solution = (SumSolutionInfo)obj;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)solution.getId().toString()));
            viewInfo.setFilter(filter);
            viewInfo.getSorter().add(new SorterItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("title"));
            this.items = SumItemFactory.getRemoteInstance().getSumItemCollection(viewInfo);
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                this.itemMap.put(this.items.get(i).getNumber(), this.items.get(i).getTitle());
            }
            this.txtGradeMode.setText(solution.getGradeMode().getName());
            StringBuffer sb = new StringBuffer();
            String unit = EASResource.getString((String)RES, (String)"grade");
            DecimalFormat format = new DecimalFormat("0.00");
            sb.append(format.format(solution.getGradeMode().getMinGrade()));
            sb.append(unit);
            sb.append(" ~ ");
            sb.append(format.format(solution.getGradeMode().getMaxGrade()));
            sb.append(unit);
            this.txtGradeMode.setToolTipText(sb.toString());
            this.pkDateBegin.setValue((Object)solution.getAssessPeriod().getStartDate());
            this.pkEndDate.setValue((Object)solution.getAssessPeriod().getEndDate());
        }
        this.renderDetailInfo();
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.refreshList();
        this.getStatus();
        this.getStatusInfo();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = PFUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "adminOrgUnit.id");
        Object obj = this.prmptSolution.getValue();
        if (obj != null) {
            filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)((SumSolutionInfo)obj).getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)"%noeas%"));
        }
        return filter;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnModifyResult.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.menuItemEdit.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.btnSumFormula.setIcon(EASResource.getIcon((String)"imgTbtn_seeperformance"));
        this.menuItemFormula.setIcon(EASResource.getIcon((String)"imgTbtn_seeperformance"));
        this.btnConvert.setIcon(EASResource.getIcon((String)"imgTbtn_gradeconversion"));
        this.menuItemConvert.setIcon(EASResource.getIcon((String)"imgTbtn_gradeconversion"));
    }

    @Override
    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemForAudit"));
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (!Boolean.FALSE.equals(row.getCell("audited").getValue())) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemSuitebaleForAudit"));
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"selectedItems"));
        sb.append(list.size());
        sb.append(EASResource.getString((String)RES, (String)"auditConfirm"));
        if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
            return;
        }
        ISumResult iSumResult = SumResultFactory.getRemoteInstance();
        iSumResult.audit(list);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditSuccess"));
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    @Override
    public void actionUnAuditResult_actionPerformed(ActionEvent e) throws Exception {
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemForAntiAudit"));
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (!Boolean.TRUE.equals(row.getCell("audited").getValue())) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemSuitebaleForAntiAudit"));
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"selectedItems"));
        sb.append(list.size());
        sb.append(EASResource.getString((String)RES, (String)"antiAuditConfirm"));
        if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
            return;
        }
        ISumResult iSumResult = SumResultFactory.getRemoteInstance();
        iSumResult.unAudit(list);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"antiAuditSuccess"));
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        RequestContext req = super.prepareActionEdit(itemAction);
        req.put("editID", (Object)this.getSelectedKeyValue());
        return req;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getSelectedKeyValue()));
        filter.getFilterItems().add(new FilterItemInfo("audited", (Object)Boolean.TRUE));
        if (SumResultFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NoEditForAudited"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionSumFormula_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmptSolution.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"selectSumSolution"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"hr_perf_sumsolution", this.prmptSolution.getValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SumExpUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionConvert_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        SumSolutionInfo info = (SumSolutionInfo)this.prmptSolution.getValue();
        if (info == null) {
            return;
        }
        String id = info.getId().toString();
        if (id == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"sp", (Object)id);
        uiContext.put((Object)"isSum", (Object)"isSum");
        String[] idList = this.getSelectedIDListForConvert();
        if (idList.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noEvaluResultSutiableForConvert"));
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)("" + idList.length + EASResource.getString((String)RES, (String)"confirmConvert"))))) {
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RankConvertStartUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        RankConvertStartUI userUI = (RankConvertStartUI)uiWindow.getUIObject();
        if (!userUI.isCanceled()) {
            ISumResult iSumResult = SumResultFactory.getRemoteInstance();
            if (userUI.getScoreType() == 0) {
                iSumResult.convertTotalScoreToRank(this.getSelectedIDListForConvert(), userUI.getSelectedRule().getId().toString());
            } else {
                iSumResult.convertModfiedSocreToRank(this.getSelectedIDListForConvert(), userUI.getSelectedRule().getId().toString());
            }
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"convertSuccessful"));
            this.execQuery();
        }
    }

    @Override
    public void actionNDCalculate_actionPerformed(ActionEvent e) throws Exception {
        String actionName = EASResource.getString((String)RES, (String)"ndCalculate");
        if (!this.checkNDCondition(actionName) || this.checkResultAudited()) {
            return;
        }
        this.showNDWindow(NDCalculatorUI.class, OprtState.EDIT, actionName);
    }

    private boolean checkResultAudited() throws BOSException {
        boolean result = false;
        result = this.getRowCount() <= 100 ? this.checkResultAuditedByClient() : this.checkResultAuditedByServer();
        if (result) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"resultAudited"));
        }
        return result;
    }

    private boolean checkResultAuditedByServer() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("audited", (Object)new Integer(1)));
        return this.hasData(filterInfo);
    }

    private boolean checkResultAuditedByClient() {
        Object value = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            value = this.tblMain.getRow(i).getCell("audited").getValue();
            if (!Boolean.TRUE.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionNDCheck_actionPerformed(ActionEvent e) throws Exception {
        String actionName = EASResource.getString((String)RES, (String)"ndCheck");
        if (!this.checkNDCondition(actionName) || this.checkResultRankEmpty()) {
            return;
        }
        this.showNDWindow(NDCheckUI.class, OprtState.VIEW, actionName);
    }

    private void showNDWindow(Class uiClass, String state, String actionName) throws BOSException, EASBizException, UIException {
        SumSolutionInfo info = (SumSolutionInfo)this.prmptSolution.getValue();
        String ruleId = NDFacadeFactory.getRemoteInstance().getNDRuleID(info.getId().toString());
        if (ruleId == null) {
            String message = MessageFormat.format(EASResource.getString((String)RES, (String)"sumSolutionNoMatchRule"), actionName);
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)ruleId);
        uiContext.put((Object)"totalAmount", (Object)new Integer(this.getRowCount()));
        uiContext.put((Object)"queryPk", (Object)this.mainQueryPK);
        uiContext.put((Object)"condition", (Object)this.mainQuery.getFilter());
        uiContext.put((Object)"solutionPeriod", (Object)info);
        uiContext.put((Object)"type", (Object)new Integer(2));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass.getName(), (Map)uiContext, null, state);
        uiWindow.show();
        NDBaseUI uiObject = (NDBaseUI)uiWindow.getUIObject();
        if (!uiObject.isCanceled()) {
            this.execQuery();
        }
    }

    private boolean checkNDCondition(String actionName) throws BOSException {
        boolean result = true;
        int amount = 10;
        int curRowCount = this.getRowCount();
        if (curRowCount <= 0) {
            String message = MessageFormat.format(EASResource.getString((String)RES, (String)"sumResultIsNull"), actionName);
            MsgBox.showInfo((Component)((Object)this), (String)message);
            result = false;
        } else if (curRowCount < amount) {
            String message = MessageFormat.format(EASResource.getString((String)RES, (String)"sumResultIsLittle"), String.valueOf(amount), actionName);
            MsgBox.showInfo((Component)((Object)this), (String)message);
            result = false;
        }
        return result;
    }

    private boolean checkResultRankEmpty() throws BOSException {
        boolean result = false;
        result = this.getRowCount() <= 100 ? this.checkResultRankEmptyByClient() : this.checkResultRankEmptyByServer();
        if (result) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"resultRankEmpty"));
        }
        return result;
    }

    private boolean checkResultRankEmptyByServer() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("rank.id", null, CompareType.EQUALS));
        return this.hasData(filterInfo);
    }

    private boolean hasData(FilterInfo filterInfo) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        filterInfo.mergeFilter(this.mainQuery.getFilter(), "AND");
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        return rowSet.size() > 0;
    }

    private boolean checkResultRankEmptyByClient() {
        Object value = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            value = this.tblMain.getRow(i).getCell("perfRank").getValue();
            if (!StringUtils.isEmpty((String)((String)value))) continue;
            return true;
        }
        return false;
    }

    private String[] getSelectedIDListForConvert() {
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            return null;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        Object obj = null;
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            obj = row.getCell("audited").getValue();
            if (obj != null && ((Boolean)obj).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        return idList;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public boolean isPrepareActionView() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solution", this.prmptSolution.getValue());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solution", this.prmptSolution.getValue());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }
}

