/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.engine.FormulaTransformer;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AllAdminPromptBox;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.GradeDealModeEnum;
import com.kingdee.eas.hr.perf.GradeModeCollection;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.ISumSolutionFacade;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.RankGroupCollection;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.SumExpInfo;
import com.kingdee.eas.hr.perf.SumItemCollection;
import com.kingdee.eas.hr.perf.SumItemFactory;
import com.kingdee.eas.hr.perf.SumItemInfo;
import com.kingdee.eas.hr.perf.SumPersonFactory;
import com.kingdee.eas.hr.perf.SumPersonInfo;
import com.kingdee.eas.hr.perf.SumResultFactory;
import com.kingdee.eas.hr.perf.SumSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.SumSolutionFactory;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.SumStateEnum;
import com.kingdee.eas.hr.perf.client.AbstractSumSolutionEditUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.ExtendKDTextPane;
import com.kingdee.eas.hr.perf.client.FormulaPanel;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PreviewSumResultUI;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.perf.client.RankViewListUI;
import com.kingdee.eas.hr.perf.client.SumItemUI;
import com.kingdee.eas.hr.perf.client.SumPropertyItemUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class SumSolutionEditUI
extends AbstractSumSolutionEditUI {
    private static final long serialVersionUID = -61166L;
    private static final Logger logger = CoreUIObject.getLogger((String)"com.kingdee.eas.hr.perf.client.SumSolutionEditUI");
    private static final String RES = "com.kingdee.eas.hr.perf.client.SumClientResource";
    private static final String TEMPLATENAME = "eas.hr.perf.SumPersonAssessUnit";
    private ExtendKDTextPane area = new ExtendKDTextPane();
    private FormulaPanel panel = new FormulaPanel();
    private String solutionID = null;
    private JButton btnAddConditionProperty = null;
    private JButton btnAddItem = null;
    private JButton btnRemoveItem = null;
    private JButton btnEditSumItem = null;
    private JButton btnViewSumItem = null;
    private SumExpInfo oldExpInfo = null;
    private HashMap gradeAndRankMap = null;
    private static final String USER = "0";
    private static final String MACHINE = "1";
    private LocateAssistant locateAssistant;
    private IUIObject uiObject;
    private boolean isUseNumberRule = false;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.initFormula();
    }

    @Override
    public void loadFields() {
        try {
            this.isUseNumberRule = PerfUtils.setAutoNumberByOrg("ControlUnit", this.createNewData(), (IObjectValue)this.editData, this.txtNumber);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        super.loadFields();
        GradeModeInfo gradeMode = null;
        if (this.editData.getGradeMode() != null) {
            BOSUuid gradeModeID = this.editData.getGradeMode().getId();
            int n = this.comboGradeMode.getItemCount();
            for (int i = 0; i < n; ++i) {
                gradeMode = (GradeModeInfo)this.comboGradeMode.getItemAt(i);
                if (!gradeMode.getId().equals((Object)gradeModeID)) continue;
                this.comboGradeMode.setSelectedIndex(i);
                break;
            }
        }
        RankGroupInfo rankGroup = null;
        if (this.editData.getRankGroup() != null) {
            BOSUuid rankGroupID = this.editData.getRankGroup().getId();
            int n = this.comboRankGroup.getItemCount();
            for (int i = 0; i < n; ++i) {
                rankGroup = (RankGroupInfo)this.comboRankGroup.getItemAt(i);
                if (!rankGroup.getId().equals((Object)rankGroupID)) continue;
                this.comboRankGroup.setSelectedIndex(i);
                break;
            }
        } else {
            this.comboRankGroup.setSelectedItem(null);
        }
        this.area.setText(this.editData.getSumExp().getText());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("sumExp.*"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.name"));
        sic.add(new SelectorItemInfo("gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("gradeMode.isDefault"));
        sic.add(new SelectorItemInfo("rankGroup.id"));
        sic.add(new SelectorItemInfo("rankGroup.name"));
        sic.add(new SelectorItemInfo("rankGroup.gradeMode.id"));
        sic.add(new SelectorItemInfo("rankGroup.gradeMode.name"));
        return sic;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.txtNumber.isEnabled()) {
            PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        }
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboGradeMode);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboRankGroup);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.promptOrgUnit);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.promptAssessPeriod);
        String text = this.area.getText();
        if (text != null) {
            int index = 0;
            index = text.indexOf("++");
            if (index != -1) {
                MsgBox.showError((String)EASResource.getString((String)RES, (String)"plusplusNotAllow"));
                this.area.requestFocus();
                this.area.setSelectionStart(index);
                this.area.setSelectionEnd(index + 2);
                SysUtil.abort();
            }
            if ((index = text.indexOf("--")) != -1) {
                MsgBox.showError((String)EASResource.getString((String)RES, (String)"subSubNotAllow"));
                this.area.requestFocus();
                this.area.setSelectionStart(index);
                this.area.setSelectionEnd(index + 2);
                SysUtil.abort();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getSumExp() != null) {
            String exp = this.area.getText().trim();
            exp = exp.replaceAll("\uff1b", ";").replaceAll("\uff09", ")").replaceAll("\uff08", "(").replaceAll("/", "/");
            this.editData.getSumExp().setText(exp);
            String script = this.getTransScript();
            logger.info((Object)script);
            this.editData.getSumExp().setScript(script);
        }
        if (this.txtRemark.getText() == null || "".equals(this.txtRemark.getText().trim())) {
            this.editData.setDescription(null);
        }
    }

    public void onLoad() throws Exception {
        EvaluSolutionHelper.initOrgUnit(this.promptOrgUnit, (IUIObject)this);
        this.gradeAndRankMap = EvaluSolutionFactory.getRemoteInstance().getUsebleGradeModeAndRankGroup();
        GradeModeCollection gradeModeCollection = (GradeModeCollection)((Object)this.gradeAndRankMap.get("GradeMode"));
        this.comboGradeMode.setActionCommand(MACHINE);
        this.comboGradeMode.removeAllItems();
        this.comboGradeMode.addItems(gradeModeCollection.toArray());
        this.comboGradeMode.setSelectedItem(null);
        this.comboGradeMode.setActionCommand(USER);
        super.onLoad();
        this.tblSumItem.checkParsed();
        this.tblPerson.checkParsed();
        KDTSortManager sm = new KDTSortManager(this.tblPerson);
        int n = this.tblPerson.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.tblPerson.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
        this.tblPerson.getSelectManager().setSelectMode(10);
        this.tblSumItem.getSelectManager().setSelectMode(10);
        this.tblSumItem.getColumn("title").getStyleAttributes().setWrapText(true);
        this.tblSumItem.getColumn("name").getStyleAttributes().setWrapText(true);
        PerfClientUtils.setCellPrmtEditor(this.tblPerson, "assessUnit", this.getAssessUnitPromt());
        this.fetchSumItem();
        this.dateBegin.setValue(null);
        this.dateEnd.setValue(null);
        if (this.editData != null && this.editData.getState() != null) {
            this.txtSumState.setText(this.editData.getState().toString());
        } else {
            this.txtSumState.setText(SumStateEnum.TODO.toString());
        }
        this.setUIEnalbedByState(this.getOprtState());
        this.promptAssessPeriod_dataChanged(null);
        EvaluSolutionHelper.initOrgUnit(this.promptOrgUnit, (IUIObject)this);
    }

    private KDBizPromptBox getAssessUnitPromt() throws Exception {
        KDBizPromptBox prmtAdminF7 = new KDBizPromptBox();
        prmtAdminF7.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        prmtAdminF7.setEditable(false);
        AllAdminPromptBox adminPromptBox = new AllAdminPromptBox();
        prmtAdminF7.setSelector((KDPromptSelector)adminPromptBox);
        return prmtAdminF7;
    }

    private void initFormula() {
        KDScrollPane scroll = new KDScrollPane((Component)((Object)this.area));
        this.contForumla.getContentPane().add((Component)scroll, "Center");
        this.contForumla.revalidate();
        this.panel.setDestArea(this.area);
        final KDPopupMenu pop = new KDPopupMenu();
        JMenuItem item = null;
        item = pop.add((Action)((Object)this.actionInsertSumResult));
        item.setIcon(EASResource.getIcon((String)"imgTbtn_checkresult"));
        item.setText(EASResource.getString((String)RES, (String)"insertSumResult"));
        item.setToolTipText(null);
        pop.addSeparator();
        item = pop.add((Action)((Object)this.actionInsertEqual));
        item.setIcon(EASResource.getIcon((String)"imgTbtn_amountsign"));
        item.setText(EASResource.getString((String)RES, (String)"insertEquals"));
        item.setToolTipText(null);
        item = pop.add((Action)((Object)this.actionInsertAdd));
        item.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        item.setText(EASResource.getString((String)RES, (String)"insertAdd"));
        item.setToolTipText(null);
        item = pop.add((Action)((Object)this.actionInsertSub));
        item.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        item.setText(EASResource.getString((String)RES, (String)"insertSub"));
        item.setToolTipText(null);
        item = pop.add((Action)((Object)this.actionInsertMultiply));
        item.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        item.setText(EASResource.getString((String)RES, (String)"insertMultiply"));
        item.setToolTipText(null);
        item = pop.add((Action)((Object)this.actionInsertDevide));
        item.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        item.setText(EASResource.getString((String)RES, (String)"insertDevide"));
        item.setToolTipText(null);
        this.area.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SumSolutionEditUI.this.area.isEditable()) {
                    return;
                }
                if (e.getButton() == 3) {
                    pop.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    pop.setVisible(false);
                }
            }
        });
        this.pnlCacu.add((Component)((Object)this.panel), (Object)"Center");
        this.pnlCacu.revalidate();
    }

    private void setUIEnalbedByState(String state) {
        if (OprtState.VIEW.equals(state)) {
            this.panel.setPanelEnabled(false);
            this.area.setEditable(false);
            this.contSumItem.setEnabled(false);
            this.btnAddConditionProperty.setEnabled(false);
            this.btnAddItem.setEnabled(false);
            this.btnRemoveItem.setEnabled(false);
            this.btnEditSumItem.setEnabled(false);
            this.tblPerson.setEnabled(false);
            this.tblSumItem.setEnabled(false);
            this.btnCalculate.setEnabled(false);
            this.btnViewResult.setEnabled(true);
            this.btnSubmit.setEnabled(false);
            this.btnAddPerson.setEnabled(false);
            this.btnDelPerson.setEnabled(false);
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.comboGradeMode.setEnabled(false);
            this.promptOrgUnit.setEnabled(false);
            this.promptAssessPeriod.setEnabled(false);
            this.txtRemark.setEnabled(false);
            this.comboGradeDealMode.setEnabled(false);
            this.btnImportAssessUnit.setEnabled(false);
        }
    }

    public void fetchSumItem() throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        String oql = "SELECT id,number,title,name,type WHERE sumSolution.id ='" + this.editData.getId().toString() + "'" + " " + " ORDER BY number";
        SumItemCollection coll = SumItemFactory.getRemoteInstance().getSumItemCollection(oql);
        this.tblSumItem.setUserObject((Object)coll);
        this.tblSumItem.removeRows();
        IRow row = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            row = this.tblSumItem.addRow();
            row.setUserObject((Object)coll.get(i));
            row.getCell("id").setValue((Object)coll.get(i).getId().toString());
            row.getCell("number").setValue((Object)coll.get(i).getNumber());
            row.getCell("title").setValue((Object)coll.get(i).getTitle());
            row.getCell("name").setValue((Object)coll.get(i).getName());
            if (coll.get(i).getName().length() <= 65) continue;
            row.setHeight(36);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddPerson.setEnabled(true);
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_querypersonnel"));
        this.btnDelPerson.setEnabled(true);
        this.btnDelPerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnLocate.setEnabled(true);
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.btnAddConditionProperty = this.contSumItem.add((Action)((Object)this.actionaddPropertyItem));
        this.btnAddConditionProperty.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddConditionProperty.setToolTipText(EASResource.getString((String)RES, (String)"addConditionProperty"));
        this.btnRemoveItem = this.contSumItem.add((Action)((Object)this.ActionRemoveItem));
        this.btnRemoveItem.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveItem.setToolTipText(EASResource.getString((String)RES, (String)"removeItem"));
        this.btnAddItem = this.contSumItem.add((Action)((Object)this.actionAddItem));
        this.btnAddItem.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddItem.setToolTipText(EASResource.getString((String)RES, (String)"addItem"));
        this.btnEditSumItem = this.contSumItem.add((Action)((Object)this.actionEditSumItem));
        this.btnEditSumItem.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnEditSumItem.setToolTipText(EASResource.getString((String)RES, (String)"editSumItem"));
        this.btnViewSumItem = this.contSumItem.add((Action)((Object)this.actionViewSumItem));
        this.btnViewSumItem.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnViewSumItem.setToolTipText(EASResource.getString((String)RES, (String)"viewSumItem"));
        this.btnViewResult.setEnabled(true);
        this.btnViewResult.setIcon(EASResource.getIcon((String)"imgTbtn_preview2"));
        this.btnCalculate.setEnabled(true);
        this.btnCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        String hrId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrId));
        evi.setFilter(fi);
        this.promptAssessPeriod.setEntityViewInfo(evi);
        this.comboGradeDealMode.addItems(GradeDealModeEnum.getEnumList().toArray());
    }

    @Override
    protected void tabMain_stateChanged(ChangeEvent e) throws Exception {
        if (this.tabMain.getSelectedComponent() != this.pnlBase) {
            if (this.getUIContext().get("ID") == null) {
                this.tabMain.setSelectedComponent((Component)this.pnlBase);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"BaseInfoNotSave"));
                return;
            }
            this.solutionID = this.getUIContext().get("ID").toString();
        }
        if (this.tabMain.getSelectedComponent() == this.pnlPerson) {
            this.btnSubmit.setVisible(false);
            this.btnAddPerson.setVisible(true);
            this.btnDelPerson.setVisible(true);
            this.btnLocate.setVisible(true);
            this.btnImportAssessUnit.setVisible(true);
            this.btnExportAssessUnit.setVisible(true);
            this.fillPersonTable();
        } else {
            this.btnSubmit.setVisible(true);
            this.btnAddPerson.setVisible(false);
            this.btnDelPerson.setVisible(false);
            this.btnLocate.setVisible(false);
            this.btnImportAssessUnit.setVisible(false);
            this.btnExportAssessUnit.setVisible(false);
        }
        if (this.tabMain.getSelectedComponent() != this.pnlFormula) {
            this.btnViewResult.setVisible(false);
            this.btnCalculate.setVisible(false);
        } else {
            this.btnViewResult.setVisible(true);
            this.btnCalculate.setVisible(true);
        }
    }

    @Override
    protected void tblSumItem_tableClicked(KDTMouseEvent e) throws Exception {
        if (!this.tblSumItem.isEnabled()) {
            return;
        }
        if (e.getType() == 0 || e.getRowIndex() < 0) {
            return;
        }
        if (e.getClickCount() != 2) {
            return;
        }
        String cmdStr = (String)this.tblSumItem.getRow(e.getRowIndex()).getCell("number").getValue();
        this.insertFormulaItem(cmdStr);
    }

    private String getTransScript() {
        FormulaTransformer transformer = new FormulaTransformer();
        String result = null;
        try {
            result = this.editData.getSumExp().getText();
            result = transformer.transforme(result);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"scriptError"));
            SysUtil.abort();
        }
        return result;
    }

    @Override
    public void actionViewResult_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"saveBeforeCalculate"));
            return;
        }
        if (this.area.getText() == null || "".equals(this.area.getText().trim())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"checkFormual"));
            return;
        }
        if (this.tblSumItem.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noSumItem"));
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)this.editData.getId().toString()));
        if (!SumPersonFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noSumPerson"));
            this.tabMain.setSelectedIndex(1);
            return;
        }
        this.uiObject = this.getUIWindow().getUIObject();
        IProgTask prog = new IProgTask(){
            private IRowSet rowSet = null;

            @Override
            public Object exec() throws Exception {
                this.rowSet = SumSolutionFactory.getRemoteInstance().previewCalculate(SumSolutionEditUI.this.editData.getId().toString());
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UIContext uiContext = new UIContext((Object)SumSolutionEditUI.this.uiObject);
                uiContext.put((Object)"calculateData", (Object)this.rowSet);
                uiContext.put((Object)"solution", (Object)SumSolutionEditUI.this.editData);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PreviewSumResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filter;
        if (this.editData.getId() != null) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sumPerson.sumSolution.id", (Object)this.editData.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("audited", (Object)Boolean.TRUE));
            if (SumResultFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"auditResultSolutionCalu"));
                return;
            }
        }
        if (this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"saveBeforeCalculate"));
            return;
        }
        if (this.area.getText() == null || "".equals(this.area.getText().trim())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"checkFormual"));
            return;
        }
        if (this.tblSumItem.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noSumItem"));
            return;
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)this.editData.getId().toString()));
        if (!SumPersonFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noSumPerson"));
            this.tabMain.setSelectedIndex(1);
            return;
        }
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                SumSolutionFactory.getRemoteInstance().calulate(SumSolutionEditUI.this.editData.getId().toString());
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                SumSolutionEditUI.this.editData.setState(SumStateEnum.DONE);
                SumSolutionEditUI.this.txtSumState.setText(SumSolutionEditUI.this.editData.getState().toString());
                MsgBox.showInfo((String)EASResource.getString((String)SumSolutionEditUI.RES, (String)"calculateOK"));
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
        this.setSaved(true);
    }

    @Override
    protected void promptAssessPeriod_dataChanged(DataChangeEvent e) throws Exception {
        AssessPeriodInfo apInfo = (AssessPeriodInfo)this.promptAssessPeriod.getData();
        if (apInfo != null) {
            this.dateBegin.setValue((Object)apInfo.getStartDate());
            this.dateEnd.setValue((Object)apInfo.getEndDate());
        }
    }

    protected IObjectValue createNewData() {
        SumSolutionInfo info = new SumSolutionInfo();
        info.setGradeDealMode(GradeDealModeEnum.UNITY);
        info.setState(SumStateEnum.TODO);
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        SumExpInfo exp = new SumExpInfo();
        exp.setId(BOSUuid.create((BOSObjectType)exp.getBOSType()));
        exp.setText(EASResource.getString((String)RES, (String)"sumResult"));
        exp.setScript(EASResource.getString((String)RES, (String)"sumResult"));
        info.setSumExp(exp);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SumSolutionFactory.getRemoteInstance();
    }

    @Override
    public void actionAddItem_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"SolutionID", (Object)this.editData.getId().toString());
        uiContext.put((Object)"SolutionUI", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SumItemUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionRemoveItem_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblSumItem);
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return;
        }
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblSumItem);
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> numbers = new ArrayList<String>();
        for (int i = 0; i < rowIndexs.length; ++i) {
            set.add(this.tblSumItem.getRow(rowIndexs[i]).getCell("id").getValue().toString());
            numbers.add(this.tblSumItem.getRow(rowIndexs[i]).getCell("number").getValue().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SumItemFactory.getRemoteInstance().delete(filter);
        String text = this.area.getText();
        String number2 = null;
        ArrayList<String> refs = new ArrayList<String>();
        for (String number2 : numbers) {
            if (text.indexOf(number2) == -1) continue;
            refs.add(number2);
        }
        if (refs.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("[ ");
            Iterator iter = refs.iterator();
            while (iter.hasNext()) {
                sb.append((String)iter.next());
                sb.append(" ");
            }
            sb.append("]");
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.SumSolutionResource", (String)"delItemOK"));
            int option = MsgBox.showConfirm2((Component)((Object)this), (String)sb.toString());
            if (option == 0) {
                Iterator iter2 = refs.iterator();
                while (iter2.hasNext()) {
                    text = text.replaceAll((String)iter2.next(), " ");
                }
                this.area.setText(text);
            }
        }
        for (int i = rowIndexs.length - 1; i >= 0; --i) {
            this.tblSumItem.removeRow(rowIndexs[i]);
        }
    }

    @Override
    public void actionEditSumItem_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblSumItem);
        int selectedRowIndex = PFUtils.getSelectedRow(this.tblSumItem);
        IRow row = this.tblSumItem.getRow(selectedRowIndex);
        SumItemInfo info = (SumItemInfo)row.getUserObject();
        String number = info.getNumber();
        if (number.startsWith("FITEM000")) {
            return;
        }
        String defaultPackage = "com.kingdee.eas.hr.perf.client.";
        String uiName = info.getType().getValue();
        if (uiName.indexOf(".") == -1) {
            uiName = defaultPackage + uiName;
        }
        Class<?> uiClass = Class.forName(uiName);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)info.getId().toString());
        uiContext.put((Object)"SolutionUI", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionViewSumItem_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblSumItem);
        int selectedRowIndex = PFUtils.getSelectedRow(this.tblSumItem);
        IRow row = this.tblSumItem.getRow(selectedRowIndex);
        SumItemInfo info = (SumItemInfo)row.getUserObject();
        String number = info.getNumber();
        if (number.startsWith("FITEM000")) {
            return;
        }
        String defaultPackage = "com.kingdee.eas.hr.perf.client.";
        String uiName = info.getType().getValue();
        if (uiName.indexOf(".") == -1) {
            uiName = defaultPackage + uiName;
        }
        Class<?> uiClass = Class.forName(uiName);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)info.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void fillPersonTable() throws BOSException, SQLException {
        String query = "com.kingdee.eas.hr.perf.app.SumPersonQuery";
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(query));
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)this.solutionID));
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("person.number"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        IRow row = null;
        this.tblPerson.removeRows();
        this.tblPerson.getSelectManager().setSelectMode(10);
        while (rowSet.next()) {
            row = this.tblPerson.addRow();
            row.getCell("ID").setValue((Object)rowSet.getString("id"));
            row.getCell("person.id").setValue((Object)rowSet.getString("person.id"));
            row.getCell("person.number").setValue((Object)rowSet.getString("person.number"));
            row.getCell("person.name").setValue((Object)rowSet.getString("person.name"));
            row.getCell("position").setValue((Object)rowSet.getString("position.name"));
            row.getCell("jobGrade").setValue((Object)rowSet.getString("jobGrade.name"));
            row.getCell("orgUnit").setValue((Object)rowSet.getString("adminOrgUnit"));
            row.getCell("job").setValue((Object)rowSet.getString("job.name"));
            if (rowSet.getString("assessUnit.id") == null) continue;
            AdminOrgUnitInfo assessUnit = new AdminOrgUnitInfo();
            assessUnit.setId(BOSUuid.read((String)rowSet.getString("assessUnit.id")));
            assessUnit.setName(rowSet.getString("assessUnit.displayName"));
            row.getCell("assessUnit").setValue((Object)assessUnit);
        }
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(false);
        pmt.setModal(true);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            final Object[] obj = (Object[])pmt.getData();
            if (obj.length > 50) {
                IProgTask prog = new IProgTask(){

                    @Override
                    public Object exec() throws Exception {
                        SumSolutionEditUI.this.dealAddEvaluObject(obj);
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                        SumSolutionEditUI.this.fillPersonTable();
                    }
                };
                ProgDialog dialog = null;
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                if (win instanceof Frame) {
                    dialog = new ProgDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new ProgDialog((Dialog)win);
                }
                dialog.setLongTimeTask(prog);
                dialog.show();
            } else {
                this.dealAddEvaluObject(obj);
                this.fillPersonTable();
            }
        }
    }

    private void dealAddEvaluObject(Object[] obj) throws Exception {
        HashSet<PersonInfo> personSet = new HashSet<PersonInfo>();
        PersonInfo personInfo = null;
        for (int i = 0; i < obj.length; ++i) {
            personInfo = (PersonInfo)obj[i];
            if (personInfo == null) continue;
            personSet.add(personInfo);
        }
        if (personSet.size() != 0) {
            SumSolutionFacadeFactory.getRemoteInstance().addSumPerson(personSet, this.solutionID);
        }
    }

    @Override
    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblPerson);
        if (this.confirmRemove()) {
            int[] rowIndexList = KDTableUtil.getSelectedRows((KDTable)this.tblPerson);
            IRow row = null;
            final HashSet<String> idSet = new HashSet<String>();
            final ArrayList<Integer> delRowIndex = new ArrayList<Integer>();
            for (int i = rowIndexList.length - 1; i >= 0; --i) {
                row = this.tblPerson.getRow(rowIndexList[i]);
                String id = (String)row.getCell("ID").getValue();
                if (id == null) continue;
                delRowIndex.add(new Integer(rowIndexList[i]));
                idSet.add(id);
            }
            if (idSet.size() != 0) {
                final ISumSolutionFacade isumSolutionFacade = SumSolutionFacadeFactory.getRemoteInstance();
                if (idSet.size() > 50) {
                    IProgTask prog = new IProgTask(){

                        @Override
                        public Object exec() throws Exception {
                            isumSolutionFacade.delSumPerson(idSet);
                            SumSolutionEditUI.this.removeRowsFromTable(delRowIndex);
                            return "";
                        }

                        @Override
                        public void afterExec(Object result) throws Exception {
                        }
                    };
                    ProgDialog dialog = null;
                    Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                    if (win instanceof Frame) {
                        dialog = new ProgDialog((Frame)win);
                    } else if (win instanceof Dialog) {
                        dialog = new ProgDialog((Dialog)win);
                    }
                    dialog.setLongTimeTask(prog);
                    dialog.show();
                } else {
                    isumSolutionFacade.delSumPerson(idSet);
                    this.removeRowsFromTable(delRowIndex);
                }
            }
        }
    }

    @Override
    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        if (this.locateAssistant == null) {
            this.locateAssistant = new LocateAssistant((CoreUIObject)this, this.tblPerson, this.getLocateNames());
        }
        this.locateAssistant.actionLocate();
    }

    private void removeRowsFromTable(List delRowIndex) {
        for (int i = 0; i < delRowIndex.size(); ++i) {
            int rowIndex = (Integer)delRowIndex.get(i);
            this.tblPerson.removeRow(rowIndex);
        }
    }

    protected void initOldData(IObjectValue dataObject) {
        super.initOldData(dataObject);
        SumSolutionInfo solution = (SumSolutionInfo)dataObject;
        this.oldExpInfo = (SumExpInfo)solution.getSumExp().clone();
    }

    public boolean isModify() {
        boolean flag = super.isModify();
        if (flag) {
            return flag;
        }
        SumExpInfo newExpInfo = this.editData.getSumExp();
        return !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)this.oldExpInfo, (AbstractObjectValue)newExpInfo);
    }

    @Override
    public void actionInsertEqual_actionPerformed(ActionEvent e) throws Exception {
        this.insertFormulaItem("=");
    }

    @Override
    public void actionInsertAdd_actionPerformed(ActionEvent e) throws Exception {
        this.insertFormulaItem("+");
    }

    @Override
    public void actionInsertDevide_actionPerformed(ActionEvent e) throws Exception {
        this.insertFormulaItem("/");
    }

    @Override
    public void actionInsertMultiply_actionPerformed(ActionEvent e) throws Exception {
        this.insertFormulaItem("*");
    }

    @Override
    public void actionInsertSub_actionPerformed(ActionEvent e) throws Exception {
        this.insertFormulaItem("-");
    }

    @Override
    public void actionInsertSumResult_actionPerformed(ActionEvent e) throws Exception {
        String cmdStr = EASResource.getString((String)RES, (String)"sumResult");
        this.insertFormulaItem(cmdStr);
    }

    private void insertFormulaItem(String cmdStr) {
        String str = this.area.getText();
        cmdStr = " " + cmdStr + " ";
        StringBuffer sb = new StringBuffer();
        int caretPo = this.area.getCaretPosition();
        String left = str.substring(0, caretPo);
        String right = str.substring(caretPo);
        sb.append(left);
        sb.append(cmdStr);
        sb.append(right);
        this.area.setText(sb.toString());
        this.area.requestFocus();
        this.area.setSelectionStart(caretPo);
        this.area.setSelectionEnd(caretPo + cmdStr.length());
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"person.number", "person.name", "position", "jobGrade", "orgUnit"};
        return locateNames;
    }

    @Override
    protected void btnViewRankGroup_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.comboRankGroup.getSelectedItem() != null) {
            String rankGroupId = ((RankGroupInfo)this.comboRankGroup.getSelectedItem()).getId().toString();
            uiContext.put((Object)"RankGroupID", (Object)rankGroupId);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RankViewListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void comboGradeMode_actionPerformed(ActionEvent e) throws Exception {
        GradeModeInfo gradeModeInfo;
        if (!USER.equals(e.getActionCommand())) {
            return;
        }
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.comboRankGroup.setEnabled(true);
        }
        if ((gradeModeInfo = (GradeModeInfo)this.comboGradeMode.getSelectedItem()) != null && gradeModeInfo.getId() != null) {
            String id = gradeModeInfo.getId().toString();
            RankGroupCollection rankGroupCollection = (RankGroupCollection)((Object)this.gradeAndRankMap.get(id));
            this.comboRankGroup.removeAllItems();
            if (rankGroupCollection != null && rankGroupCollection.size() > 0) {
                this.comboRankGroup.addItems(rankGroupCollection.toArray());
            }
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public void actionImportAssessUnit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<DatataskParameter> arrayList = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = TEMPLATENAME;
        param.alias = EASResource.getString((String)RES, (String)"sumPersonAssessUnit");
        param.putContextParam((Object)"sumSolution", (Object)this.editData);
        arrayList.add(param);
        DatataskCaller task = new DatataskCaller();
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            task.setParentComponent((Component)((Object)this));
        }
        task.invoke(arrayList, 0);
        this.fillPersonTable();
    }

    @Override
    public void actionExportAssessUnit_actionPerformed(ActionEvent e) throws Exception {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = TEMPLATENAME;
        param.alias = EASResource.getString((String)RES, (String)"sumPersonAssessUnit");
        param.datataskMode = 1;
        String query = "com.kingdee.eas.hr.perf.app.SumPersonQuery";
        param.putContextParam((Object)"queryInfo", (Object)query);
        param.putContextParam((Object)"sumSolution", (Object)this.editData);
        ArrayList<DatataskParameter> array = new ArrayList<DatataskParameter>();
        array.add(param);
        DatataskCaller dc = new DatataskCaller();
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            dc.setParentComponent((Component)((Object)this));
        }
        dc.invoke(array, 1);
    }

    @Override
    protected void tblPerson_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.tblPerson.getColumnIndex("assessUnit")) {
            if (e.getValue() == e.getOldValue()) {
                return;
            }
            IRow row = this.tblPerson.getRow(rowIndex);
            if (row != null && row.getCell("ID").getValue() != null && (e.getValue() instanceof AdminOrgUnitInfo || e.getValue() == null)) {
                String sumPersonID = row.getCell("ID").getValue().toString();
                SumPersonInfo sumPerson = new SumPersonInfo();
                sumPerson.setId(BOSUuid.read((String)sumPersonID));
                sumPerson.setAssessUnit((AdminOrgUnitInfo)e.getValue());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("assessUnit"));
                SumPersonFactory.getRemoteInstance().updatePartial(sumPerson, sic);
                if (e.getValue() != null) {
                    AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)e.getValue();
                    adminOrgUnit.setName(adminOrgUnit.getDisplayName());
                }
            }
        }
    }

    @Override
    public void actionaddPropertyItem_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"SolutionID", (Object)this.editData.getId().toString());
        uiContext.put((Object)"SolutionUI", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SumPropertyItemUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    protected void tblSumItem_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTSelectBlock block = this.tblSumItem.getSelectManager().get();
        if (block == null) {
            this.actionEditSumItem.setEnabled(true);
        } else {
            if (block.getTop() == -1) {
                return;
            }
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblSumItem);
            IRow row = null;
            String number = null;
            for (int i = 0; i < rows.length; ++i) {
                row = this.tblSumItem.getRow(rows[i]);
                number = (String)row.getCell("number").getValue();
                if (number.startsWith("FITEM000")) {
                    this.actionEditSumItem.setEnabled(false);
                    this.actionViewSumItem.setEnabled(false);
                    continue;
                }
                this.actionEditSumItem.setEnabled(true);
                this.actionViewSumItem.setEnabled(true);
            }
        }
    }
}

