/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.SumItemCollection;
import com.kingdee.eas.hr.perf.SumItemFactory;
import com.kingdee.eas.hr.perf.SumItemInfo;
import com.kingdee.eas.hr.perf.SumResultFactory;
import com.kingdee.eas.hr.perf.SumSolutionCollection;
import com.kingdee.eas.hr.perf.SumSolutionFactory;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractSumSolutionPersonListUI;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.SumExpUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SumSolutionPersonListUI
extends AbstractSumSolutionPersonListUI {
    private static final long serialVersionUID = -61166L;
    private static final Logger logger = CoreUIObject.getLogger(SumSolutionPersonListUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private String CURRENT_PERSONID = null;
    private static final String keyPrefix = "prefix_";
    private SumItemCollection sumItemCollection = null;
    private Set assessPeriodIdSet = new HashSet();
    private Set columnKeySet = new HashSet();

    public SumSolutionPersonListUI() throws Exception {
        PerfClientUtils.checkValidPerson((CoreUI)this);
        this.CURRENT_PERSONID = PerfClientUtils.getCurrentPersonID();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        HashSet idSet;
        FilterInfo filterInfo = new FilterInfo();
        Object data = null;
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.CURRENT_PERSONID));
        filterInfo.getFilterItems().add(new FilterItemInfo("audited", (Object)new Integer(1)));
        data = this.prmptSolution.getValue();
        if (!PerfClientUtils.objectArrayIsNull(data) && (idSet = PerfClientUtils.getObjectArrayIds(data)) != null && !idSet.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)idSet, CompareType.INCLUDE));
        }
        if (!PerfClientUtils.objectArrayIsNull(data = this.prmptAssessPeriod.getValue()) && (idSet = PerfClientUtils.getObjectArrayIds(data)) != null && !idSet.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)idSet, CompareType.INCLUDE));
        }
        return filterInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        PerfClientUtils.checkValidHRO((CoreUI)this);
        EntityViewInfo sumSolutionViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.CURRENT_PERSONID));
        sumSolutionViewInfo.setFilter(filterInfo);
        this.prmptSolution.setEntityViewInfo(sumSolutionViewInfo);
        this.prmptSolution.setEnabledMultiSelection(true);
        this.prmptAssessPeriod.setEnabledMultiSelection(true);
        this.setAssessPeriodEntityViewInfo();
        this.getAssessPeriodAndSumItem();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                SumSolutionPersonListUI.this.showSumItemDetailInfo();
            }
        });
    }

    @Override
    protected void prmptSolution_dataChanged(DataChangeEvent e) throws Exception {
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.getAssessPeriodAndSumItem();
        this.renderDetailInfo();
        EntityViewInfo viewInfo = this.setAssessPeriodEntityViewInfo();
        this.prmptAssessPeriod.setEntityViewInfo(viewInfo);
        this.prmptAssessPeriod.setValue(null);
        this.refreshList();
    }

    @Override
    protected void prmptAssessPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.getAssessPeriodAndSumItem();
        this.renderDetailInfo();
        super.refreshList();
    }

    @Override
    protected void chkDetail_itemStateChanged(ItemEvent e) throws Exception {
        this.renderDetailInfo();
        this.showSumItemDetailInfo();
    }

    private EntityViewInfo setAssessPeriodEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.assessPeriodIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private void getAssessPeriodAndSumItem() {
        this.assessPeriodIdSet.clear();
        if (this.sumItemCollection != null) {
            this.sumItemCollection = null;
        }
        try {
            EntityViewInfo viewInfo = null;
            FilterInfo filterInfo = null;
            HashSet<String> sumSolutionIdSet = new HashSet<String>();
            IQueryExecutor queryExecutor = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
            String execSQL = queryExecutor.getSQL();
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT DISTINCT \"SUMSOLUTION\".FID AS \"ID\" ");
            buffer.append(execSQL.substring(execSQL.indexOf("FROM"), execSQL.indexOf("ORDER")));
            String sql = buffer.toString();
            IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
            while (rowSet.next()) {
                sumSolutionIdSet.add(rowSet.getString(1));
            }
            if (!sumSolutionIdSet.isEmpty()) {
                viewInfo = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", sumSolutionIdSet, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                SumSolutionCollection sumSolutionCollection = SumSolutionFactory.getRemoteInstance().getSumSolutionCollection(viewInfo);
                if (sumSolutionCollection != null && !sumSolutionCollection.isEmpty()) {
                    int n = sumSolutionCollection.size();
                    for (int i = 0; i < n; ++i) {
                        this.assessPeriodIdSet.add(sumSolutionCollection.get(i).getAssessPeriod().getId().toString());
                    }
                }
                viewInfo = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("sumSolution.id", sumSolutionIdSet, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                this.sumItemCollection = SumItemFactory.getRemoteInstance().getSumItemCollection(viewInfo);
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void renderDetailInfo() {
        if (!this.columnKeySet.isEmpty()) {
            Iterator it = this.columnKeySet.iterator();
            while (it.hasNext()) {
                int colIndex = this.tblMain.getColumnIndex(it.next().toString());
                this.tblMain.removeColumn(colIndex);
            }
            this.columnKeySet.clear();
        }
        if (this.chkDetail.isSelected() && this.sumItemCollection != null && !this.sumItemCollection.isEmpty()) {
            int startIndex = this.tblMain.getColumnIndex("score");
            Iterator it = this.sumItemCollection.iterator();
            IColumn column = null;
            int index = 0;
            while (it.hasNext()) {
                String title = ((SumItemInfo)it.next()).getTitle();
                String key = keyPrefix + title;
                if (this.tblMain.getColumn(key) != null) continue;
                column = this.tblMain.addColumn(startIndex + index);
                column.setKey(key);
                this.tblMain.getHeadRow(0).getCell(startIndex + index).setValue((Object)title);
                this.columnKeySet.add(key);
                StyleAttributes style = column.getStyleAttributes();
                Object owner = style.getOwner();
                style.setOwner(null);
                style.setNumberFormat("0.00");
                style.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                style.setOwner(owner);
                style.update();
                ++index;
            }
        }
    }

    private void showSumItemDetailInfo() {
        try {
            if (!this.columnKeySet.isEmpty()) {
                IRow row = null;
                Object detail = null;
                String number = null;
                String title = null;
                String sumSolutionId = null;
                StringTokenizer token = null;
                StringTokenizer devide = null;
                BigDecimal value = null;
                for (int i = 0; i < this.tblMain.getBody().size(); ++i) {
                    row = this.tblMain.getRow2(i);
                    detail = row.getCell("detail").getValue();
                    sumSolutionId = row.getCell("sumSolution.id").getValue().toString();
                    if (detail == null || "".equals(detail.toString().trim())) continue;
                    token = new StringTokenizer(detail.toString(), ";");
                    while (token.hasMoreTokens()) {
                        devide = new StringTokenizer(token.nextToken(), "=");
                        number = devide.nextToken().trim();
                        title = this.convertNumberWithTitle(number, sumSolutionId);
                        value = new BigDecimal(devide.nextToken());
                        if (!this.columnKeySet.contains(keyPrefix + title)) continue;
                        row.getCell(keyPrefix + title).setValue((Object)value);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.renderDetailInfo();
        }
    }

    private String convertNumberWithTitle(String number, String sumSolutionId) {
        String title = null;
        int n = this.sumItemCollection.size();
        for (int i = 0; i < n; ++i) {
            SumItemInfo sumItem = this.sumItemCollection.get(i);
            if (!number.equals(sumItem.getNumber()) || !sumSolutionId.equals(sumItem.getSumSolution().getId().toString())) continue;
            title = sumItem.getTitle();
            break;
        }
        return title;
    }

    @Override
    public void actionSumExpView_actionPerformed(ActionEvent e) throws Exception {
        SumSolutionInfo sumSolutionInfo = this.getSelectedForSumSolution();
        if (sumSolutionInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noSelectedRecord"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"hr_perf_sumsolution", (Object)sumSolutionInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SumExpUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private SumSolutionInfo getSelectedForSumSolution() throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return null;
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("sumSolution.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                SumSolutionInfo sumSolutionInfo = SumSolutionFactory.getRemoteInstance().getSumSolutionInfo((IObjectPK)new ObjectUuidPK(keyValue.toString()));
                return sumSolutionInfo;
            }
        }
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSumExpView.setIcon(EASResource.getIcon((String)"imgTbtn_seeperformance"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SumResultFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }
}

