/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.ISynSolution;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.SynEvaluFlowFactory;
import com.kingdee.eas.hr.perf.SynModeEnum;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractSynBaseInfoUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.SynSolutionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.event.ChangeEvent;

public class SynBaseInfoUI
extends AbstractSynBaseInfoUI
implements IMultiDimentionSolutionUI {
    private static final long serialVersionUID = -978670L;
    private String evaluSolutionId;
    private Container parentToolBar;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private boolean isUseNumberRule = false;

    public void onLoad() throws Exception {
        EvaluSolutionHelper.initOrgUnit(this.prmtOrgUnit, (IUIObject)this);
        EvaluSolutionHelper.initComboGrade(this.comboGrade);
        this.comboGrade.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                SynBaseInfoUI.this.beforeActionPerformed(e);
                try {
                    SynBaseInfoUI.this.comboGrade_actionPerformed(e);
                }
                catch (Exception exc) {
                    SynBaseInfoUI.this.handUIException(exc);
                }
                finally {
                    SynBaseInfoUI.this.afterActionPerformed(e);
                }
            }
        });
        this.prmtOrgUnit.setRequired(true);
        this.parentToolBar = (Container)this.getUIContext().get("TOOLBAR");
        super.onLoad();
        this.loadBaseInfo();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocus(true);
    }

    public void initUIStatus(boolean isExistSolutionPeriodStarted) {
        Object obj;
        String[] workButtons;
        if (isExistSolutionPeriodStarted) {
            SynSolutionHelper.setEnabled((Container)((Object)this), false);
            workButtons = new String[]{"btnSubmit"};
            SynSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, false);
            this.btnRankGroup.setEnabled(false);
            this.comboRankGroup.setEnabled(false);
            this.btnGrade.setEnabled(false);
            this.btnViewTarget.setEnabled(false);
            this.btnView360.setEnabled(false);
            this.btnViewAudit360.setEnabled(false);
            this.btnViewForm.setEnabled(false);
            this.txtEvalRemark.setEditable(false);
            this.txtSolutionRemark.setEditable(false);
        } else {
            SynSolutionHelper.setEnabled((Container)((Object)this), true);
            if (!OprtState.VIEW.equals(this.getOprtState())) {
                workButtons = new String[]{"btnSubmit"};
                SynSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, true);
            }
            this.btnRankGroup.setEnabled(true);
            this.comboRankGroup.setEnabled(true);
            this.btnGrade.setEnabled(true);
            this.btnViewTarget.setEnabled(this.btnUnify.isSelected());
            this.btnView360.setEnabled(this.btnUnify.isSelected());
            this.btnViewAudit360.setEnabled(this.btnUnify.isSelected());
            this.btnViewForm.setEnabled(true);
            this.txtEvalRemark.setEditable(true);
            this.txtSolutionRemark.setEditable(true);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            SynSolutionHelper.setEnabled((Container)((Object)this), new String[]{"btnViewRankGroup"}, true, false);
            this.btnRankGroup.setEnabled(false);
            this.comboRankGroup.setEnabled(false);
            this.btnGrade.setEnabled(false);
            this.btnViewTarget.setEnabled(false);
            this.btnView360.setEnabled(false);
            this.btnViewAudit360.setEnabled(false);
            this.btnViewForm.setEnabled(false);
            this.txtEvalRemark.setEditable(false);
            this.txtSolutionRemark.setEditable(false);
        }
        if ((obj = this.getUIContext().get("ID")) != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.solution.id", obj));
            try {
                if (SynEvaluFlowFactory.getRemoteInstance().exists(filter)) {
                    this.txtNumber.setEditable(false);
                    this.txtName.setEditable(false);
                }
            }
            catch (Exception ex) {
                super.handleException(ex);
            }
        }
    }

    private void loadBaseInfo() throws Exception {
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        this.synSolution = this.evaluSolutionId == null ? this.createNewData() : SynSolutionFactory.getRemoteInstance().getSynSolutionInfo((IObjectPK)new ObjectUuidPK(this.evaluSolutionId), this.getSelectors());
        this.setDataObject((IObjectValue)this.synSolution);
        this.loadFields();
        boolean isModifiable = this.txtNumber.isEnabled();
        if (this.evaluSolutionId != null) {
            this.initUIStatus(SynSolutionHelper.isExistSolutionPeriodStartedOrEnded(this.evaluSolutionId));
        }
        this.txtNumber.setEnabled(isModifiable);
    }

    private SynSolutionInfo createNewData() {
        SynSolutionInfo solutionInfo = new SynSolutionInfo();
        solutionInfo.setHrOrgUnit(PFUtils.getCurrentHROrgUnit());
        solutionInfo.setEvaluMode(SynModeEnum.Unify);
        solutionInfo.setStatus(SolutionStatusEnum.UNUSED);
        return solutionInfo;
    }

    @Override
    public void loadFields() {
        int i;
        int size;
        try {
            this.isUseNumberRule = PerfUtils.setAutoNumberByOrg("ControlUnit", (IObjectValue)this.createNewData(), (IObjectValue)this.synSolution, this.txtNumber);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        super.loadFields();
        String id = null;
        if (this.synSolution.getGradeMode() != null) {
            GradeModeInfo info = null;
            id = this.synSolution.getGradeMode().getId().toString();
            size = this.comboGrade.getItemCount();
            for (i = 0; i < size; ++i) {
                info = (GradeModeInfo)this.comboGrade.getItemAt(i);
                if (!id.equals(info.getId().toString())) continue;
                this.comboGrade.setSelectedIndex(i);
                break;
            }
        }
        if (this.synSolution.getRankGroup() != null) {
            RankGroupInfo group = null;
            id = this.synSolution.getRankGroup().getId().toString();
            size = this.comboRankGroup.getItemCount();
            for (i = 0; i < size; ++i) {
                group = (RankGroupInfo)this.comboRankGroup.getItemAt(i);
                if (!id.equals(group.getId().toString())) continue;
                this.comboRankGroup.setSelectedIndex(i);
                break;
            }
        }
        if (SynModeEnum.Unify.equals((Object)this.synSolution.getEvaluMode())) {
            this.btnUnify.setSelected(true);
        } else {
            this.btnInput.setSelected(true);
        }
        if (EvaluModeEnum.MANUAL_ENTER.equals((Object)this.synSolution.getInputMode())) {
            this.btnGrade.setSelected(true);
        } else {
            this.btnRankGroup.setSelected(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.name"));
        sic.add(new SelectorItemInfo("rankGroup.id"));
        sic.add(new SelectorItemInfo("rankGroup.name"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        return sic;
    }

    @Override
    public void secondLoad() throws Exception {
        if (this.evaluSolutionId != null) {
            this.initUIStatus(SynSolutionHelper.isExistSolutionPeriodStartedOrEnded(this.evaluSolutionId));
        }
    }

    public String getEvaluSolutionId() {
        return this.evaluSolutionId;
    }

    protected void comboGrade_actionPerformed(ActionEvent e) throws Exception {
        GradeModeInfo gradeModeInfo;
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.comboRankGroup.setEnabled(true);
        }
        if ((gradeModeInfo = (GradeModeInfo)this.comboGrade.getSelectedItem()) != null) {
            EvaluSolutionHelper.initComboRank(this.comboRankGroup, gradeModeInfo.getId().toString());
        }
    }

    @Override
    protected void btnRankGroup_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = this.btnRankGroup.isSelected();
        if (!flag) {
            this.comboRankGroup.setSelectedItem(null);
        }
        this.comboRankGroup.setEnabled(flag);
    }

    @Override
    protected void btnGrade_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = this.btnRankGroup.isSelected();
        if (!flag) {
            this.comboRankGroup.setSelectedItem(null);
        }
        this.comboRankGroup.setEnabled(flag);
    }

    @Override
    public void submit() throws Exception {
        this.verifyInput();
        this.storeFields();
        ISynSolution iSynSolution = SynSolutionFactory.getRemoteInstance();
        this.evaluSolutionId = iSynSolution.submit((CoreBaseInfo)this.synSolution).toString();
        this.synSolution = (SynSolutionInfo)iSynSolution.getValue((IObjectPK)new ObjectUuidPK(this.evaluSolutionId));
        this.txtNumber.setText(this.synSolution.getNumber());
    }

    @Override
    public void verifyInput() throws Exception {
        if (this.txtNumber.isEnabled()) {
            PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        }
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtOrgUnit);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboGrade);
        if (this.btnRankGroup.isSelected() && this.comboRankGroup.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"synSolutionRankGroupNotNull"));
            this.comboRankGroup.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.btnGrade.isSelected()) {
            this.synSolution.setInputMode(EvaluModeEnum.MANUAL_ENTER);
        } else {
            this.synSolution.setInputMode(EvaluModeEnum.RANK_GROUP);
        }
        if (this.btnUnify.isSelected()) {
            this.synSolution.setEvaluMode(SynModeEnum.Unify);
        } else {
            this.synSolution.setEvaluMode(SynModeEnum.Direct_Input);
        }
    }

    @Override
    protected void btnInput_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnInput.isSelected()) {
            this.btnView360.setEnabled(false);
            this.btnViewAudit360.setEnabled(false);
            this.btnViewTarget.setEnabled(false);
        } else {
            this.btnView360.setEnabled(true);
            this.btnViewAudit360.setEnabled(true);
            this.btnViewTarget.setEnabled(true);
        }
    }

    @Override
    protected void btnUnify_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnUnify.isSelected()) {
            this.btnView360.setEnabled(true);
            this.btnViewAudit360.setEnabled(true);
            this.btnViewTarget.setEnabled(true);
        } else {
            this.btnView360.setEnabled(false);
            this.btnViewAudit360.setEnabled(false);
            this.btnViewTarget.setEnabled(false);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        req.put("evaluSolutionId", (Object)this.evaluSolutionId);
        postman.setRequestContext((Serializable)req);
        return postman;
    }
}

