/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.perf.SynEvaluFlowCollection;
import com.kingdee.eas.hr.perf.SynEvaluFlowFactory;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SynWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.client.AbstractSynCopyWorkFlowUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.SynWorkFlowToString;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;

public class SynCopyWorkFlowUI
extends AbstractSynCopyWorkFlowUI {
    private static final long serialVersionUID = -61166L;
    String evaluSolutionID;
    SynSolutionPeriodInfo solutionPeriodInfo;
    String NUMBER = "number";
    String NAME = "name";
    String WEIGHT = "nodeWeight";
    String ID = "id";
    Color selectedColor = new Color(201, 215, 233);
    HashMap strBuffersMap = new HashMap();
    private String RES = "com.kingdee.eas.hr.perf.client.WorkFlowDefineResource";

    public SynCopyWorkFlowUI() throws Exception {
        this.workflowTable.checkParsed();
        this.workflowTable.getSelectManager().setSelectMode(2);
        this.workflowTable.getStyleAttributes().setWrapText(true);
        this.workflowTable.getIndexColumn().setWidthAdjustMode((short)0);
        this.comboAssessPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SynCopyWorkFlowUI.this.comboAssessPeriod_itemStateChanged(e);
                }
                catch (Exception e1) {
                    SynCopyWorkFlowUI.this.handUIException(e1);
                }
            }
        });
    }

    @Override
    protected void buttonOK_actionPerformed(ActionEvent e) throws Exception {
        super.buttonOK_actionPerformed(e);
        if (this.workflowTable.getRowCount() <= 0) {
            this.showErrorMessage("noEvalWorkflowCopy");
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)this.solutionPeriodInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (SynEvaluFlowFactory.getRemoteInstance().exists(filter)) {
            if (this.confirm()) {
                this.copyWorkflow();
            }
        } else {
            this.copyWorkflow();
        }
        this.getUIWindow().close();
    }

    private void copyWorkflow() throws Exception {
        SynWorkFlowFacadeFactory.getRemoteInstance().copyWorkFlow(((SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem()).getId().toString(), this.solutionPeriodInfo.getId().toString());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"copyWorkFlowSuccess"));
    }

    @Override
    protected void buttonCancle_actionPerformed(ActionEvent e) throws Exception {
        super.buttonCancle_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.evaluSolutionID = (String)this.getUIContext().get("evaluSolutionID");
        this.solutionPeriodInfo = (SynSolutionPeriodInfo)this.getUIContext().get("solutionPeriod");
        if (PFVerifyUtils.objectIsNull(this.evaluSolutionID)) {
            this.showErrorMessage("evaluSolutionNotNull");
        }
        if (PFVerifyUtils.objectIsNull(this.solutionPeriodInfo)) {
            this.showErrorMessage("solutionPeriodNotNull");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solution.id", (Object)this.evaluSolutionID);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        SorterItemInfo sorterItem = new SorterItemInfo("createTime");
        sorterItem.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItem);
        SynSolutionPeriodCollection solutionPeriodCollection = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodCollection(viewInfo);
        solutionPeriodCollection.remove(this.solutionPeriodInfo);
        this.comboAssessPeriod.setActionCommand("INIT");
        this.comboAssessPeriod.removeAllItems();
        this.comboAssessPeriod.addItems(solutionPeriodCollection.toArray());
        if (this.comboAssessPeriod.getItemCount() > 0) {
            this.comboAssessPeriod.setSelectedIndex(0);
            this.executeQuery(this.workflowTable, ((SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem()).getId());
        }
        this.comboAssessPeriod.setActionCommand(null);
    }

    public void comboAssessPeriod_itemStateChanged(ActionEvent e) throws Exception {
        if ("INIT".equals(this.comboAssessPeriod.getActionCommand())) {
            return;
        }
        SynSolutionPeriodInfo solutionPeriodInfo = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        if (PFVerifyUtils.objectIsNull(solutionPeriodInfo)) {
            return;
        }
        this.executeQuery(this.workflowTable, solutionPeriodInfo.getId());
    }

    private void executeQuery(KDTable table, BOSUuid solutionPeriodID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("wfLevels"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurrenceLevels"));
        viewInfo.getSelector().add(new SelectorItemInfo("workFlowID"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.nodeName"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.seqNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.weight"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.canComment"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.canGrade"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.canEvaluateLevel"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.nodeLevel"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurArgs.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurArgs.count"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurArgs.concurrenceLevel"));
        SynEvaluFlowCollection evalWorkFlowCollection = SynEvaluFlowFactory.getRemoteInstance().getSynEvaluFlowCollection(viewInfo);
        table.removeRows();
        this.strBuffersMap = new HashMap();
        int n = evalWorkFlowCollection.size();
        for (int i = 0; i < n; ++i) {
            IRow row = table.addRow();
            row.getStyleAttributes().setBackground(this.selectedColor);
            SynEvaluFlowInfo evalWorkFlowInfo = evalWorkFlowCollection.get(i);
            row.getCell(this.ID).setValue((Object)evalWorkFlowInfo.getId());
            row.getCell(this.NUMBER).setValue((Object)evalWorkFlowInfo.getNumber());
            row.getCell(this.NAME).setValue((Object)evalWorkFlowInfo.getName());
            StringBuffer[] stringBuffers = SynWorkFlowToString.convertEvalWorkFlowToString(evalWorkFlowInfo);
            int width = 7 * stringBuffers[0].toString().getBytes().length;
            if (table.getColumn(this.WEIGHT).getWidth() < width) {
                table.getColumn(this.WEIGHT).setWidth(width);
            }
            row.setHeight(stringBuffers.length * 19);
            StringBuffer strBuffer = new StringBuffer();
            int m = stringBuffers.length;
            for (int j = 0; j < m; ++j) {
                strBuffer.append(stringBuffers[j].toString());
                if (j >= m - 1) continue;
                strBuffer.append("\n");
            }
            this.strBuffersMap.put(new Integer(row.getRowIndex()), stringBuffers);
            row.getCell(this.WEIGHT).setValue((Object)strBuffer.toString());
            row.getStyleAttributes().setLocked(true);
        }
    }

    public void viewWorkFlowDetail_actionPerform() throws Exception {
    }

    protected boolean confirm() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"confirmCopyWorkFlow")));
    }

    @Override
    protected void workflowTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.workflowTable_tableClicked(e);
        if (e.getClickCount() == 2 && e.getRowIndex() >= 0) {
            this.viewWorkFlowDetail_actionPerform();
        }
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)this.RES, (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }
}

