/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.ISynEvaluItem;
import com.kingdee.eas.hr.perf.ISynNodeEvaluItem;
import com.kingdee.eas.hr.perf.SynEvaluItemCollection;
import com.kingdee.eas.hr.perf.SynEvaluItemFactory;
import com.kingdee.eas.hr.perf.SynEvaluItemInfo;
import com.kingdee.eas.hr.perf.SynNodeEvaluItemFactory;
import com.kingdee.eas.hr.perf.SynSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractSynEvaluItemUI;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.SynSolutionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTextField;

public class SynEvaluItemUI
extends AbstractSynEvaluItemUI
implements IMultiDimentionSolutionUI {
    private static final long serialVersionUID = -61166L;
    private SynEvaluItemCollection editData = null;
    private SynEvaluItemCollection oldData = null;
    private SynSolutionInfo solution = null;
    String solutionID = null;
    private Icon newLineIcon = EASResource.getIcon((String)"imgTbtn_addline");
    private Icon removeLineIcon = EASResource.getIcon((String)"imgTbtn_deleteline");
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private Container parentToolBar;
    JButton btnAddItem = null;
    JButton btnRemoveItem = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.parentToolBar = (Container)this.getUIContext().get("TOOLBAR");
        this.btnAddItem = this.kDContainer1.add((Action)((Object)this.actionAddEvaluItem));
        this.btnAddItem.setIcon(this.newLineIcon);
        this.btnAddItem.setToolTipText(EASResource.getString((String)RES, (String)"addEvaluItem"));
        this.btnRemoveItem = this.kDContainer1.add((Action)((Object)this.actionRemoveEvaluItem));
        this.btnRemoveItem.setIcon(this.removeLineIcon);
        this.btnRemoveItem.setToolTipText(EASResource.getString((String)RES, (String)"removeEvaluItem"));
        this.solutionID = (String)this.getUIContext().get("ID");
        this.solution = new SynSolutionInfo();
        this.solution.setId(BOSUuid.read((String)this.solutionID));
        this.tblMain.checkParsed();
        KDTextField txtField = new KDTextField();
        txtField.setMaxLength(80);
        this.tblMain.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        this.tblMain.getColumn("content").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        this.loadData();
    }

    private void loadData() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)this.solutionID));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("number"));
        this.editData = SynEvaluItemFactory.getRemoteInstance().getSynEvaluItemCollection(viewInfo);
        this.oldData = (SynEvaluItemCollection)((Object)this.editData.clone());
        this.loadFields();
        this.initUIStatus(SynSolutionHelper.isExistSolutionPeriodStartedOrEnded(this.solutionID));
    }

    public void initUIStatus(boolean isExistSolutionPeriodStarted) throws Exception {
        String[] workButtons;
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            SynSolutionHelper.setEnabled((Container)((Object)this), true);
            workButtons = new String[]{"btnSubmit"};
            MDSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, true);
        }
        if (isExistSolutionPeriodStarted) {
            SynSolutionHelper.setEnabled((Container)((Object)this), false);
            workButtons = new String[]{"btnSubmit"};
            SynSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, false);
            this.btnAddItem.setEnabled(false);
            this.btnRemoveItem.setEnabled(false);
        } else {
            SynSolutionHelper.setEnabled((Container)((Object)this), true);
            this.btnAddItem.setEnabled(true);
            this.btnRemoveItem.setEnabled(true);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            MDSolutionHelper.setEnabled((Container)((Object)this), false);
            this.btnAddItem.setEnabled(false);
            this.btnRemoveItem.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        this.tblMain.setUserObject((Object)this.editData);
        IRow row = null;
        SynEvaluItemInfo info = null;
        ISynNodeEvaluItem isnei = null;
        try {
            isnei = SynNodeEvaluItemFactory.getRemoteInstance();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        FilterItemInfo item1 = new FilterItemInfo("canWrite", (Object)Boolean.TRUE);
        FilterInfo filter = null;
        boolean flag = false;
        Color gray = new Color(0xE8E8E3);
        int n = this.editData.size();
        for (int i = 0; i < n; ++i) {
            info = this.editData.get(i);
            if (info.getId() == null) {
                flag = false;
            } else {
                filter = new FilterInfo();
                filter.getFilterItems().add(item1);
                filter.getFilterItems().add(new FilterItemInfo("evaluItem.id", (Object)info.getId().toString()));
                try {
                    flag = isnei.exists(filter);
                }
                catch (Exception ex) {
                    super.handleException(ex);
                }
            }
            row = this.tblMain.addRow();
            row.getStyleAttributes().setLocked(flag);
            if (flag) {
                row.getStyleAttributes().setBackground(gray);
            }
            row.setUserObject((Object)info);
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("content").setValue((Object)info.getContent());
        }
    }

    @Override
    public void storeFields() {
        SynEvaluItemInfo info = null;
        IRow row = null;
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            info = (SynEvaluItemInfo)row.getUserObject();
            info.put("number", row.getCell("number").getValue());
            info.put("content", row.getCell("content").getValue());
        }
    }

    @Override
    public void actionAddEvaluItem_actionPerformed(ActionEvent e) throws Exception {
        SynEvaluItemInfo ret = new SynEvaluItemInfo();
        ret.setId(BOSUuid.create((BOSObjectType)ret.getBOSType()));
        ret.setSolution(this.solution);
        IRow row = this.tblMain.addRow();
        this.editData.add(ret);
        row.setUserObject((Object)ret);
        row.getCell("id").setValue((Object)ret.getId());
        row.getCell("id").setValue((Object)ret.getId());
        row.getCell("number").setValue((Object)ret.getNumber());
        row.getCell("content").setValue((Object)ret.getContent());
    }

    @Override
    public void actionRemoveEvaluItem_actionPerformed(ActionEvent e) throws Exception {
        int[] index = KDTableUtil.getSelectedRows(this.tblMain);
        if (index.length == 0) {
            return;
        }
        Arrays.sort(index);
        FilterInfo filter = null;
        ISynNodeEvaluItem isei = SynNodeEvaluItemFactory.getRemoteInstance();
        int count = index.length;
        for (int i = index.length - 1; i >= 0; --i) {
            SynEvaluItemInfo info = (SynEvaluItemInfo)this.tblMain.getRow(index[i]).getUserObject();
            if (info.getId() == null) continue;
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluItem.id", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("canWrite", (Object)Boolean.TRUE));
            if (!isei.exists(filter)) continue;
            index[i] = -1;
            --count;
        }
        if (count > 0) {
            int result = MsgBox.showConfirm2((String)("" + count + EASResource.getString((String)RES, (String)"delSynEvaluItemInfo")));
            if (result != 0) {
                return;
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"allSynEvaluItemRefered"));
            return;
        }
        HashSet<String> delSet = new HashSet<String>();
        for (int i = index.length - 1; i >= 0; --i) {
            if (index[i] == -1) continue;
            SynEvaluItemInfo info = (SynEvaluItemInfo)this.tblMain.getRow(index[i]).getUserObject();
            this.editData.removeObject((IObjectValue)info);
            if (info.getId() != null) {
                delSet.add(info.getId().toString());
            }
            this.tblMain.removeRow(index[i]);
        }
        ISynEvaluItem iSynEvaluItem = SynEvaluItemFactory.getRemoteInstance();
        if (delSet.size() > 0) {
            iSynEvaluItem.deleteEvaluItem(delSet);
        }
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"delSynEvaluItemOK"));
    }

    @Override
    public void secondLoad() throws Exception {
        this.initUIStatus(SynSolutionHelper.isExistSolutionPeriodStartedOrEnded(this.solutionID));
    }

    @Override
    public void submit() throws Exception {
        boolean isModified = this.isDataModified();
        this.verifyInput();
        if (!isModified) {
            return;
        }
        ISynEvaluItem iSynEvaluItem = SynEvaluItemFactory.getRemoteInstance();
        int n = this.editData.size();
        for (int i = 0; i < n; ++i) {
            iSynEvaluItem.submit(this.editData.get(i));
        }
        this.oldData = (SynEvaluItemCollection)((Object)this.editData.clone());
    }

    @Override
    public void verifyInput() throws Exception {
        ICell cell = null;
        Object obj = null;
        HashSet<Object> numberSet = new HashSet<Object>();
        HashSet<Object> contentSet = new HashSet<Object>();
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            cell = this.tblMain.getRow(i).getCell("number");
            obj = cell.getValue();
            if (obj == null || "".equals(obj.toString().trim())) {
                this.tblMain.getEditManager().editCellAt(i, cell.getColumnIndex());
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"synEvaluItemNumberNull"));
                SysUtil.abort();
            } else if (numberSet.contains(obj = obj.toString().trim())) {
                this.tblMain.getEditManager().editCellAt(i, cell.getColumnIndex());
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"synEvaluItemNumberDup"));
                SysUtil.abort();
            } else {
                numberSet.add(obj);
            }
            cell = this.tblMain.getRow(i).getCell("content");
            obj = cell.getValue();
            if (obj == null || "".equals(obj.toString().trim())) {
                this.tblMain.getEditManager().editCellAt(i, cell.getColumnIndex());
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"synEvaluItemContentNull"));
                SysUtil.abort();
                continue;
            }
            if (contentSet.contains(obj = obj.toString().trim())) {
                this.tblMain.getEditManager().editCellAt(i, cell.getColumnIndex());
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"synEvaluItemContentDup"));
                SysUtil.abort();
                continue;
            }
            contentSet.add(obj);
        }
    }

    public boolean isDataModified() throws Exception {
        ControlUtilities.checkFocusAndCommit();
        this.storeFields();
        boolean isModified = false;
        if (this.oldData.size() == this.editData.size()) {
            int n = this.oldData.size();
            for (int i = 0; i < n; ++i) {
                boolean bl = isModified = !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)this.oldData.get(i), (AbstractObjectValue)this.editData.get(i));
                if (!isModified) {
                    continue;
                }
                break;
            }
        } else {
            isModified = true;
        }
        return isModified;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("id", this.getUIContext().get("ID"));
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

