/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SynEvaluResultFactory;
import com.kingdee.eas.hr.perf.SynEvaluResultInfo;
import com.kingdee.eas.hr.perf.client.AbstractSynEvaluResultModifyUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;

public class SynEvaluResultModifyUI
extends AbstractSynEvaluResultModifyUI {
    private static final long serialVersionUID = -65534L;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final String editTitlte = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResult");
    private static final String unEditTitlte = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResultNotEdit");
    private static final String viewTitle = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResultTitle");
    private boolean onlyView = false;
    private SynEvaluResultInfo oldResult = null;

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("mdObject.id"));
        sic.add(new SelectorItemInfo("mdObject.person.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.solution.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.assessPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.solution.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.solution.gradeMode.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.solution.gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("solutionPeriod.solution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("rank.id"));
        sic.add(new SelectorItemInfo("rank.name"));
        sic.add(new SelectorItemInfo("modifyer.id"));
        sic.add(new SelectorItemInfo("modifyDate"));
        sic.add(new SelectorItemInfo("isApproved"));
        sic.add(new SelectorItemInfo("solutionPeriod.solution.rankGroup.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.solution.inputMode"));
        return sic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtModifiedScore.setEditable(true);
            this.comboModifiedRank.setEnabled(true);
            this.txtModifyCause.setEditable(true);
            this.kDContainer1.setTitle(editTitlte);
        } else {
            this.txtModifiedScore.setEditable(false);
            this.comboModifiedRank.setEnabled(false);
            if (!this.onlyView) {
                this.kDContainer1.setTitle(unEditTitlte);
            } else {
                this.kDContainer1.setTitle(viewTitle);
            }
            this.txtModifyCause.setEditable(false);
        }
        if (EvaluModeEnum.RANK_GROUP.equals((Object)this.editData.getSolutionPeriod().getSolution().getInputMode())) {
            this.contEvaluScore.setVisible(false);
            this.contModifiedScore.setVisible(false);
            this.contRank.setVisible(true);
            this.contRank.setEnabled(false);
            this.contModifiedRank.setVisible(true);
            if (this.editData.getRank() != null) {
                this.comboRank.removeAllItems();
                this.comboRank.addItem((Object)this.editData.getRank().getName());
            }
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)this.editData.getSolutionPeriod().getSolution().getRankGroup().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("id"));
            SorterItemCollection sorter = viewInfo.getSorter();
            sorter.add(new SorterItemInfo("serial"));
            RankInfo rank = this.editData.getModifiedRank();
            try {
                RankCollection coll = RankFactory.getRemoteInstance().getRankCollection(viewInfo);
                this.comboModifiedRank.removeAllItems();
                if (coll == null || coll.size() <= 0) return;
                this.comboModifiedRank.addItems(coll.toArray());
                this.comboModifiedRank.setSelectedItem(null);
                if (rank == null) return;
                int n = coll.size();
                for (int i = 0; i < n; ++i) {
                    if (!coll.get(i).getId().equals((Object)rank.getId())) continue;
                    this.comboModifiedRank.setSelectedIndex(i);
                    return;
                }
                return;
            }
            catch (Exception ex) {
                super.handleException(ex);
                return;
            }
        } else {
            this.contEvaluScore.setVisible(true);
            this.contModifiedScore.setVisible(true);
            this.contRank.setVisible(false);
            this.contModifiedRank.setVisible(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SynEvaluResultFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        BigDecimal maxGrade = this.editData.getSolutionPeriod().getSolution().getGradeMode().getMaxGrade();
        BigDecimal minGrade = this.editData.getSolutionPeriod().getSolution().getGradeMode().getMinGrade();
        BigDecimal grade = this.txtModifiedScore.getBigDecimalValue();
        if (grade != null) {
            if (grade.compareTo(maxGrade) > 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"tooLarger") + ":" + PFVerifyUtils.formatBigDecimal(maxGrade, 2)));
                SysUtil.abort();
            }
            if (grade.compareTo(minGrade) < 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"tooLess") + ":" + PFVerifyUtils.formatBigDecimal(minGrade, 2)));
                SysUtil.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.onlyView = true;
        }
        super.onLoad();
        this.txtModifiedScore.setRemoveingZeroInDispaly(false);
        this.txtModifiedScore.setRemoveingZeroInEdit(false);
        this.txtEvaluScore.setRemoveingZeroInDispaly(false);
        this.txtEvaluScore.setRemoveingZeroInEdit(false);
        this.txtEvaluScore.setEditable(false);
        this.comboRank.setEditable(false);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        if (!this.onlyView && !this.editData.isIsApproved()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        if (!this.onlyView && !this.editData.isIsApproved()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        if (!this.onlyView && !this.editData.isIsApproved()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        if (!this.onlyView && !this.editData.isIsApproved()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.pickerModifyDate.setValue((Object)new Date());
            this.prmptModifier.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        }
    }

    public IObjectPK runSave() throws Exception {
        Date date = this.editData.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
            this.editData.setModifyDate(date);
        }
        return super.runSave();
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setModifyDate(DateTimeUtils.truncateDate((Date)new Date()));
        this.editData.setModifyer(SysContext.getSysContext().getCurrentUserInfo());
        this.editData.setIsModify(true);
        return super.runSubmit();
    }

    protected void initOldData(IObjectValue dataObject) {
        super.initOldData(dataObject);
        this.oldResult = (SynEvaluResultInfo)((SynEvaluResultInfo)dataObject).clone();
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        if (this.oldResult.getModifiedScore() != null && this.editData.getModifiedScore() != null ? this.oldResult.getModifiedScore().compareTo(this.editData.getModifiedScore()) != 0 : this.oldResult.getModifiedScore() != this.editData.getModifiedScore()) {
            return true;
        }
        if (this.oldResult.getModifiedRank() != null && this.editData.getModifiedRank() != null ? !this.oldResult.getModifiedRank().getId().toString().equals(this.editData.getModifiedRank().getId().toString()) : this.oldResult.getModifiedRank() != this.editData.getModifiedRank()) {
            return true;
        }
        return !this.causeEquals(this.oldResult.getModifyCause(), this.editData.getModifyCause());
    }

    private boolean causeEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return StringUtils.isEmpty((String)str2);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

