/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.ISynEvaluResultFacade;
import com.kingdee.eas.hr.perf.SynEvaluObjectFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.hr.perf.SynEvaluResultFacadeFactory;
import com.kingdee.eas.hr.perf.SynEvaluResultFactory;
import com.kingdee.eas.hr.perf.SynNodeProcesserFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractSynEvaluResultProcUI;
import com.kingdee.eas.hr.perf.client.EvaluResultPersonalListUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.MDEvaluResultPersonalListUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.SynEvaluResultModifyUI;
import com.kingdee.eas.hr.perf.client.SynPaperFormUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynEvaluResultProcUI
extends AbstractSynEvaluResultProcUI {
    private static final long serialVersionUID = 6927629030045895165L;
    private static final Logger logger = CoreUIObject.getLogger(SynEvaluResultProcUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private IColumn rankCol = null;
    private IColumn modifiedRankCol = null;
    private IColumn evaluScoreCol = null;
    private IColumn modifiedScoreCol = null;
    private Object rankHeadName = null;
    private Object modifiedRankHeadName = null;
    private Object evaluScoreHeadName = null;
    private Object modifiedScoreHeadName = null;

    public void onLoad() throws Exception {
        super.onLoad();
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.setSolutionPeriodF7Filter();
        this.tblMain.setColumnMoveable(true);
        this.prmptSolutionPeriod.setEditable(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SynEvaluResultFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return SynEvaluResultModifyUI.class.getName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnViewTargetResult.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        this.btnViewMDEvaluResult.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnResultModify.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.btnViewPaper.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnModifyPaper.setIcon(EASResource.getIcon((String)"imgTbtn_ruleinitialize"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemEvResult.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        this.menuItemMDResult.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.menuItemResultModify.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.menuItemViewPaper.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.menuItemEdit.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.menuItemModifyPaper.setIcon(EASResource.getIcon((String)"imgTbtn_ruleinitialize"));
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setShowSorter(false);
        dialog.setUiObject((IUIObject)this);
        return dialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String id = null;
        Object value = this.prmptSolutionPeriod.getValue();
        id = value != null ? ((SynSolutionPeriodInfo)value).getId().toString() : "%noeas%";
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)id, CompareType.EQUALS));
        try {
            filter.getFilterItems().add(PFUtils.getAdminRangeFilterItemInfo("adminOrgUnit.id"));
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        return filter;
    }

    private void setSolutionPeriodF7Filter() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        FilterInfo newFilter = new FilterInfo();
        newFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(102)));
        filter.mergeFilter(newFilter, "AND");
        viewInfo.setFilter(filter);
        this.prmptSolutionPeriod.setEntityViewInfo(viewInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("solution.id"));
        sic.add(new SelectorItemInfo("solution.name"));
        sic.add(new SelectorItemInfo("solution.gradeMode.id"));
        sic.add(new SelectorItemInfo("solution.gradeMode.name"));
        sic.add(new SelectorItemInfo("solution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("solution.gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("solution.inputMode"));
        sic.add(new SelectorItemInfo("assessPeriod.id"));
        sic.add(new SelectorItemInfo("assessPeriod.name"));
        sic.add(new SelectorItemInfo("assessPeriod.startDate"));
        sic.add(new SelectorItemInfo("assessPeriod.endDate"));
        this.prmptSolutionPeriod.setSelectorCollection(sic);
    }

    @Override
    protected void prmptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        SynSolutionPeriodInfo info = (SynSolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        ICell cell = null;
        if (info != null) {
            this.txtGradeMode.setText(info.getSolution().getGradeMode().getName());
            this.txtGradeFrom.setText(PFVerifyUtils.formatBigDecimal(info.getSolution().getGradeMode().getMinGrade(), 2));
            this.txtGradeTo.setText(PFVerifyUtils.formatBigDecimal(info.getSolution().getGradeMode().getMaxGrade(), 2));
            this.txtSolution.setText(info.getSolution().getName());
            this.txtAssessPeriod.setText(info.getAssessPeriod().getName());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.txtStartDate.setText(format.format(info.getAssessPeriod().getStartDate()));
            this.txtEndDate.setText(format.format(info.getAssessPeriod().getEndDate()));
            if (EvaluModeEnum.MANUAL_ENTER.equals((Object)info.getSolution().getInputMode())) {
                cell = this.tblMain.getHeadRow(0).getCell("modifiedRank.name");
                if (cell != null) {
                    this.modifiedRankHeadName = cell.getValue();
                    this.modifiedRankCol = this.tblMain.removeColumn(this.tblMain.getColumn("modifiedRank.name").getColumnIndex());
                }
                if ((cell = this.tblMain.getHeadRow(0).getCell("rank.name")) != null) {
                    this.rankHeadName = cell.getValue();
                    this.rankCol = this.tblMain.removeColumn(this.tblMain.getColumn("rank.name").getColumnIndex());
                }
                if (this.evaluScoreCol != null && this.modifiedScoreCol != null && this.evaluScoreHeadName != null && this.modifiedScoreHeadName != null && this.tblMain.getColumn("evaluScore") == null) {
                    this.tblMain.addColumn(this.tblMain.getColumn("adminOrgUnit.displayName").getColumnIndex() + 1, this.evaluScoreCol);
                    this.tblMain.addColumn(this.tblMain.getColumn("evaluScore").getColumnIndex() + 1, this.modifiedScoreCol);
                    this.tblMain.getHeadRow(0).getCell("evaluScore").setValue(this.evaluScoreHeadName);
                    this.tblMain.getHeadRow(0).getCell("modifiedScore").setValue(this.modifiedScoreHeadName);
                    this.tblMain.getColumn("evaluScore").setWidth(100);
                    this.tblMain.getColumn("modifiedScore").setWidth(100);
                }
            } else {
                cell = this.tblMain.getHeadRow(0).getCell("modifiedScore");
                if (cell != null) {
                    this.modifiedScoreHeadName = cell.getValue();
                    this.modifiedScoreCol = this.tblMain.removeColumn(this.tblMain.getColumn("modifiedScore").getColumnIndex());
                }
                if ((cell = this.tblMain.getHeadRow(0).getCell("evaluScore")) != null) {
                    this.evaluScoreHeadName = cell.getValue();
                    this.evaluScoreCol = this.tblMain.removeColumn(this.tblMain.getColumn("evaluScore").getColumnIndex());
                }
                if (this.rankCol != null && this.modifiedRankCol != null && this.rankHeadName != null && this.modifiedRankHeadName != null && this.tblMain.getColumn("rank.name") == null) {
                    this.tblMain.addColumn(this.tblMain.getColumn("adminOrgUnit.displayName").getColumnIndex() + 1, this.rankCol);
                    this.tblMain.addColumn(this.tblMain.getColumn("rank.name").getColumnIndex() + 1, this.modifiedRankCol);
                    this.tblMain.getHeadRow(0).getCell("rank.name").setValue(this.rankHeadName);
                    this.tblMain.getHeadRow(0).getCell("modifiedRank.name").setValue(this.modifiedRankHeadName);
                }
            }
            this.prmptSolutionPeriod.setToolTipText(info.getName());
        } else {
            this.txtGradeFrom.setText(null);
            this.txtGradeTo.setText(null);
            this.txtGradeMode.setText(null);
            this.txtSolution.setText(null);
            this.txtAssessPeriod.setText(null);
            this.txtStartDate.setText(null);
            this.txtEndDate.setText(null);
        }
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.execQuery();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private String getSelectedPersonID() {
        if (this.tblMain.getRowCount() <= 0) {
            return null;
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("person.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected String getSelectedMDObjectID() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("mdObject.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected boolean getSelectedIsApproved() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            } else {
                return (Boolean)row.getCell("isApproved").getValue();
            }
        }
        return false;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedIsApproved()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NoEditForAudited"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemForAudit"));
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (((Boolean)row.getCell("isApproved").getValue()).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemSuitebaleForAudit"));
            return;
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"selectedItems"));
        sb.append(idList.length);
        sb.append(EASResource.getString((String)RES, (String)"auditConfirm"));
        if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
            return;
        }
        ISynEvaluResultFacade facade = SynEvaluResultFacadeFactory.getRemoteInstance();
        facade.auditBill(idList);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditSuccess"));
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemForAntiAudit"));
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (!((Boolean)row.getCell("isApproved").getValue()).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemSuitebaleForAntiAudit"));
            return;
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"selectedItems"));
        sb.append(idList.length);
        sb.append(EASResource.getString((String)RES, (String)"antiAuditConfirm"));
        if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
            return;
        }
        ISynEvaluResultFacade facade = SynEvaluResultFacadeFactory.getRemoteInstance();
        facade.antiAuditBill(idList);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"antiAuditSuccess"));
    }

    @Override
    public void actionViewMDEvaluResult_actionPerformed(ActionEvent e) throws Exception {
        String evaluObjectID = this.getSelectedPersonID();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"evalor", (Object)evaluObjectID);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MDEvaluResultPersonalListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewTargetResult_actionPerformed(ActionEvent e) throws Exception {
        String evaluObjectID = this.getSelectedPersonID();
        EvaluObjectTypeEnum evaluObjectType = EvaluObjectTypeEnum.PERSON;
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"evalor", (Object)evaluObjectID);
        uiContext.put((Object)"evaluObjectType", (Object)evaluObjectType);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EvaluResultPersonalListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public RequestContext prepareActionViewPaper(IItemAction itemAction) throws Exception {
        this.checkSelected();
        RequestContext req = super.prepareActionViewPaper(itemAction);
        String objectID = this.getSelectedMDObjectID();
        req.put("objectID", (Object)objectID);
        return req;
    }

    @Override
    public void actionViewPaper_actionPerformed(ActionEvent e) throws Exception {
        this.showPaper(e, OprtState.VIEW);
    }

    @Override
    public void actionModifyPaper_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedIsApproved()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NoEditForAudited"));
            return;
        }
        this.showPaper(e, OprtState.EDIT);
    }

    private void showPaper(ActionEvent e, String state) throws EASBizException, BOSException {
        this.checkSelected();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.id", (Object)this.getSelectedKeyValue()));
        if (!SynNodeProcesserFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noNodeProcesser"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        SynSolutionPeriodInfo info = (SynSolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        uiContext.put((Object)"solutionPeriodID", (Object)info.getId().toString());
        String objectID = this.getSelectedMDObjectID();
        uiContext.put((Object)"evaluObjectID", (Object)objectID);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        SynEvaluObjectInfo eo = SynEvaluObjectFactory.getRemoteInstance().getSynEvaluObjectInfo((IObjectPK)new ObjectUuidPK(objectID), sic);
        uiContext.put((Object)"evalor", (Object)eo.getPerson().getId().toString());
        if (OprtState.EDIT.equals(state)) {
            uiContext.put((Object)"flag", (Object)"input");
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(SynPaperFormUI.class.getName(), (Map)uiContext, null, state);
        uiWindow.show();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewPaper() {
        return true;
    }

    @Override
    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    @Override
    public boolean isPrepareActionView() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionPeriod", this.prmptSolutionPeriod.getValue());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionPeriod", this.prmptSolutionPeriod.getValue());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }
}

