/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.IMultiDimEvaluator;
import com.kingdee.eas.hr.perf.MessageString;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SynWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.WorkFlowControlEnum;
import com.kingdee.eas.hr.perf.client.AbstractSynEvaluTrailFlowHastenUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class SynEvaluTrailFlowHastenUI
extends AbstractSynEvaluTrailFlowHastenUI {
    private static final Logger logger = CoreUIObject.getLogger(SynEvaluTrailFlowHastenUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.perf.client.WorkFlowControlResource";
    private String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private String resClass = "com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.";
    private String solutionPeriodId;
    private String evaluObjectId;
    private String evaluPersonName;
    private HashMap personMap = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        this.fetchDataFromContext();
        this.initPersonTable();
        this.btnSendMessage.setEnabled(true);
        this.btnSendMail.setEnabled(true);
        this.btnAddPerson.setEnabled(true);
        this.btnDeletePerson.setEnabled(true);
    }

    private void fetchDataFromContext() {
        this.solutionPeriodId = (String)this.getUIContext().get("solutionPeriodID");
        this.evaluObjectId = (String)this.getUIContext().get("evaluObjectID");
        this.evaluPersonName = (String)this.getUIContext().get("evaluPersonName");
        if (PFVerifyUtils.objectIsNull(this.evaluObjectId)) {
            PerfClientUtils.showErrorMessage(RESOURCE, "evaluobjectNotNull", this);
        }
        if (PFVerifyUtils.objectIsNull(this.solutionPeriodId)) {
            PerfClientUtils.showErrorMessage(RESOURCE, "solutionperiodNotNull", this);
        }
        if (PFVerifyUtils.objectIsNull(this.evaluPersonName)) {
            PerfClientUtils.showErrorMessage(RESOURCE, "evaluObjectNameNotNull", this);
        }
    }

    private void initPersonTable() throws BOSException, EASBizException, Exception, SQLException {
        this.personTable.checkParsed();
        String[] persons = null;
        Object obj = this.getUIContext().get("operatorID");
        persons = obj != null ? new String[]{obj.toString()} : SynWorkFlowFacadeFactory.getRemoteInstance().getPersonIdsFromInst(this.solutionPeriodId, this.evaluObjectId);
        SynEvaluObjectInfo evaluObjectInfo = SynEvaluObjectFactory.getRemoteInstance().getSynEvaluObjectInfo((IObjectPK)new ObjectUuidPK(this.evaluObjectId));
        String evalorId = evaluObjectInfo.getPerson().getId().toString();
        HashSet<String> ids = new HashSet<String>();
        ids.add(evalorId);
        this.personMap.put(evalorId, WorkFlowControlEnum.EVALUOBJECT);
        if (persons != null && persons.length > 0) {
            int n = persons.length;
            for (int i = 0; i < n; ++i) {
                ids.add(persons[i]);
                this.personMap.put(persons[i], WorkFlowControlEnum.UNDISPOSE);
            }
        }
        IRowSet rowSet = this.getPersonRowSetByPersonIds(ids);
        while (rowSet.next()) {
            if (evalorId.equals(rowSet.getString("id")) && !WorkFlowControlEnum.EVALUOBJECT.equals((Object)((WorkFlowControlEnum)((Object)this.personMap.get(evalorId))))) {
                this.setRowInfo(evalorId, rowSet, WorkFlowControlEnum.EVALUOBJECT);
            }
            this.setRowInfo(rowSet.getString("id"), rowSet, (WorkFlowControlEnum)((Object)this.personMap.get(rowSet.getString("id"))));
        }
        this.personTable.getStyleAttributes().setLocked(true);
        this.personTable.getSelectManager().setSelectMode(2);
    }

    private void setRowInfo(String evalorId, IRowSet rowSet, WorkFlowControlEnum role) throws SQLException {
        IRow row = this.personTable.addRow();
        String noPos = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"noPositionPerson");
        row.getCell("id").setValue((Object)evalorId);
        row.getCell("name").setValue((Object)rowSet.getString("name"));
        row.getCell("number").setValue((Object)rowSet.getString("number"));
        row.getCell("position").setValue((Object)rowSet.getString("position.name"));
        String org = rowSet.getString("adminOrgUnit.displayName");
        if (org == null || "".equals(org.trim())) {
            org = noPos;
        }
        row.getCell("orgunit").setValue((Object)org);
        row.getCell("role").setValue((Object)role);
        row.getCell("email").setValue((Object)rowSet.getString("email"));
    }

    private IRowSet getPersonRowSetByPersonIds(Set ids) throws Exception {
        if (PFVerifyUtils.objectIsNull(ids) || ids.size() == 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "WorkFlowControlPersonQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = null;
        try {
            rowSet = iqec.executeQuery();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return rowSet;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnSendMessage.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.btnSendMail.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnDeletePerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
    }

    @Override
    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        SynSolutionPeriodInfo solutionPeriodInfo = this.getSynSolutionPeriod();
        HashMap messageMap = this.assembleMessages(solutionPeriodInfo);
        EvalWorkFlowFacadeFactory.getRemoteInstance().sendMessage(messageMap);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"sendMessageSuccess"));
    }

    private SynSolutionPeriodInfo getSynSolutionPeriod() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.solutionPeriodId));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        SynSolutionPeriodInfo solutionPeriodInfo = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodCollection(viewInfo).get(0);
        return solutionPeriodInfo;
    }

    private HashMap assembleMessages(SynSolutionPeriodInfo solutionPeriodInfo) {
        HashMap<String, MessageString> messageMap = new HashMap<String, MessageString>();
        MessageString messageString = null;
        String message = null;
        Object[] variables = null;
        IRow row = null;
        WorkFlowControlEnum role = null;
        int n = this.personTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.personTable.getRow(i);
            if (PFVerifyUtils.objectIsNull(row.getCell("id").getValue())) continue;
            messageString = new MessageString();
            role = (WorkFlowControlEnum)((Object)row.getCell("role").getValue());
            if (WorkFlowControlEnum.UNDISPOSE.equals((Object)role)) {
                String evaluerName = row.getCell("name").getValue().toString();
                message = EASResource.getString((String)RESOURCE, (String)"synEvaluerMessage");
                variables = new Object[]{evaluerName, solutionPeriodInfo.getName(), this.evaluPersonName};
            } else {
                message = EASResource.getString((String)RESOURCE, (String)"synEvaluObjectMessage");
                variables = new Object[]{this.evaluPersonName, solutionPeriodInfo.getName()};
            }
            messageString.setTitle(MessageFormat.format(message, variables));
            messageString.setSender(EASResource.getString((String)RESOURCE, (String)"sender"));
            messageMap.put(row.getCell("id").getValue().toString(), messageString);
        }
        return messageMap;
    }

    @Override
    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        int rowSize = this.personTable.getRowCount();
        if (rowSize <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"atleastOneEmailAddr"));
            SysUtil.abort();
        }
        int badEmailCount = 0;
        StringBuffer badEmailName = new StringBuffer();
        String email = null;
        IRow row = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.personTable.getRow(i);
            email = (String)row.getCell("email").getValue();
            if (!StringUtils.isEmpty((String)email) && email.indexOf("@") >= 0) continue;
            if (badEmailCount != 0) {
                badEmailName.append(",");
            }
            badEmailName.append(row.getCell("name").getValue().toString());
            ++badEmailCount;
        }
        if (badEmailCount > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(badEmailName);
            sb.append(EASResource.getString((String)this.RES, (String)"etc"));
            sb.append(badEmailCount);
            sb.append(EASResource.getString((String)this.RES, (String)"sendMailConfirm"));
            if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
                return;
            }
        }
        String solutionPeriodName = this.getSynSolutionPeriod().getName();
        String message = EASResource.getString((String)this.RES, (String)"hastenSubmitPaper");
        WorkFlowControlEnum role = null;
        String subject = null;
        String content = null;
        String fromPersonID = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
        String to = null;
        IMultiDimEvaluator iMDEvaluator = MultiDimEvaluatorFactory.getRemoteInstance();
        for (int i = 0; i < rowSize; ++i) {
            Object[] variables;
            row = this.personTable.getRow(i);
            if (PFVerifyUtils.objectIsNull(row.getCell("id").getValue()) || (to = (String)row.getCell("email").getValue()) == null || to.indexOf("@") < 0) continue;
            role = (WorkFlowControlEnum)((Object)row.getCell("role").getValue());
            if (WorkFlowControlEnum.UNDISPOSE.equals((Object)role)) {
                String evaluerName = row.getCell("name").getValue().toString();
                message = EASResource.getString((String)RESOURCE, (String)"synEvaluerMessage");
                variables = new Object[]{evaluerName, solutionPeriodName, this.evaluPersonName};
            } else {
                message = EASResource.getString((String)RESOURCE, (String)"synEvaluObjectMessage");
                variables = new Object[]{this.evaluPersonName, solutionPeriodName};
            }
            content = subject = MessageFormat.format(message, variables);
            try {
                iMDEvaluator.sendMail(fromPersonID, to, subject, content);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex.getCause(), (Throwable)ex);
                ExceptionHandler.handle((Component)((Object)this), (String)ex.getMessage(), (Throwable)ex);
                SysUtil.abort();
            }
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SENDMAIL_SUCCESS")));
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        KDPromptBox promptBox = new KDPromptBox();
        EmployeeMultiF7PromptBox box = new EmployeeMultiF7PromptBox((IUIObject)this);
        box.setIsSingleSelect(false);
        promptBox.setSelector((KDPromptSelector)box);
        promptBox.setDataBySelector();
        Object[] objs = (Object[])promptBox.getValue();
        HashSet<String> ids = new HashSet<String>();
        if (!PFVerifyUtils.objectIsNull(objs) && !PFVerifyUtils.objectIsNull(objs[0])) {
            int n = objs.length;
            for (int i = 0; i < n; ++i) {
                PersonInfo personInfo = (PersonInfo)objs[i];
                String id = personInfo.getId().toString();
                if (this.personMap.containsKey(id)) continue;
                ids.add(id);
                this.personMap.put(id, WorkFlowControlEnum.ASSIGNER);
            }
        }
        if (ids.size() > 0) {
            IRowSet rowSet = this.getPersonRowSetByPersonIds(ids);
            while (rowSet.next()) {
                this.setRowInfo(rowSet.getString("id"), rowSet, WorkFlowControlEnum.ASSIGNER);
            }
        }
    }

    @Override
    public void actionDeletePerson_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.personTable);
        if (this.personTable.getRowCount() == 1) {
            PerfClientUtils.showErrorMessage(RESOURCE, "notDeleteAll", this);
        }
        int currentIndex = PFUtils.getSelectedRow(this.personTable);
        IRow row = this.personTable.getRow(currentIndex);
        this.personMap.remove(row.getCell("id").getValue().toString());
        this.personTable.removeRow(currentIndex);
    }
}

