/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.SynFlowObjectCollection;
import com.kingdee.eas.hr.perf.SynFlowObjectFactory;
import com.kingdee.eas.hr.perf.SynNodeProcesserFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SynWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.client.AbstractSynEvaluTrailListUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.SynEvaluTrailFlowHastenUI;
import com.kingdee.eas.hr.perf.client.SynPaperFormUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.util.Map;

public class SynEvaluTrailListUI
extends AbstractSynEvaluTrailListUI {
    private static final String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.fillCboSolutionPeriod();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFlowReset.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.btnAssessRecord.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
        this.btnViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.btnFlowHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.menuItemResetFlow.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.menuItemViewForm.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
        this.menuItemViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemFlowHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.actionFlowReset.setEnabled(true);
        this.actionViewFlow.setEnabled(true);
        this.actionFlowHasten.setEnabled(true);
        this.actionAssessRecord.setEnabled(true);
    }

    private void fillCboSolutionPeriod() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(101)));
        filterInfo.getFilterItems().add(new FilterItemInfo("solution.evaluMode", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("solution.hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("solution.inputMode"));
        viewInfo.setFilter(filterInfo);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("endDate");
        sorterItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        SynSolutionPeriodCollection collection = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodCollection(viewInfo);
        if (collection != null) {
            this.cboSolutionPeriod.addItems(collection.toArray());
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        SynSolutionPeriodInfo periodInfo = (SynSolutionPeriodInfo)this.cboSolutionPeriod.getSelectedItem();
        String solutionPeriodId = periodInfo != null ? periodInfo.getId().toString() : "%noeas%";
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        filterInfo.getFilterItems().add(new FilterItemInfo("SynSolutionPeriod.id", (Object)solutionPeriodId));
        try {
            filterInfo.getFilterItems().add(PFUtils.getAdminRangeFilterItemInfo("adminOrgUnit.id"));
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        this.setColumnHide(periodInfo);
        return filterInfo;
    }

    private void setColumnHide(SynSolutionPeriodInfo periodInfo) {
        if (periodInfo == null || periodInfo.getSolution() == null) {
            return;
        }
        if (EvaluModeEnum.RANK_GROUP.equals((Object)periodInfo.getSolution().getInputMode())) {
            this.tblMain.getColumn("rank.name").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("synEvaluResult.evaluScore").getStyleAttributes().setHided(true);
        } else if (EvaluModeEnum.MANUAL_ENTER.equals((Object)periodInfo.getSolution().getInputMode())) {
            this.tblMain.getColumn("rank.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("synEvaluResult.evaluScore").getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void cboSolutionPeriod_itemStateChanged(ItemEvent e) throws Exception {
        this.mainQuery = this.getEntityViewInfo(new EntityViewInfo());
        this.execQuery();
    }

    @Override
    public void actionAssessRecord_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String solutionPeriodID = row.getCell("synSolutionPeriodID").getValue().toString();
        String evaluObjectID = row.getCell("synEvaluObjectID").getValue().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod.id", (Object)solutionPeriodID));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.mdObject.id", (Object)evaluObjectID));
        if (!SynNodeProcesserFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"noSynNodeprocesser"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriodID", (Object)solutionPeriodID);
        uiContext.put((Object)"evaluObjectID", (Object)evaluObjectID);
        uiContext.put((Object)"evalor", (Object)row.getCell("personID").getValue().toString());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(SynPaperFormUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionFlowHasten_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (10 == status.getInt()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"UnUsedFlow"));
            SysUtil.abort();
        }
        if (30 == status.getInt()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"ClosedFlow"));
            SysUtil.abort();
        }
        String solutionPeriodId = (String)row.getCell("synSolutionPeriodID").getValue();
        String evaluObjectId = (String)row.getCell("synEvaluObjectID").getValue();
        String evaluObjectName = (String)row.getCell("person.name").getValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriodID", (Object)solutionPeriodId);
        uiContext.put((Object)"evaluObjectID", (Object)evaluObjectId);
        uiContext.put((Object)"evaluPersonName", (Object)evaluObjectName);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(SynEvaluTrailFlowHastenUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionFlowReset_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)resourcePath, (String)"affirmRestartFlow"));
        if (result != 0) {
            return;
        }
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String solutionPeriodId = (String)row.getCell("synSolutionPeriodID").getValue();
        String evaluObjectId = (String)row.getCell("synEvaluObjectID").getValue();
        SynWorkFlowFacadeFactory.getRemoteInstance().restartProcess(solutionPeriodId, evaluObjectId);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RestartFlowSuccess"));
        this.refresh(e);
    }

    @Override
    public RequestContext prepareActionViewFlow(IItemAction itemAction) throws Exception {
        RequestContext req = super.prepareActionViewFlow(itemAction);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String workFlowId = row.getCell("workFlowID").getValue().toString();
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status == null || 10 == status.getInt()) {
            req.put("workFlowId", (Object)workFlowId);
        } else {
            String solutionPeriodId = (String)row.getCell("synSolutionPeriodID").getValue();
            String evaluObjectId = (String)row.getCell("synEvaluObjectID").getValue();
            req.put("solutionPeriodId", (Object)solutionPeriodId);
            req.put("evaluObjectId", (Object)evaluObjectId);
        }
        return req;
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String workFlowId = row.getCell("workFlowID").getValue().toString();
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status == null || 10 == status.getInt()) {
            PFVerifyUtils.showWorkFlowDef((CoreUIObject)this, workFlowId);
        } else {
            String solutionPeriodId = (String)row.getCell("synSolutionPeriodID").getValue();
            String evaluObjectId = (String)row.getCell("synEvaluObjectID").getValue();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectId));
            filterInfo.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodId));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("procInstID"));
            SynFlowObjectCollection collection = SynFlowObjectFactory.getRemoteInstance().getSynFlowObjectCollection(viewInfo);
            if (collection.size() > 0) {
                WfMonitorUtils.showWfDiagram((Component)((Object)this), (String)collection.get(0).getProcInstID());
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    @Override
    public boolean isPrepareActionAssessRecord() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewFlow() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareQuery() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionPeriod", this.cboSolutionPeriod.getSelectedItem());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionPeriod", this.cboSolutionPeriod.getSelectedItem());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    @Override
    public RequestContext prepareActionAssessRecord(IItemAction itemAction) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String solutionPeriodID = row.getCell("synSolutionPeriodID").getValue().toString();
        String evaluObjectID = row.getCell("synEvaluObjectID").getValue().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod.id", (Object)solutionPeriodID));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.mdObject.id", (Object)evaluObjectID));
        RequestContext req = super.prepareActionAssessRecord(itemAction);
        req.put("filter", (Object)filter);
        return req;
    }
}

