/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvalWorkFlowFactory;
import com.kingdee.eas.hr.perf.ISynEvaluFlow;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SynEvaluFlowFactory;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractSynEvaluWorkFlowUI;
import com.kingdee.eas.hr.perf.client.CopyEvaluWorkFlowOrgUI;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.SynWorkFlowToString;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynEvaluWorkFlowUI
extends AbstractSynEvaluWorkFlowUI
implements IMultiDimentionSolutionUI {
    private static final long serialVersionUID = -61166L;
    private String evaluSolutionID;
    private static final String USER = "0";
    private static final String MACHINE = "1";
    private int selectedIndex = -1;
    private static final String RES = "com.kingdee.eas.hr.perf.client.NodeProcesserResource";
    private static final Logger logger = CoreUIObject.getLogger((String)"com.kingdee.eas.hr.perf.client.SynEvaluWorkFlowUI");

    public void onLoad() throws Exception {
        super.onLoad();
        this.evaluSolutionID = (String)this.getUIContext().get("ID");
        this.initSolutionPeriod();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getIndexColumn().setWidthAdjustMode((short)0);
    }

    private void initSolutionPeriod() throws BOSException, Exception {
        if (this.evaluSolutionID == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)this.evaluSolutionID));
        SorterItemInfo sorterItem = new SorterItemInfo("createTime");
        sorterItem.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItem);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("solution.id"));
        SynSolutionPeriodCollection coll = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            this.comboAssessPeriod.setActionCommand(MACHINE);
            this.comboAssessPeriod.addItems(coll.toArray());
            this.comboAssessPeriod.setActionCommand(USER);
            this.comboAssessPeriod.setSelectedIndex(0);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    protected void comboAssessPeriod_actionPerformed(ActionEvent e) throws Exception {
        if (MACHINE.equals(e.getActionCommand())) {
            return;
        }
        if (this.selectedIndex == this.comboAssessPeriod.getSelectedIndex()) {
            return;
        }
        this.selectedIndex = this.comboAssessPeriod.getSelectedIndex();
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.refreshList();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        SynSolutionPeriodInfo info = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)info.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)"%noeas%"));
        }
        return filter;
    }

    public void addNewWorkFlow_actionPerform() throws Exception {
    }

    public void copyWorkFlow_actionPerform() throws Exception {
        FilterItemInfo filterItem;
        if (PFVerifyUtils.objectIsNull(this.comboAssessPeriod.getSelectedItem())) {
            this.showErrorMessage("comboxSolutionPeriodNotNull");
        }
        if (this.comboAssessPeriod.getItemCount() < 2) {
            this.showErrorMessage("noEvalWorkflowCopy");
        }
        StringBuffer maskString = new StringBuffer();
        int index = 0;
        FilterInfo filter = new FilterInfo();
        maskString.append("( ");
        int n = this.comboAssessPeriod.getItemCount();
        for (int i = 0; i < n; ++i) {
            filterItem = new FilterItemInfo("solutionPeriod.id", (Object)((SynSolutionPeriodInfo)this.comboAssessPeriod.getItemAt(i)).getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            PFVerifyUtils.makeMaskString(maskString, index, " OR ");
            ++index;
        }
        maskString.append(" ) ");
        filterItem = new FilterItemInfo("solutionPeriod.id", (Object)((SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem()).getId().toString(), CompareType.NOTEQUALS);
        filter.getFilterItems().add(filterItem);
        PFVerifyUtils.makeMaskString(maskString, index, " AND ");
        ++index;
        filter.setMaskString(maskString.toString());
        if (!EvalWorkFlowFactory.getRemoteInstance().exists(filter)) {
            this.showErrorMessage("noEvalWorkflowCopy");
        }
        IUIFactory uiFactory = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"flag", (Object)this.getOprtState());
        uiContext.put((Object)"evaluSolutionID", (Object)this.evaluSolutionID);
        uiContext.put((Object)"solutionPeriod", this.comboAssessPeriod.getSelectedItem());
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(CopyEvaluWorkFlowOrgUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        this.refreshList();
    }

    public void deleteWorkFlow_actionPerform() throws Exception {
        this.checkSelected();
        SynSolutionPeriodInfo solutionPeriodInfo = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        if (!SolutionPeriodStatusEnum.UN_EVALU.equals((Object)solutionPeriodInfo.getStatus())) {
            this.showErrorMessage("inUseNotDelete");
        }
        if (this.confirmRemove()) {
            HashSet<Object> set = new HashSet<Object>();
            KDTSelectBlock sb = null;
            int size = this.tblMain.getSelectManager().size();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain.getSelectManager().get(i);
                int bottom = sb.getBottom();
                for (int j = sb.getTop(); j <= bottom; ++j) {
                    set.add(this.tblMain.getRow(j).getCell("id").getValue());
                }
            }
            ObjectUuidPK[] pks = new ObjectUuidPK[set.size()];
            int i = 0;
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                pks[i] = new ObjectUuidPK((String)iter.next());
                ++i;
            }
            SynEvaluFlowFactory.getRemoteInstance().delete((IObjectPK[])pks);
            String message = EASResource.getString((String)RES, (String)"recordsDeleteSuccess");
            Object[] variables = new Object[]{new Integer(pks.length)};
            String output = MessageFormat.format(message, variables);
            MsgBox.showInfo((Component)((Object)this), (String)output);
            this.refreshList();
        }
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)RES, (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }

    @Override
    public void secondLoad() throws Exception {
    }

    @Override
    public void submit() throws Exception {
    }

    @Override
    public void verifyInput() throws Exception {
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            rowSet.beforeFirst();
            String id = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("evaluNodes.*"));
            sic.add(new SelectorItemInfo("concurArgs.*"));
            ISynEvaluFlow isef = SynEvaluFlowFactory.getRemoteInstance();
            StringBuffer[] stringBuffers = null;
            StringBuffer strBuffer = null;
            while (rowSet.next()) {
                id = rowSet.getString("id");
                SynEvaluFlowInfo wfInfo = isef.getSynEvaluFlowInfo((IObjectPK)new ObjectUuidPK(id), sic);
                stringBuffers = SynWorkFlowToString.convertEvalWorkFlowToString(wfInfo);
                strBuffer = new StringBuffer();
                int m = stringBuffers.length;
                for (int j = 0; j < m; ++j) {
                    strBuffer.append(stringBuffers[j].toString());
                    if (j >= m - 1) continue;
                    strBuffer.append("\n");
                }
                rowSet.updateString("solutionPeriod.description", strBuffer.toString());
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }
}

