/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SynEvaluFlowCollection;
import com.kingdee.eas.hr.perf.SynEvaluFlowFactory;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynEvaluItemFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.hr.perf.SynSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractSynFlowUI;
import com.kingdee.eas.hr.perf.client.ESTargetEvaluWorkFlowUI;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.SynCopyWorkFlowUI;
import com.kingdee.eas.hr.perf.client.SynEvaluObjectForFlowUI;
import com.kingdee.eas.hr.perf.client.SynSolutionHelper;
import com.kingdee.eas.hr.perf.client.SynViewWorkFlowUI;
import com.kingdee.eas.hr.perf.client.SynWorkFlowDefineSchWizardUI;
import com.kingdee.eas.hr.perf.client.SynWorkFlowToString;
import com.kingdee.eas.hr.perf.client.ViewSynFlowUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynFlowUI
extends AbstractSynFlowUI
implements IMultiDimentionSolutionUI {
    private static final long serialVersionUID = -61166L;
    private static final Logger logger = CoreUIObject.getLogger(ESTargetEvaluWorkFlowUI.class);
    String evaluSolutionID;
    String NUMBER = "number";
    String NAME = "name";
    String WEIGHT = "nodeWeight";
    String ID = "id";
    HashMap evaluWorkFlowMap = null;
    private String RES = "com.kingdee.eas.hr.perf.client.NodeProcesserResource";

    public SynFlowUI() throws Exception {
        this.workflowTable.checkParsed();
        this.workflowTable.getSelectManager().setSelectMode(2);
        this.workflowTable.getSelectManager().setSelectMode(10);
        this.workflowTable.getStyleAttributes().setWrapText(true);
        this.workflowTable.getIndexColumn().setWidthAdjustMode((short)0);
        this.comboAssessPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SynFlowUI.this.comboAssessPeriod_itemStateChanged(e);
                }
                catch (Exception e1) {
                    SynFlowUI.this.handUIException(e1);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.evaluSolutionID = (String)this.getUIContext().get("ID");
        this.initSolutionPeriod();
    }

    private void initSolutionPeriod() throws BOSException, Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solution.id", (Object)this.evaluSolutionID);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        SorterItemInfo sorterItem = new SorterItemInfo("createTime");
        sorterItem.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItem);
        SynSolutionPeriodCollection solutionPeriodCollection = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodCollection(viewInfo);
        SynSolutionPeriodInfo oldSolutionPeriodInfo = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        this.comboAssessPeriod.setActionCommand("INIT");
        this.comboAssessPeriod.removeAllItems();
        this.comboAssessPeriod.addItems(solutionPeriodCollection.toArray());
        if (this.comboAssessPeriod.getItemCount() > 0) {
            this.comboAssessPeriod.setSelectedIndex(0);
            if (oldSolutionPeriodInfo != null) {
                int n = this.comboAssessPeriod.getItemCount();
                for (int i = 0; i < n; ++i) {
                    if (!((SynSolutionPeriodInfo)this.comboAssessPeriod.getItemAt(i)).getId().equals((Object)oldSolutionPeriodInfo.getId())) continue;
                    this.comboAssessPeriod.setSelectedIndex(i);
                    break;
                }
            }
        } else {
            this.comboAssessPeriod.setSelectedItem(null);
        }
        if (this.comboAssessPeriod.getSelectedItem() == null || oldSolutionPeriodInfo == null || !((SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem()).getId().equals((Object)oldSolutionPeriodInfo.getId())) {
            this.executeQuery(this.workflowTable, (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem());
        }
        this.comboAssessPeriod.setActionCommand(null);
        SynSolutionPeriodInfo spInfo = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        if (!PFVerifyUtils.objectIsNull(spInfo)) {
            this.initUIStatus(spInfo.getStatus());
        } else {
            this.initUIStatus(null);
        }
    }

    public void initUIStatus(SolutionPeriodStatusEnum status) {
        Container toolBar = (Container)this.getUIContext().get("TOOLBAR");
        String state = this.getOprtState();
        if (OprtState.VIEW.equals(state)) {
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnFlowObject_Flow", "btnViewFlow_Flow", "btnFlowInfo_Flow"}, false, true);
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnCopyFlow_Flow", "btnAddFlow_Flow", "btnEditFlow_Flow", "btnDelFlow_Flow", "btnAddObjectToFlow"}, false, false);
        } else if (SolutionPeriodStatusEnum.UN_EVALU.equals((Object)status)) {
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnCopyFlow_Flow", "btnFlowObject_Flow", "btnAddFlow_Flow", "btnViewFlow_Flow", "btnFlowInfo_Flow", "btnEditFlow_Flow", "btnDelFlow_Flow"}, false, true);
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnEditFlow_Flow", "btnAddObjectToFlow"}, false, false);
        } else if (SolutionPeriodStatusEnum.ON_EVALU.equals((Object)status)) {
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnFlowObject_Flow", "btnViewFlow_Flow", "btnFlowInfo_Flow", "btnAddObjectToFlow"}, false, true);
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnCopyFlow_Flow", "btnAddFlow_Flow", "btnEditFlow_Flow", "btnDelFlow_Flow"}, false, false);
        } else if (SolutionPeriodStatusEnum.END_EVALU.equals((Object)status)) {
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnFlowObject_Flow", "btnViewFlow_Flow", "btnFlowInfo_Flow"}, false, true);
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnCopyFlow_Flow", "btnAddFlow_Flow", "btnEditFlow_Flow", "btnDelFlow_Flow", "btnAddObjectToFlow"}, false, false);
        } else {
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnViewFlow_Flow", "btnFlowInfo_Flow"}, false, false);
            SynSolutionHelper.setEnabled(toolBar, new String[]{"btnCopyFlow_Flow", "btnFlowObject_Flow", "btnAddFlow_Flow", "btnEditFlow_Flow", "btnDelFlow_Flow", "btnAddObjectToFlow"}, false, false);
        }
    }

    public void comboAssessPeriod_itemStateChanged(ActionEvent e) throws Exception {
        if ("INIT".equals(this.comboAssessPeriod.getActionCommand())) {
            return;
        }
        SynSolutionPeriodInfo solutionPeriodInfo = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        this.executeQuery(this.workflowTable, solutionPeriodInfo);
    }

    public void addNewWorkFlow_actionPerform() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)this.evaluSolutionID));
        Map map = SynEvaluItemFactory.getRemoteInstance().checkAddFlow(this.evaluSolutionID);
        if (map.get("evaluItem") == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RES, (String)"plzAddEvaluItem"));
            SysUtil.abort();
        }
        if (map.get("evaluObject") == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.NodeProcesserResource", (String)"evaluSolutionNoevaluObject"));
            SysUtil.abort();
        }
        if (PFVerifyUtils.objectIsNull(this.comboAssessPeriod.getSelectedItem())) {
            this.showErrorMessage("comboxSolutionPeriodNotNull");
        }
        String solutionPeriodID = ((SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem()).getId().toString();
        boolean over = SynSolutionFacadeFactory.getRemoteInstance().isAllEvaluObjectInFlow(this.evaluSolutionID, solutionPeriodID);
        if (over) {
            this.showErrorMessage("noevaluObject");
        }
        IUIFactory uiFactory = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", this.comboAssessPeriod.getSelectedItem());
        uiContext.put((Object)"solutionID", (Object)this.evaluSolutionID);
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(SynWorkFlowDefineSchWizardUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        this.executeQuery(this.workflowTable, (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem());
    }

    private void executeQuery(KDTable table, SynSolutionPeriodInfo solutionPeriodInfo) throws Exception {
        SynSolutionPeriodInfo spInfo;
        table.removeRows();
        if (solutionPeriodInfo == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodInfo.getId().toString());
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("wfLevels"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurrenceLevels"));
        viewInfo.getSelector().add(new SelectorItemInfo("workFlowID"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.nodeName"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.seqNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.weight"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.canComment"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.canGrade"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.canEvaluateLevel"));
        viewInfo.getSelector().add(new SelectorItemInfo("evaluNodes.nodeLevel"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurArgs.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurArgs.count"));
        viewInfo.getSelector().add(new SelectorItemInfo("concurArgs.concurrenceLevel"));
        SynEvaluFlowCollection evalWorkFlowCollection = SynEvaluFlowFactory.getRemoteInstance().getSynEvaluFlowCollection(viewInfo);
        this.evaluWorkFlowMap = new HashMap();
        int n = evalWorkFlowCollection.size();
        for (int i = 0; i < n; ++i) {
            IRow row = table.addRow();
            SynEvaluFlowInfo evalWorkFlowInfo = evalWorkFlowCollection.get(i);
            row.getCell(this.ID).setValue((Object)evalWorkFlowInfo.getId());
            row.getCell(this.NUMBER).setValue((Object)evalWorkFlowInfo.getNumber());
            row.getCell(this.NAME).setValue((Object)evalWorkFlowInfo.getName());
            StringBuffer[] stringBuffers = SynWorkFlowToString.convertEvalWorkFlowToString(evalWorkFlowInfo);
            int width = 7 * stringBuffers[0].toString().getBytes().length;
            if (table.getColumn(this.WEIGHT).getWidth() < width) {
                table.getColumn(this.WEIGHT).setWidth(width);
            }
            row.setHeight(stringBuffers.length * 19);
            StringBuffer strBuffer = new StringBuffer();
            int m = stringBuffers.length;
            for (int j = 0; j < m; ++j) {
                strBuffer.append(stringBuffers[j].toString());
                if (j >= m - 1) continue;
                strBuffer.append("\n");
            }
            this.evaluWorkFlowMap.put(new Integer(row.getRowIndex()), evalWorkFlowInfo);
            row.getCell(this.WEIGHT).setValue((Object)strBuffer.toString());
            row.getStyleAttributes().setLocked(true);
        }
        if (table.getRowCount() > 0) {
            table.getSelectManager().select(0, 0);
        }
        if (!PFVerifyUtils.objectIsNull(spInfo = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem())) {
            this.initUIStatus(spInfo.getStatus());
        } else {
            this.initUIStatus(null);
        }
    }

    public void modifyWorkFlow_actionPerform() throws Exception {
    }

    public void viewWorkFlowDetail_actionPerform() throws Exception {
        int top;
        if (this.workflowTable.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelected");
        }
        if (this.workflowTable.getRow(top = this.workflowTable.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelected");
        }
        IRow row = this.workflowTable.getRow(top);
        String wfInfoID = row.getCell(this.ID).getValue().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)wfInfoID));
        if (!SynEvaluFlowFactory.getRemoteInstance().exists(filter)) {
            this.showErrorMessage("evalWorkFlowNotNull");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"flowID", (Object)wfInfoID);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ViewSynFlowUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    public void modifyWorkFlowEvaluObject_actionPerform() throws Exception {
    }

    public void deleteWorkFlow_actionPerform() throws Exception {
        int top;
        SynSolutionPeriodInfo solutionPeriodInfo = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        if (this.workflowTable.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelectedRecord");
        }
        if (this.workflowTable.getRow(top = this.workflowTable.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelectedRecord");
        }
        if (!SolutionPeriodStatusEnum.UN_EVALU.equals((Object)solutionPeriodInfo.getStatus())) {
            this.showErrorMessage("inUseNotDelete");
        }
        if (this.confirmRemove()) {
            ArrayList<Object> list = new ArrayList<Object>();
            KDTSelectBlock sb = null;
            int size = this.workflowTable.getSelectManager().size();
            for (int i = 0; i < size; ++i) {
                sb = this.workflowTable.getSelectManager().get(i);
                int bottom = sb.getBottom();
                for (int j = sb.getTop(); j <= bottom; ++j) {
                    list.add(this.workflowTable.getRow(j).getCell(this.ID).getValue());
                }
            }
            ObjectUuidPK[] pks = new ObjectUuidPK[list.size()];
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                pks[i] = new ObjectUuidPK((BOSUuid)list.get(i));
            }
            SynEvaluFlowFactory.getRemoteInstance().delete((IObjectPK[])pks);
            String message = EASResource.getString((String)this.RES, (String)"recordsDeleteSuccess");
            Object[] variables = new Object[]{new Integer(pks.length)};
            String output = MessageFormat.format(message, variables);
            MsgBox.showInfo((Component)((Object)this), (String)output);
            this.executeQuery(this.workflowTable, solutionPeriodInfo);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public void copyWorkFlow_actionPerform() throws Exception {
        FilterItemInfo filterItem;
        if (PFVerifyUtils.objectIsNull(this.comboAssessPeriod.getSelectedItem())) {
            this.showErrorMessage("comboxSolutionPeriodNotNull");
        }
        if (this.comboAssessPeriod.getItemCount() <= 1) {
            this.showErrorMessage("noEvalWorkflowCopy");
        }
        StringBuffer maskString = new StringBuffer();
        int index = 0;
        FilterInfo filter = new FilterInfo();
        maskString.append("( ");
        int n = this.comboAssessPeriod.getItemCount();
        for (int i = 0; i < n; ++i) {
            filterItem = new FilterItemInfo("solutionPeriod.id", (Object)((SynSolutionPeriodInfo)this.comboAssessPeriod.getItemAt(i)).getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            PFVerifyUtils.makeMaskString(maskString, index, " OR ");
            ++index;
        }
        maskString.append(" ) ");
        filterItem = new FilterItemInfo("solutionPeriod.id", (Object)((SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem()).getId().toString(), CompareType.NOTEQUALS);
        filter.getFilterItems().add(filterItem);
        PFVerifyUtils.makeMaskString(maskString, index, " AND ");
        ++index;
        filter.setMaskString(maskString.toString());
        if (!SynEvaluFlowFactory.getRemoteInstance().exists(filter)) {
            this.showErrorMessage("noEvalWorkflowCopy");
        }
        IUIFactory uiFactory = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"flag", (Object)this.getOprtState());
        uiContext.put((Object)"evaluSolutionID", (Object)this.evaluSolutionID);
        uiContext.put((Object)"solutionPeriod", this.comboAssessPeriod.getSelectedItem());
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(SynCopyWorkFlowUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        this.executeQuery(this.workflowTable, (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem());
    }

    public void viewEvaluObject_actionPerform() throws Exception {
        int top;
        if (this.workflowTable.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelected");
        }
        if (this.workflowTable.getRow(top = this.workflowTable.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelected");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", this.comboAssessPeriod.getSelectedItem());
        uiContext.put((Object)"evalWorkFlowID", (Object)this.workflowTable.getRow(top).getCell(this.ID).getValue().toString());
        uiContext.put((Object)"view", (Object)this.getOprtState());
        SynSolutionPeriodInfo solutionPeriodInfo = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        if (!SolutionPeriodStatusEnum.UN_EVALU.equals((Object)solutionPeriodInfo.getStatus())) {
            uiContext.put((Object)"view", (Object)"view");
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(SynEvaluObjectForFlowUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        window.show();
    }

    @Override
    protected void workflowTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.workflowTable_tableClicked(e);
        if (e.getClickCount() == 2 && e.getRowIndex() >= 0) {
            if (PFVerifyUtils.objectIsNull(this.evaluWorkFlowMap.get(new Integer(e.getRowIndex())))) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"evalWorkFlowInfo", this.evaluWorkFlowMap.get(new Integer(e.getRowIndex())));
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(SynViewWorkFlowUI.class.getName(), (Map)uiContext, null, null);
            window.show();
        }
    }

    public void viewProcess_actionPerform() throws Exception {
        int top;
        if (this.workflowTable.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelected");
        }
        if (this.workflowTable.getRow(top = this.workflowTable.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelected");
        }
        if (PFVerifyUtils.objectIsNull(this.evaluWorkFlowMap.get(new Integer(top)))) {
            return;
        }
        SynEvaluFlowInfo info = (SynEvaluFlowInfo)this.evaluWorkFlowMap.get(new Integer(top));
        PFVerifyUtils.showWorkFlowDef((CoreUIObject)this, info.getWorkFlowID().toString());
    }

    @Override
    public void secondLoad() throws Exception {
        LoadThread loadThread = new LoadThread();
        loadThread.start();
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)this.RES, (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }

    public void addObjectToFlow() {
        PFUtils.checkSelected((Component)((Object)this), this.workflowTable);
        SynSolutionPeriodInfo currentSynSolutionPeriod = (SynSolutionPeriodInfo)this.comboAssessPeriod.getSelectedItem();
        if (currentSynSolutionPeriod == null) {
            return;
        }
        KDCommonPromptDialog dlg = new KDCommonPromptDialog();
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app", "SynUntouchObjectQuery");
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        dlg.setQueryInfo(queryInfo);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        StringBuffer sb = new StringBuffer();
        sb.append("select FEvaluObjectID from T_PF_SynFlowObject where FEvalWorkFlowID in ( ");
        sb.append(" select fid from T_PF_SynEvaluFlow where FSolutionPeriodID = '");
        sb.append(currentSynSolutionPeriod.getId().toString());
        sb.append("')");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.NOTINNER));
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)this.evaluSolutionID));
        filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        dlg.setEntityViewInfo(evi);
        dlg.setEnabledMultiSelection(true);
        dlg.show();
        if (dlg.isCanceled()) {
            return;
        }
        Object[] obj = (Object[])dlg.getData();
        String[] ids = new String[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ids[i] = ((SynEvaluObjectInfo)obj[i]).getId().toString();
        }
        String flowID = this.workflowTable.getRow(PFUtils.getSelectedRow(this.workflowTable)).getCell("id").getValue().toString();
        try {
            SynSolutionFactory.getRemoteInstance().addObjectToFlow(ids, flowID, currentSynSolutionPeriod.getId().toString());
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"addOK"));
    }

    @Override
    public void submit() throws Exception {
    }

    @Override
    public void verifyInput() throws Exception {
    }

    private class LoadThread
    extends Thread {
        private LoadThread() {
        }

        @Override
        public void run() {
            try {
                SynFlowUI.this.initSolutionPeriod();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }
}

