/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.perf.ISynSolutionPeriod;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.SynBaseInfoUI;
import com.kingdee.eas.hr.perf.client.SynEvaluItemUI;
import com.kingdee.eas.hr.perf.client.SynEvaluObjectListUI;
import com.kingdee.eas.hr.perf.client.SynFlowUI;
import com.kingdee.eas.hr.perf.client.SynSolutionPeriodListUI;
import java.awt.Component;
import java.awt.Container;
import java.util.HashSet;

public class SynSolutionHelper {
    public static final int BASEINFO_PANEL_INDEX = 0;
    public static final String TABINDEX = "TABINDEX";
    public static final int KDTABINDEX_BASEINFO = 0;
    public static final int KDTABINDEX_EVALUITEM = 1;
    public static final int KDTABINDEX_EVALUOBJECT = 2;
    public static final int KDTABINDEX_ASSESSPERIOD = 3;
    public static final int KDTABINDEX_FLOW = 4;
    public static final String TOOLBAR = "TOOLBAR";
    public static final String TBPMAIN = "TBPMAIN";
    public static final String CURRENT_INDEX = "CURRENT_INDEX";
    public static final String MAIN_FRAME = "MAIN_FRAME";
    public static final int DEFAULT_UIOBJ_WIDTH = 730;
    public static final int DEFAULT_UIOBJ_HEIGHT = 450;
    public static final String ESID = "EvaluSolutionID";

    public static String getUIClassName(int tabIndex) {
        switch (tabIndex) {
            case 0: {
                return SynBaseInfoUI.class.getName();
            }
            case 1: {
                return SynEvaluItemUI.class.getName();
            }
            case 2: {
                return SynEvaluObjectListUI.class.getName();
            }
            case 3: {
                return SynSolutionPeriodListUI.class.getName();
            }
            case 4: {
                return SynFlowUI.class.getName();
            }
        }
        return null;
    }

    public static boolean checkPeriodHasBeenUsed(String assessPeriodId, String evaluSolutionId, String editDataID) throws Exception {
        if (evaluSolutionId == null || assessPeriodId == null) {
            return false;
        }
        ISynSolutionPeriod solutionPeriod = SynSolutionPeriodFactory.getRemoteInstance();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)assessPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("solution.id", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)editDataID, CompareType.NOTEQUALS));
        return solutionPeriod.exists(fi);
    }

    public static void setEnabled(Container container, boolean isEnabled) {
        SynSolutionHelper.setEnabled(container, null, true, isEnabled);
    }

    public static void setEnabled(Container container, String[] componentNames, boolean expected, boolean isEnabled) {
        int size = -1;
        boolean flag = false;
        if (container instanceof KDToolBar) {
            size = ((KDToolBar)container).getToolBarComponentCount();
            flag = true;
        } else {
            size = container.getComponentCount();
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; componentNames != null && i < componentNames.length; ++i) {
            set.add(componentNames[i]);
        }
        Component c = null;
        for (int i = 0; i < size; ++i) {
            KDWorkButton workButton;
            c = flag ? ((KDToolBar)container).getToolBarComponentAt(i) : container.getComponent(i);
            if (c == null) continue;
            if (expected) {
                if (!set.contains(c.getName())) {
                    if (c instanceof KDWorkButton) {
                        workButton = (KDWorkButton)c;
                        if (workButton.getAction() != null) {
                            workButton.getAction().setEnabled(isEnabled);
                        } else {
                            workButton.setEnabled(isEnabled);
                        }
                    } else {
                        c.setEnabled(isEnabled);
                    }
                }
            } else if (set.contains(c.getName())) {
                if (c instanceof KDWorkButton) {
                    workButton = (KDWorkButton)c;
                    workButton.getAction().setEnabled(isEnabled);
                } else {
                    c.setEnabled(isEnabled);
                }
            }
            if (!(c instanceof KDWorkButton) || c.getName() != null) continue;
            c.setEnabled(true);
        }
    }

    public static SolutionPeriodStatusEnum getSolutionPeriodStatus(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return SolutionPeriodStatusEnum.UN_EVALU;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("status"));
        SynSolutionPeriodInfo solutionPeriodInfo = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        return solutionPeriodInfo.getStatus();
    }

    public static boolean isSolutionPeriodNeedASynchronize(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return false;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("solution.evaluMode", (Object)new Integer(10), CompareType.NOTEQUALS));
        return SynSolutionPeriodFactory.getRemoteInstance().exists(fi);
    }

    public static boolean isSolutionPeriodProcessing(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return false;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("transactionState", (Object)new Integer(10)));
        fi.getFilterItems().add(new FilterItemInfo("lastOperateTime", (Object)PerfUtils.getDateBefore(), CompareType.GREATER));
        return SynSolutionPeriodFactory.getRemoteInstance().exists(fi);
    }

    public static SolutionStatusEnum getEvaluSolutionStatus(String evaluSolutionId) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("status"));
        SynSolutionInfo info = SynSolutionFactory.getRemoteInstance().getSynSolutionInfo((IObjectPK)new ObjectUuidPK(evaluSolutionId), sic);
        return info.getStatus();
    }

    public static boolean isExistSolutionPeriodStartedOrEnded(String mdSolutionId) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)mdSolutionId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(100), CompareType.NOTEQUALS));
        return SynSolutionPeriodFactory.getRemoteInstance().exists(filter);
    }
}

