/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.SynEvaluResultFactory;
import com.kingdee.eas.hr.perf.SynSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.client.AbstractSynSolutionListUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.SynCopySolutionUI;
import com.kingdee.eas.hr.perf.client.SynSolutionQueryPanel;
import com.kingdee.eas.hr.perf.client.SynSolutionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynSolutionListUI
extends AbstractSynSolutionListUI {
    private static final Logger logger = CoreUIObject.getLogger(SynSolutionListUI.class);
    private static final long serialVersionUID = -61166L;
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private CommonQueryDialog queryDlg;
    private SynSolutionQueryPanel filterUI;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCloseSolution.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemCloseSolu.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnCopySolution.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        PerfClientUtils.checkValidHRO((CoreUI)this);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SynSolutionFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return SynSolutionUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return PFUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "orgUnit.id");
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            LinkedHashSet<String> idSet = new LinkedHashSet<String>();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
            rowSet.beforeFirst();
            Map map = SynSolutionFacadeFactory.getRemoteInstance().getAssessPeriodNames(idSet);
            while (rowSet.next()) {
                rowSet.updateString("description", (String)map.get(rowSet.getString("id")));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
    }

    private String getAssessPeriodNames(SynSolutionPeriodCollection synSolutionPeriodColl) {
        if (synSolutionPeriodColl == null) {
            return null;
        }
        AssessPeriodInfo assessPeriodInfo = null;
        StringBuffer sb = new StringBuffer();
        int size = synSolutionPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            assessPeriodInfo = synSolutionPeriodColl.get(i).getAssessPeriod();
            sb.append(assessPeriodInfo.getName());
            if (i == size - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        super.refresh(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status.getInt() == 102) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotEditSolution"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status.getInt() != 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotDelSolution"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    public void actionCopySolution_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"noSelected"));
            return;
        }
        SynSolutionInfo solution = SynSolutionFactory.getRemoteInstance().getSynSolutionInfo((IObjectPK)new ObjectUuidPK(id));
        if (!solution.getStatus().equals((Object)SolutionStatusEnum.ONUSED)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"noOnusedConntCopy"));
            return;
        }
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SynCopySolutionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refreshList();
    }

    @Override
    public void actionCloseSolution_actionPerformed(ActionEvent e) throws Exception {
        String id;
        this.checkSelected();
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmCloseEvaluSolution")))) {
            return;
        }
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
        if (status.getInt() == 100 || status.getInt() == 102) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotCloseSolution"));
            SysUtil.abort();
        }
        if (this.checkIfHaveSolutionPeriodOnEvalued(id = this.getSelectedKeyValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"HaveSolutionPeriodOnEvalued"));
            SysUtil.abort();
        }
        if (this.checkIfHaveEvaluResultUnChecked(id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"HaveEvaluResultUnChecked"));
            SysUtil.abort();
        }
        SynSolutionFactory.getRemoteInstance().closeSolution(id);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CloseSuccess"));
        this.refresh(e);
    }

    private boolean checkIfHaveSolutionPeriodOnEvalued(String id) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(101)));
        return SynSolutionPeriodFactory.getRemoteInstance().exists(filter);
    }

    private boolean checkIfHaveEvaluResultUnChecked(String id) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.solution.id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("isApproved", (Object)Boolean.FALSE));
        return SynEvaluResultFactory.getRemoteInstance().exists(filter);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        try {
            if (this.queryDlg != null) {
                return this.queryDlg;
            }
            this.queryDlg = new CommonQueryDialog();
            this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
            this.queryDlg.setHeight(350);
            this.queryDlg.setWidth(450);
            this.queryDlg.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDlg.setTitle(EASResource.getString((String)this.resourcePath, (String)"SynSolutionQuery"));
            this.queryDlg.setShowSorter(false);
            this.queryDlg.setUiObject((IUIObject)this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return this.queryDlg;
    }

    public SynSolutionQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SynSolutionQueryPanel();
        }
        return this.filterUI;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }
}

