/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractSynSolutionPeriodEditUI;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.SynSolutionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.STConverter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Locale;

public class SynSolutionPeriodEditUI
extends AbstractSynSolutionPeriodEditUI {
    private static final long serialVersionUID = -61166L;
    private String resourcePath = "com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIStatus();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(MDSolutionHelper.getDefaultFilterForQuery());
        this.prmtAssessPeriod.setEntityViewInfo(evi);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.prmtAssessPeriod.setEnabled(false);
            this.pkEvaluStartDate.setEnabled(false);
            this.pkEvaluEndDate.setEnabled(false);
            this.txtTitle.setEnabled(false);
            this.txtRemark.setEnabled(false);
        }
        if (this.editData != null && (this.editData.getStatus().equals((Object)SolutionPeriodStatusEnum.ON_EVALU) || this.editData.getStatus().equals((Object)SolutionPeriodStatusEnum.END_EVALU))) {
            this.btnEdit.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getUIContext().get("superOprtState"))) {
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
    }

    private void initUIStatus() {
        this.prmtAssessPeriod.setRequired(true);
        this.pkEvaluStartDate.setRequired(true);
        this.pkEvaluEndDate.setRequired(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtAssessPeriod.requestFocus(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.pkPeriodStrartDate.setValue(null);
            this.pkPeriodEndDate.setValue(null);
            this.pkEvaluStartDate.setValue(null);
            this.pkEvaluEndDate.setValue(null);
        }
    }

    @Override
    public void storeFields() {
        Date endDate;
        Date startDate;
        super.storeFields();
        StringBuffer sb = new StringBuffer();
        SynSolutionInfo evaluSolutionInfo = this.editData.getSolution();
        AssessPeriodInfo assessPeriod = this.editData.getAssessPeriod();
        if (assessPeriod != null) {
            sb.append(evaluSolutionInfo.getName());
            sb.append(" ");
            sb.append(MDSolutionHelper.getStartDate2EndDateString(assessPeriod.getStartDate(), assessPeriod.getEndDate()));
            Locale locale = PFUtils.getLocale();
            if (locale.equals(PFUtils.getSLocale())) {
                this.editData.setName(sb.toString(), locale);
                this.editData.setName(STConverter.sc2tc((String)sb.toString()), PFUtils.getTLocale());
            } else if (locale.equals(PFUtils.getTLocale())) {
                this.editData.setName(sb.toString(), locale);
                this.editData.setName(STConverter.tc2sc((String)sb.toString()), PFUtils.getSLocale());
            } else {
                this.editData.setName(sb.toString());
            }
        }
        if ((startDate = this.editData.getStartDate()) != null) {
            startDate = DateTimeUtils.truncateDate((Date)startDate);
            this.editData.setStartDate(startDate);
        }
        if ((endDate = this.editData.getEndDate()) != null) {
            endDate = DateTimeUtils.truncateDate((Date)endDate);
            this.editData.setEndDate(endDate);
        }
    }

    protected IObjectValue createNewData() {
        SynSolutionPeriodInfo solutionPeriodInfo = new SynSolutionPeriodInfo();
        solutionPeriodInfo.setStatus(SolutionPeriodStatusEnum.UN_EVALU);
        String solutionID = this.getUIContext().get("EvaluSolutionID").toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        SynSolutionInfo solution = null;
        try {
            solution = SynSolutionFactory.getRemoteInstance().getSynSolutionInfo((IObjectPK)new ObjectUuidPK(solutionID), sic);
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        solutionPeriodInfo.setSolution(solution);
        return solutionPeriodInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SynSolutionPeriodFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtAssessPeriod);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkEvaluStartDate);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkEvaluEndDate);
        PFVerifyUtils.verifyDateBigOrSmall((CoreUIObject)this, this.pkEvaluStartDate, this.pkEvaluEndDate);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtTitle);
        this.checkPeriodHasBeenUsed();
    }

    private void checkPeriodHasBeenUsed() throws Exception {
        AssessPeriodInfo assessPeriod = (AssessPeriodInfo)this.prmtAssessPeriod.getValue();
        String editdataID = null;
        if (this.editData.getId() != null) {
            editdataID = this.editData.getId().toString();
        }
        if (SynSolutionHelper.checkPeriodHasBeenUsed(assessPeriod.getId().toString(), (String)this.getUIContext().get("EvaluSolutionID"), editdataID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"PeriodHasBeenUsed"));
            SysUtil.abort();
        }
    }

    @Override
    protected void prmtAssessPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtAssessPeriod_dataChanged(e);
        AssessPeriodInfo assessPeriodInfo = (AssessPeriodInfo)this.prmtAssessPeriod.getData();
        if (assessPeriodInfo == null) {
            return;
        }
        Date startDate = assessPeriodInfo.getStartDate();
        Date endDate = assessPeriodInfo.getEndDate();
        this.pkPeriodStrartDate.setValue((Object)startDate);
        this.pkPeriodEndDate.setValue((Object)endDate);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("solution.name"));
        sic.add(new SelectorItemInfo("solution.id"));
        sic.add(new SelectorItemInfo("status"));
        return sic;
    }

    protected void lockUIForViewStatus() {
        this.prmtAssessPeriod.setEnabled(false);
        this.pkEvaluStartDate.setEnabled(false);
        this.pkEvaluEndDate.setEnabled(false);
        this.txtTitle.setEnabled(false);
        this.txtRemark.setEnabled(false);
    }

    protected void unLockUI() {
        super.unLockUI();
        this.prmtAssessPeriod.setEnabled(true);
        this.pkEvaluStartDate.setEnabled(true);
        this.pkEvaluEndDate.setEnabled(true);
        this.txtTitle.setEnabled(true);
        this.txtRemark.setEnabled(true);
    }

    protected void showSubmitSuccess() {
        super.showSubmitSuccess();
        this.setSave(true);
        this.setSaved(true);
        super.initOldData((IObjectValue)this.editData);
        this.getUIWindow().close();
    }
}

