/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.SynEvaluFlowFactory;
import com.kingdee.eas.hr.perf.SynFlowObjectFactory;
import com.kingdee.eas.hr.perf.SynSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.client.AbstractSynSolutionPeriodListUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.MDSolutionPeriodResetUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.perf.client.SynSolutionHelper;
import com.kingdee.eas.hr.perf.client.SynSolutionPeriodEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import javax.swing.SwingUtilities;

public class SynSolutionPeriodListUI
extends AbstractSynSolutionPeriodListUI
implements IMultiDimentionSolutionUI {
    private static final long serialVersionUID = -61166L;
    private String resourcePath = "com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource";
    private String evaluSolutionId;
    private Container parentToolBar;

    public void onLoad() throws Exception {
        this.parentToolBar = (Container)this.getUIContext().get("TOOLBAR");
        super.onLoad();
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        this.setDataObject(this.getEntityViewInfo());
        this.setUIStatusByView();
    }

    private void setUIStatusByView() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            String[] workButtons = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            SynSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, false);
        }
    }

    private IObjectValue getEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solution.id", (Object)this.evaluSolutionId));
        evi.setFilter(fi);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItemInfo);
        return evi;
    }

    protected String getEditUIName() {
        return SynSolutionPeriodEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SynSolutionPeriodFactory.getRemoteInstance();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put("EvaluSolutionID", this.evaluSolutionId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmDelSolutionPeriod")));
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.VIEW, e);
    }

    private void dealEditUI(String oprtState, ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext();
        uiContext.put("EvaluSolutionID", this.evaluSolutionId);
        uiContext.put("ID", this.getSelectedKeyValue());
        uiContext.put("superOprtState", this.getOprtState());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.EDIT, e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (SynSolutionHelper.getEvaluSolutionStatus(this.evaluSolutionId).equals((Object)SolutionStatusEnum.CLOSED)) {
            Container toolBar = (Container)this.getUIContext().get("TOOLBAR");
            String[] workButtons = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            SynSolutionHelper.setEnabled(toolBar, workButtons, false, false);
        } else {
            this.changeWorkButtonStatus();
        }
    }

    private void changeWorkButtonStatus() {
        String[] workButtonsEnabled;
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        if (row.getCell("status").getValue() == null) {
            return;
        }
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        Container toolBar = (Container)this.getUIContext().get("TOOLBAR");
        if (status.getInt() == 100) {
            String[] workButtonsUnEnabled = new String[]{"btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod"};
            SynSolutionHelper.setEnabled(toolBar, workButtonsUnEnabled, false, false);
            String[] workButtonsEnabled2 = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            SynSolutionHelper.setEnabled(toolBar, workButtonsEnabled2, false, true);
        }
        if (status.getInt() == 102) {
            workButtonsEnabled = new String[]{"btnAddAssessPeriod_AssessPeriod"};
            SynSolutionHelper.setEnabled(toolBar, workButtonsEnabled, false, true);
            String[] workButtonsUnEnable = new String[]{"btnResetAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            SynSolutionHelper.setEnabled(toolBar, workButtonsUnEnable, false, false);
        }
        if (status.getInt() == 101) {
            workButtonsEnabled = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod"};
            SynSolutionHelper.setEnabled(toolBar, workButtonsEnabled, false, true);
            String[] workButtonsUnEnabled = new String[]{"btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            SynSolutionHelper.setEnabled(toolBar, workButtonsUnEnabled, false, false);
        }
        this.setUIStatusByView();
    }

    public void finishSolutionPeriod() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        final String solutionPeriodID = this.getSelectedKeyValue();
        SolutionPeriodStatusEnum status = SynSolutionHelper.getSolutionPeriodStatus(solutionPeriodID);
        if (status.getValue() == 102 || status.getValue() == 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotFinishSolutionPeriod"));
            SysUtil.abort();
        }
        if (this.checkIfAllObjectHaveFinishFlow(solutionPeriodID)) {
            if (this.confirmFinishSolutionPeriod()) {
                IProgTask prog = new IProgTask(){

                    @Override
                    public Object exec() throws Exception {
                        SynSolutionFacadeFactory.getRemoteInstance().finishSolutionPeriod(solutionPeriodID);
                        SynSolutionPeriodListUI.this.refreshList();
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                        MsgBox.showInfo((String)EASResource.getString((String)SynSolutionPeriodListUI.this.resourcePath, (String)"FinishSuccess"));
                    }
                };
                ProgDialog dialog = null;
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                if (win instanceof Frame) {
                    dialog = new ProgDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new ProgDialog((Dialog)win);
                }
                dialog.setLongTimeTask(prog);
                dialog.show();
            }
        } else {
            IProgTask prog = new IProgTask(){

                @Override
                public Object exec() throws Exception {
                    SynSolutionFacadeFactory.getRemoteInstance().finishSolutionPeriod(solutionPeriodID);
                    SynSolutionPeriodListUI.this.refreshList();
                    return "";
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    MsgBox.showInfo((String)EASResource.getString((String)SynSolutionPeriodListUI.this.resourcePath, (String)"FinishSuccess"));
                }
            };
            ProgDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(prog);
            dialog.show();
        }
    }

    private boolean checkIfAllObjectHaveFinishFlow(String solutionPeriodID) throws Exception {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID));
        fi.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(30), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.solution.evaluMode", (Object)new Integer(10), CompareType.NOTEQUALS));
        return SynFlowObjectFactory.getRemoteInstance().exists(fi);
    }

    public void resetSolutionPeriod() throws Exception {
        Date endDate;
        Date startDate;
        boolean isReset;
        this.checkSelected();
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        final String solutionPeriodID = this.tblMain.getRow(selectedRow).getCell("id").getValue().toString();
        if (solutionPeriodID == null) {
            return;
        }
        SolutionPeriodStatusEnum status = SynSolutionHelper.getSolutionPeriodStatus(solutionPeriodID);
        if (status.getValue() == 102 || status.getValue() == 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotResetSolutionPeriod"));
            SysUtil.abort();
        }
        if (this.confirmResetSolutionPeriod() && (isReset = MDSolutionPeriodResetUI.showDialogWindows((IUIObject)this, startDate = (Date)this.tblMain.getRow(selectedRow).getCell("assessPeriod.startDate").getValue(), endDate = (Date)this.tblMain.getRow(selectedRow).getCell("assessPeriod.endDate").getValue()))) {
            IProgTask prog = new IProgTask(){

                @Override
                public Object exec() throws Exception {
                    SynSolutionFacadeFactory.getRemoteInstance().resetSolutionPeriod(solutionPeriodID);
                    SynSolutionPeriodListUI.this.refreshList();
                    return "";
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    MsgBox.showInfo((String)EASResource.getString((String)SynSolutionPeriodListUI.this.resourcePath, (String)"ResetSuccess"));
                }
            };
            ProgDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            }
            dialog.setLongTimeTask(prog);
            dialog.show();
        }
    }

    public void startSolutionPeriod() throws Exception {
        this.checkSelected();
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
        final String solutionPeriodID = this.getSelectedKeyValue();
        if (status.getInt() == 102 || status.getInt() == 101) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotStartSolutionPeriod"));
            SysUtil.abort();
        }
        if (this.checkIfExistSolutionPeriodOnUsed()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ExistSolutionPeriodOnUsed"));
            SysUtil.abort();
        }
        if (!this.checkIfExistEvaluFlow(solutionPeriodID)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NotExistEvaluFlow"));
            SysUtil.abort();
        }
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                SynWorkFlowFacadeFactory.getRemoteInstance().startSolutionPeriod(BOSUuid.read((String)solutionPeriodID));
                SynSolutionPeriodListUI.this.setUIStatus(true, EvaluSolutionHelper.isExistSolutionPeriodEnded(SynSolutionPeriodListUI.this.evaluSolutionId));
                SynSolutionPeriodListUI.this.refresh(null);
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((String)EASResource.getString((String)SynSolutionPeriodListUI.this.resourcePath, (String)"StartSuccess"));
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    private boolean confirmResetSolutionPeriod() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmResetSolutionPeriod")));
    }

    private boolean confirmFinishSolutionPeriod() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmFinishSolutionPeriod")));
    }

    private boolean checkIfExistSolutionPeriodOnUsed() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solution.id", (Object)this.evaluSolutionId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(101)));
        return SynSolutionPeriodFactory.getRemoteInstance().exists(filter);
    }

    private boolean checkIfExistEvaluFlow(String solutionPeriodID) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        return SynEvaluFlowFactory.getRemoteInstance().exists(filter);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.refreshList();
    }

    @Override
    public void secondLoad() throws Exception {
        this.refreshList();
    }

    @Override
    public void submit() throws Exception {
    }

    @Override
    public void verifyInput() throws Exception {
    }

    private void setUIStatus(boolean isSolutionPeriodStarted, boolean isSolutionPeriodEnded) {
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }
}

