/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.AbstractSynSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.SynConcArgsCollection;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynFlowNodeCollection;
import com.kingdee.eas.hr.perf.SynFlowNodeInfo;
import com.kingdee.eas.hr.perf.SynNodeEvaluItemCollection;
import com.kingdee.eas.hr.perf.SynNodeEvaluItemInfo;
import com.kingdee.eas.hr.perf.SynSolutionFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractSynWorkFlowConfirmPropsUI;
import com.kingdee.eas.hr.perf.client.ViewSynEvaluObjectUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Map;

public class SynWorkFlowConfirmPropsUI
extends AbstractSynWorkFlowConfirmPropsUI {
    private static final long serialVersionUID = -61166L;
    private SynEvaluFlowInfo workFlowInfo = null;
    private static final String RES = "com.kingdee.eas.hr.perf.client.WorkFlowDefineResource";

    public void initViewUI(SynEvaluFlowInfo wfInfo) {
        SynSolutionPeriodInfo info = wfInfo.getSolutionPeriod();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("inputMode"));
        AbstractSynSolutionInfo solution = null;
        try {
            solution = SynSolutionFactory.getRemoteInstance().getSynSolutionInfo((IObjectPK)new ObjectUuidPK(info.getSolution().getId().toString()), sic);
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        EvaluModeEnum imputMode = solution.getInputMode();
        boolean isGrade = EvaluModeEnum.MANUAL_ENTER.equals((Object)imputMode);
        this.workFlowInfo = wfInfo;
        this.txtLevels.setText("" + wfInfo.getWfLevels());
        this.txtLevels.setEditable(false);
        this.txtConcs.setText("" + wfInfo.getConcurrenceLevels());
        this.txtConcs.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        SynFlowNodeInfo[] nodes = this.getSortedSynFlowNodes(wfInfo.getEvaluNodes());
        SynNodeEvaluItemInfo[] items = null;
        IRow row = null;
        SynConcArgsCollection concArgsColl = wfInfo.getConcurArgs();
        boolean flag = false;
        int count = 0;
        int level = -1;
        int itemCount = 0;
        StringBuffer stringBuffer = null;
        String binfa = EASResource.getString((String)RES, (String)"binfaLabel");
        for (int i = 0; i < nodes.length; ++i) {
            items = this.getSortedItems(nodes[i].getNodeEvaluItems());
            if (level != nodes[i].getNodeLevel()) {
                count = 0;
                level = nodes[i].getNodeLevel();
            }
            flag = false;
            int cSize = concArgsColl.size();
            for (int c = 0; c < cSize; ++c) {
                if (concArgsColl.get(c).getConcurrenceLevel() != level) continue;
                flag = true;
                break;
            }
            if (flag) {
                ++count;
            }
            itemCount = 0;
            for (int j = 0; j < items.length; ++j) {
                if (!items[j].isCanWrite()) continue;
                ++itemCount;
                row = this.tblMain.addRow();
                stringBuffer = new StringBuffer();
                stringBuffer.append(nodes[i].getLevelName());
                if (flag) {
                    stringBuffer.append("[");
                    stringBuffer.append(binfa);
                    stringBuffer.append(count);
                    stringBuffer.append("]");
                }
                stringBuffer.append(" : ");
                stringBuffer.append(nodes[i].getNodeName());
                row.getCell("name").setValue((Object)stringBuffer.toString());
                row.getCell("writeComm").setValue((Object)new Boolean(nodes[i].isCanComment()));
                row.getCell("grade").setValue((Object)new Boolean(nodes[i].isCanGrade()));
                row.getCell("rank").setValue((Object)new Boolean(nodes[i].isCanEvaluateLevel()));
                row.getCell("evaluItem").setValue((Object)items[j].getEvaluItem().getContent());
            }
            if (itemCount != 0) continue;
            row = this.tblMain.addRow();
            stringBuffer = new StringBuffer();
            stringBuffer.append(nodes[i].getLevelName());
            if (flag) {
                stringBuffer.append("[");
                stringBuffer.append(binfa);
                stringBuffer.append(count);
                stringBuffer.append("]");
            }
            stringBuffer.append(" : ");
            stringBuffer.append(nodes[i].getNodeName());
            row.getCell("name").setValue((Object)stringBuffer.toString());
            row.getCell("writeComm").setValue((Object)new Boolean(nodes[i].isCanComment()));
            row.getCell("grade").setValue((Object)new Boolean(nodes[i].isCanGrade()));
            row.getCell("rank").setValue((Object)new Boolean(nodes[i].isCanEvaluateLevel()));
        }
        this.tblMain.getColumn("name").setGroup(true);
        this.tblMain.getColumn("writeComm").setGroup(true);
        this.tblMain.getColumn("grade").setGroup(true);
        this.tblMain.getColumn("rank").setGroup(true);
        this.tblMain.getColumn("evaluItem").setGroup(true);
        if (isGrade) {
            this.tblMain.getColumn("grade").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("rank").getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn("grade").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("rank").getStyleAttributes().setHided(false);
        }
        this.tblMain.getGroupManager().group();
    }

    private SynFlowNodeInfo[] getSortedSynFlowNodes(SynFlowNodeCollection nodes) {
        int i;
        SynFlowNodeInfo[] ret = new SynFlowNodeInfo[nodes.size()];
        int[] seqs = new int[nodes.size()];
        for (i = 0; i < seqs.length; ++i) {
            seqs[i] = nodes.get(i).getSeqNumber();
        }
        Arrays.sort(seqs);
        block1: for (i = 0; i < seqs.length; ++i) {
            int n = nodes.size();
            for (int j = 0; j < n; ++j) {
                if (seqs[i] != nodes.get(j).getSeqNumber()) continue;
                ret[i] = nodes.get(j);
                continue block1;
            }
        }
        return ret;
    }

    private SynNodeEvaluItemInfo[] getSortedItems(SynNodeEvaluItemCollection items) {
        int i;
        int size = items.size();
        SynNodeEvaluItemInfo[] ret = new SynNodeEvaluItemInfo[size];
        Object[] seqs = new String[size];
        for (i = 0; i < size; ++i) {
            seqs[i] = items.get(i).getEvaluItem().getNumber();
        }
        Arrays.sort(seqs);
        block1: for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (!((String)seqs[i]).equals(items.get(j).getEvaluItem().getNumber())) continue;
                ret[i] = items.get(j);
                continue block1;
            }
        }
        return ret;
    }

    @Override
    protected void lblFlowObj_mouseClicked(MouseEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"workFlowInfo", (Object)this.workFlowInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ViewSynEvaluObjectUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        window.show();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initUserConfig() {
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }
}

