/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.hr.perf.ISynEvaluFlow;
import com.kingdee.eas.hr.perf.SynConcArgsCollection;
import com.kingdee.eas.hr.perf.SynConcArgsInfo;
import com.kingdee.eas.hr.perf.SynEvaluFlowFactory;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynFlowNodeInfo;
import com.kingdee.eas.hr.perf.SynWfParam;
import java.util.List;

public class SynWorkFlowToString {
    static String LT = "\u250c";
    static String LB = "\u2514";
    static String LC = "\u2502";
    static String RT = "\u2510";
    static String RB = "\u2518";
    static String RC = "\u2502";
    static String CL = "\u3014";
    static String CR = "\u3015";
    private static ISynEvaluFlow isef = null;

    public static StringBuffer[] convertEvalWorkFlowToString(String id) throws Exception {
        if (isef == null) {
            isef = SynEvaluFlowFactory.getRemoteInstance();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluNodes.*"));
        SynEvaluFlowInfo wfInfo = isef.getSynEvaluFlowInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return SynWorkFlowToString.convertEvalWorkFlowToString(wfInfo);
    }

    public static StringBuffer[] convertEvalWorkFlowToString(SynEvaluFlowInfo wfInfo) {
        int maxConcurrent = 1;
        int centerLevel = 1;
        int start = 0;
        SynConcArgsInfo conInfo = null;
        SynConcArgsCollection collection = wfInfo.getConcurArgs();
        int m = collection.size();
        for (int j = 0; j < m; ++j) {
            conInfo = collection.get(j);
            if (conInfo.getCount() <= maxConcurrent) continue;
            maxConcurrent = conInfo.getCount();
        }
        StringBuffer[] strBuffers = new StringBuffer[maxConcurrent];
        for (int i = 0; i < maxConcurrent; ++i) {
            strBuffers[i] = new StringBuffer();
        }
        centerLevel = maxConcurrent % 2 == 0 ? maxConcurrent / 2 : maxConcurrent / 2 + 1;
        SynWfParam wfParam = new SynWfParam();
        wfParam.setNodeCollection(wfInfo.getEvaluNodes());
        int n = wfInfo.getWfLevels();
        for (int i = 0; i < n; ++i) {
            List list = wfParam.getLevelNodes(i + 1);
            start = (maxConcurrent - list.size()) / 2;
            SynWorkFlowToString.convertLevelNodesToString(strBuffers, list, centerLevel, start);
            if (i >= n - 1) continue;
            strBuffers[centerLevel - 1].append("-->");
            SynWorkFlowToString.equalLenString(strBuffers);
        }
        return strBuffers;
    }

    private static void convertLevelNodesToString(StringBuffer[] strBuffers, List list, int center, int start) {
        if (list.size() == 1) {
            SynFlowNodeInfo nodeInfo = (SynFlowNodeInfo)list.get(0);
            strBuffers[center - 1].append(CL);
            SynWorkFlowToString.appendNodeInfo(nodeInfo, strBuffers[center - 1]);
            strBuffers[center - 1].append(CR);
        } else {
            SynFlowNodeInfo nodeInfo;
            int i;
            int n = list.size();
            for (i = 0; i < n; ++i) {
                nodeInfo = (SynFlowNodeInfo)list.get(i);
                if (i == 0) {
                    strBuffers[start + i].append(LT);
                } else if (i == list.size() - 1) {
                    strBuffers[start + i].append(LB);
                } else {
                    strBuffers[start + i].append(LC);
                }
                strBuffers[start + i].append(i + 1);
                strBuffers[start + i].append(".");
                SynWorkFlowToString.appendNodeInfo(nodeInfo, strBuffers[start + i]);
            }
            SynWorkFlowToString.equalLenString(strBuffers);
            n = list.size();
            for (i = 0; i < n; ++i) {
                nodeInfo = (SynFlowNodeInfo)list.get(i);
                if (i == 0) {
                    strBuffers[start + i].append(RT);
                    continue;
                }
                if (i == list.size() - 1) {
                    strBuffers[start + i].append(RB);
                    continue;
                }
                strBuffers[start + i].append(RC);
            }
        }
        SynWorkFlowToString.equalLenString(strBuffers);
    }

    private static void appendNodeInfo(SynFlowNodeInfo nodeInfo, StringBuffer strBuffer) {
        strBuffer.append(nodeInfo.getNodeName());
    }

    private static void equalLenString(StringBuffer[] strBuffers) {
        int i;
        int maxLen = 0;
        int[] lens = new int[strBuffers.length];
        int n = strBuffers.length;
        for (i = 0; i < n; ++i) {
            lens[i] = strBuffers[i].toString().getBytes().length;
            if (lens[i] <= maxLen) continue;
            maxLen = lens[i];
        }
        n = strBuffers.length;
        for (i = 0; i < n; ++i) {
            for (int j = lens[i]; j < maxLen; ++j) {
                strBuffers[i].append(" ");
            }
        }
    }

    public static StringBuffer[] convertEvalWorkFlowToStringForTextArea(SynEvaluFlowInfo wfInfo) {
        int maxConcurrent = 1;
        int centerLevel = 1;
        int start = 0;
        SynConcArgsInfo conInfo = null;
        SynConcArgsCollection collection = wfInfo.getConcurArgs();
        int m = collection.size();
        for (int j = 0; j < m; ++j) {
            conInfo = collection.get(j);
            if (conInfo.getCount() <= maxConcurrent) continue;
            maxConcurrent = conInfo.getCount();
        }
        StringBuffer[] strBuffers = new StringBuffer[maxConcurrent];
        StringBuffer[] tempBuffers = new StringBuffer[maxConcurrent];
        for (int i = 0; i < maxConcurrent; ++i) {
            strBuffers[i] = new StringBuffer();
            tempBuffers[i] = new StringBuffer();
        }
        centerLevel = maxConcurrent % 2 == 0 ? maxConcurrent / 2 : maxConcurrent / 2 + 1;
        SynWfParam wfParam = new SynWfParam();
        wfParam.setNodeCollection(wfInfo.getEvaluNodes());
        int n = wfInfo.getWfLevels();
        for (int i = 0; i < n; ++i) {
            int k;
            List list = wfParam.getLevelNodes(i + 1);
            start = (maxConcurrent - list.size()) / 2;
            SynWorkFlowToString.convertLevelNodesToStringForTextArea(tempBuffers, list, centerLevel, start);
            for (k = 0; k < maxConcurrent; ++k) {
                strBuffers[k].append(tempBuffers[k].toString());
                tempBuffers[k] = new StringBuffer();
            }
            if (i < n - 1) {
                tempBuffers[centerLevel - 1].append("-->");
                SynWorkFlowToString.equalLenStringForTextArea(tempBuffers);
            }
            for (k = 0; k < maxConcurrent; ++k) {
                strBuffers[k].append(tempBuffers[k].toString());
                tempBuffers[k] = new StringBuffer();
            }
        }
        return strBuffers;
    }

    private static void convertLevelNodesToStringForTextArea(StringBuffer[] strBuffers, List list, int center, int start) {
        SynFlowNodeInfo nodeInfo;
        int i;
        StringBuffer[] tempStrBuffer = new StringBuffer[strBuffers.length];
        int n = strBuffers.length;
        for (i = 0; i < n; ++i) {
            tempStrBuffer[i] = new StringBuffer();
        }
        if (list.size() == 1) {
            nodeInfo = (SynFlowNodeInfo)list.get(0);
            strBuffers[center - 1].append(CL);
            SynWorkFlowToString.appendNodeInfo(nodeInfo, strBuffers[center - 1]);
        } else {
            n = list.size();
            for (i = 0; i < n; ++i) {
                nodeInfo = (SynFlowNodeInfo)list.get(i);
                if (i == 0) {
                    strBuffers[start + i].append(LT);
                } else if (i == list.size() - 1) {
                    strBuffers[start + i].append(LB);
                } else {
                    strBuffers[start + i].append(LC);
                }
                strBuffers[start + i].append(i + 1);
                strBuffers[start + i].append(".");
                SynWorkFlowToString.appendNodeInfo(nodeInfo, strBuffers[start + i]);
            }
        }
        SynWorkFlowToString.equalLenStringForTextArea(strBuffers);
        if (list.size() == 1) {
            tempStrBuffer[center - 1].append(CR);
        } else {
            n = list.size();
            for (i = 0; i < n; ++i) {
                if (i == 0) {
                    tempStrBuffer[start + i].append(RT);
                    continue;
                }
                if (i == list.size() - 1) {
                    tempStrBuffer[start + i].append(RB);
                    continue;
                }
                tempStrBuffer[start + i].append(RC);
            }
        }
        SynWorkFlowToString.equalLenStringForTextArea(tempStrBuffer);
        for (int k = 0; k < strBuffers.length; ++k) {
            strBuffers[k].append(tempStrBuffer[k].toString());
        }
    }

    private static void equalLenStringForTextArea(StringBuffer[] strBuffers) {
        int i;
        int maxLen = 0;
        int[] lens = new int[strBuffers.length];
        int n = strBuffers.length;
        for (i = 0; i < n; ++i) {
            lens[i] = SynWorkFlowToString.countLength(strBuffers[i].toString());
            if (lens[i] <= maxLen) continue;
            maxLen = lens[i];
        }
        n = strBuffers.length;
        for (i = 0; i < n; ++i) {
            for (int j = lens[i]; j < maxLen; ++j) {
                strBuffers[i].append(" ");
            }
        }
    }

    private static int countLength(String str) {
        if (str == null) {
            return 0;
        }
        int charLen = 0;
        int varcharLen = 0;
        int len = 0;
        len = str.length();
        charLen = str.getBytes().length;
        varcharLen = charLen - len;
        return len + varcharLen;
    }
}

