/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluRuleInfo;
import com.kingdee.eas.hr.perf.EvaluRuleModeEnum;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetDelivererCollection;
import com.kingdee.eas.hr.perf.TargetDelivererInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentFactory;
import com.kingdee.eas.hr.perf.TargetStateEnum;
import com.kingdee.eas.hr.perf.client.AbstractTargetDeliverTrackListUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PersonalTargetEvaluStoreViewListUI;
import com.kingdee.eas.hr.perf.client.TargetDeliverTrackPersonHastenUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TargetDeliverTrackListUI
extends AbstractTargetDeliverTrackListUI {
    private static final Logger logger = CoreUIObject.getLogger(TargetDeliverTrackListUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private CommonQueryDialog queryDlg;
    private static final long serialVersionUID = -61166L;
    private static Pattern pattern = Pattern.compile("^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
    Matcher matcher = null;
    EvaluRuleInfo evaluRuleInfo = null;
    private Map evaluObjs = null;
    private Map sumTargetWeights = null;
    private String querySql = null;
    private IRowSet queryRowSet = null;

    public void onLoad() throws Exception {
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.tblMain.setColumnMoveable(true);
        this.initTargetStateComboBox();
        this.initComboBox();
        super.onLoad();
    }

    private void initComboBox() throws Exception {
        this.comboSolutionPeriod.setActionCommand("init");
        EvaluSolutionHelper.initHRSolutionPeriod(this.comboSolutionPeriod, null, EvaluSolutionTypeEnum.PERSON);
        if (this.comboSolutionPeriod.getItemCount() > 0) {
            this.comboSolutionPeriod.setSelectedIndex(0);
        }
        this.comboSolutionPeriod.setActionCommand(null);
    }

    private void initTargetStateComboBox() throws Exception {
        this.comboTargetState.setActionCommand("init");
        this.comboTargetState.addItems(TargetStateEnum.getEnumList().toArray());
        this.comboTargetState.setSelectedIndex(0);
        this.comboTargetState.setActionCommand(null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTargetDeliverHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.menuItemTargetDeliverHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.btnTargetView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.menuItemTargetView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnTargetDeliverAllHasten.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnTargetBuildedAllHasten.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.menuItemTargetDeliverAllHasten.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.menuItemTargetBuildedAllHasten.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
    }

    @Override
    protected void comboTargetState_actionPerformed(ActionEvent e) throws Exception {
        if ("init".equals(this.comboTargetState.getActionCommand())) {
            return;
        }
        this.comonActionQuery();
        super.comboTargetState_actionPerformed(e);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
            String solutionPeriodId = null;
            if (solutionPeriodInfo == null) {
                return;
            }
            solutionPeriodId = solutionPeriodInfo.getId().toString();
            HashSet<String> objectIds = new HashSet<String>();
            rowSet.beforeFirst();
            String id = null;
            this.btnTargetBuildedAllHasten.setEnabled(false);
            this.btnTargetDeliverAllHasten.setEnabled(false);
            this.menuItemTargetDeliverAllHasten.setEnabled(false);
            this.menuItemTargetBuildedAllHasten.setEnabled(false);
            while (rowSet.next()) {
                id = rowSet.getString("evaluObject.id");
                objectIds.add(id);
                if (TargetStateEnum.unSubmit.getAlias().equals(rowSet.getString("state"))) {
                    this.btnTargetBuildedAllHasten.setEnabled(true);
                    this.menuItemTargetBuildedAllHasten.setEnabled(true);
                }
                if (!TargetStateEnum.isSubmited.getAlias().equals(rowSet.getString("state"))) continue;
                this.btnTargetDeliverAllHasten.setEnabled(true);
                this.menuItemTargetDeliverAllHasten.setEnabled(true);
            }
            rowSet.beforeFirst();
            this.evaluRuleInfo = EvaluSolutionHelper.getEvaluRuleBySolutionPeriodId(solutionPeriodId);
            Map sumTargetWeight = EvaluSolutionHelper.getSumTargetWeightOrValue(solutionPeriodId, objectIds, this.evaluRuleInfo.getRuleMode());
            this.setTableStyle(this.evaluRuleInfo.getRuleMode());
            BigDecimal sumWeight = null;
            while (rowSet.next()) {
                id = rowSet.getString("evaluObject.id");
                sumWeight = sumTargetWeight != null && !sumTargetWeight.isEmpty() && sumTargetWeight.get(id) != null ? (BigDecimal)sumTargetWeight.get(id) : PerfClientUtils.ZERO;
                rowSet.updateBigDecimal("sumTargetWeight", sumWeight);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        if ("init".equals(this.comboSolutionPeriod.getActionCommand())) {
            return;
        }
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String cureQueryName = TargetDeliverTrackListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), cureQueryName);
        EntityViewInfo entityView = new EntityViewInfo();
        if (solution != null && solution.getEntityViewInfo() != null) {
            entityView = Util.getInnerFilterInfo((QuerySolutionInfo)solution);
        }
        this.mainQuery = super.getEntityViewInfo(entityView);
        if (this.evaluObjs != null && !this.evaluObjs.isEmpty()) {
            this.evaluObjs.clear();
        }
        if (this.sumTargetWeights != null && !this.sumTargetWeights.isEmpty()) {
            this.sumTargetWeights.clear();
        }
        this.comonActionQuery();
        this.queryRowSet = SQLExecutorFactory.getRemoteInstance((String)this.querySql).executeSQL();
    }

    private void setTableStyle(EvaluRuleModeEnum evaluRuleModeEnum) throws Exception {
        if (EvaluRuleModeEnum.SCORE_MODE.equals((Object)evaluRuleModeEnum)) {
            this.tblMain.getColumn("sumTargetWeight").getStyleAttributes().setNumberFormat("0.00");
        } else {
            this.tblMain.getColumn("sumTargetWeight").getStyleAttributes().setNumberFormat("0.00%");
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void actionTargetDeliverHasten_actionPerformed(ActionEvent e) throws Exception {
        this.actionSelectHasten_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        this.queryDlg = new CommonQueryDialog();
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setShowSorter(false);
        this.queryDlg.setTitle(EASResource.getString((String)RES, (String)"personTargetDeTrTitle"));
        this.queryDlg.setUiObject((IUIObject)this);
        return this.queryDlg;
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected FilterInfo getDefaultFilterForQuery() {
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        TargetStateEnum targetStateEnum = (TargetStateEnum)((Object)this.comboTargetState.getSelectedItem());
        FilterInfo returnFilterInfo = new FilterInfo();
        if (solutionPeriodInfo == null || targetStateEnum == null) {
            returnFilterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)""));
            return returnFilterInfo;
        }
        returnFilterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodInfo.getId().toString()));
        returnFilterInfo.getFilterItems().add(new FilterItemInfo("solutionDeliverd", (Object)Boolean.TRUE));
        if (!targetStateEnum.equals((Object)TargetStateEnum.ALL)) {
            returnFilterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(targetStateEnum.getValue())));
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", (Object)Boolean.FALSE));
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "adminOrgUnit.id"));
        filter2.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", null, CompareType.IS));
        filter2.setMaskString("#0 OR #1");
        try {
            fi.mergeFilter(returnFilterInfo, "and");
            fi.mergeFilter(filter2, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnFilterInfo;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        try {
            this.querySql = this.getSqlBySelectors(" \"EVALUOBJECT\".FID AS \"ID\" ", exec.getSQL());
            logger.info((Object)exec.getSQL());
        }
        catch (BOSException e) {
            // empty catch block
        }
        return exec;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    @Override
    public void actionSelectHasten_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        HashSet<String> evaluObjectSet = new HashSet<String>();
        HashMap<String, String> evaluObjectMap = new HashMap<String, String>();
        List rowIndexs = PFUtils.getSelectedRows(this.tblMain);
        if (rowIndexs != null && !rowIndexs.isEmpty()) {
            for (int i = 0; i < rowIndexs.size(); ++i) {
                Integer rowIndex = (Integer)rowIndexs.get(i);
                IRow row = this.tblMain.getRow(rowIndex.intValue());
                String id = (String)row.getCell("id").getValue();
                String evaluObjectName = (String)row.getCell("evaluObject.name").getValue();
                evaluObjectSet.add(id);
                evaluObjectMap.put(id, evaluObjectName);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", evaluObjectSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluObject.evaluObjectType"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("evaluObject.responser"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.workflow"));
        view.setSelector(sic);
        TargetEvaluStoreParentCollection targetEvaluStoreParentColl = TargetEvaluStoreParentFactory.getRemoteInstance().getTargetEvaluStoreParentCollection(view);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriodID", (Object)solutionPeriodId);
        uiContext.put((Object)"evaluObjectMap", evaluObjectMap);
        uiContext.put((Object)"targetEvaluStoreParentColl", (Object)targetEvaluStoreParentColl);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TargetDeliverTrackPersonHastenUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionTargetView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = PFUtils.getSelectedRow(this.tblMain);
        Object evaluObjectID = this.tblMain.getRow(rowIndex).getCell("evaluObject.objectID").getValue();
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        if (evaluObjectID == null || solutionPeriodInfo == null || solutionPeriodInfo.getId() == null || solutionPeriodInfo.getEvaluSolution() == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", (Object)solutionPeriodInfo.getId().toString());
        uiContext.put((Object)"evaluObject", (Object)evaluObjectID.toString());
        uiContext.put((Object)"evaluRuleInfo", (Object)this.evaluRuleInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PersonalTargetEvaluStoreViewListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void comonActionQuery() throws Exception {
        this.mainQuery = this.getDialog() != null ? this.getEntityViewInfo(this.getDialog().getEntityViewInfoResult()) : this.getEntityViewInfo(new EntityViewInfo());
        this.refreshList();
    }

    private String getSqlBySelectors(String selectorStr, String sqlSource) {
        if (selectorStr == null || "".equals(selectorStr)) {
            return sqlSource;
        }
        int endIndex = sqlSource.indexOf("FROM");
        String sqlSelectorStr = sqlSource.substring(6, endIndex);
        sqlSource = sqlSource.replaceFirst(sqlSelectorStr, selectorStr);
        return sqlSource;
    }

    @Override
    public void actionTargetBuildedAllHasten_actionPerformed(ActionEvent e) throws Exception {
        this.actionTargetBuildedAllHasten(e);
    }

    @Override
    public void actionTargetDeliverAllHasten_actionPerformed(ActionEvent e) throws Exception {
        this.actionTargetDeliverAllHasten(e);
    }

    private void actionTargetBuildedAllHasten(ActionEvent e) throws Exception {
        this.checkEvaluObjectExist();
        EvaluObjectCollection col = this.getEvaluObjectByWeight("build");
        Map personMap = this.getEvaluObjectAndDeliverer(col);
        PersonCollection evaluPersonCol = this.getPersonCol(col);
        this.sendEmail(evaluPersonCol, personMap, true);
    }

    private void actionTargetDeliverAllHasten(ActionEvent e) throws Exception {
        this.checkEvaluObjectExist();
        EvaluObjectCollection col = this.getEvaluObjectByWeight("deliver");
        Map personMap = this.getEvaluObjectAndDeliverer(col);
        PersonCollection evaluPersonCol = this.getPersonCol(col);
        this.sendEmail(evaluPersonCol, personMap, false);
    }

    private PersonCollection getPersonCol(EvaluObjectCollection col) throws Exception {
        PersonCollection personCol = null;
        HashSet<String> evaluPersonIdSet = new HashSet<String>();
        EvaluObjectInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            evaluPersonIdSet.add(info.getObjectID());
        }
        if (evaluPersonIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", evaluPersonIdSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("email"));
            view.setSelector(sic);
            personCol = PersonFactory.getRemoteInstance().getPersonCollection(view);
        }
        return personCol;
    }

    private Map getEvaluObjectAndDeliverer(EvaluObjectCollection col) {
        HashMap<String, PersonCollection> personMap = new HashMap<String, PersonCollection>();
        PersonCollection personCol = null;
        EvaluObjectInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            TargetDelivererCollection delivererCol = info.getTargetDeliverers();
            if (delivererCol.size() > 0) {
                personCol = new PersonCollection();
                int colSize = delivererCol.size();
                for (int k = 0; k < colSize; ++k) {
                    TargetDelivererInfo delivererInfo = delivererCol.get(k);
                    personCol.add(delivererInfo.getPerson());
                }
            }
            if (personCol == null) continue;
            personMap.put(info.getObjectID(), personCol);
        }
        return personMap;
    }

    private void checkEvaluObjectExist() {
        if (this.tblMain == null || this.tblMain.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"18_EvaluObjectNotExist"));
            SysUtil.abort();
        }
    }

    private EvaluObjectCollection getEvaluObjectByWeight(String value) throws Exception {
        EvaluObjectCollection col = new EvaluObjectCollection();
        HashSet<String> evaluObjectSet = new HashSet<String>();
        IRow row = null;
        String evaluObjectId = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("state").getValue() == null) continue;
            String state = row.getCell("state").getValue().toString();
            if ("build".equals(value) && TargetStateEnum.unSubmit.getAlias().equals(state)) {
                evaluObjectId = (String)row.getCell("evaluObject.id").getValue();
                evaluObjectSet.add(evaluObjectId);
                continue;
            }
            if (!"deliver".equals(value) || !TargetStateEnum.isSubmited.getAlias().equals(state)) continue;
            evaluObjectId = (String)row.getCell("evaluObject.id").getValue();
            evaluObjectSet.add(evaluObjectId);
        }
        if (evaluObjectSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", evaluObjectSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("targetDeliverers.person.id"));
            sic.add(new SelectorItemInfo("targetDeliverers.person.name"));
            sic.add(new SelectorItemInfo("targetDeliverers.person.email"));
            sic.add(new SelectorItemInfo("evaluSolution.id"));
            sic.add(new SelectorItemInfo("objectID"));
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            col = EvaluObjectFactory.getRemoteInstance().getEvaluObjectCollection(view);
        } else {
            if ("build".equals(value)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"425_DoNotNeedHasten"));
                SysUtil.abort();
            }
            if ("deliver".equals(value)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"426_DoNotNeedHasten"));
                SysUtil.abort();
            }
        }
        return col;
    }

    private void sendEmail(PersonCollection evaluPersonCol, Map personMap, boolean isBuilded) throws Exception {
        HashMap<String, String> emailErrorOfPerson = new HashMap<String, String>();
        Map bodyMap = this.getBodyMap(evaluPersonCol, isBuilded);
        HashMap<String, PersonInfo> hashEmailEvalu = new HashMap<String, PersonInfo>();
        PersonCollection oldEvaluPersonCol = (PersonCollection)evaluPersonCol.clone();
        PersonInfo evaluPersonInfo = null;
        PersonCollection personCol = null;
        PersonInfo delivererInfo = null;
        String eMail = null;
        for (int i = evaluPersonCol.size() - 1; 0 <= i; --i) {
            evaluPersonInfo = evaluPersonCol.get(i);
            if (personMap.get(evaluPersonInfo.getId().toString()) != null) {
                personCol = (PersonCollection)personMap.get(evaluPersonInfo.getId().toString());
            }
            if (personCol != null) {
                for (int k = personCol.size() - 1; 0 <= k; --k) {
                    delivererInfo = personCol.get(k);
                    eMail = delivererInfo.getEmail();
                    if (!StringUtils.isEmpty((String)eMail) && this.isCorrectEmail(eMail)) continue;
                    emailErrorOfPerson.put(delivererInfo.getId().toString(), delivererInfo.getName());
                    personCol.remove(delivererInfo);
                }
                personMap.put(evaluPersonInfo.getId().toString(), personCol);
            }
            if (StringUtils.isEmpty((String)(eMail = evaluPersonInfo.getEmail())) || !this.isCorrectEmail(eMail)) {
                emailErrorOfPerson.put(evaluPersonInfo.getId().toString(), evaluPersonInfo.getName());
                continue;
            }
            hashEmailEvalu.put(evaluPersonInfo.getId().toString(), evaluPersonInfo);
        }
        if (!emailErrorOfPerson.isEmpty()) {
            StringBuffer personNames = new StringBuffer();
            Object[] personName = emailErrorOfPerson.values().toArray();
            int size = emailErrorOfPerson.size();
            for (int i = 0; i < size; ++i) {
                personNames.append(personName[i]);
                if (20 <= size) {
                    if (i >= 19) break;
                    personNames.append(EASResource.getString((String)RES, (String)"431_Mark"));
                    continue;
                }
                if (i >= size - 1) continue;
                personNames.append(EASResource.getString((String)RES, (String)"431_Mark"));
            }
            String emailNull = EASResource.getString((String)RES, (String)"429_EmailNull");
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((String)(emailNull = MessageFormat.format(emailNull, personNames, new Integer(size)))))) {
                return;
            }
        }
        EvaluObjectFacadeFactory.getRemoteInstance().sendMail(oldEvaluPersonCol, hashEmailEvalu, bodyMap, personMap);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"430_Success"));
    }

    private boolean isCorrectEmail(String eMail) {
        this.matcher = pattern.matcher(eMail);
        return this.matcher.matches();
    }

    private Map getBodyMap(PersonCollection personCol, boolean isBuilded) {
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        if (personCol != null && personCol.size() > 0) {
            String body = null;
            PersonInfo info = null;
            String solution = null;
            String name = null;
            int size = personCol.size();
            for (int i = 0; i < size; ++i) {
                info = personCol.get(i);
                body = isBuilded ? EASResource.getString((String)RES, (String)"428_body") : EASResource.getString((String)RES, (String)"432_body");
                solution = this.comboSolutionPeriod.getSelectedItem().toString();
                name = info.getName();
                body = MessageFormat.format(body, name, solution);
                bodyMap.put(info.getId().toString(), body);
            }
        }
        return bodyMap;
    }
}

