/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.EvaluRuleInfo;
import com.kingdee.eas.hr.perf.EvaluRuleModeEnum;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentFactory;
import com.kingdee.eas.hr.perf.TargetStateEnum;
import com.kingdee.eas.hr.perf.client.AbstractTargetDeliverTrackOrgUnitListUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PersonalTargetEvaluStoreViewListUI;
import com.kingdee.eas.hr.perf.client.TargetDeliverTrackOrgUnitHastenUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TargetDeliverTrackOrgUnitListUI
extends AbstractTargetDeliverTrackOrgUnitListUI {
    private static final String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private CommonQueryDialog queryDlg;
    private Map evaluObjs = null;
    private Map sumTargetWeights = null;
    private static final long serialVersionUID = -61166L;
    private static final Logger logger = CoreUIObject.getLogger(TargetDeliverTrackOrgUnitListUI.class);
    EvaluRuleInfo evaluRuleInfo = null;

    public void onLoad() throws Exception {
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.tblMain.setColumnMoveable(true);
        this.initTargetStateComboBox();
        this.initComboBox();
        super.onLoad();
    }

    private void initComboBox() throws Exception {
        this.comboSolutionPeriod.setActionCommand("init");
        EvaluSolutionHelper.initHRSolutionPeriod(this.comboSolutionPeriod, null, EvaluSolutionTypeEnum.ORGUNIT);
        this.comboSolutionPeriod.setActionCommand(null);
        if (this.comboSolutionPeriod.getItemCount() > 0) {
            this.comboSolutionPeriod.setSelectedIndex(0);
        }
    }

    private void initTargetStateComboBox() throws Exception {
        this.comboTargetState.setActionCommand("init");
        this.comboTargetState.addItems(TargetStateEnum.getEnumList().toArray());
        this.comboTargetState.setSelectedIndex(0);
        this.comboTargetState.setActionCommand(null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTargetDeliverHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.menuItemTargetDeliverHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.btnTargetView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.menuItemTargetView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
    }

    @Override
    protected void comboTargetState_actionPerformed(ActionEvent e) throws Exception {
        if ("init".equals(this.comboTargetState.getActionCommand())) {
            return;
        }
        this.comonActionQuery();
        super.comboTargetState_actionPerformed(e);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
            String solutionPeriodId = null;
            if (solutionPeriodInfo == null) {
                return;
            }
            solutionPeriodId = solutionPeriodInfo.getId().toString();
            HashSet<String> objectIds = new HashSet<String>();
            rowSet.beforeFirst();
            String id = null;
            while (rowSet.next()) {
                id = rowSet.getString("evaluObject.id");
                objectIds.add(id);
            }
            rowSet.beforeFirst();
            this.evaluRuleInfo = EvaluSolutionHelper.getEvaluRuleBySolutionPeriodId(solutionPeriodId);
            Map sumTargetWeight = EvaluSolutionHelper.getSumTargetWeightOrValue(solutionPeriodId, objectIds, this.evaluRuleInfo.getRuleMode());
            this.setTableStyle(this.evaluRuleInfo.getRuleMode());
            rowSet.beforeFirst();
            BigDecimal sumWeight = null;
            while (rowSet.next()) {
                id = rowSet.getString("evaluObject.id");
                sumWeight = sumTargetWeight != null && !sumTargetWeight.isEmpty() && sumTargetWeight.get(id) != null ? (BigDecimal)sumTargetWeight.get(id) : PerfClientUtils.ZERO;
                rowSet.updateBigDecimal("sumTargetWeight", sumWeight);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        if ("init".equals(this.comboSolutionPeriod.getActionCommand())) {
            return;
        }
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String cureQueryName = TargetDeliverTrackOrgUnitListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), cureQueryName);
        EntityViewInfo entityView = new EntityViewInfo();
        if (solution != null && solution.getEntityViewInfo() != null) {
            entityView = Util.getInnerFilterInfo((QuerySolutionInfo)solution);
        }
        this.mainQuery = super.getEntityViewInfo(entityView);
        if (this.evaluObjs != null && !this.evaluObjs.isEmpty()) {
            this.evaluObjs.clear();
        }
        if (this.sumTargetWeights != null && !this.sumTargetWeights.isEmpty()) {
            this.sumTargetWeights.clear();
        }
        this.comonActionQuery();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void actionTargetDeliverHasten_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        HashSet<String> evaluObjectSet = new HashSet<String>();
        HashMap<String, String> evaluObjectMap = new HashMap<String, String>();
        List rowIndexs = PFUtils.getSelectedRows(this.tblMain);
        if (rowIndexs != null && !rowIndexs.isEmpty()) {
            for (int i = 0; i < rowIndexs.size(); ++i) {
                Integer rowIndex = (Integer)rowIndexs.get(i);
                IRow row = this.tblMain.getRow(rowIndex.intValue());
                String id = (String)row.getCell("id").getValue();
                String responserName = (String)row.getCell("responser.name").getValue();
                evaluObjectSet.add(id);
                evaluObjectMap.put(id, responserName);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", evaluObjectSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("evaluObject.evaluObjectType"));
        sic.add(new SelectorItemInfo("evaluObject.responser.id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.workflow"));
        view.setSelector(sic);
        TargetEvaluStoreParentCollection targetEvaluStoreParentColl = TargetEvaluStoreParentFactory.getRemoteInstance().getTargetEvaluStoreParentCollection(view);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriodID", (Object)solutionPeriodId);
        uiContext.put((Object)"targetEvaluStoreParentColl", (Object)targetEvaluStoreParentColl);
        uiContext.put((Object)"evaluObjectMap", evaluObjectMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TargetDeliverTrackOrgUnitHastenUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionTargetView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = PFUtils.getSelectedRow(this.tblMain);
        Object evaluObjectID = this.tblMain.getRow(rowIndex).getCell("orgUnit.id").getValue();
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        if (evaluObjectID == null || solutionPeriodInfo == null || solutionPeriodInfo.getId() == null || solutionPeriodInfo.getEvaluSolution() == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", (Object)solutionPeriodInfo.getId().toString());
        uiContext.put((Object)"evaluObject", (Object)evaluObjectID.toString());
        uiContext.put((Object)"evaluRuleInfo", (Object)this.evaluRuleInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PersonalTargetEvaluStoreViewListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        this.queryDlg = new CommonQueryDialog();
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setShowSorter(false);
        this.queryDlg.setTitle(EASResource.getString((String)RES, (String)"targetDeliverTrOrgTitle"));
        this.queryDlg.setUiObject((IUIObject)this);
        return this.queryDlg;
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    private void setTableStyle(EvaluRuleModeEnum evaluRuleModeEnum) {
        if (EvaluRuleModeEnum.WEIGHT_MODE.equals((Object)evaluRuleModeEnum)) {
            this.tblMain.getColumn("sumTargetWeight").getStyleAttributes().setNumberFormat("0.00%");
        } else {
            this.tblMain.getColumn("sumTargetWeight").getStyleAttributes().setNumberFormat("0.00");
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        TargetStateEnum targetStateEnum = (TargetStateEnum)((Object)this.comboTargetState.getSelectedItem());
        FilterInfo returnFilterInfo = new FilterInfo();
        if (solutionPeriodInfo == null || targetStateEnum == null) {
            returnFilterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)""));
            return returnFilterInfo;
        }
        returnFilterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodInfo.getId().toString()));
        returnFilterInfo.getFilterItems().add(new FilterItemInfo("solutionDeliverd", (Object)Boolean.TRUE));
        if (!targetStateEnum.equals((Object)TargetStateEnum.ALL)) {
            returnFilterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(targetStateEnum.getValue())));
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluObject.deleted", (Object)Boolean.FALSE));
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "adminOrgUnit.id"));
        filter2.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", null, CompareType.IS));
        filter2.setMaskString("#0 OR #1");
        try {
            fi.mergeFilter(returnFilterInfo, "and");
            fi.mergeFilter(filter2, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnFilterInfo;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman post = super.prepareQuery(e);
        RequestContext req = (RequestContext)post.getRequestContext();
        if (this.comboSolutionPeriod.getSelectedItem() != null) {
            req.put("solutionPeriod", this.comboSolutionPeriod.getSelectedItem());
        }
        post.setRequestContext((Serializable)req);
        return post;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.comboSolutionPeriod_actionPerformed(e);
    }

    private void comonActionQuery() throws Exception {
        this.mainQuery = this.getDialog() != null ? this.getEntityViewInfo(this.getDialog().getEntityViewInfoResult()) : this.getEntityViewInfo(new EntityViewInfo());
        this.refreshList();
    }
}

