/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.IEvaluObject;
import com.kingdee.eas.hr.perf.ITargetDeliverFacade;
import com.kingdee.eas.hr.perf.TargetDeliverFacadeFactory;
import com.kingdee.eas.hr.perf.client.AbstractTargetDelivererSetRecorderUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionF7Helper;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class TargetDelivererSetRecorderUI
extends AbstractTargetDelivererSetRecorderUI {
    private static final Logger logger = CoreUIObject.getLogger(TargetDelivererSetRecorderUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    AbstractTargetDelivererSetRecorderUI.ActionSelectPerson actionSelectPerson;
    AbstractTargetDelivererSetRecorderUI.ActionRemoveLine actionRemoveRow;
    private boolean isCancel = true;
    private Set oldPersons = new HashSet();
    private Set addPersons = new HashSet();
    private Set removePersons = new HashSet();
    private String evaluObjectId;
    private EvaluObjectInfo evaluObject;
    private String evaluSolutionId;
    private String objectId;
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private boolean isOrg = false;
    private HashSet objIdSet;

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParam();
        this.initUI();
        this.initCompomentStatus();
    }

    private void initParam() throws BOSException, EASBizException, UuidException {
        Map uiContext = this.getUIContext();
        this.evaluObjectId = (String)uiContext.get("id");
        this.evaluSolutionId = (String)uiContext.get("evaluSolutionId");
        this.objectId = (String)uiContext.get("objectId");
        this.isOrg = (Boolean)uiContext.get("isOrg");
        this.objIdSet = (HashSet)uiContext.get("objIdSet");
        IEvaluObject ieo = EvaluObjectFactory.getRemoteInstance();
        this.evaluObject = ieo.getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.evaluObjectId)));
        if (this.evaluObject == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    private void initCompomentStatus() {
        this.chkIncludeApoint.setSelected(this.evaluObject.isAppointPerson());
        this.chkIncludeSelf.setSelected(this.evaluObject.isOneself());
        this.chkIncludeSuperior.setSelected(this.evaluObject.isSuperior());
        this.actionRemoveRow.setEnabled(this.chkIncludeApoint.isSelected());
        this.actionSelectPerson.setEnabled(this.chkIncludeApoint.isSelected());
    }

    private void initUI() {
        this.actionSelectPerson = new AbstractTargetDelivererSetRecorderUI.ActionSelectPerson((IUIObject)this);
        JButton btnSelectAchieve = this.contEntry.add((Action)((Object)this.actionSelectPerson));
        btnSelectAchieve.setIcon(EASResource.getIcon((String)"imgTbtn_BatchAdd"));
        btnSelectAchieve.setToolTipText(EASResource.getString((String)RES, (String)"addTargetDeliver"));
        this.actionRemoveRow = new AbstractTargetDelivererSetRecorderUI.ActionRemoveLine((IUIObject)this);
        JButton btnRemoveAch = this.contEntry.add((Action)((Object)this.actionRemoveRow));
        btnRemoveAch.setIcon(EASResource.getIcon((String)"imgTbtn_deletegroup"));
        btnRemoveAch.setToolTipText(EASResource.getString((String)RES, (String)"delTargetDeliver"));
        if (this.isOrg) {
            this.chkIncludeSelf.setText(EASResource.getString((String)RES, (String)"org_targetDeliverName"));
            this.chkIncludeSuperior.setText(EASResource.getString((String)RES, (String)"org_supervisor"));
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.evaluObjectId == null) {
            Map uiContext = this.getUIContext();
            this.evaluObjectId = (String)uiContext.get("id");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.evaluObjectId));
        return filter;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.validateBeforeConfirm()) {
            this.removePersons.retainAll(this.oldPersons);
            ITargetDeliverFacade iTargetDeliverFacade = TargetDeliverFacadeFactory.getRemoteInstance();
            IEvaluObject ieo = EvaluObjectFactory.getRemoteInstance();
            if (this.evaluObject != null) {
                this.evaluObject.setAppointPerson(this.chkIncludeApoint.isSelected());
                this.evaluObject.setOneself(this.chkIncludeSelf.isSelected());
                this.evaluObject.setSuperior(this.chkIncludeSuperior.isSelected());
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("appointPerson"));
                selectors.add(new SelectorItemInfo("superior"));
                selectors.add(new SelectorItemInfo("oneself"));
                ieo.updatePartial((CoreBaseInfo)this.evaluObject, selectors);
                if (this.removePersons.size() > 0 || this.addPersons.size() > 0) {
                    iTargetDeliverFacade.saveTargetDelivers(this.evaluObjectId, this.addPersons, this.removePersons);
                }
                if (this.chkObjAll.isSelected()) {
                    if (this.isOrg) {
                        if (this.evaluSolutionId == null || this.evaluObjectId == null) {
                            return;
                        }
                        iTargetDeliverFacade.synTargetDeliver(this.evaluSolutionId, this.evaluObjectId, this.isOrg);
                    } else {
                        if (this.objIdSet.size() == 0 || this.evaluObjectId == null) {
                            return;
                        }
                        iTargetDeliverFacade.synTargetDeliverToEvaluObjectSet(this.objIdSet, this.evaluObjectId, this.isOrg);
                    }
                }
                this.isCancel = false;
                this.getUIWindow().close();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"unChooseDeliver"));
        }
    }

    private boolean validateBeforeConfirm() {
        if (this.chkIncludeSelf.isSelected() || this.chkIncludeSuperior.isSelected()) {
            return true;
        }
        return this.chkIncludeApoint.isSelected() && this.tblMain.getRowCount() > 0;
    }

    protected void tblMain_tableClicked(KDTMouseEvent arg0) throws Exception {
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int[] rows = KDTableUtil.getSelectedRows(this.tblMain);
        IRow row = null;
        String id = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(rows[i]);
            if (row.getCell("person.id") != null && row.getCell("person.id").getValue() != null) {
                id = row.getCell("person.id").getValue().toString();
                this.removePersons.add(id);
                if (this.addPersons.contains(id)) {
                    this.addPersons.remove(id);
                }
            }
            this.tblMain.removeRow(rows[i]);
        }
    }

    @Override
    public void actionSelectPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox personF7 = (EmployeeMultiF7PromptBox)EvaluSolutionF7Helper.getEmployeeF7((IUIObject)this);
        personF7.show();
        Object data = personF7.getData();
        if (data != null && data instanceof Object[]) {
            Object[] obj = (Object[])data;
            int j = obj.length;
            for (int i = 0; i < j; ++i) {
                String pId;
                PersonInfo info = (PersonInfo)obj[i];
                if (info == null || this.oldPersons.contains(pId = info.getId().toString()) || this.addPersons.contains(pId)) continue;
                this.addPersons.add(pId);
                IRow row = this.tblMain.addRow();
                row.getCell("person.id").setValue((Object)pId);
                row.getCell("person.name").setValue((Object)info.getName());
                row.getCell("person.number").setValue((Object)info.getNumber());
                row.getCell("person.position").setValue(info.get("primaryposition"));
            }
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                this.oldPersons.add(rowSet.getString("person.id"));
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public boolean isApplyForAllObj() {
        return this.chkObjAll.isSelected();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected void chkIncludeApoint_stateChanged(ChangeEvent e) throws Exception {
        boolean checked = this.chkIncludeApoint.isSelected();
        this.actionSelectPerson.setEnabled(checked);
        this.actionRemoveRow.setEnabled(checked);
    }
}

