/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.client.AbstractTargetDelivererUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionF7Helper;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class TargetDelivererUI
extends AbstractTargetDelivererUI {
    private static final Logger logger = CoreUIObject.getLogger(TargetDelivererUI.class);
    private PersonCollection personCollection;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblTargetDeliverer.checkParsed();
        PersonCollection personColl = (PersonCollection)this.getUIContext().get("PersonCollection");
        if (personColl != null && personColl.size() > 0) {
            this.fillTable(personColl.toArray());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddTargetDeliverer.setIcon(EASResource.getIcon((String)"imgTbtn_BatchAdd"));
        this.btnDelTargetDeliverer.setIcon(EASResource.getIcon((String)"imgTbtn_deletegroup"));
    }

    public PersonCollection getPersonCollection() {
        return this.personCollection;
    }

    public void setPersonCollection(PersonCollection personCollection) {
        this.personCollection = personCollection;
    }

    @Override
    public void actionAddTargetDeliverer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddTargetDeliverer_actionPerformed(e);
        EmployeeMultiF7PromptBox pmt = (EmployeeMultiF7PromptBox)EvaluSolutionF7Helper.getEmployeeF7AndNoPositionPerson((IUIObject)this);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            Object[] obj = (Object[])pmt.getData();
            this.fillTable(obj);
        }
    }

    public void fillTable(Object[] obj) throws Exception {
        PersonInfo personInfo = null;
        IPositionMember positionMember = null;
        int length = obj.length;
        for (int i = 0; i < length; ++i) {
            PositionInfo positionInfo;
            personInfo = (PersonInfo)obj[i];
            if (personInfo == null || this.checkIfRefered(personInfo)) continue;
            IRow row = this.tblTargetDeliverer.addRow();
            row.getCell("id").setValue((Object)personInfo.getId().toString());
            row.getCell("number").setValue((Object)personInfo.getNumber());
            row.getCell("name").setValue((Object)personInfo.getName());
            if (positionMember == null) {
                positionMember = PositionMemberFactory.getRemoteInstance();
            }
            if ((positionInfo = EvaluSolutionHelper.getPositionInfo(positionMember, personInfo.getId().toString())) == null) continue;
            row.getCell("position").setValue((Object)positionInfo.getName());
        }
    }

    private boolean checkIfRefered(PersonInfo personInfo) {
        IRow row = null;
        for (int i = 0; i < this.tblTargetDeliverer.getRowCount(); ++i) {
            row = this.tblTargetDeliverer.getRow(i);
            String personId = (String)row.getCell("id").getValue();
            if (!personInfo.getId().toString().equals(personId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionDelTargetDeliverer_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelTargetDeliverer_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblTargetDeliverer);
        int selectedRow = PFUtils.getSelectedRow(this.tblTargetDeliverer);
        this.tblTargetDeliverer.removeRow(selectedRow);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        IRow row = null;
        PersonCollection coll = new PersonCollection();
        PersonInfo info = null;
        int size = this.tblTargetDeliverer.getRowCount();
        for (int i = 0; i < size; ++i) {
            info = new PersonInfo();
            row = this.tblTargetDeliverer.getRow(i);
            if (row.getCell("id").getValue() == null) continue;
            info.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
            if (row.getCell("number").getValue() != null) {
                info.setNumber(row.getCell("number").getValue().toString());
            }
            if (row.getCell("name").getValue() != null) {
                info.setName(row.getCell("name").getValue().toString());
            }
            coll.add(info);
        }
        this.setPersonCollection(coll);
        this.disposeUIWindow();
    }

    public static PersonCollection showDialogWindows(IUIObject ui, PersonCollection personColl) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"PersonCollection", (Object)personColl);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TargetDelivererUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        TargetDelivererUI delivererUI = (TargetDelivererUI)uiWindow.getUIObject();
        return delivererUI.getPersonCollection();
    }
}

