/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.competmodel.CompetenceIndexInfo;
import com.kingdee.eas.hr.competmodel.client.CompetModelF7PromptBox;
import com.kingdee.eas.hr.org.ResponsibilityCollection;
import com.kingdee.eas.hr.org.ResponsibilityInfo;
import com.kingdee.eas.hr.perf.AchieveDataHelper;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.EvaluTargetTypeStoreCollection;
import com.kingdee.eas.hr.perf.FormulaInfo;
import com.kingdee.eas.hr.perf.ITargetEvaluStore;
import com.kingdee.eas.hr.perf.KindEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PerformTargetItemInfo;
import com.kingdee.eas.hr.perf.PerformTargetTypeFactory;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.ReportFrequencyEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.client.AbstractTargetEvaluStoreBaseEditUI;
import com.kingdee.eas.hr.perf.client.EvaluFormSolutionUIHelper;
import com.kingdee.eas.hr.perf.client.FormulaPromptBox;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PercentRender;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PerformItemHelper;
import com.kingdee.eas.hr.perf.client.PerformTargetTypePromptBox;
import com.kingdee.eas.hr.perf.client.PerformanceTargetPromptBox;
import com.kingdee.eas.hr.perf.client.PositionRespListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public abstract class TargetEvaluStoreBaseEditUI
extends AbstractTargetEvaluStoreBaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TargetEvaluStoreBaseEditUI.class);
    protected HROrgUnitInfo hrOrgUntiInfo = SysContext.getSysContext().getCurrentHRUnit();
    protected UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
    private PersonInfo creator = null;
    private PositionInfo creatorPosition = null;
    protected final String PERSON = "person";
    protected final String ORGUNIT = "orgUnit";
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private KDTPropertyChangeListener propChangeListener;
    private static IBasicRender defRender;
    private Map oldData = new HashMap();
    private static final String targetRes = "com.kingdee.eas.hr.perf.client.TargetEvaluStoreResource";
    private BigDecimal curWeight = new BigDecimal("0.00");
    private BigDecimal outsideWeight = new BigDecimal("0.00");
    private BigDecimal selectedWeight = new BigDecimal("0.00");
    private BigDecimal totalWeight = new BigDecimal("0.00");
    private boolean isControlWeight = true;
    private BigDecimal HUNDRED = new BigDecimal("100.00");
    private EvaluTargetTypeStoreCollection targetTypeStoreList = new EvaluTargetTypeStoreCollection();

    protected IObjectValue createNewData() {
        return new TargetEvaluStoreInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TargetEvaluStoreFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.propChangeListener = new TablePropertyChangeListener();
        this.tblMain.setColumnMoveable(true);
        if (this.isTargetTemplateMode()) {
            this.initTargetType();
        }
        this.setTableCellEditor();
        super.onLoad();
        if (!OprtState.ADDNEW.equals(this.getOprtState().toString())) {
            this.fillTable();
        }
        this.initBaseInfo();
        this.txtEvaluObject.setEnabled(false);
        this.txtPositionOrResponser.setEnabled(false);
        this.txtEvaluSolution.setEnabled(false);
        this.txtAccessPeriod.setEnabled(false);
        this.tblMain.addKDTPropertyChangeListener(this.propChangeListener);
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.addCommonMenusToTable(this.tblMain);
        this.initParams();
        this.initWeightState();
        this.tblMain.getColumn("dataPrecision").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("precisionType").getStyleAttributes().setHided(true);
    }

    private void initTargetType() {
        if (this.getUIContext().get("targetTypeStoreList") != null) {
            this.targetTypeStoreList = (EvaluTargetTypeStoreCollection)((Object)this.getUIContext().get("targetTypeStoreList"));
        }
    }

    private void initParams() {
        this.isControlWeight = ((SolutionPeriodInfo)this.getUIContext().get("solutionPeriod")).getEvaluSolution().isIsControlWeight();
        Map uiContext = this.getUIContext();
        BigDecimal sumWeight = ((BigDecimal)uiContext.get("sumWeight")).setScale(2);
        this.selectedWeight = ((BigDecimal)uiContext.get("selectedWeight")).setScale(2);
        this.outsideWeight = OprtState.ADDNEW.equals(this.getOprtState()) ? sumWeight : sumWeight.subtract(this.selectedWeight);
    }

    private void initWeightState() {
        this.calCurrentWeight();
        this.totalWeight = this.outsideWeight.add(this.curWeight).setScale(2);
        String txt = null;
        if (!this.isControlWeight) {
            Object[] var = new Object[]{this.totalWeight.toString() + "%", this.HUNDRED.subtract(this.totalWeight).setScale(2) + "%"};
            String message = EASResource.getString((String)targetRes, (String)"targetWeightStateControlWeight");
            txt = MessageFormat.format(message, var);
        } else {
            Object[] var = new Object[]{this.totalWeight.toString() + "%"};
            String message = EASResource.getString((String)targetRes, (String)"targetWeightStateNotControlWeight");
            txt = MessageFormat.format(message, var);
        }
        this.lblWeight.setText(txt);
    }

    private void calCurrentWeight() {
        IRow row = null;
        this.curWeight = new BigDecimal("0.00");
        int j = this.tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("weight").getValue() == null) continue;
            this.curWeight = this.curWeight.add((BigDecimal)row.getCell("weight").getValue());
        }
    }

    protected abstract void initBaseInfo() throws Exception;

    protected abstract String getEvaluStoreType();

    protected IRowSet getBaseInfo() throws Exception {
        String queryStr = "com.kingdee.eas.hr.perf.app.TargetEvaluStoreBaseQuery";
        MetaDataPK queryPK = new MetaDataPK(queryStr);
        IQueryExecutor query = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterItemInfo fi = new FilterItemInfo("id", this.getUIContext().get("ID"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(fi);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        query.setObjectView(evi);
        IRowSet rowSet = query.executeQuery();
        return rowSet;
    }

    protected void setTableCellEditor() throws Exception {
        PerfClientUtils.setTableCellEditorByComboBox(this.tblMain, "kind", "com.kingdee.eas.hr.perf.KindEnum");
        PerfClientUtils.setTableCellEditorByComboBox(this.tblMain, "precisionType", "com.kingdee.eas.hr.perf.PrecisionTypeEnum");
        Object[] dataPrecision = new Object[5];
        for (int i = 0; i < dataPrecision.length; ++i) {
            dataPrecision[i] = new Integer(i);
        }
        PerfClientUtils.setCellComboBoxEditor(this.tblMain, "dataPrecision", dataPrecision);
        PerfClientUtils.setTableCellEditorByComboBox(this.tblMain, "reportFrequency", "com.kingdee.eas.hr.perf.ReportFrequencyEnum");
        PFUtils.setTableCellEditorByFormattedTextFieldWithNegative(this.tblMain, "thresholdValue", 5, true);
        PFUtils.setTableCellEditorByFormattedTextFieldWithNegative(this.tblMain, "standardValue", 5, true);
        PFUtils.setTableCellEditorByFormattedTextFieldWithNegative(this.tblMain, "challengeValue", 5, true);
        PFUtils.setTableCellEditorByFormattedTextFieldWithNegative(this.tblMain, "reservedField2", 2, true);
        PFUtils.setTableCellEditorByFormattedTextField(this.tblMain, "weight", 2, true);
        if (!this.isTargetTemplateMode()) {
            PerfClientUtils.setTableCellEditorByF7Selector(this.tblMain, (KDPromptSelector)new PerformTargetTypePromptBox(), "type");
        } else {
            this.tblMain.getColumn("type").setRequired(false);
            this.tblMain.getColumn("type").getStyleAttributes().setLocked(true);
        }
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "content");
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "standard");
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "description");
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "scoringMethod", 100);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "reservedField1");
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "reservedField1");
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "unit", 100);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "evaluationSide", 80);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "creator", 80);
        PerfClientUtils.setTableCellEditorByTextArea(this.tblMain, "creatorPosition", 80);
        FormulaPromptBox formulaF7 = new FormulaPromptBox((IUIObject)this);
        formulaF7.setFormulaType(2);
        PerfClientUtils.setTableCellEditorByF7Selector(this.tblMain, (KDPromptSelector)formulaF7, "calFormula");
        this.tblMain.getColumn("creator").getStyleAttributes().setLocked(true);
    }

    private boolean isTargetTemplateMode() {
        Object isTargetTemplate = this.getUIContext().get("isTargetTemplate");
        return isTargetTemplate != null && isTargetTemplate instanceof Boolean && (Boolean)isTargetTemplate != false;
    }

    protected void fillTable() throws Exception {
        Set ids = new HashSet();
        ids = this.getSelectedRows();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        evi.setSelector(this.getSelector());
        TargetEvaluStoreCollection coll = TargetEvaluStoreFactory.getRemoteInstance().getTargetEvaluStoreCollection(evi);
        this.putDataToTable(coll);
    }

    protected void putDataToTable(TargetEvaluStoreCollection coll) throws Exception {
        this.oldData.clear();
        TargetEvaluStoreInfo info = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            info = coll.get(i);
            this.fillTable(info);
            this.oldData.put(info.getId(), info.clone());
        }
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("uniteTarget"));
        sic.add(new SelectorItemInfo("weight"));
        sic.add(new SelectorItemInfo("creator.person.name"));
        sic.add(new SelectorItemInfo("evaluTarget"));
        sic.add(new SelectorItemInfo("evaluTarget.type.id"));
        sic.add(new SelectorItemInfo("evaluTarget.type.name"));
        sic.add(new SelectorItemInfo("evaluTarget.type.displayName"));
        sic.add(new SelectorItemInfo("evaluTarget.number"));
        sic.add(new SelectorItemInfo("evaluTarget.content"));
        sic.add(new SelectorItemInfo("evaluTarget.standard"));
        sic.add(new SelectorItemInfo("evaluTarget.description"));
        sic.add(new SelectorItemInfo("evaluTarget.kind"));
        sic.add(new SelectorItemInfo("thresholdValue"));
        sic.add(new SelectorItemInfo("standardValue"));
        sic.add(new SelectorItemInfo("challengeValue"));
        sic.add(new SelectorItemInfo("evaluTarget.unit"));
        sic.add(new SelectorItemInfo("evaluTarget.reportFrequency"));
        sic.add(new SelectorItemInfo("evaluTarget.scoringMethod"));
        sic.add(new SelectorItemInfo("evaluTarget.evaluationSide"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField1"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField2"));
        sic.add(new SelectorItemInfo("evaluTarget.targetID"));
        sic.add(new SelectorItemInfo("evaluTarget.targetType"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.id"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.name"));
        sic.add(new SelectorItemInfo("evaluTarget.seqNumber"));
        sic.add(new SelectorItemInfo("evaluTarget.solutionPeriod.id"));
        sic.add(new SelectorItemInfo("evaluTarget.dataPrecision"));
        sic.add(new SelectorItemInfo("evaluTarget.precisionType"));
        sic.add(new SelectorItemInfo("evaluTargetStoreType.id"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btn_addLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.contEvaluTarget.addButton((JButton)this.btn_addLine);
        this.btn_delLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.contEvaluTarget.addButton((JButton)this.btn_delLine);
        boolean flag = OprtState.VIEW.equals(this.getOprtState());
        this.btn_addLine.setEnabled(!flag);
        this.btn_delLine.setEnabled(!flag);
        this.btnSelectCopy.setEnabled(!flag);
        this.btnCopyColumn.setEnabled(!flag);
        this.btnReferDiathesis.setEnabled(!flag);
        this.btnReferPerform.setEnabled(!flag);
        this.btnReferWorkResponse.setEnabled(!flag);
        if (flag) {
            this.tblMain.getStyleAttributes().setLocked(true);
        }
    }

    private Set getSelectedRows() {
        ArrayList idList = (ArrayList)this.getUIContext().get("idList");
        HashSet<String> ids = new HashSet<String>();
        if (idList == null || idList.size() == 0) {
            return ids;
        }
        int n = idList.size();
        for (int i = 0; i < n; ++i) {
            ids.add(idList.get(i).toString());
        }
        return ids;
    }

    @Override
    protected void btn_addLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.addRow();
        TargetEvaluStoreInfo info = new TargetEvaluStoreInfo();
        EvaluTargetInfo evaluTargetInfo = new EvaluTargetInfo();
        if (this.isTargetTemplateMode() && this.targetTypeStoreList != null) {
            PerformTargetTypeInfo typeInfo;
            String selectedTypeID = this.getUIContext().get("selectedTypeID").toString();
            if (StringUtils.isEmpty((String)selectedTypeID)) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u6ca1\u6709\u6307\u5b9a\u6307\u6807\u7c7b\u578b\u3002");
                SysUtil.abort();
            }
            if ((typeInfo = PerformTargetTypeFactory.getRemoteInstance().getPerformTargetTypeInfo((IObjectPK)new ObjectUuidPK(selectedTypeID))) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u6ca1\u6709\u627e\u5230\u6240\u6307\u5b9a\u7684\u6307\u6807\u7c7b\u578b\u3002");
                SysUtil.abort();
            }
            evaluTargetInfo.setType(typeInfo);
            typeInfo.setName(typeInfo.getDisplayName());
            row.getCell("type").setValue((Object)typeInfo);
            int len = this.targetTypeStoreList.size();
            for (int i = 0; i < len; ++i) {
                if (!selectedTypeID.equals(this.targetTypeStoreList.get(i).get("type.id"))) continue;
                info.setEvaluTargetStoreType(this.targetTypeStoreList.get(i));
            }
        }
        if (this.creator == null) {
            this.creator = this.userInfo.getPerson();
        }
        row.getCell("creator").setValue((Object)this.creator);
        info.setCreator(this.userInfo);
        if (this.creatorPosition == null) {
            this.creatorPosition = PFUtils.getPositionReferToPerson(this.userInfo.getPerson());
        }
        row.getCell("creatorPosition").setValue((Object)this.creatorPosition);
        row.getCell("kind").setValue((Object)KindEnum.QUALITATIVE);
        evaluTargetInfo.setKind(KindEnum.QUALITATIVE);
        row.getCell("precisionType").setValue((Object)PrecisionTypeEnum.ROUND);
        evaluTargetInfo.setPrecisionType(PrecisionTypeEnum.ROUND);
        row.getCell("dataPrecision").setValue((Object)new Integer(2));
        evaluTargetInfo.setDataPrecision(2);
        Map evaluFormMap = (Map)this.getUIContext().get("evaluFormMap");
        this.tblMain.getColumn("dataPrecision").getStyleAttributes().setHided(true);
        if (evaluFormMap.get("dataPrecision") != null && ((EvaluFormSolutionEntryInfo)evaluFormMap.get("dataPrecision")).isVisible()) {
            this.tblMain.getColumn("dataPrecision").getStyleAttributes().setHided(false);
        }
        this.tblMain.getColumn("precisionType").getStyleAttributes().setHided(true);
        if (evaluFormMap.get("precisionType") != null && ((EvaluFormSolutionEntryInfo)evaluFormMap.get("precisionType")).isVisible()) {
            this.tblMain.getColumn("precisionType").getStyleAttributes().setHided(false);
        }
        info.setEvaluTarget(evaluTargetInfo);
        info.setUniteTarget(false);
        row.setUserObject((Object)info);
    }

    @Override
    protected void btn_delLine_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int[] rowID = KDTableUtil.getSelectedRows(this.tblMain);
        TargetEvaluStoreInfo info = null;
        IRow row = null;
        for (int i = rowID.length - 1; i >= 0; --i) {
            row = this.tblMain.removeRow(rowID[i]);
            info = (TargetEvaluStoreInfo)row.getUserObject();
            if (info.getId() == null) continue;
            this.outsideWeight = this.outsideWeight.add(info.getWeight());
        }
        this.initWeightState();
    }

    private void checkData() throws Exception {
        IRow row;
        boolean isControlWeight = ((SolutionPeriodInfo)this.getUIContext().get("solutionPeriod")).getEvaluSolution().isIsControlWeight();
        int rowEnd = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < rowEnd; ++rowIndex) {
            row = this.tblMain.getRow(rowIndex);
            if (row == null) continue;
            PFVerifyUtils.checkStringLength((Component)((Object)this), targetRes, row, "number", 44);
        }
        PFVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, "type");
        PFVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, "content");
        int n = this.tblMain.getRowCount();
        for (int i = 0; i <= n - 1; ++i) {
            row = this.tblMain.getRow(i);
            BigDecimal weight = (BigDecimal)row.getCell("weight").getValue();
            if (weight == null) {
                this.tblMain.getEditManager().editCellAt(row.getRowIndex(), row.getCell("weight").getColumnIndex());
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"targetWeightNotAllowNull"));
                SysUtil.abort();
            }
            if ((weight = weight.setScale(2, 4)).equals(new BigDecimal("0.00"))) {
                this.tblMain.getEditManager().editCellAt(row.getRowIndex(), row.getCell("weight").getColumnIndex());
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"targetWeigthLargeThanZero"));
                SysUtil.abort();
            }
            if (isControlWeight || weight.compareTo(new BigDecimal("100.00")) <= 0) continue;
            this.tblMain.getEditManager().editCellAt(row.getRowIndex(), row.getCell("weight").getColumnIndex());
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"targetWeigthLargeThanHundred"));
            SysUtil.abort();
        }
        if (this.totalWeight.compareTo(PerfClientUtils.HUNDRED) > 0 && !isControlWeight) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"targetWeigthLargeThanHundred"));
            SysUtil.abort();
        }
        if (this.isTargetTemplateMode()) {
            this.checkSumWeightByTypeStore();
        }
        PFVerifyUtils.verifyInput((CoreUIObject)this, this.tblMain, "kind");
        ArrayList<String> list = new ArrayList<String>();
        int n2 = this.tblMain.getRowCount();
        for (int i = 0; i < n2; ++i) {
            FormulaInfo fmInfo = (FormulaInfo)this.tblMain.getCell(i, "calFormula").getValue();
            if (fmInfo == null) continue;
            list.add(fmInfo.getId().toString());
        }
        SolutionPeriodInfo spInfo = (SolutionPeriodInfo)this.getUIContext().get("solutionPeriod");
        boolean b = AchieveDataHelper.verifyFormulaCloneOnSaveTarget(null, list, spInfo.getId().toString());
        if (!b) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"formula_entry_period_error"));
            SysUtil.abort();
        }
    }

    private void checkSumWeightByTypeStore() throws BOSException {
        BigDecimal sumWeightByType;
        String typeStoreID;
        TargetEvaluStoreInfo info;
        HashSet<String> editIds = new HashSet<String>();
        HashMap<String, BigDecimal> sumWeightMap = new HashMap<String, BigDecimal>();
        int len = this.tblMain.getRowCount();
        for (int i = 0; i < len; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getUserObject() == null || !(row.getUserObject() instanceof TargetEvaluStoreInfo)) continue;
            info = (TargetEvaluStoreInfo)row.getUserObject();
            info.setWeight((BigDecimal)row.getCell("weight").getValue());
            if (info.getId() != null) {
                editIds.add(info.getId().toString());
            }
            if (sumWeightMap.get(typeStoreID = info.getEvaluTargetStoreType().getId().toString()) == null) {
                sumWeightMap.put(typeStoreID, new BigDecimal("0.00"));
            }
            sumWeightByType = (BigDecimal)sumWeightMap.get(typeStoreID);
            sumWeightByType = sumWeightByType.add(info.getWeight());
            sumWeightMap.put(typeStoreID, sumWeightByType);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        HashSet<BOSUuid> storeIdSet = new HashSet<BOSUuid>();
        int len2 = this.targetTypeStoreList.size();
        for (int i = 0; i < len2; ++i) {
            storeIdSet.add(this.targetTypeStoreList.get(i).getId());
        }
        if (storeIdSet != null && storeIdSet.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("evaluTargetStoreType.id", storeIdSet, CompareType.INCLUDE));
        }
        if (editIds != null && editIds.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("id", editIds, CompareType.NOTINCLUDE));
        }
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("weight"));
        evi.getSelector().add(new SelectorItemInfo("evaluTargetStoreType.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTargetStoreType.evaluGroupTargetType.id"));
        evi.getSelector().add(new SelectorItemInfo("evaluTargetStoreType.evaluGroupTargetType.weight"));
        TargetEvaluStoreCollection storeColl = TargetEvaluStoreFactory.getRemoteInstance().getTargetEvaluStoreCollection(evi);
        int len3 = storeColl.size();
        for (int i = 0; i < len3; ++i) {
            info = storeColl.get(i);
            typeStoreID = info.getEvaluTargetStoreType().getId().toString();
            if (sumWeightMap.get(typeStoreID) == null) {
                sumWeightMap.put(typeStoreID, new BigDecimal("0.00"));
            }
            sumWeightByType = (BigDecimal)sumWeightMap.get(typeStoreID);
            sumWeightByType = sumWeightByType.add(info.getWeight());
            sumWeightMap.put(typeStoreID, sumWeightByType);
        }
        Iterator iterator = sumWeightMap.keySet().iterator();
        HashSet<String> sumWeightLarger = new HashSet<String>();
        HashMap<String, Object> typeWeight = new HashMap<String, Object>();
        int len4 = this.targetTypeStoreList.size();
        for (int i = 0; i < len4; ++i) {
            typeWeight.put(this.targetTypeStoreList.get(i).getId().toString(), this.targetTypeStoreList.get(i).get("typeWeight"));
        }
        while (iterator.hasNext()) {
            typeStoreID = iterator.next().toString();
            sumWeightByType = (BigDecimal)sumWeightMap.get(typeStoreID);
            if (sumWeightByType == null || sumWeightByType.compareTo((BigDecimal)typeWeight.get(typeStoreID)) <= 0) continue;
            sumWeightLarger.add(typeStoreID);
        }
        if (sumWeightLarger.size() > 0) {
            Iterator iterator2 = sumWeightLarger.iterator();
            StringBuffer msg = new StringBuffer();
            msg.append("\u6307\u6807\u7c7b\u578b ");
            while (iterator2.hasNext()) {
                typeStoreID = iterator2.next().toString();
                int len5 = this.targetTypeStoreList.size();
                for (int i = 0; i < len5; ++i) {
                    if (!this.targetTypeStoreList.get(i).getId().toString().equals(typeStoreID)) continue;
                    msg.append(this.targetTypeStoreList.get(i).get("type.displayName")).append(",");
                }
            }
            msg.deleteCharAt(msg.length() - 1);
            msg.append(" \u4e0b\u7684\u6307\u6807\u6743\u91cd\u548c\u8d85\u8fc7\u4e86\u6307\u6807\u7c7b\u578b\u6743\u91cd\uff0c\u8bf7\u8c03\u6574\u3002");
            MsgBox.showInfo((String)msg.toString());
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            PerfUtils.promptInfo(RES, "noRecord");
            return;
        }
        this.checkData();
        this.storeData();
        this.setTBAutoFitRowHeight();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"evaluTargetStoreSaveSuccess"));
        this.setSave(true);
        this.setSaved(true);
    }

    private void storeData() throws Exception {
        TargetEvaluStoreCollection targetEvaluStoreColls = null;
        TargetEvaluStoreCollection uniteTarget = null;
        EvaluObjectInfo evaluObj = this.getCurrentEvaluObject();
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.getUIContext().get("solutionPeriod");
        targetEvaluStoreColls = new TargetEvaluStoreCollection();
        uniteTarget = new TargetEvaluStoreCollection();
        int n = this.tblMain.getRowCount();
        for (int i = 0; i <= n - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            TargetEvaluStoreInfo info = this.storeRowInfo(row);
            if (info == null) {
                info = new TargetEvaluStoreInfo();
                info.setCreator(this.userInfo);
            }
            if (info.isUniteTarget()) {
                uniteTarget.add(info);
                continue;
            }
            info.setSolutionPeriod(solutionPeriodInfo);
            info.setEvaluObject(evaluObj);
            info.setWeight((BigDecimal)row.getCell("weight").getValue());
            info.setHrOrgUnit(this.hrOrgUntiInfo);
            targetEvaluStoreColls.add(info);
        }
        ITargetEvaluStore iTargetEvaluStore = TargetEvaluStoreFactory.getRemoteInstance();
        if (targetEvaluStoreColls != null && targetEvaluStoreColls.size() > 0) {
            targetEvaluStoreColls = (TargetEvaluStoreCollection)iTargetEvaluStore.batchSubmit(targetEvaluStoreColls);
        }
        if (uniteTarget != null && uniteTarget.size() > 0) {
            if ("person".equals(this.getEvaluStoreType())) {
                iTargetEvaluStore.updateTargetValue(uniteTarget, "person");
            } else {
                iTargetEvaluStore.updateTargetValue(uniteTarget, "org");
            }
        }
        this.tblMain.removeRows();
        targetEvaluStoreColls.addCollection(uniteTarget);
        this.putDataToTable(targetEvaluStoreColls);
    }

    private TargetEvaluStoreInfo storeRowInfo(IRow row) {
        TargetEvaluStoreInfo info = (TargetEvaluStoreInfo)row.getUserObject();
        this.saveData(row, info);
        return info;
    }

    protected abstract String getCurrentEvaluObjectId();

    protected EvaluObjectInfo getCurrentEvaluObject() throws Exception {
        String objectID = this.getCurrentEvaluObjectId();
        EvaluSolutionInfo solutionInfo = (EvaluSolutionInfo)this.getUIContext().get("PF_EvaluSolution");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("objectID", (Object)objectID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)solutionInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        EvaluObjectInfo ret = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add("id");
        sic.add("name");
        sic.add("objectID");
        sic.add("responser.id");
        sic.add("responser.name");
        CoreBaseCollection coll = EvaluObjectFactory.getRemoteInstance().getCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            ret = (EvaluObjectInfo)coll.get(0);
        }
        if (ret == null) {
            String msg = null;
            msg = this.getEvaluStoreType().equals("person") ? EASResource.getString((String)RES, (String)"soultionPeriodSutiablePerson") : EASResource.getString((String)RES, (String)"soultionPeriodSutiableOrg");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        return ret;
    }

    private void saveData(IRow row, TargetEvaluStoreInfo info) {
        BigDecimal value;
        EvaluTargetInfo evaluTargetInfo = info.getEvaluTarget();
        if (row.getCell("type").getValue() != null) {
            evaluTargetInfo.setType((PerformTargetTypeInfo)row.getCell("type").getValue());
        } else {
            evaluTargetInfo.setType(null);
        }
        Object number = row.getCell("number").getValue();
        if (number != null) {
            evaluTargetInfo.setNumber(number.toString().trim());
        } else {
            evaluTargetInfo.setNumber(null);
        }
        Object content = row.getCell("content").getValue();
        if (content != null) {
            evaluTargetInfo.setContent(content.toString().trim());
        } else {
            evaluTargetInfo.setContent(null);
        }
        if (row.getCell("description").getValue() != null) {
            evaluTargetInfo.setDescription(row.getCell("description").getValue().toString().trim());
        } else {
            evaluTargetInfo.setDescription(null);
        }
        if (row.getCell("standard").getValue() != null) {
            evaluTargetInfo.setStandard(row.getCell("standard").getValue().toString().trim());
        } else {
            evaluTargetInfo.setStandard(null);
        }
        evaluTargetInfo.setKind((KindEnum)((Object)row.getCell("kind").getValue()));
        if (row.getCell("scoringMethod").getValue() != null) {
            evaluTargetInfo.setScoringMethod(row.getCell("scoringMethod").getValue().toString().trim());
        } else {
            evaluTargetInfo.setScoringMethod(null);
        }
        if (row.getCell("dataPrecision").getValue() != null) {
            evaluTargetInfo.setDataPrecision(Integer.valueOf(row.getCell("dataPrecision").getValue().toString()));
        } else {
            evaluTargetInfo.setDataPrecision(2);
        }
        if (row.getCell("precisionType").getValue() != null) {
            evaluTargetInfo.setPrecisionType((PrecisionTypeEnum)((Object)row.getCell("precisionType").getValue()));
        } else {
            evaluTargetInfo.setPrecisionType(null);
        }
        boolean isPercent = KindEnum.QUANTITATIVE2.equals((Object)((KindEnum)((Object)row.getCell("kind").getValue())));
        BigDecimal per = new BigDecimal("0.01");
        if (row.getCell("thresholdValue").getValue() != null) {
            value = new BigDecimal(row.getCell("thresholdValue").getValue().toString());
            if (isPercent) {
                value = value.multiply(per);
            }
            info.setThresholdValue(value);
        } else {
            info.setThresholdValue(null);
        }
        if (row.getCell("standardValue").getValue() != null) {
            value = new BigDecimal(row.getCell("standardValue").getValue().toString());
            if (isPercent) {
                value = value.multiply(per);
            }
            info.setStandardValue(value);
        } else {
            info.setStandardValue(null);
        }
        if (row.getCell("challengeValue").getValue() != null) {
            value = new BigDecimal(row.getCell("challengeValue").getValue().toString());
            if (isPercent) {
                value = value.multiply(per);
            }
            info.setChallengeValue(value);
        } else {
            info.setChallengeValue(null);
        }
        if (row.getCell("reservedField2").getValue() != null) {
            value = new BigDecimal(row.getCell("reservedField2").getValue().toString());
            if (isPercent) {
                value = value.multiply(per);
            }
            evaluTargetInfo.setReservedField2(value);
        } else {
            evaluTargetInfo.setReservedField2(null);
        }
        if (row.getCell("unit").getValue() != null) {
            evaluTargetInfo.setUnit(row.getCell("unit").getValue().toString());
        } else {
            evaluTargetInfo.setUnit(null);
        }
        if (row.getCell("reportFrequency") != null) {
            evaluTargetInfo.setReportFrequency((ReportFrequencyEnum)((Object)row.getCell("reportFrequency").getValue()));
        } else {
            evaluTargetInfo.setReportFrequency(ReportFrequencyEnum.NULL);
        }
        if (row.getCell("evaluationSide").getValue() != null) {
            evaluTargetInfo.setEvaluationSide(row.getCell("evaluationSide").getValue().toString().trim());
        } else {
            evaluTargetInfo.setEvaluationSide(null);
        }
        if (row.getCell("reservedField1").getValue() != null) {
            evaluTargetInfo.setReservedField1(row.getCell("reservedField1").getValue().toString().trim());
        } else {
            evaluTargetInfo.setReservedField1(null);
        }
        if (row.getCell("calFormula").getValue() != null) {
            evaluTargetInfo.setFormula((FormulaInfo)row.getCell("calFormula").getValue());
        } else {
            evaluTargetInfo.setFormula(null);
        }
        evaluTargetInfo.setSolutionPeriod((SolutionPeriodInfo)this.getUIContext().get("solutionPeriod"));
    }

    @Override
    public void actionSelectCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked() || this.tblMain.getCell(row, column).getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                    if (this.tblMain.getCell(j, column).getStyleAttributes().isLocked()) continue;
                    this.tblMain.getCell(j, column).setValue(value);
                }
            }
        }
    }

    @Override
    public void actionCopyColumn_actionPerformed(ActionEvent e) throws Exception {
        Map evaluFormMap = (Map)this.getUIContext().get("evaluFormMap");
        EvaluFormSolutionEntryInfo _dataPrecision = (EvaluFormSolutionEntryInfo)evaluFormMap.get("dataPrecision");
        EvaluFormSolutionEntryInfo _precisionType = (EvaluFormSolutionEntryInfo)evaluFormMap.get("precisionType");
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked() || iColumn.getStyleAttributes().isHided()) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            int length = this.tblMain.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row) continue;
                this.tblMain.getCell(i, column).setValue(value);
            }
            if (_dataPrecision != null && _precisionType != null) {
                this.tblMain.getColumn("dataPrecision").getStyleAttributes().setHided(!_dataPrecision.isVisible());
                this.tblMain.getColumn("precisionType").getStyleAttributes().setHided(!_precisionType.isVisible());
            }
        }
    }

    private void fillTable(TargetEvaluStoreInfo storeInfo) throws Exception {
        String[] columnName;
        if (storeInfo == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        row.setUserObject((Object)storeInfo);
        boolean isAllowModifyTargetValue = ((SolutionPeriodInfo)this.getUIContext().get("solutionPeriod")).getEvaluSolution().isAllowModifyTargetValue();
        if (!storeInfo.isUniteTarget()) {
            this.allfiledIsEnable();
        } else if (isAllowModifyTargetValue) {
            this.tblMain.getColumn("thresholdValue").getStyleAttributes().setLocked(false);
            this.tblMain.getColumn("standardValue").getStyleAttributes().setLocked(false);
            this.tblMain.getColumn("challengeValue").getStyleAttributes().setLocked(false);
            this.tblMain.getColumn("type").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("content").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("weight").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("description").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("standard").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("kind").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("unit").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("calFormula").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("reportFrequency").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("scoringMethod").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("evaluationSide").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("reservedField1").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("reservedField2").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("creator").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("creatorPosition").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("dataPrecision").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("precisionType").getStyleAttributes().setLocked(true);
            this.btnReferPerform.setEnabled(false);
            this.btnReferDiathesis.setEnabled(false);
            this.actionAddNew.setEnabled(false);
            this.actionReferWorkResponse.setEnabled(false);
            this.btn_addLine.setEnabled(false);
        } else {
            this.tblMain.getColumn("thresholdValue").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("standardValue").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("challengeValue").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("type").getStyleAttributes().setLocked(this.isTargetTemplateMode());
            this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("content").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("weight").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("description").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("standard").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("kind").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("unit").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("calFormula").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("reportFrequency").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("scoringMethod").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("evaluationSide").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("reservedField1").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("reservedField2").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("creator").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("creatorPosition").getStyleAttributes().setLocked(true);
        }
        EvaluTargetInfo evaluTargetInfo = storeInfo.getEvaluTarget();
        PerformTargetTypeInfo targetType = evaluTargetInfo.getType();
        if (targetType != null && targetType.getDisplayName() != null) {
            targetType.setName(targetType.getDisplayName());
        }
        row.getCell("type").setValue((Object)targetType);
        row.getCell("number").setValue((Object)evaluTargetInfo.getNumber());
        row.getCell("content").setValue((Object)evaluTargetInfo.getContent());
        row.getCell("standard").setValue((Object)evaluTargetInfo.getStandard());
        row.getCell("description").setValue((Object)evaluTargetInfo.getDescription());
        row.getCell("dataPrecision").setValue((Object)new Integer(evaluTargetInfo.getDataPrecision()));
        row.getCell("precisionType").setValue((Object)evaluTargetInfo.getPrecisionType());
        row.getCell("kind").setValue((Object)evaluTargetInfo.getKind());
        boolean isPercent = KindEnum.QUANTITATIVE2.equals((Object)evaluTargetInfo.getKind());
        BigDecimal per = new BigDecimal("100.00");
        int dataPrecision = evaluTargetInfo.getDataPrecision();
        String precision = PFUtils.getNumberFormat(dataPrecision);
        DecimalFormat df = new DecimalFormat(precision);
        BigDecimal value = null;
        if (PrecisionTypeEnum.ROUND.equals((Object)evaluTargetInfo.getPrecisionType())) {
            if (KindEnum.QUANTITATIVE2.equals((Object)evaluTargetInfo.getKind())) {
                if (storeInfo.getThresholdValue() != null) {
                    value = new BigDecimal(storeInfo.getThresholdValue().multiply(per).toString()).setScale(dataPrecision, 4);
                    row.getCell("thresholdValue").setValue((Object)df.format(value));
                }
                if (storeInfo.getStandardValue() != null) {
                    value = new BigDecimal(storeInfo.getStandardValue().multiply(per).toString()).setScale(dataPrecision, 4);
                    row.getCell("standardValue").setValue((Object)df.format(value));
                }
                if (storeInfo.getChallengeValue() != null) {
                    value = new BigDecimal(storeInfo.getChallengeValue().multiply(per).toString()).setScale(dataPrecision, 4);
                    row.getCell("challengeValue").setValue((Object)df.format(value));
                }
                if (evaluTargetInfo.getReservedField2() != null) {
                    df = new DecimalFormat("0.00");
                    dataPrecision = 2;
                    value = new BigDecimal(evaluTargetInfo.getReservedField2().multiply(per).toString()).setScale(dataPrecision, 4);
                    row.getCell("reservedField2").setValue((Object)df.format(value));
                }
                columnName = new String[]{"thresholdValue", "standardValue", "challengeValue", "reservedField2"};
                defRender = row.getCell("thresholdValue").getRenderer();
                PerformItemHelper.setRender(row, columnName, new PercentRender());
            } else {
                if (storeInfo.getThresholdValue() != null) {
                    value = new BigDecimal(storeInfo.getThresholdValue().toString()).setScale(dataPrecision, 4);
                    row.getCell("thresholdValue").setValue((Object)df.format(value));
                }
                if (storeInfo.getStandardValue() != null) {
                    value = new BigDecimal(storeInfo.getStandardValue().toString()).setScale(dataPrecision, 4);
                    row.getCell("standardValue").setValue((Object)df.format(value));
                }
                if (storeInfo.getChallengeValue() != null) {
                    value = new BigDecimal(storeInfo.getChallengeValue().toString()).setScale(dataPrecision, 4);
                    row.getCell("challengeValue").setValue((Object)df.format(value));
                }
                if (evaluTargetInfo.getReservedField2() != null) {
                    df = new DecimalFormat("0.00");
                    dataPrecision = 2;
                    value = new BigDecimal(evaluTargetInfo.getReservedField2().toString()).setScale(dataPrecision, 4);
                    row.getCell("reservedField2").setValue((Object)df.format(value));
                }
                defRender = row.getCell("thresholdValue").getRenderer();
            }
        } else if (PrecisionTypeEnum.CARRY.equals((Object)evaluTargetInfo.getPrecisionType())) {
            if (KindEnum.QUANTITATIVE2.equals((Object)evaluTargetInfo.getKind())) {
                if (storeInfo.getThresholdValue() != null) {
                    value = new BigDecimal(storeInfo.getThresholdValue().multiply(per).toString()).setScale(dataPrecision, 0);
                    row.getCell("thresholdValue").setValue((Object)df.format(value));
                }
                if (storeInfo.getStandardValue() != null) {
                    value = new BigDecimal(storeInfo.getStandardValue().multiply(per).toString()).setScale(dataPrecision, 0);
                    row.getCell("standardValue").setValue((Object)df.format(value));
                }
                if (storeInfo.getChallengeValue() != null) {
                    value = new BigDecimal(storeInfo.getChallengeValue().multiply(per).toString()).setScale(dataPrecision, 0);
                    row.getCell("challengeValue").setValue((Object)df.format(value));
                }
                if (evaluTargetInfo.getReservedField2() != null) {
                    df = new DecimalFormat("0.00");
                    dataPrecision = 2;
                    value = new BigDecimal(evaluTargetInfo.getReservedField2().multiply(per).toString()).setScale(dataPrecision, 0);
                    row.getCell("reservedField2").setValue((Object)df.format(value));
                }
                columnName = new String[]{"thresholdValue", "standardValue", "challengeValue", "reservedField2"};
                defRender = row.getCell("thresholdValue").getRenderer();
                PerformItemHelper.setRender(row, columnName, new PercentRender());
            } else {
                if (storeInfo.getThresholdValue() != null) {
                    value = new BigDecimal(storeInfo.getThresholdValue().toString()).setScale(dataPrecision, 0);
                    row.getCell("thresholdValue").setValue((Object)df.format(value));
                }
                if (storeInfo.getStandardValue() != null) {
                    value = new BigDecimal(storeInfo.getStandardValue().toString()).setScale(dataPrecision, 0);
                    row.getCell("standardValue").setValue((Object)df.format(value));
                }
                if (storeInfo.getChallengeValue() != null) {
                    value = new BigDecimal(storeInfo.getChallengeValue().toString()).setScale(dataPrecision, 0);
                    row.getCell("challengeValue").setValue((Object)df.format(value));
                }
                if (evaluTargetInfo.getReservedField2() != null) {
                    df = new DecimalFormat("0.00");
                    dataPrecision = 2;
                    value = new BigDecimal(evaluTargetInfo.getReservedField2().toString()).setScale(dataPrecision, 0);
                    row.getCell("reservedField2").setValue((Object)df.format(value));
                }
                defRender = row.getCell("thresholdValue").getRenderer();
            }
        } else if (KindEnum.QUANTITATIVE2.equals((Object)evaluTargetInfo.getKind())) {
            if (storeInfo.getThresholdValue() != null) {
                value = new BigDecimal(storeInfo.getThresholdValue().multiply(per).toString()).setScale(dataPrecision, 1);
                row.getCell("thresholdValue").setValue((Object)df.format(value));
            }
            if (storeInfo.getStandardValue() != null) {
                value = new BigDecimal(storeInfo.getStandardValue().multiply(per).toString()).setScale(dataPrecision, 1);
                row.getCell("standardValue").setValue((Object)df.format(value));
            }
            if (storeInfo.getChallengeValue() != null) {
                value = new BigDecimal(storeInfo.getChallengeValue().multiply(per).toString()).setScale(dataPrecision, 1);
                row.getCell("challengeValue").setValue((Object)df.format(value));
            }
            if (evaluTargetInfo.getReservedField2() != null) {
                df = new DecimalFormat("0.00");
                dataPrecision = 2;
                value = new BigDecimal(evaluTargetInfo.getReservedField2().multiply(per).toString()).setScale(dataPrecision, 1);
                row.getCell("reservedField2").setValue((Object)df.format(value));
            }
            columnName = new String[]{"thresholdValue", "standardValue", "challengeValue", "reservedField2"};
            defRender = row.getCell("thresholdValue").getRenderer();
            PerformItemHelper.setRender(row, columnName, new PercentRender());
        } else {
            if (storeInfo.getThresholdValue() != null) {
                value = new BigDecimal(storeInfo.getThresholdValue().toString()).setScale(dataPrecision, 1);
                row.getCell("thresholdValue").setValue((Object)df.format(value));
            }
            if (storeInfo.getStandardValue() != null) {
                value = new BigDecimal(storeInfo.getStandardValue().toString()).setScale(dataPrecision, 1);
                row.getCell("standardValue").setValue((Object)df.format(value));
            }
            if (storeInfo.getChallengeValue() != null) {
                value = new BigDecimal(storeInfo.getChallengeValue().toString()).setScale(dataPrecision, 1);
                row.getCell("challengeValue").setValue((Object)df.format(value));
            }
            if (evaluTargetInfo.getReservedField2() != null) {
                df = new DecimalFormat("0.00");
                dataPrecision = 2;
                value = new BigDecimal(evaluTargetInfo.getReservedField2().toString()).setScale(dataPrecision, 1);
                row.getCell("reservedField2").setValue((Object)df.format(value));
            }
            defRender = row.getCell("thresholdValue").getRenderer();
        }
        row.getCell("unit").setValue((Object)evaluTargetInfo.getUnit());
        row.getCell("scoringMethod").setValue((Object)evaluTargetInfo.getScoringMethod());
        row.getCell("reportFrequency").setValue((Object)evaluTargetInfo.getReportFrequency());
        row.getCell("evaluationSide").setValue((Object)evaluTargetInfo.getEvaluationSide());
        row.getCell("reservedField1").setValue((Object)evaluTargetInfo.getReservedField1());
        row.getCell("weight").setValue((Object)storeInfo.getWeight());
        if (storeInfo.getCreator() != null) {
            PersonInfo perInfo = storeInfo.getCreator().getPerson();
            row.getCell("creator").setValue((Object)perInfo);
            row.getCell("creatorPosition").setValue((Object)PFUtils.getPositionReferToPerson(perInfo));
        } else {
            if (this.creator == null) {
                this.creator = this.userInfo.getPerson();
            }
            row.getCell("creator").setValue((Object)this.creator);
            if (this.creatorPosition == null) {
                this.creatorPosition = PFUtils.getPositionReferToPerson(this.creator);
            }
            row.getCell("creatorPosition").setValue((Object)this.creatorPosition);
        }
        if (evaluTargetInfo.getFormula() != null) {
            row.getCell("calFormula").setValue((Object)evaluTargetInfo.getFormula());
        }
    }

    private TargetEvaluStoreInfo assembleTargetEvaluStoreInfo(PerformTargetItemInfo itemInfo) {
        if (itemInfo == null) {
            return null;
        }
        TargetEvaluStoreInfo info = new TargetEvaluStoreInfo();
        EvaluTargetInfo targetInfo = new EvaluTargetInfo();
        info.setEvaluTarget(targetInfo);
        targetInfo.setType(itemInfo.getType());
        if (itemInfo.getType() != null && this.isTargetTemplateMode() && this.targetTypeStoreList != null) {
            int len = this.targetTypeStoreList.size();
            for (int i = 0; i < len; ++i) {
                if (!itemInfo.getType().getId().toString().equals(this.targetTypeStoreList.get(i).get("type.id"))) continue;
                info.setEvaluTargetStoreType(this.targetTypeStoreList.get(i));
            }
        }
        targetInfo.setNumber(itemInfo.getNumber());
        targetInfo.setContent(itemInfo.getContent());
        targetInfo.setStandard(itemInfo.getStandard());
        targetInfo.setDescription(itemInfo.getDescription());
        targetInfo.setKind(itemInfo.getKind());
        targetInfo.setThresholdValue(info.getThresholdValue());
        targetInfo.setStandardValue(info.getStandardValue());
        targetInfo.setChallengeValue(info.getChallengeValue());
        targetInfo.setUnit(itemInfo.getUnit());
        targetInfo.setScoringMethod(itemInfo.getScoringMethod());
        targetInfo.setReportFrequency(itemInfo.getReportFrequency());
        targetInfo.setEvaluationSide(itemInfo.getEvaluationSide());
        targetInfo.setReservedField1(itemInfo.getReservedField1());
        targetInfo.setReservedField2(itemInfo.getReservedField2());
        targetInfo.setFormula(itemInfo.getFormula());
        targetInfo.setDataPrecision(itemInfo.getDataPrecision());
        targetInfo.setPrecisionType(itemInfo.getPrecisionType());
        info.setUniteTarget(false);
        info.setCreator(this.userInfo);
        return info;
    }

    @Override
    public void actionReferPerform_actionPerformed(ActionEvent e) throws Exception {
        PerformanceTargetPromptBox targetTypeBox = new PerformanceTargetPromptBox((IUIObject)this);
        if (this.isTargetTemplateMode() && this.targetTypeStoreList != null && this.targetTypeStoreList.size() > 0) {
            String selectedTypeID = this.getUIContext().get("selectedTypeID").toString();
            HashSet<String> typeSet = new HashSet<String>();
            typeSet.add(selectedTypeID);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", typeSet, CompareType.INCLUDE));
            targetTypeBox.setTargetTypeFilterInfo(fi);
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("type.id", typeSet, CompareType.INCLUDE));
            targetTypeBox.setTargetItemFilterInfo(fi);
        }
        targetTypeBox.show();
        Object[] targets = (Object[])targetTypeBox.getData();
        if (targets == null || targets.length == 0) {
            return;
        }
        int n = targets.length;
        for (int i = 0; i < n; ++i) {
            PerformTargetItemInfo itemInfo = (PerformTargetItemInfo)targets[i];
            TargetEvaluStoreInfo storeInfo = this.assembleTargetEvaluStoreInfo(itemInfo);
            this.fillTable(storeInfo);
        }
        this.setTBAutoFitRowHeight();
    }

    private TargetEvaluStoreInfo assembleTargetEvaluStoreInfo(CompetenceIndexInfo itemInfo) throws EASBizException, BOSException {
        if (itemInfo == null) {
            return null;
        }
        TargetEvaluStoreInfo info = new TargetEvaluStoreInfo();
        EvaluTargetInfo targetInfo = new EvaluTargetInfo();
        if (this.isTargetTemplateMode() && this.targetTypeStoreList != null) {
            PerformTargetTypeInfo typeInfo;
            String selectedTypeID = this.getUIContext().get("selectedTypeID").toString();
            if (StringUtils.isEmpty((String)selectedTypeID)) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u6ca1\u6709\u6307\u5b9a\u6307\u6807\u7c7b\u578b\u3002");
                SysUtil.abort();
            }
            if ((typeInfo = PerformTargetTypeFactory.getRemoteInstance().getPerformTargetTypeInfo((IObjectPK)new ObjectUuidPK(selectedTypeID))) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u6ca1\u6709\u627e\u5230\u6240\u6307\u5b9a\u7684\u6307\u6807\u7c7b\u578b\u3002");
                SysUtil.abort();
            }
            targetInfo.setType(typeInfo);
            int len = this.targetTypeStoreList.size();
            for (int i = 0; i < len; ++i) {
                if (!selectedTypeID.equals(this.targetTypeStoreList.get(i).get("type.id"))) continue;
                info.setEvaluTargetStoreType(this.targetTypeStoreList.get(i));
            }
        }
        info.setEvaluTarget(targetInfo);
        targetInfo.setNumber(itemInfo.getNumber());
        targetInfo.setContent(itemInfo.getName());
        targetInfo.setDescription(itemInfo.getDescription());
        targetInfo.setKind(KindEnum.QUALITATIVE);
        targetInfo.setDataPrecision(2);
        targetInfo.setPrecisionType(PrecisionTypeEnum.ROUND);
        info.setUniteTarget(false);
        info.setCreator(this.userInfo);
        return info;
    }

    @Override
    public void actionReferDiathesis_actionPerformed(ActionEvent e) throws Exception {
        CompetModelF7PromptBox prmptTargetType = new CompetModelF7PromptBox((IUIObject)this);
        prmptTargetType.show();
        Object[] targets = (Object[])prmptTargetType.getData();
        if (targets == null || targets.length == 0) {
            return;
        }
        int n = targets.length;
        for (int i = 0; i < n; ++i) {
            CompetenceIndexInfo itemInfo = (CompetenceIndexInfo)targets[i];
            TargetEvaluStoreInfo storeInfo = this.assembleTargetEvaluStoreInfo(itemInfo);
            this.fillTable(storeInfo);
        }
        this.setTBAutoFitRowHeight();
    }

    private TargetEvaluStoreInfo assembleTargetEvaluStoreInfo(ResponsibilityInfo itemInfo) throws EASBizException, BOSException {
        if (itemInfo == null) {
            return null;
        }
        TargetEvaluStoreInfo info = new TargetEvaluStoreInfo();
        EvaluTargetInfo targetInfo = new EvaluTargetInfo();
        if (this.isTargetTemplateMode() && this.targetTypeStoreList != null) {
            PerformTargetTypeInfo typeInfo;
            String selectedTypeID = this.getUIContext().get("selectedTypeID").toString();
            if (StringUtils.isEmpty((String)selectedTypeID)) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u6ca1\u6709\u6307\u5b9a\u6307\u6807\u7c7b\u578b\u3002");
                SysUtil.abort();
            }
            if ((typeInfo = PerformTargetTypeFactory.getRemoteInstance().getPerformTargetTypeInfo((IObjectPK)new ObjectUuidPK(selectedTypeID))) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u6ca1\u6709\u627e\u5230\u6240\u6307\u5b9a\u7684\u6307\u6807\u7c7b\u578b\u3002");
                SysUtil.abort();
            }
            targetInfo.setType(typeInfo);
            int len = this.targetTypeStoreList.size();
            for (int i = 0; i < len; ++i) {
                if (!selectedTypeID.equals(this.targetTypeStoreList.get(i).get("type.id"))) continue;
                info.setEvaluTargetStoreType(this.targetTypeStoreList.get(i));
            }
        } else {
            info.setEvaluTargetStoreType(this.targetTypeStoreList.get(0));
        }
        info.setEvaluTarget(targetInfo);
        targetInfo.setNumber(itemInfo.getNumber());
        targetInfo.setContent(itemInfo.getName());
        targetInfo.setDescription(itemInfo.getDescription());
        targetInfo.setKind(KindEnum.QUALITATIVE);
        targetInfo.setDataPrecision(2);
        targetInfo.setPrecisionType(PrecisionTypeEnum.ROUND);
        info.setUniteTarget(false);
        info.setCreator(this.userInfo);
        return info;
    }

    @Override
    public void actionReferWorkResponse_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        Object obj = this.getUIContext().get("PF_EvaluObject");
        EvalWFObjectsInfo info = (EvalWFObjectsInfo)obj;
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)info.getEvaluObject().getObjectID()));
        PositionInfo position = null;
        position = PFUtils.getPositionReferToPerson(person);
        uiContext.put((Object)"position", (Object)position);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(PositionRespListUI.class.getName(), (Map)uiContext);
        PositionRespListUI userUI = (PositionRespListUI)window.getUIObject();
        window.show();
        ResponsibilityCollection coll = userUI.getSelectedResp();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            ResponsibilityInfo itemInfo = coll.get(i);
            TargetEvaluStoreInfo storeInfo = this.assembleTargetEvaluStoreInfo(itemInfo);
            this.fillTable(storeInfo);
        }
        this.setTBAutoFitRowHeight();
    }

    public void onShow() throws Exception {
        super.onShow();
        EvaluFormSolutionUIHelper.setTableDisplay((Map)this.getUIContext().get("evaluFormMap"), this.tblMain, true);
        this.setTBAutoFitRowHeight();
    }

    private void setTBAutoFitRowHeight() {
        Map evaluFormMap = (Map)this.getUIContext().get("evaluFormMap");
        int k = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < k; ++rowIndex) {
            KDTableHelper.autoFitRowHeight((KDTable)this.tblMain, (int)rowIndex, (int)0);
            this.tblMain.getColumn("dataPrecision").getStyleAttributes().setHided(true);
            if (evaluFormMap.get("dataPrecision") != null && ((EvaluFormSolutionEntryInfo)evaluFormMap.get("dataPrecision")).isVisible()) {
                this.tblMain.getColumn("dataPrecision").getStyleAttributes().setHided(false);
            }
            this.tblMain.getColumn("precisionType").getStyleAttributes().setHided(true);
            if (evaluFormMap.get("precisionType") == null || !((EvaluFormSolutionEntryInfo)evaluFormMap.get("precisionType")).isVisible()) continue;
            this.tblMain.getColumn("precisionType").getStyleAttributes().setHided(false);
        }
    }

    private void tblMain_propertyChange(KDTPropertyChangeEvent evt) {
        if (evt.getType() == 0) {
            return;
        }
        int rowIndex = evt.getRowIndex();
        int colIndex = evt.getColIndex();
        Map evaluFormMap = (Map)this.getUIContext().get("evaluFormMap");
        EvaluFormSolutionEntryInfo _dataPrecision = (EvaluFormSolutionEntryInfo)evaluFormMap.get("dataPrecision");
        EvaluFormSolutionEntryInfo _precisionType = (EvaluFormSolutionEntryInfo)evaluFormMap.get("precisionType");
        if (_dataPrecision != null && _precisionType != null) {
            this.tblMain.getColumn("dataPrecision").getStyleAttributes().setHided(!_dataPrecision.isVisible());
            this.tblMain.getColumn("precisionType").getStyleAttributes().setHided(!_precisionType.isVisible());
        }
        if (this.tblMain.getColumn(colIndex) != null || this.tblMain.getRow(rowIndex) != null) {
            if (this.tblMain.getColumn(colIndex).getKey().equals("kind") && this.tblMain.getCell(rowIndex, colIndex).getValue() != null) {
                if (evt.getNewValue().equals(evt.getOldValue())) {
                    return;
                }
                KindEnum newValue = (KindEnum)((Object)evt.getNewValue());
                KindEnum oldValue = (KindEnum)((Object)evt.getOldValue());
                if (KindEnum.QUANTITATIVE2.equals((Object)newValue)) {
                    String[] columnName = new String[]{"thresholdValue", "standardValue", "challengeValue", "reservedField2"};
                    PerformItemHelper.setRender(this.tblMain.getRow(rowIndex), columnName, new PercentRender());
                } else if (KindEnum.QUANTITATIVE2.equals((Object)oldValue)) {
                    String[] columnName = new String[]{"thresholdValue", "standardValue", "challengeValue", "reservedField2"};
                    PerformItemHelper.setRender(this.tblMain.getRow(rowIndex), columnName, defRender);
                }
            } else if (this.tblMain.getColumn(colIndex).getKey().equals("weight")) {
                this.initWeightState();
            }
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        this.setTBAutoFitRowHeight();
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(i);
            TargetEvaluStoreInfo info = this.storeRowInfo(row);
            if (info == null || info.getId() == null) {
                return true;
            }
            info.setWeight((BigDecimal)row.getCell("weight").getValue());
            TargetEvaluStoreInfo oldInfo = (TargetEvaluStoreInfo)this.oldData.get(info.getId());
            if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)oldInfo, (AbstractObjectValue)info)) {
                if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)oldInfo.getEvaluTarget(), (AbstractObjectValue)info.getEvaluTarget())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void allfiledIsEnable() {
        this.tblMain.getColumn("thresholdValue").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("thresholdValue").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("thresholdValue").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("type").getStyleAttributes().setLocked(this.isTargetTemplateMode());
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("content").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("weight").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("description").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("standard").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("kind").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("unit").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("calFormula").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("reportFrequency").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("scoringMethod").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("evaluationSide").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("reservedField1").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("reservedField2").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("creator").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("creatorPosition").getStyleAttributes().setLocked(false);
    }

    private class TablePropertyChangeListener
    implements KDTPropertyChangeListener {
        private TablePropertyChangeListener() {
        }

        public void propertyChange(KDTPropertyChangeEvent evt) {
            TargetEvaluStoreBaseEditUI.this.tblMain_propertyChange(evt);
        }
    }
}

