/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.EvaluFormSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluGroupFactory;
import com.kingdee.eas.hr.perf.EvaluGroupInfo;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.INodeProcesserHandler;
import com.kingdee.eas.hr.perf.NodeProcesserParam;
import com.kingdee.eas.hr.perf.PerfContractTemplateHelper;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.client.PercentRender;
import com.kingdee.eas.hr.perf.client.PerfContractTemplateClientHelper;
import com.kingdee.eas.hr.perf.client.PerfContractTemplateDrawTableHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TargetEvaluStoreHandler
implements INodeProcesserHandler {
    static final BigDecimal hundred = new BigDecimal("100");

    @Override
    public NodeProcesserParam initParameters(Map uiContext) throws EASBizException, BOSException {
        NodeProcesserParam parameter = new NodeProcesserParam();
        parameter.setFormSolutionId((String)uiContext.get("evaluFormSolutionId"));
        parameter.setEvaluGroupId((String)uiContext.get("evaluGroupId"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.solutionType"));
        EvaluGroupInfo evaluGroupInfo = EvaluGroupFactory.getRemoteInstance().getEvaluGroupInfo((IObjectPK)new ObjectUuidPK(parameter.getEvaluGroupId()), sic);
        parameter.setEvaluSolutionType(evaluGroupInfo.getSolutionPeriod().getEvaluSolution().getSolutionType());
        if (EvaluSolutionTypeEnum.PERSON.equals((Object)parameter.getEvaluSolutionType())) {
            parameter.setEvaluObjectType(EvaluObjectTypeEnum.PERSON);
        } else if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)parameter.getEvaluSolutionType())) {
            parameter.setEvaluObjectType(EvaluObjectTypeEnum.ORGUNIT);
        }
        return parameter;
    }

    @Override
    public Map getHeadData(NodeProcesserParam parameters) throws EASBizException, BOSException {
        Map map = EvaluFormSolutionFacadeFactory.getRemoteInstance().getVisibleSortedEntrys(parameters.getFormSolutionId(), parameters.getEvaluObjectType());
        HashMap<String, Map> headData = new HashMap<String, Map>();
        headData.put("names", map);
        return headData;
    }

    @Override
    public AbstractObjectCollection getTargetData(NodeProcesserParam parameters) throws BOSException {
        return PerfContractTemplateHelper.getEvaluGroupTargetCollectionByGroupId(parameters.getEvaluGroupId());
    }

    @Override
    public Map assembleMultiTableTargetDataMap(AbstractObjectCollection objectCollection) {
        HashMap<String, EvaluGroupTargetCollection> map = new HashMap<String, EvaluGroupTargetCollection>();
        EvaluGroupTargetInfo info = null;
        EvaluGroupTargetCollection targets = null;
        EvaluGroupTargetCollection collection = (EvaluGroupTargetCollection)objectCollection;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            info = collection.get(i);
            String multiTableId = info.getMultiTable().getId().toString();
            targets = (EvaluGroupTargetCollection)((Object)map.get(multiTableId));
            if (targets == null) {
                targets = new EvaluGroupTargetCollection();
                map.put(multiTableId, targets);
            }
            targets.add(info);
        }
        return map;
    }

    public static Map assembleMultiTableTargetEvaluStoreDataMap(AbstractObjectCollection objectCollection) {
        HashMap<String, TargetEvaluStoreCollection> map = new HashMap<String, TargetEvaluStoreCollection>();
        TargetEvaluStoreInfo info = null;
        TargetEvaluStoreCollection targets = null;
        TargetEvaluStoreCollection collection = (TargetEvaluStoreCollection)objectCollection;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            info = collection.get(i);
            String multiTableId = info.getMultiTable().getId().toString();
            targets = (TargetEvaluStoreCollection)((Object)map.get(multiTableId));
            if (targets == null) {
                targets = new TargetEvaluStoreCollection();
                map.put(multiTableId, targets);
            }
            targets.add(info);
        }
        return map;
    }

    @Override
    public void fillTable(KDTable table, AbstractObjectCollection collection) {
        PerfContractTemplateClientHelper.addDataToTableByEvaluGroupTargetInfo(table, (EvaluGroupTargetCollection)collection);
    }

    @Override
    public Collection getWickedlyColumns() {
        HashSet<String> columns = new HashSet<String>();
        columns.add("evalutargetScore");
        columns.add("targetWeightedScore");
        return columns;
    }

    public static AbstractObjectCollection getTargetData(String solutionId, String evaluObjectId, Set currMultiTableIds) throws BOSException {
        return TargetEvaluStoreFactory.getRemoteInstance().getTargetEvaluStoreCollection(TargetEvaluStoreHandler.getEntityViewInfo(solutionId, evaluObjectId, currMultiTableIds));
    }

    protected static EntityViewInfo getEntityViewInfo(String solutionId, String evaluObjectId, Set currMultiTableIds) {
        HashMap map = new HashMap();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)evaluObjectId));
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionId));
        filterInfo.getFilterItems().add(new FilterItemInfo("multiTable.id", (Object)currMultiTableIds, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SorterItemCollection sorterItemColl = entityViewInfo.getSorter();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("multiTable.id");
        sorterItemColl.add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("seqNumber");
        sorterItemInfo.setSortType(SortType.ASCEND);
        sorterItemColl.add(sorterItemInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("uniteTarget"));
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("weight"));
        sic.add(new SelectorItemInfo("values"));
        sic.add(new SelectorItemInfo("thresholdValue"));
        sic.add(new SelectorItemInfo("standardValue"));
        sic.add(new SelectorItemInfo("challengeValue"));
        sic.add(new SelectorItemInfo("seqNumber"));
        sic.add(new SelectorItemInfo("parent.state"));
        sic.add(new SelectorItemInfo("evaluTarget.id"));
        sic.add(new SelectorItemInfo("evaluTarget.type.id"));
        sic.add(new SelectorItemInfo("evaluTarget.type.name"));
        sic.add(new SelectorItemInfo("evaluTarget.type.parent.id"));
        sic.add(new SelectorItemInfo("evaluTarget.type.parent.name"));
        sic.add(new SelectorItemInfo("evaluTarget.firstTypeWeight"));
        sic.add(new SelectorItemInfo("evaluTarget.firstTypeScore"));
        sic.add(new SelectorItemInfo("evaluTarget.secondType.id"));
        sic.add(new SelectorItemInfo("evaluTarget.secondType.name"));
        sic.add(new SelectorItemInfo("evaluTarget.secondTypeWeight"));
        sic.add(new SelectorItemInfo("evaluTarget.secondTypeScore"));
        sic.add(new SelectorItemInfo("evaluTarget.number"));
        sic.add(new SelectorItemInfo("evaluTarget.content"));
        sic.add(new SelectorItemInfo("evaluTarget.description"));
        sic.add(new SelectorItemInfo("evaluTarget.standard"));
        sic.add(new SelectorItemInfo("evaluTarget.kind"));
        sic.add(new SelectorItemInfo("evaluTarget.dataPrecision"));
        sic.add(new SelectorItemInfo("evaluTarget.precisionType"));
        sic.add(new SelectorItemInfo("evaluTarget.unit"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.id"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.name"));
        sic.add(new SelectorItemInfo("evaluTarget.reportFrequency"));
        sic.add(new SelectorItemInfo("evaluTarget.scoringMethod"));
        sic.add(new SelectorItemInfo("evaluTarget.evaluationSide"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField1"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField2text"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField3"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField4"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField5"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField6"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField2"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.person.id"));
        sic.add(new SelectorItemInfo("creator.person.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.allowModifyTargetValue"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.modifyContent"));
        entityViewInfo.setSelector(sic);
        SorterItemInfo sorterItemInfoMultiTableId = new SorterItemInfo("multiTable.id");
        sorterItemInfoMultiTableId.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterItemInfoMultiTableId);
        SorterItemInfo sorterItemInfoseqNumber = new SorterItemInfo("evaluTarget.seqNumber");
        sorterItemInfoseqNumber.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterItemInfoseqNumber);
        return entityViewInfo;
    }

    public static void addDataToTableByTargetEvaluStoreInfo(KDTable table, TargetEvaluStoreCollection targetEvaluStoreCollection) {
        if (targetEvaluStoreCollection.size() <= 0) {
            return;
        }
        TargetEvaluStoreInfo targetEvaluStoreInfo = null;
        EvaluTargetInfo evaluTargetInfo = null;
        IRow irow = null;
        int scaleForBigdecimal = 2;
        for (int i = 0; i < targetEvaluStoreCollection.size(); ++i) {
            targetEvaluStoreInfo = targetEvaluStoreCollection.get(i);
            evaluTargetInfo = targetEvaluStoreInfo.getEvaluTarget();
            irow = table.addRow();
            if (irow.getCell("PerformTargetItemFid") != null && evaluTargetInfo.getTargetID() != null) {
                irow.getCell("PerformTargetItemFid").setValue((Object)evaluTargetInfo.getTargetID().toString());
            }
            if (irow.getCell("id") != null && irow.getCell("id").getValue() != null) {
                irow.getCell("id").setValue((Object)evaluTargetInfo.getId().toString());
            }
            if (irow.getCell("seq") != null) {
                irow.getCell("seq").setValue((Object)new Integer(evaluTargetInfo.getSeqNumber()));
            }
            if (irow.getCell("content") != null) {
                irow.getCell("content").setValue((Object)evaluTargetInfo.getContent());
            }
            if (irow.getCell("number") != null) {
                irow.getCell("number").setValue((Object)evaluTargetInfo.getNumber());
            }
            if (irow.getCell("description") != null) {
                irow.getCell("description").setValue((Object)evaluTargetInfo.getDescription());
            }
            if (irow.getCell("firstLevelTargetTypeWeight") != null && evaluTargetInfo.getFirstTypeWeight() != null) {
                irow.getCell("firstLevelTargetTypeWeight").setValue((Object)evaluTargetInfo.getFirstTypeWeight().setScale(scaleForBigdecimal, 4));
            }
            if (irow.getCell("firstLevelTargetTypeScore") != null && evaluTargetInfo.getFirstTypeScore() != null) {
                irow.getCell("firstLevelTargetTypeScore").setValue((Object)evaluTargetInfo.getFirstTypeScore().setScale(0, 4));
            }
            if (irow.getCell("secondLevelTargetTypeWeight") != null && evaluTargetInfo.getSecondTypeWeight() != null) {
                irow.getCell("secondLevelTargetTypeWeight").setValue((Object)evaluTargetInfo.getSecondTypeWeight().setScale(scaleForBigdecimal, 4));
            }
            if (irow.getCell("secondLevelTargetTypeScore") != null && evaluTargetInfo.getSecondTypeScore() != null) {
                irow.getCell("secondLevelTargetTypeScore").setValue((Object)evaluTargetInfo.getSecondTypeScore().setScale(0, 4));
            }
            if (irow.getCell("standard") != null) {
                irow.getCell("standard").setValue((Object)evaluTargetInfo.getStandard());
            }
            if (irow.getCell("weight") != null && targetEvaluStoreInfo.getWeight() != null) {
                irow.getCell("weight").setValue((Object)targetEvaluStoreInfo.getWeight().setScale(scaleForBigdecimal, 4));
            }
            if (irow.getCell("values") != null && targetEvaluStoreInfo.getValues() != null) {
                irow.getCell("values").setValue((Object)targetEvaluStoreInfo.getValues().setScale(0, 4));
            }
            if (irow.getCell("kind") != null) {
                irow.getCell("kind").setValue((Object)evaluTargetInfo.getKind());
            }
            int curRowdataPrecisionForthresholdValue = 2;
            PrecisionTypeEnum curRowPrecisionTypeForthresholdValue = PrecisionTypeEnum.ROUND;
            if (irow.getCell("dataPrecision") != null) {
                irow.getCell("dataPrecision").setValue((Object)new Integer(evaluTargetInfo.getDataPrecision()));
                curRowdataPrecisionForthresholdValue = evaluTargetInfo.getDataPrecision();
            }
            if (irow.getCell("precisionType") != null) {
                irow.getCell("precisionType").setValue((Object)evaluTargetInfo.getPrecisionType());
                if (evaluTargetInfo.getPrecisionType() != null) {
                    curRowPrecisionTypeForthresholdValue = evaluTargetInfo.getPrecisionType();
                }
            }
            int roundForThresholdValue = PerfContractTemplateDrawTableHelper.getRoundStyle(curRowPrecisionTypeForthresholdValue);
            if (irow.getCell("thresholdValue") != null && targetEvaluStoreInfo.getThresholdValue() != null) {
                if (evaluTargetInfo.getKind() != null && evaluTargetInfo.getKind().getValue() == 22) {
                    irow.getCell("thresholdValue").setValue((Object)targetEvaluStoreInfo.getThresholdValue().multiply(hundred).setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue));
                    irow.getCell("thresholdValue").setRenderer((IBasicRender)new PercentRender());
                } else {
                    irow.getCell("thresholdValue").setValue((Object)targetEvaluStoreInfo.getThresholdValue().setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue));
                }
            }
            if (irow.getCell("standardValue") != null && targetEvaluStoreInfo.getStandardValue() != null) {
                if (evaluTargetInfo.getKind() != null && evaluTargetInfo.getKind().getValue() == 22) {
                    irow.getCell("standardValue").setValue((Object)targetEvaluStoreInfo.getStandardValue().multiply(hundred).setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue));
                    irow.getCell("standardValue").setRenderer((IBasicRender)new PercentRender());
                } else {
                    irow.getCell("standardValue").setValue((Object)targetEvaluStoreInfo.getStandardValue().setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue));
                }
            }
            if (irow.getCell("challengeValue") != null && targetEvaluStoreInfo.getChallengeValue() != null) {
                if (evaluTargetInfo.getKind() != null && evaluTargetInfo.getKind().getValue() == 22) {
                    irow.getCell("challengeValue").setValue((Object)targetEvaluStoreInfo.getChallengeValue().multiply(hundred).setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue));
                    irow.getCell("challengeValue").setRenderer((IBasicRender)new PercentRender());
                } else {
                    irow.getCell("challengeValue").setValue((Object)targetEvaluStoreInfo.getChallengeValue().setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue));
                }
            }
            if (irow.getCell("unit") != null) {
                irow.getCell("unit").setValue((Object)evaluTargetInfo.getUnit());
            }
            if (irow.getCell("reportFrequency") != null) {
                irow.getCell("reportFrequency").setValue((Object)evaluTargetInfo.getReportFrequency());
            }
            if (irow.getCell("scoringMethod") != null) {
                irow.getCell("scoringMethod").setValue((Object)evaluTargetInfo.getScoringMethod());
            }
            if (irow.getCell("evaluationSide") != null) {
                irow.getCell("evaluationSide").setValue((Object)evaluTargetInfo.getEvaluationSide());
            }
            if (irow.getCell("reservedField1") != null) {
                irow.getCell("reservedField1").setValue((Object)evaluTargetInfo.getReservedField1());
            }
            if (irow.getCell("reservedField2") != null) {
                irow.getCell("reservedField2").setValue((Object)evaluTargetInfo.getReservedField2text());
            }
            if (irow.getCell("reservedField3") != null) {
                irow.getCell("reservedField3").setValue((Object)evaluTargetInfo.getReservedField3());
            }
            if (irow.getCell("reservedField4") != null) {
                irow.getCell("reservedField4").setValue((Object)evaluTargetInfo.getReservedField4());
            }
            if (irow.getCell("reservedField5") != null) {
                irow.getCell("reservedField5").setValue((Object)evaluTargetInfo.getReservedField5());
            }
            if (irow.getCell("reservedField6") != null) {
                irow.getCell("reservedField6").setValue((Object)evaluTargetInfo.getReservedField6());
            }
            if (irow.getCell("reservedFieldNumber") != null && evaluTargetInfo.getReservedField2() != null) {
                if (evaluTargetInfo.getKind() != null && evaluTargetInfo.getKind().getValue() == 22) {
                    irow.getCell("reservedFieldNumber").setValue((Object)evaluTargetInfo.getReservedField2().multiply(hundred).setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue));
                    irow.getCell("reservedFieldNumber").setRenderer((IBasicRender)new PercentRender());
                } else {
                    irow.getCell("reservedFieldNumber").setValue((Object)evaluTargetInfo.getReservedField2().setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue));
                }
            }
            if (irow.getCell("calFormula") != null) {
                irow.getCell("calFormula").setValue((Object)evaluTargetInfo.getFormula());
            }
            if (irow.getCell("type") != null) {
                irow.getCell("type").setValue((Object)evaluTargetInfo.getType());
            }
            if (irow.getCell("secondLevelTargetType") == null) continue;
            irow.getCell("secondLevelTargetType").setValue((Object)evaluTargetInfo.getSecondType());
        }
        table.getStyleAttributes().setWrapText(true);
    }
}

