/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.ITargetEvaluStoreWeightFacade;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreWeightFacadeFactory;
import com.kingdee.eas.hr.perf.client.AbstractTargetEvaluStoreViewUI;
import com.kingdee.eas.hr.perf.client.EvaluFormSolutionUIHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PerformItemHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TargetEvaluStoreViewUI
extends AbstractTargetEvaluStoreViewUI {
    private static final Logger logger = CoreUIObject.getLogger(TargetEvaluStoreViewUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private BigDecimal sumWeight = new BigDecimal("0.00");
    private BigDecimal deliveredWeight = new BigDecimal("0.00");
    private Color statisticsColor = new Color(0xF6F6BF);
    private String specialID = "$%no-eas-no-target-id%$";
    private boolean isAppendFootRow = false;
    private String evaluObjectID = null;
    private String solutionPeriodID = null;
    private boolean isAllocateTarget = false;
    private Map evaluFormMap;

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void onLoad() throws Exception {
        PerfClientUtils.checkValidHRO((CoreUI)this);
        PerfClientUtils.checkValidPerson((CoreUI)this);
        this.initParam();
        super.onLoad();
        this.tblMain.getStyleAttributes().setWrapText(true);
    }

    private void initParam() {
        Map param = this.getUIContext();
        if (param.get("evaluObject") != null) {
            this.evaluObjectID = (String)param.get("evaluObject");
        }
        if (param.get("solutionPeriod") != null) {
            this.solutionPeriodID = (String)param.get("solutionPeriod");
        }
        if (param.get("allocateTarget") != null) {
            this.isAllocateTarget = (Boolean)param.get("allocateTarget");
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)this.solutionPeriodID));
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", (Object)this.evaluObjectID));
        filter.setMaskString("#0 and #1");
        return filter;
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        if (!this.isAllocateTarget) {
            try {
                rowSet.beforeFirst();
                BigDecimal percent = new BigDecimal("0.01");
                DecimalFormat numberFormat = new DecimalFormat("0.00");
                DecimalFormat percentFormat = new DecimalFormat("0.00%");
                BigDecimal value = null;
                while (rowSet.next()) {
                    if (rowSet.getBigDecimal("weight") != null) {
                        rowSet.updateBigDecimal("weight", rowSet.getBigDecimal("weight").multiply(percent));
                    }
                    try {
                        DecimalFormat df;
                        String precision;
                        int dataPrecision;
                        BizEnumValueDTO dt = (BizEnumValueDTO)rowSet.getObject("evaluTarget.kind");
                        if (dt == null) continue;
                        if (22 == dt.getInt()) {
                            dataPrecision = rowSet.getInt("evaluTarget.dataPrecision");
                            precision = null;
                            precision = PFUtils.getNumberFormat(dataPrecision) + "%";
                            df = new DecimalFormat(precision);
                            value = rowSet.getBigDecimal("evaluTarget.thresholdValue");
                            if (value != null) {
                                rowSet.updateObject("evaluTarget.thresholdValue", (Object)df.format(value));
                            }
                            if ((value = rowSet.getBigDecimal("evaluTarget.standardValue")) != null) {
                                rowSet.updateObject("evaluTarget.standardValue", (Object)df.format(value));
                            }
                            if ((value = rowSet.getBigDecimal("evaluTarget.challengeValue")) != null) {
                                rowSet.updateObject("evaluTarget.challengeValue", (Object)df.format(value));
                            }
                            if ((value = rowSet.getBigDecimal("evaluTarget.reservedField2")) == null) continue;
                            rowSet.updateObject("evaluTarget.reservedField2", (Object)percentFormat.format(value));
                            continue;
                        }
                        dataPrecision = rowSet.getInt("evaluTarget.dataPrecision");
                        precision = null;
                        precision = PFUtils.getNumberFormat(dataPrecision);
                        df = new DecimalFormat(precision);
                        value = rowSet.getBigDecimal("evaluTarget.thresholdValue");
                        if (value != null) {
                            rowSet.updateObject("evaluTarget.thresholdValue", (Object)df.format(value));
                        }
                        if ((value = rowSet.getBigDecimal("evaluTarget.standardValue")) != null) {
                            rowSet.updateObject("evaluTarget.standardValue", (Object)df.format(value));
                        }
                        if ((value = rowSet.getBigDecimal("evaluTarget.challengeValue")) != null) {
                            rowSet.updateObject("evaluTarget.challengeValue", (Object)df.format(value));
                        }
                        if ((value = rowSet.getBigDecimal("evaluTarget.reservedField2")) == null) continue;
                        rowSet.updateObject("evaluTarget.reservedField2", (Object)numberFormat.format(value));
                    }
                    catch (Exception ex) {}
                }
                rowSet.beforeFirst();
            }
            catch (Exception ex) {
                super.handleException(ex);
            }
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        if (this.tblMain.getRowCount() > 0 && !this.isAllocateTarget && !this.isAppendFootRow) {
            try {
                this.initWeightInfo();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), ex.getCause());
                super.handleException(ex);
            }
            this.staticstic();
            this.isAppendFootRow = true;
        }
        this.autoFitHeight();
    }

    private void autoFitHeight() {
        int k = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < k; ++rowIndex) {
            KDTableHelper.autoFitRowHeight((KDTable)this.tblMain, (int)rowIndex, (int)0);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.isAppendFootRow = false;
        super.refresh(e);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.evaluFormMap = EvaluFormSolutionUIHelper.getFormSolution(this.solutionPeriodID);
        EvaluFormSolutionUIHelper.setTableDisplay(this.evaluFormMap, this.tblMain, true);
        if (this.isAllocateTarget) {
            this.tblMain.getColumn("weight").getStyleAttributes().setHided(true);
        }
        this.autoFitHeight();
    }

    protected void initWeightInfo() throws Exception {
        if (this.evaluObjectID == null || this.solutionPeriodID == null) {
            return;
        }
        ISolutionPeriod dao = SolutionPeriodFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("assessPeriod.id"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        SolutionPeriodInfo solutionPeriodInfo = dao.getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.solutionPeriodID), sic);
        ITargetEvaluStoreWeightFacade facade = TargetEvaluStoreWeightFacadeFactory.getRemoteInstance();
        HashMap ret = facade.getWeightInfo(solutionPeriodInfo.getAssessPeriod().getId(), solutionPeriodInfo.getEvaluSolution().getId(), BOSUuid.read((String)this.evaluObjectID));
        this.sumWeight = (BigDecimal)ret.get("total");
        this.deliveredWeight = (BigDecimal)ret.get("delivered");
    }

    private void staticstic() {
        IRow row = this.tblMain.addRow();
        KDTMergeManager mm = this.tblMain.getMergeManager();
        int index = 0;
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (this.tblMain.getColumn(i).getStyleAttributes().isHided()) continue;
            index = i;
            break;
        }
        row.getCell(index).setValue((Object)EASResource.getString((String)RES, (String)"total"));
        row.getCell(index).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        mm.mergeBlock(row.getRowIndex(), index + 1, row.getRowIndex(), this.tblMain.getColumnCount() - 1, 4);
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"sumWeight"));
        sb.append(PFVerifyUtils.formatBigDecimal(this.sumWeight, 2));
        sb.append("%");
        sb.append(", ");
        sb.append(EASResource.getString((String)RES, (String)"deliveredWeight"));
        sb.append(PFVerifyUtils.formatBigDecimal(this.deliveredWeight, 2));
        sb.append("%");
        row.getCell(index + 1).setValue((Object)sb.toString());
        row.getCell(index + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        row.getStyleAttributes().setBackground(this.statisticsColor);
        row.getCell("id").setValue((Object)this.specialID);
    }

    private void setPercent() {
        String[] columnName = new String[]{"thresholdValue", "standardValue", "challengeValue", "reservedField2"};
        PerformItemHelper.setFormatString(this.tblMain, columnName);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

