/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryTypeEnum;
import com.kingdee.eas.hr.perf.EvaluFormSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableInfo;
import com.kingdee.eas.hr.perf.EvaluGroupObjectCollection;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectInfo;
import com.kingdee.eas.hr.perf.INodeProcesserHandler;
import com.kingdee.eas.hr.perf.NodeProcesserParam;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreParentInfo;
import com.kingdee.eas.hr.perf.client.AbstractTargetEvalustoreView;
import com.kingdee.eas.hr.perf.client.NodeProcesserHelper;
import com.kingdee.eas.hr.perf.client.PerfContractTemplateDrawTableHelper;
import com.kingdee.eas.hr.perf.client.TargetEvaluStoreHandler;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class TargetEvalustoreView
extends AbstractTargetEvalustoreView {
    private static final long serialVersionUID = -436612963836530064L;
    private static final Logger logger = CoreUIObject.getLogger(TargetEvalustoreView.class);
    protected String billid = "";
    private Set wickedlyColumnSet = null;
    private INodeProcesserHandler handler = null;
    private static final String[] columnKeys = new String[]{"type", "firstLevelTargetTypeWeight", "firstLevelTargetTypeScore", "secondLevelTargetType", "secondLevelTargetTypeWeight", "secondLevelTargetTypeScore"};
    protected static final int space = 3;
    protected static final String RESOURCE = "com.kingdee.eas.hr.perf.client.PerfResource";
    protected static final int STYLE = 13;
    protected static final int panelStyle = 31;
    protected NodeProcesserParam parameter = null;
    protected List tables = null;
    EvaluFormSolutionEntryCollection evaluFormSolutionEntryColl = null;
    private TargetEvaluStoreParentInfo parentInfo = new TargetEvaluStoreParentInfo();

    public void onLoad() throws Exception {
        this.initParameters();
        this.initData();
        this.initUI();
        this.fillDataToUI();
        this.fillComboxData();
    }

    protected void initParameters() throws Exception {
        this.parentInfo = this.getTargetParentInfo(this.getBillID());
        String className = (String)NodeProcesserHelper.getNodeProcesserHandlerMap().get("evaluSolution");
        try {
            this.handler = (INodeProcesserHandler)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        HashMap<String, String> ParmaeterMap = new HashMap<String, String>();
        ParmaeterMap.put("evaluFormSolutionId", this.parentInfo.getSolutionPeriod().getFormSolution().getId().toString());
        ParmaeterMap.put("evaluGroupId", this.getGroupId());
        this.parameter = this.handler.initParameters(ParmaeterMap);
        this.wickedlyColumnSet = this.getWickedlyColumnSet();
        Collection columns = this.handler.getWickedlyColumns();
        if (columns != null) {
            this.wickedlyColumnSet.addAll(columns);
        }
        if (StringUtils.isEmpty((String)this.getOprtState())) {
            this.setOprtState(OprtState.VIEW);
        }
    }

    private void initData() throws BOSException, EASBizException {
        EvaluFormSolutionInfo solutionInfo = EvaluFormSolutionFactory.getRemoteInstance().getEvaluFormSolutionInfo((IObjectPK)new ObjectUuidPK(this.parameter.getFormSolutionId()));
        this.parameter.setMultiTableCollection(solutionInfo.getMultiTable());
        this.evaluFormSolutionEntryColl = this.getvaluFormSolutionEntryCollection();
        this.parameter.setMultiTableSettingMap(this.assembleMultiTableSettingMap(this.evaluFormSolutionEntryColl));
        AbstractObjectCollection targetCollection = TargetEvaluStoreHandler.getTargetData(this.parentInfo.getSolutionPeriod().getId().toString(), this.parentInfo.getEvaluObject().getId().toString(), this.getCurrMultiTableIds());
        this.parameter.setMultiTableDataMap(TargetEvaluStoreHandler.assembleMultiTableTargetEvaluStoreDataMap(targetCollection));
    }

    private void initUI() throws Exception {
        List panels = this.createPanels();
        KDPanel panel = null;
        int y = 0;
        int size = panels.size();
        for (int i = 0; i < size; ++i) {
            panel = (KDPanel)panels.get(i);
            if (panel == null) continue;
            panel.setBounds(new Rectangle(panel.getBounds().x, y, panel.getBounds().width, panel.getBounds().height));
            y += panel.getBounds().height + 5;
            this.addPanel(this.pnlMain, panel);
        }
        int height = y + 10;
        this.pnlMain.setPreferredSize(new Dimension(this.pnlMain.getBounds().width, height));
        this.revalidate();
        this.pnlMain.revalidate();
    }

    protected void fillDataToUI() {
        Map multiTableDataMap = this.parameter.getMultiTableDataMap();
        if (multiTableDataMap == null || multiTableDataMap.isEmpty()) {
            return;
        }
        Iterator it = this.tables.iterator();
        KDTable table = null;
        EvaluFormSolutionMultiTableInfo tableInfo = null;
        TargetEvaluStoreCollection targetCollection = null;
        while (it.hasNext()) {
            table = (KDTable)it.next();
            tableInfo = (EvaluFormSolutionMultiTableInfo)table.getUserObject();
            targetCollection = (TargetEvaluStoreCollection)((Object)multiTableDataMap.get(tableInfo.getId().toString()));
            if (targetCollection == null) continue;
            TargetEvaluStoreHandler.addDataToTableByTargetEvaluStoreInfo(table, targetCollection);
            this.afterFillTable(table);
        }
    }

    protected void afterFillTable(KDTable table) {
    }

    protected List createPanels() throws BOSException, EASBizException, Exception {
        ArrayList<KDPanel> panels = new ArrayList<KDPanel>();
        panels.add(this.initTablesPanel(this.parameter.getMultiTableCollection()));
        return panels;
    }

    private void addPanel(KDPanel parent, KDPanel children) {
        Rectangle rectangle = children.getBounds();
        children.putClientProperty((Object)"OriginalBounds", (Object)rectangle);
        children.setLayout((LayoutManager)new KDLayout());
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = rectangle;
        cons.anchor = 13;
        children.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        parent.add((Component)children);
    }

    private KDPanel initTablesPanel(EvaluFormSolutionMultiTableCollection multiTableCollection) throws Exception {
        KDPanel pnlTablesPanel = new KDPanel();
        pnlTablesPanel.setName("pnlTablesPanel");
        KDPanel panel = null;
        int y = 0;
        EvaluFormSolutionMultiTableInfo tableInfo = null;
        int size = multiTableCollection.size();
        for (int i = 0; i < size; ++i) {
            tableInfo = multiTableCollection.get(i);
            panel = this.createTablePanel(tableInfo, (EvaluFormSolutionEntryCollection)((Object)this.parameter.getMultiTableSettingMap().get(tableInfo.getId().toString())));
            panel.setBounds(new Rectangle(panel.getBounds().x, y, panel.getBounds().width, panel.getBounds().height));
            y += panel.getBounds().height;
            this.addPanel(pnlTablesPanel, panel);
        }
        pnlTablesPanel.setBounds(new Rectangle(0, 0, this.getBounds().width, y));
        return pnlTablesPanel;
    }

    private KDPanel createTablePanel(EvaluFormSolutionMultiTableInfo tableInfo, EvaluFormSolutionEntryCollection entrys) throws Exception {
        KDTable table;
        KDPanel pnlTablePanel = new KDPanel();
        pnlTablePanel.setName("pnlTablePanel" + tableInfo.getSeq());
        int x = 10;
        int y = 0;
        int width = 0;
        int height = 0;
        KDLabel label = new KDLabel();
        label.setText(tableInfo.getName());
        width = 200;
        height = 19;
        label.setBounds(new Rectangle(x, y += 10, width, height));
        pnlTablePanel.add((Component)label, (Object)new KDLayout.Constraints(x, y, width, height, 13));
        y += label.getBounds().height + 3;
        KDLayout.Constraints cons = null;
        if (tableInfo.isPartTableDesShow()) {
            KDScrollPane scrollPane = new KDScrollPane();
            width = this.getBounds().width - 20;
            height = 70;
            scrollPane.setBounds(new Rectangle(x, y, width, height));
            cons = new KDLayout.Constraints();
            cons.originalBounds = new Rectangle(x, y, width, height);
            cons.anchor = 31;
            scrollPane.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
            pnlTablePanel.add((Component)scrollPane);
            KDTextArea txtArea = new KDTextArea();
            txtArea.setText(tableInfo.getPartTableDes());
            txtArea.setEnabled(false);
            scrollPane.getViewport().add((Component)txtArea, null);
            y += scrollPane.getBounds().height + 3;
        }
        if ((table = PerfContractTemplateDrawTableHelper.getEvaluTargetTable(entrys, this.wickedlyColumnSet)).getColumn("precisionType") != null) {
            table.getColumn("precisionType").setWidth(0);
        }
        if (table.getColumn("dataPrecision") != null) {
            table.getColumn("dataPrecision").setWidth(0);
        }
        table.setUserObject((Object)tableInfo);
        this.setColumnDefaultAttribute(table);
        this.afterCreateTable(table);
        this.mergeTable(table);
        table.getStyleAttributes().setLocked(OprtState.VIEW.equals(this.getOprtState()));
        if (this.tables == null) {
            this.tables = new ArrayList();
        }
        table.getActionMap().remove("Delete");
        this.tables.add(table);
        width = this.getBounds().width - 20;
        height = 200;
        table.setBounds(new Rectangle(x, y, width, height));
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(x, y, width, height);
        cons.anchor = 31;
        table.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        pnlTablePanel.add((Component)table);
        y += table.getBounds().height + 3;
        pnlTablePanel.setBounds(new Rectangle(0, 0, this.getBounds().width, y += 10));
        return pnlTablePanel;
    }

    protected Component addSubScoreComponent(int seq, int y) {
        KDLabelContainer cont = new KDLabelContainer();
        cont.setName("cont_" + seq);
        cont.setBoundLabelLength(100);
        cont.setBoundLabelUnderline(true);
        cont.setBoundLabelText("\u5c0f\u8ba1");
        cont.setToolTipText("\u5c0f\u8ba1");
        int width = 270;
        int height = 19;
        int x = this.getBounds().width - 10 - width;
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(x, y, width, height);
        cons.anchor = 9;
        cont.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        KDTextField txtField = new KDTextField();
        txtField.setEnabled(false);
        cont.setBoundEditor((JComponent)txtField);
        cont.setBounds(new Rectangle(x, y, width, height));
        return cont;
    }

    private void mergeTable(KDTable table) {
        KDTMergeManager mergeManager = table.getHeadMergeManager();
        IRow headRow = table.getHeadRow(0);
        int left = 0;
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (headRow.getCell(left) == null || headRow.getCell(left).getValue() == null || headRow.getCell(left).getValue().equals(headRow.getCell(i).getValue())) continue;
            mergeManager.mergeBlock(0, left, 0, i - 1);
            left = i;
        }
        mergeManager.mergeBlock(0, left, 0, count - 1);
        IColumn column = null;
        for (int i = 0; i < columnKeys.length; ++i) {
            column = table.getColumn(columnKeys[i]);
            if (column == null) continue;
            column.setGroup(true);
        }
        table.getGroupManager().setGroup(true);
    }

    protected void afterCreateTable(KDTable table) {
    }

    private void setColumnDefaultAttribute(KDTable table) {
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            table.getColumn(i).getStyleAttributes().setLocked(true);
            table.getColumn(i).setRequired(false);
        }
    }

    private Map assembleMultiTableSettingMap(EvaluFormSolutionEntryCollection collection) {
        HashMap<String, EvaluFormSolutionEntryCollection> map = new HashMap<String, EvaluFormSolutionEntryCollection>();
        EvaluFormSolutionEntryCollection entryCollection = null;
        EvaluFormSolutionEntryInfo info = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            info = collection.get(i);
            if (EvaluFormSolutionEntryTypeEnum.head.equals((Object)info.getType())) continue;
            String multiTableId = info.getMultiTable().getId().toString();
            entryCollection = (EvaluFormSolutionEntryCollection)((Object)map.get(multiTableId));
            if (entryCollection == null) {
                entryCollection = new EvaluFormSolutionEntryCollection();
                map.put(multiTableId, entryCollection);
            }
            entryCollection.add(info);
        }
        return map;
    }

    private EvaluFormSolutionEntryCollection getvaluFormSolutionEntryCollection() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("multiTable.id"));
        sic.add(new SelectorItemInfo("multiTable.seq"));
        sic.add(new SelectorItemInfo("multiTable.name"));
        sic.add(new SelectorItemInfo("multiTable.partTableDes"));
        sic.add(new SelectorItemInfo("evaluFormSolution.id"));
        viewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluFormSolution.id", (Object)this.parameter.getFormSolutionId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(20)));
        viewInfo.setFilter(filterInfo);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("multiTable.id");
        sorterItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("seq");
        sorterItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        EvaluFormSolutionEntryCollection collection = EvaluFormSolutionEntryFactory.getRemoteInstance().getEvaluFormSolutionEntryCollection(viewInfo);
        return collection;
    }

    protected Set getWickedlyColumnSet() {
        HashSet<String> wickedlyColumnSet_temp = new HashSet<String>();
        wickedlyColumnSet_temp.add("creator");
        wickedlyColumnSet_temp.add("creatorPosition");
        wickedlyColumnSet_temp.add("score");
        wickedlyColumnSet_temp.add("targetComm");
        wickedlyColumnSet_temp.add("calFormula");
        return wickedlyColumnSet_temp;
    }

    protected String getBillID() {
        return this.billid;
    }

    protected void fillComboxData() {
        this.kDComboBox1.addItems(new Object[]{this.parentInfo.getSolutionPeriod()});
        this.kDComboBox1.setSelectedIndex(0);
        this.kDComboBox1.setEnabled(false);
        this.kDComboBox2.addItems(new Object[]{this.parentInfo.getEvaluObject()});
        this.kDComboBox2.setSelectedIndex(0);
        this.kDComboBox2.setEnabled(false);
    }

    private TargetEvaluStoreParentInfo getTargetParentInfo(String billid) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("evaluObject.id"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.status"));
        sic.add(new SelectorItemInfo("solutionPeriod.formSolution.id"));
        TargetEvaluStoreParentInfo parentInfo = null;
        try {
            parentInfo = TargetEvaluStoreParentFactory.getRemoteInstance().getTargetEvaluStoreParentInfo((IObjectPK)new ObjectUuidPK(billid), sic);
        }
        catch (EASBizException e) {
            super.handleException((Exception)((Object)e));
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return parentInfo;
    }

    private String getGroupId() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("evaluGroup.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)this.parentInfo.getEvaluObject().getId()));
        viewInfo.setFilter(filterInfo);
        EvaluGroupObjectCollection groupColl = null;
        try {
            groupColl = EvaluGroupObjectFactory.getRemoteInstance().getEvaluGroupObjectCollection(viewInfo);
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
        }
        EvaluGroupObjectInfo evaluGroupObjectInfo = null;
        if (groupColl != null && groupColl.size() > 0) {
            evaluGroupObjectInfo = groupColl.get(0);
            return evaluGroupObjectInfo.getEvaluGroup().getId().toString();
        }
        return null;
    }

    private Set getCurrMultiTableIds() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluFormSolution.id", (Object)this.parentInfo.getSolutionPeriod().getFormSolution().getId()));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("seq");
        sorterItemInfo.setSortType(SortType.ASCEND);
        EntityViewInfo eviMultiTableSetInfo = new EntityViewInfo();
        eviMultiTableSetInfo.setFilter(filterInfo);
        eviMultiTableSetInfo.getSorter().add(sorterItemInfo);
        EvaluFormSolutionMultiTableCollection multiTableColl = null;
        try {
            multiTableColl = EvaluFormSolutionMultiTableFactory.getRemoteInstance().getEvaluFormSolutionMultiTableCollection(eviMultiTableSetInfo);
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
        }
        EvaluFormSolutionMultiTableInfo evaluFormSolutionMultiTableInfo = null;
        HashSet<String> currMultiTableIds = new HashSet<String>();
        if (multiTableColl != null && multiTableColl.size() > 0) {
            for (int i = 0; i < multiTableColl.size(); ++i) {
                evaluFormSolutionMultiTableInfo = multiTableColl.get(i);
                currMultiTableIds.add(evaluFormSolutionMultiTableInfo.getId().toString());
            }
        }
        return currMultiTableIds;
    }
}

