/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.TargetScoreTypeEnum;
import com.kingdee.eas.hr.perf.client.AbstractTargetResultReportBaseUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.TargetResultReportQueryPanelBaseUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class TargetResultReportBaseUI
extends AbstractTargetResultReportBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(TargetResultReportBaseUI.class);
    private static final IMetaDataPK initQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
    private static final String objectIDKey = "objectID";
    private static final String evaluObjectName = "evaluObjectName";
    private static final String evaluObjectNumber = "evaluObjectNumber";
    private static final String responser = "responser";
    private static final String columnAvgScore = "columnAvgScore";
    private static final String rowAvgScoreKey = "rowAvgScoreKey";
    private static final Color backgroundColor = new Color(0xF6F6BF);
    private static String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static String eoNumberValue = EASResource.getString((String)RES, (String)"evaluObjectNumber");
    private static String eoNameValue = EASResource.getString((String)RES, (String)"esObject");
    private static String responserValue = EASResource.getString((String)RES, (String)"mdOrgResponser");
    private static String avgScoreValue = EASResource.getString((String)RES, (String)"avgScore");
    private CommonQueryDialog dialog = null;
    private EntityViewInfo mainQuery = null;
    private IMetaDataPK mainQueryPK = null;
    private boolean isFirstDefaultQuery = true;
    private EvaluSolutionTypeEnum solutionType = null;
    private Map eoMap = null;
    private Map apMap = null;
    private Map dataMap = null;
    protected TargetScoreTypeEnum targetScoreType = null;
    private PrecisionMaintainInfo PMInfo = null;

    protected abstract TargetResultReportQueryPanelBaseUI getUserPanel();

    protected abstract EvaluSolutionTypeEnum getEvaluSolutionType();

    protected abstract String getQueryFullName();

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        KDTableHelper.releaseTab((JComponent)this.tblMain);
        this.solutionType = this.getEvaluSolutionType();
        this.actionQuery_actionPerformed(null);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = TargetResultReportBaseUI.getQueryInfo(initQueryPK).getFullName();
        String uiClassName = this.getMetaDataPK().getFullName();
        boolean isShowFilter = true;
        String perfItemName = null;
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(uiClassName, queryName)) {
            EntityViewInfo entityViewInfo = (EntityViewInfo)iQuery.getDefaultFilterInfo(uiClassName, queryName);
            QuerySolutionInfo solution = iQuery.getDefaultSolution(uiClassName, queryName);
            QueryPanelInfo queryPanelInfo = solution.getQueryPanelInfo().get(0);
            CustomerParams cp = null;
            if (queryPanelInfo != null) {
                cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams());
            }
            if (entityViewInfo != null && cp != null && entityViewInfo.getFilter() != null && !entityViewInfo.getFilter().getFilterItems().isEmpty()) {
                this.mainQuery = entityViewInfo;
                this.targetScoreType = cp.getCustomerParamsHashMap().get("radioAvgScore") != null && cp.getBoolean("radioAvgScore") ? TargetScoreTypeEnum.AVGSCORE : TargetScoreTypeEnum.WEIGHTSCORE;
                perfItemName = cp.getCustomerParam("contentprmptPerformTarget");
                isShowFilter = false;
            }
            this.isFirstDefaultQuery = false;
        }
        if (isShowFilter) {
            TargetResultReportQueryPanelBaseUI userPanel = null;
            if (this.dialog == null) {
                this.dialog = new CommonQueryDialog();
                if (this.getUIWindow() == null) {
                    this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
                } else {
                    this.dialog.setOwner((Component)((Object)this));
                }
                this.dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
                this.dialog.setParentUIClassName(uiClassName);
                this.dialog.setShowFilter(false);
                this.dialog.setShowSorter(false);
                this.dialog.setQueryObjectPK(initQueryPK);
                this.dialog.setMaxReturnCountVisible(false);
                userPanel = this.getUserPanel();
                if (userPanel != null) {
                    this.dialog.addUserPanel((KDPanel)userPanel);
                }
            }
            if (this.dialog.show()) {
                userPanel = (TargetResultReportQueryPanelBaseUI)this.dialog.getUserPanel(0);
                if (userPanel != null) {
                    this.targetScoreType = userPanel.getTargetScoreType();
                    this.mainQuery = this.dialog.getEntityViewInfoResult();
                    perfItemName = userPanel.getSelectedPerformTargetName();
                }
            } else {
                SysUtil.abort();
            }
        }
        this.mainQueryPK = new MetaDataPK(this.getQueryFullName());
        this.refreshTable();
        if (!StringUtils.isEmpty(perfItemName)) {
            this.txtTitle.setToolTipText(perfItemName);
            perfItemName = perfItemName.length() > 10 ? perfItemName.substring(0, 9) + "..." : perfItemName;
            this.txtTitle.setText(perfItemName);
        }
    }

    private void refreshTable() {
        this.execQuery();
        this.clearTable();
        this.initTableColumns();
        this.initTableHeader();
        this.fillTable();
        this.calculateAvgScore();
    }

    private void execQuery() {
        if (this.mainQueryPK == null || this.mainQuery == null) {
            return;
        }
        this.eoMap = new HashMap();
        this.apMap = new HashMap();
        this.dataMap = new HashMap();
        IQueryExecutor queryExecutor = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
        try {
            IRowSet rowSet = queryExecutor.executeQuery();
            if (rowSet != null && rowSet.size() > 0) {
                String eoId = null;
                String assessPeriodId = null;
                Map<String, BigDecimal> assessPeriod_Score_Map = null;
                String evaluSolutionId = null;
                while (rowSet.next()) {
                    if (evaluSolutionId == null) {
                        evaluSolutionId = rowSet.getString("evaluSolution.id");
                    }
                    eoId = rowSet.getString(objectIDKey);
                    assessPeriodId = rowSet.getString("assessPeriod.id");
                    assessPeriod_Score_Map = this.dataMap.containsKey(eoId) ? (Map)this.dataMap.get(eoId) : new HashMap<String, BigDecimal>();
                    assessPeriod_Score_Map.put(assessPeriodId, rowSet.getBigDecimal("score"));
                    this.dataMap.put(eoId, assessPeriod_Score_Map);
                    if (!this.eoMap.containsKey(eoId)) {
                        String objectName = rowSet.getString("objectName");
                        String objectNumber = rowSet.getString("objectNumber");
                        String[] array = null;
                        if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)this.solutionType)) {
                            array = new String[]{objectNumber, objectName, rowSet.getString("responser.name")};
                        } else if (EvaluSolutionTypeEnum.PERSON.equals((Object)this.solutionType)) {
                            array = new String[]{objectNumber, objectName};
                        }
                        this.eoMap.put(eoId, array);
                    }
                    if (this.apMap.containsKey(assessPeriodId)) continue;
                    this.apMap.put(assessPeriodId, rowSet.getString("assessPeriod.name"));
                }
                this.PMInfo = PFUtils.getPrecisionMaintainInfo(evaluSolutionId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            super.handleException(e);
        }
    }

    private void clearTable() {
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
    }

    private void initTableColumns() {
        if (this.apMap == null || this.apMap.isEmpty()) {
            return;
        }
        IColumn column = null;
        StyleAttributes style = null;
        column = this.tblMain.getColumn(objectIDKey);
        if (column == null) {
            column = this.tblMain.addColumn(0);
            column.setKey(objectIDKey);
            style = column.getStyleAttributes();
            style.setHided(true);
        }
        if ((column = this.tblMain.getColumn(evaluObjectNumber)) == null) {
            column = this.tblMain.addColumn(1);
            column.setKey(evaluObjectNumber);
            style = column.getStyleAttributes();
            style.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        }
        if ((column = this.tblMain.getColumn(evaluObjectName)) == null) {
            column = this.tblMain.addColumn(2);
            column.setKey(evaluObjectName);
            style = column.getStyleAttributes();
            style.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        }
        if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)this.solutionType) && (column = this.tblMain.getColumn(responser)) == null) {
            column = this.tblMain.addColumn(3);
            column.setKey(responser);
            style = column.getStyleAttributes();
            style.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        }
        String key2 = null;
        for (String key2 : this.apMap.keySet()) {
            column = this.tblMain.getColumn(key2);
            if (column != null) continue;
            column = this.tblMain.addColumn();
            column.setKey(key2);
            style = column.getStyleAttributes();
            Object owner = style.getOwner();
            style.setOwner(null);
            if (this.PMInfo != null) {
                style.setNumberFormat(PFUtils.getNumberFormat(this.PMInfo.getIndexGradePrecision()));
            } else {
                style.setNumberFormat("0.00");
            }
            style.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            style.setOwner(owner);
            style.update();
        }
        column = this.tblMain.getColumn(rowAvgScoreKey);
        if (column == null) {
            column = this.tblMain.addColumn(this.tblMain.getColumnCount());
            column.setKey(rowAvgScoreKey);
            style = column.getStyleAttributes();
            Object owner = style.getOwner();
            style.setOwner(null);
            if (this.PMInfo != null) {
                style.setNumberFormat(PFUtils.getNumberFormat(this.PMInfo.getIndexGradePrecision()));
            } else {
                style.setNumberFormat("0.00");
            }
            style.setBackground(backgroundColor);
            style.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            style.setOwner(owner);
            style.update();
        }
    }

    private void initTableHeader() {
        int cols = this.tblMain.getColumnCount();
        int headRowCount = this.tblMain.getHeadRowCount();
        if (cols == 0 || headRowCount > 0) {
            return;
        }
        IRow row = this.tblMain.addHeadRow(0);
        String key = null;
        Object assessPeriodName = null;
        for (int i = 0; i < cols; ++i) {
            key = this.tblMain.getColumnKey(i);
            if (objectIDKey.equals(key)) {
                row.getCell(key).setValue((Object)objectIDKey);
                continue;
            }
            if (evaluObjectNumber.equals(key)) {
                row.getCell(key).setValue((Object)eoNumberValue);
                continue;
            }
            if (evaluObjectName.equals(key)) {
                row.getCell(key).setValue((Object)eoNameValue);
                continue;
            }
            if (responser.equals(key)) {
                row.getCell(key).setValue((Object)responserValue);
                continue;
            }
            if (rowAvgScoreKey.equals(key)) {
                row.getCell(key).setValue((Object)avgScoreValue);
                continue;
            }
            assessPeriodName = this.apMap.get(key);
            if (assessPeriodName == null) continue;
            row.getCell(key).setValue(assessPeriodName);
        }
    }

    private void fillTable() {
        if (this.dataMap == null || this.dataMap.isEmpty()) {
            return;
        }
        String objectID2 = null;
        String apId2 = null;
        Map apId_score_map = null;
        BigDecimal score = null;
        IRow row = null;
        String[] array = null;
        for (String objectID2 : this.dataMap.keySet()) {
            apId_score_map = (Map)this.dataMap.get(objectID2);
            if (apId_score_map == null || apId_score_map.isEmpty()) continue;
            row = this.tblMain.addRow();
            for (String apId2 : apId_score_map.keySet()) {
                score = (BigDecimal)apId_score_map.get(apId2);
                row.getCell(apId2).setValue((Object)score);
                row.getCell(apId2).setUserObject((Object)score);
            }
            row.getCell(objectIDKey).setValue((Object)objectID2);
            array = (String[])this.eoMap.get(objectID2);
            row.getCell(evaluObjectNumber).setValue((Object)array[0]);
            row.getCell(evaluObjectName).setValue((Object)array[1]);
            if (!EvaluSolutionTypeEnum.ORGUNIT.equals((Object)this.solutionType)) continue;
            row.getCell(responser).setValue((Object)array[2]);
        }
        int rows = this.tblMain.getRowCount();
        if (rows > 0) {
            row = this.tblMain.addRow(rows);
            row.getCell(objectIDKey).setValue((Object)columnAvgScore);
            row.getCell(evaluObjectName).setValue((Object)avgScoreValue);
            StyleAttributes style = row.getStyleAttributes();
            Object owner = style.getOwner();
            style.setOwner(null);
            if (this.PMInfo != null) {
                style.setNumberFormat(PFUtils.getNumberFormat(this.PMInfo.getIndexGradePrecision()));
            } else {
                style.setNumberFormat("0.00");
            }
            style.setBackground(backgroundColor);
            style.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            style.setOwner(owner);
            style.update();
        }
    }

    private void calculateAvgScore() {
        int rows = this.tblMain.getRowCount();
        int cols = this.tblMain.getColumnCount();
        if (rows == 0 || cols == 0) {
            return;
        }
        IRow row = null;
        String key = null;
        Object value = null;
        BigDecimal avgScore = null;
        BigDecimal totalScore = null;
        for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
            row = this.tblMain.getRow(rowIndex);
            if (columnAvgScore.equals(row.getCell(objectIDKey).getValue())) continue;
            totalScore = new BigDecimal("0.00");
            int count = 0;
            for (int colIndex = 0; colIndex < cols; ++colIndex) {
                key = this.tblMain.getColumnKey(colIndex);
                if (this.isNotCalculateColumn(key) || PerfClientUtils.objectIsNull(value = row.getCell(key).getUserObject())) continue;
                ++count;
                totalScore = totalScore.add((BigDecimal)value);
            }
            if (count == 0) continue;
            avgScore = new BigDecimal(totalScore.doubleValue() / (double)count);
            if (this.PMInfo != null) {
                switch (this.PMInfo.getIndexGradePrecisionType().getValue()) {
                    case 10: {
                        row.getCell(rowAvgScoreKey).setValue((Object)new Double(totalScore.doubleValue() / (double)count));
                        break;
                    }
                    case 20: {
                        row.getCell(rowAvgScoreKey).setValue((Object)avgScore.setScale(this.PMInfo.getIndexGradePrecision(), 0));
                        break;
                    }
                    case 30: {
                        row.getCell(rowAvgScoreKey).setValue((Object)avgScore.setScale(this.PMInfo.getIndexGradePrecision(), 1));
                    }
                }
                continue;
            }
            row.getCell(rowAvgScoreKey).setValue((Object)new Double(totalScore.doubleValue() / (double)count));
        }
        IRow colAvgScoreRow = this.getAvgScoreRow();
        for (int colIndex = 0; colIndex < cols; ++colIndex) {
            key = this.tblMain.getColumnKey(colIndex);
            if (this.isNotCalculateColumn(key)) continue;
            totalScore = new BigDecimal("0.00");
            int count = 0;
            for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                row = this.tblMain.getRow(rowIndex);
                if (columnAvgScore.equals(row.getCell(objectIDKey).getValue()) || PerfClientUtils.objectIsNull(value = row.getCell(key).getUserObject())) continue;
                ++count;
                totalScore = totalScore.add((BigDecimal)value);
            }
            if (count == 0) continue;
            avgScore = new BigDecimal(totalScore.doubleValue() / (double)count);
            if (this.PMInfo != null) {
                switch (this.PMInfo.getIndexGradePrecisionType().getValue()) {
                    case 10: {
                        colAvgScoreRow.getCell(key).setValue((Object)new Double(totalScore.doubleValue() / (double)count));
                        break;
                    }
                    case 20: {
                        colAvgScoreRow.getCell(key).setValue((Object)avgScore.setScale(this.PMInfo.getIndexGradePrecision(), 0));
                        break;
                    }
                    case 30: {
                        colAvgScoreRow.getCell(key).setValue((Object)avgScore.setScale(this.PMInfo.getIndexGradePrecision(), 1));
                    }
                }
                continue;
            }
            colAvgScoreRow.getCell(key).setValue((Object)new Double(totalScore.doubleValue() / (double)count));
        }
    }

    private boolean isNotCalculateColumn(String compareValue) {
        return objectIDKey.equals(compareValue) || evaluObjectNumber.equals(compareValue) || evaluObjectName.equals(compareValue) || responser.equals(compareValue) || rowAvgScoreKey.equals(compareValue);
    }

    private IRow getAvgScoreRow() {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (!columnAvgScore.equals(row.getCell(objectIDKey).getValue())) continue;
            return row;
        }
        return null;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        Context objectCtx = super.getMainOrgContext();
        IQueryExecutor exec = null;
        exec = objectCtx != null && FrameWorkUtils.getCurrentOrgUnit((Context)objectCtx) != null ? QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)queryPK, (Context)objectCtx) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterInfo fi = viewInfo.getFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "adminOrgUnit.id"));
        if (fi != null) {
            try {
                fi.mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                super.handleException((Exception)((Object)e));
            }
        } else {
            viewInfo.setFilter(filter);
        }
        exec.setObjectView(viewInfo);
        return exec;
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTable();
    }
}

