/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.PerformTargetItemInfo;
import com.kingdee.eas.hr.perf.TargetScoreTypeEnum;
import com.kingdee.eas.hr.perf.client.AbstractTargetResultReportQueryPanelBaseUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionF7Helper;
import com.kingdee.eas.hr.perf.client.FilterUIUtil;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PerformanceTargetSinglePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TargetResultReportQueryPanelBaseUI
extends AbstractTargetResultReportQueryPanelBaseUI
implements SelectorListener {
    private static final Logger logger = CoreUIObject.getLogger(TargetResultReportQueryPanelBaseUI.class);
    private static String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private boolean isLoadData = false;

    public TargetScoreTypeEnum getTargetScoreType() {
        TargetScoreTypeEnum scoreType = TargetScoreTypeEnum.WEIGHTSCORE;
        if (this.radioAvgScore.isSelected()) {
            scoreType = TargetScoreTypeEnum.AVGSCORE;
        }
        return scoreType;
    }

    public String getSelectedPerformTargetName() {
        Object obj = this.prmptPerformTarget.getData();
        if (PerfClientUtils.objectIsNull(obj)) {
            return null;
        }
        return ((PerformTargetItemInfo)obj).getContent();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.radioWeightScore.setSelected(true);
        PerformanceTargetSinglePromptBox promptBox = new PerformanceTargetSinglePromptBox((IUIObject)this);
        this.prmptPerformTarget.setSelector((KDPromptSelector)promptBox);
        this.prmptPerformTarget.setEditable(false);
        EvaluSolutionF7Helper.initOrgUnit(this.prmptAdminOrg, (IUIObject)this);
        this.prmptSolutionPeriod.addSelectorListener((SelectorListener)this);
        this.prmptSolutionPeriod.setEnabledMultiSelection(true);
        this.prmptAdminOrg.setEnabledMultiSelection(true);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        FilterItemInfo item = null;
        Object data = null;
        data = this.prmptPerformTarget.getData();
        if (!PerfClientUtils.objectIsNull(data)) {
            item = new FilterItemInfo("perfItem.id", (Object)((PerformTargetItemInfo)data).getId().toString());
            items.add(item);
        }
        if (!PerfClientUtils.objectIsNull(data = this.prmptEvaluSolution.getData())) {
            item = new FilterItemInfo("evaluSolution.id", (Object)((EvaluSolutionInfo)data).getId().toString());
            items.add(item);
        }
        if (!PerfClientUtils.objectArrayIsNull(data = this.prmptSolutionPeriod.getData())) {
            HashSet ids = PerfClientUtils.getObjectArrayIds(data);
            item = new FilterItemInfo("assessPeriod.id", (Object)ids, CompareType.INCLUDE);
            items.add(item);
        }
        return filter;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        FilterUIUtil.saveData(params, (Component)this.prmptEvaluSolution);
        FilterUIUtil.saveData(params, (Component)this.prmptSolutionPeriod);
        FilterUIUtil.saveData(params, (Component)this.prmptAdminOrg);
        FilterUIUtil.saveData(params, (Component)this.radioAvgScore);
        FilterUIUtil.saveData(params, (Component)this.radioWeightScore);
        if (this.prmptPerformTarget.getData() != null) {
            PerformTargetItemInfo info = (PerformTargetItemInfo)this.prmptPerformTarget.getData();
            params.addCustomerParam("classprmptPerformTarget", info.getClass().getName());
            params.addCustomerParam("idprmptPerformTarget", info.getId().toString());
            params.addCustomerParam("numberprmptPerformTarget", info.getNumber());
            params.addCustomerParam("contentprmptPerformTarget", info.getContent());
        }
        return params;
    }

    public void setCustomerParams(CustomerParams param) {
        this.isLoadData = true;
        try {
            FilterUIUtil.retriveData(param, (Component)this.prmptEvaluSolution);
            FilterUIUtil.retriveData(param, (Component)this.prmptSolutionPeriod);
            FilterUIUtil.retriveData(param, (Component)this.prmptAdminOrg);
            FilterUIUtil.retriveData(param, (Component)this.radioAvgScore);
            FilterUIUtil.retriveData(param, (Component)this.radioWeightScore);
            PerformTargetItemInfo info = new PerformTargetItemInfo();
            info.setContent(param.getCustomerParam("contentprmptPerformTarget"));
            info.setNumber(param.getCustomerParam("numberprmptPerformTarget"));
            info.setId(BOSUuid.read((String)param.getCustomerParam("idprmptPerformTarget")));
            this.prmptPerformTarget.setValue((Object)info);
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        this.isLoadData = false;
    }

    public void clear() {
        this.prmptPerformTarget.setValue(null);
        this.prmptEvaluSolution.setValue(null);
        this.prmptSolutionPeriod.setValue(null);
        this.prmptAdminOrg.setValue(null);
        this.radioWeightScore.setSelected(true);
    }

    public boolean verify() {
        if (this.prmptPerformTarget.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"NotSelectedPerformTarget"));
            return false;
        }
        if (this.prmptEvaluSolution.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"NotSelectedEvaluSolution"));
            return false;
        }
        return true;
    }

    @Override
    protected void prmptEvaluSolution_dataChanged(DataChangeEvent e) throws Exception {
        Object data = this.prmptEvaluSolution.getData();
        if (PerfClientUtils.objectIsNull(data)) {
            this.prmptSolutionPeriod.setValue(null);
        } else {
            String solutionId = String.valueOf(((EvaluSolutionInfo)data).getId());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)solutionId));
            view.setFilter(filter);
            this.prmptSolutionPeriod.setEntityViewInfo(view);
            if (!(this.isLoadData || e.getOldValue() != null && e.getNewValue().equals(e.getOldValue()))) {
                this.prmptSolutionPeriod.setValue(null);
            }
        }
    }

    public void willShow(SelectorEvent e) {
        if (this.prmptEvaluSolution.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"NotSelectedEvaluSolution"));
            e.setCanceled(true);
        }
    }
}

