/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.ITargetEvaluStoreFacade;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFacadeFactory;
import com.kingdee.eas.hr.perf.client.AbstractTargetStoreCopyUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public abstract class TargetStoreCopyUI
extends AbstractTargetStoreCopyUI {
    private static final long serialVersionUID = -61166L;
    private static final String COPY_ROWS = "copy_rows";
    protected BigDecimal totalWeight = null;
    protected BigDecimal allocableWeight = null;
    protected static final BigDecimal HUNDRE = new BigDecimal("100.00");
    protected static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    protected final HashMap dataMap = new HashMap();
    private boolean isConfirmed = false;
    protected Icon evaluObjectIcon = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnRemoveItem.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRemoveAllItems.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.lblTargetStoreCaption.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
        this.lblTargetStoreDest.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.setEvaluObjectIcon();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        Map context = super.getUIContext();
        IRow[] rows = (IRow[])context.get(COPY_ROWS);
        KDTColumns columns = (KDTColumns)context.get("columns");
        this.tblMain.removeColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            this.tblMain.addColumn(i, columns.getColumn(i));
        }
        this.tblMain.addHeadRow(0, (IRow)context.get("headRow"));
        this.totalWeight = new BigDecimal("0.00");
        for (int i = 0; i < rows.length; ++i) {
            IRow copyRow = rows[i];
            this.tblMain.addRow(i, copyRow);
            if (copyRow.getCell("weight").getValue() == null) continue;
            this.totalWeight = this.totalWeight.add((BigDecimal)copyRow.getCell("weight").getValue());
        }
        this.totalWeight = this.totalWeight.multiply(HUNDRE);
        this.allocableWeight = HUNDRE.subtract(this.totalWeight);
        this.initSolutionPeriod();
        this.listSource.setLayoutOrientation(1);
        this.listDest.setLayoutOrientation(1);
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        Object[] values = this.listSource.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            this.listDest.addElement(values[i]);
        }
        int[] indices = this.listSource.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.listSource.removeElementAt(indices[i]);
        }
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        int count = this.listSource.getElementCount();
        for (int i = count - 1; i >= 0; --i) {
            this.listDest.addElement(this.listSource.getElement(i));
            this.listSource.removeElementAt(i);
        }
    }

    @Override
    protected void btnRemoveAllItems_actionPerformed(ActionEvent e) throws Exception {
        int count = this.listDest.getElementCount();
        for (int i = count - 1; i >= 0; --i) {
            this.listSource.addElement(this.listDest.getElement(i));
            this.listDest.removeElementAt(i);
        }
    }

    @Override
    protected void btnRemoveItem_actionPerformed(ActionEvent e) throws Exception {
        Object[] values = this.listDest.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            this.listSource.addElement(values[i]);
        }
        int[] indices = this.listDest.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.listDest.removeElementAt(indices[i]);
        }
    }

    @Override
    protected void btnConfirmCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.listDest.getElementCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noSelectedEvaluObject"));
            return;
        }
        if (this.btnTargetCopyAndDeliver.isSelected() && !this.canDeliver()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noDeliverRigthsWhenCopy"));
            this.btnTargetCopyOnly.setSelected(true);
            this.btnTargetCopyAndDeliver.setSelected(false);
            return;
        }
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                HashMap data = TargetStoreCopyUI.this.getData();
                List evaluObjectIDList = (List)data.get("evaluObject");
                List targetStoreIDList = (List)data.get("targetStore");
                BOSUuid solutionPeriodID = (BOSUuid)data.get("solutionPeriod");
                boolean isDeiliver = (Boolean)data.get("dlivered");
                ITargetEvaluStoreFacade facade = TargetEvaluStoreFacadeFactory.getRemoteInstance();
                facade.copyTaretEvaluStore(evaluObjectIDList, solutionPeriodID, targetStoreIDList, isDeiliver);
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                TargetStoreCopyUI.this.isConfirmed = true;
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
        this.actionExitCurrent_actionPerformed(null);
    }

    protected abstract void initSolutionPeriod() throws Exception;

    public HashMap getData() {
        ArrayList<String> targetStoreIDList = new ArrayList<String>();
        Map context = super.getUIContext();
        IRow[] rows = (IRow[])context.get(COPY_ROWS);
        if (rows != null && rows.length > 0) {
            int j = rows.length;
            for (int i = 0; i < j; ++i) {
                targetStoreIDList.add(rows[i].getCell("id").getValue().toString());
            }
        }
        BOSUuid solutionPeriodID = ((SolutionPeriodInfo)this.comboSoultionPeriod.getSelectedItem()).getId();
        ArrayList<BOSUuid> evaluObjectIDList = new ArrayList<BOSUuid>();
        int n = this.listDest.getElementCount();
        for (int i = 0; i < n; ++i) {
            evaluObjectIDList.add(((EvaluObjectInfo)this.listDest.getElement(i)).getId());
        }
        this.dataMap.put("evaluObject", evaluObjectIDList);
        this.dataMap.put("targetStore", targetStoreIDList);
        this.dataMap.put("solutionPeriod", solutionPeriodID);
        this.dataMap.put("dlivered", this.btnTargetCopyAndDeliver.isSelected());
        return this.dataMap;
    }

    public boolean isConfirmed() {
        return this.isConfirmed;
    }

    protected void setEvaluObjectIcon() {
    }

    @Override
    protected void listSource_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.btnAdd_actionPerformed(null);
        }
    }

    @Override
    protected void listDest_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.btnRemoveItem_actionPerformed(null);
        }
    }

    protected abstract boolean canDeliver() throws Exception;
}

