/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.IMultiDimentionEvalution;
import com.kingdee.eas.hr.perf.MultiDimentionCommentCollection;
import com.kingdee.eas.hr.perf.MultiDimentionCommentFactory;
import com.kingdee.eas.hr.perf.MultiDimentionEvalutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.PaperQuestionsCollection;
import com.kingdee.eas.hr.perf.PaperQuestionsFactory;
import com.kingdee.eas.hr.perf.PaperQuestionsInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.TestPaperFactory;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.hr.perf.client.AbstractTestPaperBrowseUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class TestPaperBrowseUI
extends AbstractTestPaperBrowseUI {
    private static final String RES = "com.kingdee.eas.hr.perf.client.TestQuestion";
    private KDNoteHelper appHlp = new KDNoteHelper();
    private boolean haveEvals = false;
    private boolean isHidePaperWeight = false;
    private static final String HAVE_EVAL_TEMPLETE = "/HR/PF/testPaper_haveEval";
    private static final String NO_EVAL_TEMPLETE = "/HR/PF/testPaper_noEval";
    private static Color ITEM_SUM_COLOR = new Color(16119270);
    private static Color STAT_COLOR = new Color(0xF6F6BF);

    public void onLoad() throws Exception {
        super.onLoad();
        this.isHidePaperWeight = this.checkHidePaperWeight();
        this.lblTitle.setHorizontalAlignment(0);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.fillData();
        this.tblMain.getColumn("content").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn("content").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblMain.getColumn("standard").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn("standard").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblMain.addKDTResizeListener(new KDTResizeListener(){

            public void tableColumnResize(KDTResizeEvent e) {
                TestPaperBrowseUI.this.reSizeTable();
            }

            public void tableRowResize(KDTResizeEvent e) {
            }
        });
    }

    private void reSizeTable() {
        int rows = this.tblMain.getRowCount();
        List columns = this.tblMain.getColumns().getColumns();
        for (int i = 0; i < rows; ++i) {
            IRow row = this.tblMain.getRow(i);
            int rowHeight = this.getRowHeight(row, columns);
            row.setHeight(rowHeight);
        }
        this.tblMain.reLayoutAndPaint();
        this.pnlMain.revalidate();
    }

    private int getRowHeight(IRow row, List columns) {
        int rowHeight = 0;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            KDTColumn column = (KDTColumn)columns.get(i);
            if (column.getStyle().isHided()) continue;
            Object object = row.getCell(i).getValue();
            String value = null;
            if (object != null) {
                value = object.toString();
            }
            int cellHeight = 0;
            if (!StringUtil.isEmptyString((String)value)) {
                cellHeight = this.getCellHeight(value, column.getWidth());
            }
            if (rowHeight >= cellHeight) continue;
            rowHeight = cellHeight;
        }
        return rowHeight;
    }

    private int getCellHeight(String cellComment, int columnWidth) {
        if (columnWidth == -1) {
            columnWidth = 100;
        }
        String[] comment = cellComment.split("\n");
        int rowCount = 0;
        int rowCharSize = columnWidth / 12;
        int len = comment.length;
        for (int i = 0; i < len; ++i) {
            byte[] bytes = comment[i].getBytes();
            rowCount += bytes.length / (2 * rowCharSize) + 1;
        }
        int stripCount = 0;
        char[] chars = cellComment.toCharArray();
        int len2 = chars.length;
        for (int i = 0; i < len2 - 1; ++i) {
            if (chars[i] != '\n' || chars[i + 1] != '\n') continue;
            ++stripCount;
        }
        return 18 * (rowCount + stripCount);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrintTestPaper.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnTestPaperPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        super.setButtonDefaultStyl(this.btnPrintTestPaper);
        super.setButtonDefaultStyl(this.btnTestPaperPrintView);
    }

    private boolean checkHidePaperWeight() throws EASBizException, BOSException {
        String mdSolutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        if (PerfUtils.objectIsNull(mdSolutionPeriodID)) {
            return false;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.hidePaperWeight", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)mdSolutionPeriodID));
        return MultiDimentionSolutionPeriodFactory.getRemoteInstance().exists(filterInfo);
    }

    private void fillData() throws Exception {
        String id = (String)this.getUIContext().get("ID");
        if (id == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.name"));
        sic.add(new SelectorItemInfo("Remark"));
        TestPaperInfo info = (TestPaperInfo)TestPaperFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(id), sic);
        if (info.getGradeMode() != null) {
            this.txtGradeMode.setText(info.getGradeMode().getName());
        }
        if (info.getRemark() != null) {
            this.txtDes.setText(info.getRemark());
        }
        String title = info.getName();
        this.lblTitle.setText(title);
        this.pnlMain.revalidate();
        this.fillTable(id);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)id));
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("serial"));
        MultiDimentionCommentCollection coll = MultiDimentionCommentFactory.getRemoteInstance().getMultiDimentionCommentCollection(viewInfo);
        KDLabel lbl = null;
        KDScrollPane scroll = null;
        KDTextArea area = null;
        int y = this.tblMain.getY() + this.tblMain.getHeight() + 10;
        if (coll != null && coll.size() > 0) {
            int baseY = 0;
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                int height;
                baseY = y + i * 110;
                lbl = new KDLabel(coll.get(i).getComment() + ":");
                this.pnlMain.add((Component)lbl, (Object)new KDLayout.Constraints(10, baseY, 740, 19, 5));
                area = new KDTextArea();
                area.setEditable(false);
                scroll = new KDScrollPane((Component)area);
                scroll.setBounds(new Rectangle(10, baseY + 19, 740, 81));
                this.pnlMain.add((Component)scroll, (Object)new KDLayout.Constraints(10, baseY + 19, 740, 81, 5));
                if (i != n - 1 || !((double)(height = scroll.getY() + scroll.getHeight()) > this.pnlMain.getPreferredSize().getHeight())) continue;
                this.pnlMain.setPreferredSize(new Dimension(750, height + 20));
            }
        } else {
            int height = y;
            if ((double)height > this.pnlMain.getPreferredSize().getHeight()) {
                this.pnlMain.setPreferredSize(new Dimension(750, height + 20));
            }
        }
        this.pnlMain.revalidate();
        this.pnlScroll.revalidate();
    }

    private void fillTable(String id) throws Exception {
        if (id == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)id));
        IMultiDimentionEvalution imde = MultiDimentionEvalutionFactory.getRemoteInstance();
        this.haveEvals = imde.exists(filter);
        KDTMergeManager mm = this.tblMain.getMergeManager();
        StringTokenizer tk = null;
        int lineHight = 17;
        if (this.haveEvals) {
            this.tblMain.getColumn("serial").getStyleAttributes().setHided(true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("serial"));
            sic.add(new SelectorItemInfo("weight"));
            sic.add(new SelectorItemInfo("testQuestion.id"));
            sic.add(new SelectorItemInfo("testQuestion.content"));
            sic.add(new SelectorItemInfo("testQuestion.standard"));
            sic.add(new SelectorItemInfo("evaluation.id"));
            sic.add(new SelectorItemInfo("evaluation.serial"));
            sic.add(new SelectorItemInfo("evaluation.evaluation"));
            sic.add(new SelectorItemInfo("evaluation.weight"));
            SorterItemCollection sorter = viewInfo.getSorter();
            SorterItemInfo sorterItem = new SorterItemInfo("serial");
            sorterItem.setSortType(SortType.ASCEND);
            sorter.add(sorterItem);
            PaperQuestionsCollection pqColl = PaperQuestionsFactory.getRemoteInstance().getPaperQuestionsCollection(viewInfo);
            IRow row = null;
            PaperQuestionsInfo pqInfo = null;
            int height = 44;
            if (pqColl != null && pqColl.size() > 0) {
                StringBuffer sb = null;
                int count = 0;
                TreeSet<Integer> set = new TreeSet<Integer>();
                int n = pqColl.size();
                for (int i = 0; i < n; ++i) {
                    set.add(new Integer(pqColl.get(i).getEvaluation().getSerial()));
                }
                int s = 0;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    s = (Integer)iter.next();
                    int n2 = pqColl.size();
                    for (int i = 0; i < n2; ++i) {
                        pqInfo = pqColl.get(i);
                        if (pqInfo.getEvaluation().getSerial() != s) continue;
                        row = this.tblMain.addRow();
                        count = 0;
                        sb = new StringBuffer(pqInfo.getEvaluation().getEvaluation());
                        int j = 1;
                        while (j * 10 + j - 1 < sb.length()) {
                            sb.insert(j * 10 + j - 1, "\n");
                            ++j;
                        }
                        if (sb.length() < 10 && sb.length() > 2) {
                            sb.append("\n");
                        } else if (sb.length() - count * 10 < 9) {
                            sb.append("\n");
                        }
                        if (!this.isHidePaperWeight) {
                            sb.append(" (");
                            sb.append(PFVerifyUtils.formatBigDecimal(pqInfo.getEvaluation().getWeight(), 2) + "%");
                            sb.append(")");
                        }
                        row.getCell("eval").setValue((Object)sb.toString());
                        tk = new StringTokenizer(sb.toString(), "\n");
                        if (tk.countTokens() > count) {
                            count = tk.countTokens();
                        }
                        sb = new StringBuffer(pqInfo.getTestQuestion().getContent());
                        int contentCount = 0;
                        int j2 = 1;
                        while (j2 * 15 + j2 - 1 < sb.length()) {
                            ++contentCount;
                            ++j2;
                        }
                        row.getCell("content").setValue((Object)sb.toString());
                        if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                            count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                        }
                        sb = new StringBuffer(pqInfo.getTestQuestion().getStandard());
                        contentCount = 0;
                        j2 = 1;
                        while (j2 * 14 + j2 - 1 < sb.length()) {
                            ++contentCount;
                            ++j2;
                        }
                        row.getCell("standard").setValue((Object)sb.toString());
                        if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                            count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                        }
                        row.getCell("weight").setValue((Object)(PFVerifyUtils.formatBigDecimal(pqInfo.getWeight(), 2) + "%"));
                        height += lineHight * count;
                        row.setHeight(lineHight * count);
                    }
                }
                this.tblMain.getColumn("eval").setGroup(true);
                this.tblMain.getColumn("evalSumScore").setGroup(true);
                this.tblMain.getGroupManager().group();
                row = this.tblMain.addRow();
                row.getCell("eval").setValue((Object)EASResource.getString((String)RES, (String)"scoreSumTitle"));
                mm.mergeBlock(row.getRowIndex(), row.getCell("content").getColumnIndex(), row.getRowIndex(), row.getCell("score").getColumnIndex());
            }
            height = height < 500 ? height * 19 / lineHight : (height < 1000 ? height * 19 / 19 : height * lineHight / 19);
            this.tblMain.setBounds(new Rectangle(10, 110, 740, height));
            this.pnlMain.add((Component)this.tblMain, (Object)new KDLayout.Constraints(10, 110, 740, height, 5));
            if (this.pnlMain.getY() > this.pnlMain.getPreferredSize().height) {
                this.pnlMain.setPreferredSize(new Dimension(750, this.pnlMain.getY() + 50));
            }
            this.pnlMain.revalidate();
        } else {
            this.tblMain.getColumn("eval").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setHided(true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("serial"));
            sic.add(new SelectorItemInfo("weight"));
            sic.add(new SelectorItemInfo("testQuestion.id"));
            sic.add(new SelectorItemInfo("testQuestion.content"));
            sic.add(new SelectorItemInfo("testQuestion.standard"));
            SorterItemCollection sorter = viewInfo.getSorter();
            SorterItemInfo sorterItem = new SorterItemInfo("serial");
            sorterItem.setSortType(SortType.ASCEND);
            sorter.add(sorterItem);
            PaperQuestionsCollection pqColl = PaperQuestionsFactory.getRemoteInstance().getPaperQuestionsCollection(viewInfo);
            IRow row = null;
            PaperQuestionsInfo pqInfo = null;
            StringBuffer sb = null;
            int count = 0;
            int height = 44;
            if (pqColl != null && pqColl.size() > 0) {
                int n = pqColl.size();
                for (int i = 0; i < n; ++i) {
                    count = 0;
                    pqInfo = pqColl.get(i);
                    row = this.tblMain.addRow();
                    row.getCell("serial").setValue((Object)new Integer(pqInfo.getSerial()));
                    sb = new StringBuffer(pqInfo.getTestQuestion().getContent());
                    int contentCount = 0;
                    int j = 1;
                    while (j * 22 + j - 1 < sb.length()) {
                        ++contentCount;
                        ++j;
                    }
                    row.getCell("content").setValue((Object)sb.toString());
                    if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                        count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                    }
                    sb = new StringBuffer(pqInfo.getTestQuestion().getStandard());
                    contentCount = 0;
                    j = 1;
                    while (j * 22 + j - 1 < sb.length()) {
                        ++contentCount;
                        ++j;
                    }
                    row.getCell("standard").setValue((Object)sb.toString());
                    if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                        count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                    }
                    row.getCell("weight").setValue((Object)(PFVerifyUtils.formatBigDecimal(pqInfo.getWeight(), 2) + "%"));
                    row.setHeight(count * lineHight);
                    height += count * lineHight;
                }
                this.tblMain.getColumn("eval").setGroup(true);
                this.tblMain.getColumn("evalSumScore").setGroup(true);
                this.tblMain.getGroupManager().group();
                row = this.tblMain.addRow();
                row.getCell("serial").setValue((Object)EASResource.getString((String)RES, (String)"scoreSumTitle"));
                mm.mergeBlock(row.getRowIndex(), row.getCell("content").getColumnIndex(), row.getRowIndex(), row.getCell("weight").getColumnIndex());
            }
            height = height < 500 ? height * 19 / lineHight : (height < 1000 ? height * 19 / 19 : height * 15 / lineHight);
            this.tblMain.setBounds(new Rectangle(10, 110, 740, height));
            this.pnlMain.add((Component)this.tblMain, (Object)new KDLayout.Constraints(10, 110, 740, height, 5));
            if (this.pnlMain.getY() > this.pnlMain.getPreferredSize().height) {
                this.pnlMain.setPreferredSize(new Dimension(750, this.pnlMain.getY() + 50));
            }
            this.pnlMain.revalidate();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        String id = (String)this.getUIContext().get("ID");
        if (id == null) {
            return;
        }
        boolean haveEvals = false;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)id));
        IMultiDimentionEvalution imde = MultiDimentionEvalutionFactory.getRemoteInstance();
        haveEvals = imde.exists(filter);
        if (haveEvals) {
            this.tblMain.getColumn("eval").setWidth(165);
            this.tblMain.getColumn("content").setWidth(190);
            this.tblMain.getColumn("standard").setWidth(180);
            this.tblMain.getColumn("weight").setWidth(50);
            this.tblMain.getColumn("score").setWidth(50);
            this.tblMain.getColumn("evalSumScore").setWidth(77);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setBackground(ITEM_SUM_COLOR);
        } else {
            this.tblMain.getColumn("serial").setWidth(60);
            this.tblMain.getColumn("content").setWidth(280);
            this.tblMain.getColumn("standard").setWidth(272);
            this.tblMain.getColumn("weight").setWidth(50);
            this.tblMain.getColumn("score").setWidth(50);
            this.tblMain.getColumn("score").getStyleAttributes().setBackground(ITEM_SUM_COLOR);
        }
        if (this.isHidePaperWeight) {
            this.tblMain.getColumn("weight").getStyleAttributes().setHided(true);
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getStyleAttributes().setBackground(STAT_COLOR);
        this.reSizeTable();
    }

    @Override
    public void actionTestPaperPrintView_actionPerformed(ActionEvent e) throws Exception {
        String id = (String)this.getUIContext().get("ID");
        if (id == null) {
            return;
        }
        TestPaperDataProvider data = new TestPaperDataProvider(id);
        if (this.haveEvals) {
            this.appHlp.printPreview(HAVE_EVAL_TEMPLETE, (Object)data, (Component)((Object)this));
        } else {
            this.appHlp.printPreview(NO_EVAL_TEMPLETE, (Object)data, (Component)((Object)this));
        }
    }

    @Override
    public void actionPrintTestPaper_actionPerformed(ActionEvent e) throws Exception {
        String id = (String)this.getUIContext().get("ID");
        if (id == null) {
            return;
        }
        TestPaperDataProvider data = new TestPaperDataProvider(id);
        if (this.haveEvals) {
            this.appHlp.print(HAVE_EVAL_TEMPLETE, (Object)data, (Component)((Object)this));
        } else {
            this.appHlp.print(NO_EVAL_TEMPLETE, (Object)data, (Component)((Object)this));
        }
    }

    private int countStringOutPutLen(String string, int charLen, int varcharLen, int minLen, int maxLen) {
        if (PFVerifyUtils.objectIsNull(string)) {
            return minLen;
        }
        int returnLen = 0;
        int lens = string.length();
        int bytes = string.getBytes().length;
        returnLen = varcharLen * (bytes - lens);
        if ((returnLen += charLen * (2 * lens - bytes)) > maxLen) {
            return maxLen;
        }
        return returnLen;
    }

    public class TestPaperDataProvider
    implements BOSQueryDelegate {
        private static final String pack = "com.kingdee.eas.hr.perf.app";
        private String testPaperID = null;

        public TestPaperDataProvider(String testPaperID) {
            this.testPaperID = testPaperID;
        }

        public IRowSet execute(BOSQueryDataSource ds) {
            Variant paramVal = null;
            ArrayList ps = ds.getParams();
            if (ps != null && ps.size() > 0) {
                DSParam param = (DSParam)ps.get(0);
                paramVal = param.getValue();
            }
            try {
                return this.getRowSet(ds.getID(), paramVal);
            }
            catch (Exception ex) {
                TestPaperBrowseUI.this.handleException(ex);
                return null;
            }
        }

        protected IRowSet getRowSet(String id, Variant paramVal) throws Exception {
            IQueryExecutor iqec = null;
            EntityViewInfo testPaperViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)this.testPaperID));
            testPaperViewInfo.setFilter(filter);
            SorterItemCollection sorter = testPaperViewInfo.getSorter();
            sorter.add(new SorterItemInfo("serial"));
            if ("testPaper".equals(id)) {
                iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(pack, "TestPaperForPrintQuery"));
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo paperfilter = new FilterInfo();
                paperfilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.testPaperID));
                viewInfo.setFilter(paperfilter);
                iqec.setObjectView(viewInfo);
                return iqec.executeQuery();
            }
            if ("multiComment".equals(id)) {
                iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(pack, "MultiDimCommentPrintQuery"));
                iqec.setObjectView(testPaperViewInfo);
                IRowSet rowSet = iqec.executeQuery();
                while (rowSet.next()) {
                    rowSet.updateString("comment", rowSet.getString("comment") + ":");
                }
                rowSet.beforeFirst();
                return rowSet;
            }
            if ("multiEval".equals(id)) {
                iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(pack, "MultiEvalForPrintQuery"));
                iqec.setObjectView(testPaperViewInfo);
                IRowSet rowSet = iqec.executeQuery();
                if (!TestPaperBrowseUI.this.isHidePaperWeight) {
                    while (rowSet.next()) {
                        rowSet.updateString("evaluation", rowSet.getString("evaluation") + " ( " + PFVerifyUtils.formatBigDecimal(rowSet.getBigDecimal("weight"), 2) + "% )");
                    }
                    rowSet.beforeFirst();
                }
                return rowSet;
            }
            if ("paperQuestion".equals(id)) {
                iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(pack, "PaperQuestionsForPrintQuery"));
                String evalID = (String)paramVal.getValue();
                if (evalID != null) {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo evalFilter = new FilterInfo();
                    evalFilter.getFilterItems().add(new FilterItemInfo("evaluation.id", (Object)evalID));
                    viewInfo.setFilter(evalFilter);
                    sorter = viewInfo.getSorter();
                    sorter.add(new SorterItemInfo("serial"));
                    iqec.setObjectView(viewInfo);
                } else {
                    iqec.setObjectView(testPaperViewInfo);
                }
                IRowSet rowSet = iqec.executeQuery();
                while (rowSet.next()) {
                    if (TestPaperBrowseUI.this.isHidePaperWeight) {
                        rowSet.updateString("weightPercent", null);
                        continue;
                    }
                    rowSet.updateString("weightPercent", PFVerifyUtils.formatBigDecimal(rowSet.getBigDecimal("weight"), 2) + "%");
                }
                rowSet.beforeFirst();
                return rowSet;
            }
            if ("mutilEvalAndPaperQuestion".equals(id)) {
                iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(pack, "MultiEvalAndPaperQuestionForPrintQuery"));
                if (paramVal.getValue() != null) {
                    String evalID = (String)paramVal.getValue();
                    if (evalID != null) {
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo evalFilter = new FilterInfo();
                        evalFilter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)evalID));
                        viewInfo.setFilter(evalFilter);
                        sorter = viewInfo.getSorter();
                        sorter.add(new SorterItemInfo("serial"));
                        iqec.setObjectView(viewInfo);
                    } else {
                        iqec.setObjectView(testPaperViewInfo);
                    }
                }
                IRowSet rowSet = iqec.executeQuery();
                while (rowSet.next()) {
                    if (TestPaperBrowseUI.this.isHidePaperWeight) {
                        rowSet.updateString("weightPercent", null);
                        continue;
                    }
                    rowSet.updateString("evaluation.evaluation", rowSet.getString("evaluation.evaluation") + " ( " + PFVerifyUtils.formatBigDecimal(rowSet.getBigDecimal("evaluation.weight"), 2) + "% )");
                    rowSet.updateString("weightPercent", PFVerifyUtils.formatBigDecimal(rowSet.getBigDecimal("weight"), 2) + "%");
                }
                rowSet.beforeFirst();
                return rowSet;
            }
            return null;
        }
    }
}

