/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.EvalPersonInputSocreFacadeFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IEvalPersonInputSocreFacade;
import com.kingdee.eas.hr.perf.IEvalRelationDetail;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.TestPageFormFactory;
import com.kingdee.eas.hr.perf.client.AbstractTestPaperInputScoreUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class TestPaperInputScoreUI
extends AbstractTestPaperInputScoreUI {
    private static final long serialVersionUID = 104715289038L;
    private String currentMDID = null;
    private String currentSolutionPeriodID = null;
    private BigDecimal minGrade = null;
    private BigDecimal maxGrade = null;
    private BigDecimal oldScore = null;
    private String perfrankID = null;
    protected static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private HashMap changedScore = new HashMap();
    private HashMap changedPerfRank = new HashMap();
    private HashMap changedPerfRankDetail = new HashMap();
    private HashMap changedAvgScore = new HashMap();
    private HashMap changedAvgScoreDetail = new HashMap();
    private BigDecimal sumScore = null;
    private RankInfo rank = null;
    private GradeModeInfo gradeMode = null;
    private IRow avgRow = null;

    public void onLoad() throws Exception {
        this.currentMDID = (String)this.getUIContext().get("ID");
        this.currentSolutionPeriodID = (String)this.getUIContext().get("SUID");
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.gradeMode = (GradeModeInfo)this.getUIContext().get("GM");
        if (this.gradeMode != null) {
            this.txtGradeMode.setText(this.gradeMode.getName());
            this.minGrade = this.gradeMode.getMinGrade();
            this.maxGrade = this.gradeMode.getMaxGrade();
            this.txtGradeFrom.setText(PFVerifyUtils.formatBigDecimal(this.minGrade, 2));
            this.txtGradeTo.setText(PFVerifyUtils.formatBigDecimal(this.maxGrade, 2));
            this.txtGradeFrom.setEditable(false);
            this.txtGradeFrom.setEditable(false);
            this.txtGradeTo.setEditable(false);
        }
        this.tblSelected.setColumnMoveable(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        super.setButtonDefaultStyl(this.btnSaveData);
        this.btnSaveData.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TestPageFormFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MDObject.id", (Object)this.currentMDID));
        filter.getFilterItems().add(new FilterItemInfo("SolutionPeriod.id", (Object)this.currentSolutionPeriodID));
        return filter;
    }

    private void fillSelectedTable(String relationID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalRelation.id", (Object)relationID));
        String mdObjectID = (String)this.getUIContext().get("ID");
        filter.getFilterItems().add(new FilterItemInfo("MDObject.id", (Object)mdObjectID));
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalPersonInputScoreQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)queryPK, viewInfo);
        this.tblSelected.removeRows();
        IRowSet rowSet = exec.executeQuery();
        IRow row = null;
        while (rowSet.next()) {
            row = this.tblSelected.addRow();
            String id = rowSet.getString("id");
            row.getCell("id").setValue((Object)id);
            row.getCell("number").setValue((Object)rowSet.getString("person.number"));
            row.getCell("name").setValue((Object)rowSet.getString("person.name"));
            row.getCell("orgUnit").setValue((Object)rowSet.getString("adminOrgUnit.name"));
            row.getCell("position").setValue((Object)rowSet.getString("position.name"));
            row.getCell("score").setValue((Object)rowSet.getBigDecimal("score"));
            if (this.changedScore.get(id) != null) {
                row.getCell("score").setValue(this.changedScore.get(id));
            }
            row.getCell("rank").setValue((Object)rowSet.getString("rank.name"));
            if (this.changedPerfRankDetail.get(id) != null) {
                row.getCell("rank").setValue(this.changedPerfRankDetail.get(id));
            }
            row.getCell("rankID").setValue((Object)rowSet.getString("rank.id"));
            if (this.changedPerfRank.get(id) == null) continue;
            row.getCell("rankID").setValue(this.changedPerfRank.get(id));
        }
    }

    protected void wfInit() {
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        String type = null;
        try {
            BigDecimal percent = new BigDecimal("0.01");
            BigDecimal weight = null;
            while (rowSet.next()) {
                type = rowSet.getString("MDEvaluTypeEnum");
                if (!MDEvaluTypeEnum.APPOINT.toString().equals(type)) {
                    rowSet.updateString("name", type);
                } else {
                    rowSet.updateString("name", rowSet.getString("name") + "(" + type + ")");
                }
                if (this.changedAvgScore.get(rowSet.getString("id")) != null) {
                    rowSet.updateBigDecimal("EvalRelationDetail.avrScore", (BigDecimal)this.changedAvgScore.get(rowSet.getString("id")));
                }
                if ((weight = rowSet.getBigDecimal("weight")) == null) continue;
                rowSet.updateBigDecimal("weight", weight.multiply(percent));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e != null && e.getType() == 0) {
            super.tblMain_tableClicked(e);
            this.staticistic();
            this.tblSelected.removeRows();
        }
    }

    private void staticistic() {
        if (this.tblMain.getRowCount() > 0) {
            IRow row = null;
            row = this.tblMain.getRow(this.tblMain.getRowCount() - 1);
            if ("total".equals(row.getUserObject())) {
                return;
            }
            BigDecimal sumWeight = new BigDecimal("0.00");
            BigDecimal temp = null;
            Integer sumPersonRestrict = new Integer(0);
            Integer tempInt = null;
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; ++i) {
                row = this.tblMain.getRow(i);
                temp = (BigDecimal)row.getCell("weight").getValue();
                if (temp != null) {
                    sumWeight = sumWeight.add(temp);
                }
                if ((tempInt = (Integer)row.getCell("personRestrict").getValue()) == null) continue;
                sumPersonRestrict = new Integer(sumPersonRestrict + tempInt);
            }
            row = this.tblMain.addRow();
            row.setUserObject((Object)"total");
            row.getCell("weight").setValue((Object)sumWeight);
            row.getCell("personRestrict").setValue((Object)sumPersonRestrict);
            row.getCell("name").setValue((Object)EASResource.getString((String)RES, (String)"sumTestPaperInput"));
            row.getStyleAttributes().setBackground(new Color(0xF6F6BF));
        }
    }

    private void setEditor(String id) throws Exception {
        if (id == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("MDSolution.id"));
        sic.add(new SelectorItemInfo("MDSolution.rankGroup.id"));
        MultiDimentionSolutionPeriodInfo mdInfo = MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.currentSolutionPeriodID), sic);
        String groupId = mdInfo.getMDSolution().getRankGroup().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupId));
        viewInfo.setFilter(filter);
        sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        SorterItemCollection sorter = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("serial");
        sorter.add(item);
        RankCollection coll = RankFactory.getRemoteInstance().getRankCollection(viewInfo);
        KDComboBox ret = new KDComboBox();
        if (coll != null && coll.size() > 0) {
            ret.addItems(coll.toArray());
        }
        this.tblSelected.getColumn("rank").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)ret));
        KDFormattedTextField kdfTextField = new KDFormattedTextField();
        kdfTextField.setDataType(1);
        kdfTextField.setPrecision(2);
        kdfTextField.setRemoveingZeroInDispaly(false);
        kdfTextField.setRemoveingZeroInEdit(false);
        this.tblSelected.getColumn("score").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kdfTextField));
        Color YELLOW = new Color(16579551);
        this.tblSelected.getColumn("score").getStyleAttributes().setBackground(YELLOW);
        this.tblSelected.getColumn("rank").getStyleAttributes().setBackground(YELLOW);
    }

    @Override
    protected void tblSelected_editStarting(KDTEditEvent e) throws Exception {
        IRow row = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            this.avgRow = this.tblMain.getRow(rowIndex);
        }
        if (e.getColIndex() == this.tblSelected.getColumnIndex("score")) {
            row = this.tblSelected.getRow(e.getRowIndex());
            Object obj = row.getCell("score").getValue();
            this.oldScore = obj != null ? (BigDecimal)obj : null;
        } else if (e.getColIndex() == this.tblSelected.getColumnIndex("rank")) {
            row = this.tblSelected.getRow(e.getRowIndex());
            Object obj = row.getCell("rankID").getValue();
            this.perfrankID = obj != null ? obj.toString() : null;
        }
    }

    @Override
    protected void tblSelected_editStopped(KDTEditEvent e) throws Exception {
        boolean flag = false;
        IRow row = null;
        if (e.getColIndex() == this.tblSelected.getColumnIndex("score")) {
            row = this.tblSelected.getRow(e.getRowIndex());
            Object obj = row.getCell("score").getValue();
            if (obj != null) {
                BigDecimal grade = (BigDecimal)obj;
                KDTEditManager em = this.tblSelected.getEditManager();
                if (grade.compareTo(this.maxGrade) > 0) {
                    MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"gradeUPIllegal") + PFVerifyUtils.formatBigDecimal(this.maxGrade, 2)));
                    em.editCellAt(e.getRowIndex(), e.getColIndex(), true);
                    e.setCancel(true);
                    return;
                }
                if (grade.compareTo(this.minGrade) < 0) {
                    MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"gradeDownIllegal") + PFVerifyUtils.formatBigDecimal(this.minGrade, 2)));
                    em.editCellAt(e.getRowIndex(), e.getColIndex(), true);
                    e.setCancel(true);
                    return;
                }
            }
            if (obj != null && this.oldScore != null) {
                if (this.oldScore.compareTo((BigDecimal)obj) != 0) {
                    flag = true;
                }
            } else {
                boolean bl = flag = obj != this.oldScore;
            }
            if (flag) {
                this.changedScore.put(row.getCell("id").getValue().toString(), obj);
                this.caculateAvgScore(this.avgRow);
                this.cacuSumScore();
            }
        } else if (e.getColIndex() == this.tblSelected.getColumnIndex("rank")) {
            row = this.tblSelected.getRow(e.getRowIndex());
            Object obj = row.getCell("rank").getValue();
            this.rank = (RankInfo)obj;
            if (obj != null && this.perfrankID != null) {
                if (!((RankInfo)obj).getId().toString().equals(this.perfrankID)) {
                    flag = true;
                }
            } else {
                boolean bl = flag = obj != this.perfrankID;
            }
            if (flag) {
                if (obj != null) {
                    this.changedPerfRank.put(row.getCell("id").getValue().toString(), ((RankInfo)obj).getId().toString());
                    this.changedPerfRankDetail.put(row.getCell("id").getValue().toString(), obj);
                } else {
                    this.changedPerfRank.put(row.getCell("id").getValue().toString(), null);
                    this.changedPerfRankDetail.put(row.getCell("id").getValue().toString(), null);
                }
            }
        }
    }

    @Override
    public void actionSaveData_actionPerformed(ActionEvent e) throws Exception {
        boolean rankChanged;
        boolean scoreChanged = this.changedScore.size() > 0;
        boolean bl = rankChanged = this.changedPerfRank.size() > 0;
        if (!scoreChanged && !rankChanged) {
            return;
        }
        IEvalPersonInputSocreFacade facade = EvalPersonInputSocreFacadeFactory.getRemoteInstance();
        facade.updateScoreAndPerfRank(this.changedScore, this.changedPerfRank);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("avrScore"));
        sic.add(new SelectorItemInfo("id"));
        IEvalRelationDetail ier = EvalRelationDetailFactory.getRemoteInstance();
        for (String erdID : this.changedAvgScoreDetail.keySet()) {
            if (erdID == null) {
                return;
            }
            EvalRelationDetailInfo info = new EvalRelationDetailInfo();
            info.setId(BOSUuid.read((String)erdID));
            info.setAvrScore((BigDecimal)this.changedAvgScoreDetail.get(erdID));
            ier.updatePartial(info, sic);
        }
        if (e != null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"evaluResutlSumbitSuccess"));
            SelectorItemCollection aSic = new SelectorItemCollection();
            aSic.add(new SelectorItemInfo("id"));
            aSic.add(new SelectorItemInfo("person.id"));
            aSic.add(new SelectorItemInfo("person.name"));
            MultiDimentionObjectInfo info = MultiDimentionObjectFactory.getRemoteInstance().getMultiDimentionObjectInfo((IObjectPK)new ObjectUuidPK(this.currentMDID), aSic);
            if (info != null && info.getPerson() != null) {
                IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)info.getBOSType(), null, (String)info.getPerson().getName(), (String)"perf_mdEvaluResult_inputForm");
                LogUtil.afterLog(null, (IObjectPK)logPK);
            }
        }
        this.changedScore.clear();
        this.changedPerfRank.clear();
        this.changedPerfRankDetail.clear();
        this.changedAvgScore.clear();
        this.changedAvgScoreDetail.clear();
    }

    private void caculateAvgScore(IRow row) throws Exception {
        if (row == null) {
            return;
        }
        int size = this.tblSelected.getRowCount();
        if (size == 0) {
            return;
        }
        BigDecimal sum = new BigDecimal("0.00");
        BigDecimal score = null;
        for (int i = 0; i < size; ++i) {
            score = (BigDecimal)this.tblSelected.getRow(i).getCell("score").getValue();
            if (score == null) {
                return;
            }
            sum = sum.add(score);
        }
        sum = sum.multiply(new BigDecimal(1.0 / (double)size));
        row.getCell("avgScore").setValue((Object)sum);
        this.changedAvgScore.put(row.getCell("id").getValue().toString(), sum);
        this.changedAvgScoreDetail.put(row.getCell("relationDetailID").getValue().toString(), sum);
    }

    protected String getSelectedRelationDetailID() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("relationDetailID");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.changedScore.size() != 0 || this.changedPerfRank.size() != 0) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSaveData_actionPerformed(null);
                    return true;
                }
                catch (Exception exc) {
                    super.handleException(exc);
                    return false;
                }
            }
            return result == 1;
        }
        return true;
    }

    protected void execQuery() {
        super.execQuery();
        this.staticistic();
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.staticistic();
        this.cacuSumScore();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0, 0, this.tblMain.getColumnCount() - 1);
            this.tblMain_tableClicked(null);
        }
    }

    private void cacuSumScore() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        BigDecimal sum = new BigDecimal("0.00");
        BigDecimal score = null;
        BigDecimal weight = null;
        IRow row = null;
        int n = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            weight = (BigDecimal)row.getCell("weight").getValue();
            score = (BigDecimal)row.getCell("avgScore").getValue();
            if (weight == null || score == null) {
                return;
            }
            sum = sum.add(weight.multiply(score));
        }
        this.sumScore = sum;
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("avgScore").setValue((Object)this.sumScore);
    }

    public BigDecimal getSumScore() {
        return this.sumScore;
    }

    public RankInfo getRank() {
        return this.rank;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor iqec = super.getQueryExecutor(queryPK, viewInfo);
        iqec.option().isAutoIgnoreZero = false;
        return iqec;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e != null) {
            String id = this.getSelectedKeyValue();
            if (id != null) {
                this.fillSelectedTable(id);
                this.setEditor(id);
            } else {
                this.tblSelected.removeRows();
            }
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        this.currentMDID = (String)this.getUIContext().get("ID");
        this.currentSolutionPeriodID = (String)this.getUIContext().get("SUID");
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        IUIActionPostman psotman = super.prepareInit();
        RequestContext req = new RequestContext();
        req.put("currentMDID", (Object)this.currentMDID);
        req.put("currentSolutionPeriodID", (Object)this.currentSolutionPeriodID);
        if (this.getUIContext().get("ID") != null) {
            req.put("MDObject.id", (Object)this.getUIContext().get("ID").toString());
        }
        if (this.getUIContext().get("SUID") != null) {
            req.put("SolutionPeriod.id", (Object)this.getUIContext().get("SUID").toString());
        }
        psotman.setRequestContext((Serializable)req);
        return psotman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman post = super.prepareQuery(e);
        RequestContext req = (RequestContext)post.getRequestContext();
        if (this.getUIContext().get("ID") != null) {
            req.put("MDObject.id", (Object)this.getUIContext().get("ID").toString());
        }
        if (this.getUIContext().get("SUID") != null) {
            req.put("SolutionPeriod.id", (Object)this.getUIContext().get("SUID").toString());
        }
        post.setRequestContext((Serializable)req);
        return post;
    }
}

