/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.EvaluRelationDetailQuestFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IMultiDimentionSolutionPeriod;
import com.kingdee.eas.hr.perf.MDCommentDetailCollection;
import com.kingdee.eas.hr.perf.MDCommentDetailInfo;
import com.kingdee.eas.hr.perf.MDEvalDetailCollection;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.MultiDimentionCommentCollection;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PaperQueDetailCollection;
import com.kingdee.eas.hr.perf.PaperQueDetailInfo;
import com.kingdee.eas.hr.perf.PaperQuestionsCollection;
import com.kingdee.eas.hr.perf.PaperQuestionsInfo;
import com.kingdee.eas.hr.perf.PerfSummaryFactory;
import com.kingdee.eas.hr.perf.PerfSummaryInfo;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.TestPageFormFactory;
import com.kingdee.eas.hr.perf.TestPageFormInfo;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.hr.perf.client.AbstractTestPaperScoreUI;
import com.kingdee.eas.hr.perf.client.MDEvalCommUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfSummaryEditUI;
import com.kingdee.eas.hr.perf.client.WorkPlanEditUI;
import com.kingdee.eas.hr.time.client.PerfViewAttendDataUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class TestPaperScoreUI
extends AbstractTestPaperScoreUI {
    private static final long serialVersionUID = -61166L;
    private static final String RES = "com.kingdee.eas.hr.perf.client.TestQuestion";
    protected static final String perfRES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final int EVALUATION_LENGTH = 1000;
    private boolean haveEvals = false;
    private boolean isRank = false;
    private boolean isHidePaperWeight = false;
    private static Color ITEM_SUM_COLOR = new Color(16119270);
    private static Color STAT_COLOR = new Color(0xF6F6BF);
    private TestPageFormInfo editData = null;
    private TestPageFormInfo oldData = null;
    private KDTextArea[] areas = null;
    private KDComboBox rankBox = null;
    private KDFormattedTextField kdfTextField = null;
    private BigDecimal maxGrade = null;
    private BigDecimal minGrade = null;
    private String rankGroupID = null;
    private GradeModeInfo soluGradeMode = null;
    private boolean isPerson = true;
    private boolean isInitialize = false;
    private String evalPersonID;
    private String testPaperID;
    private String solutionPeriodID;
    private String mdObjectID;
    private String mdEvaluatorID;
    private String evalReDetailID;
    private String evalReDetailQuestID;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.setQueryPreference(false);
        this.lblTitle.setHorizontalAlignment(0);
        if (!this.isInitialize) {
            this.initContextParams();
        }
        this.checkInitDataOK();
        this.checkSolutionPeriodAndTestPaper();
        this.initCondition();
        this.editData = this.getTestPageForm();
        this.oldData = (TestPageFormInfo)this.editData.clone();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.fillHead();
        this.setEditor();
        this.fillData();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setNotEditableUI();
        }
        super.onLoad();
        this.tblMain.getColumn("content").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn("content").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblMain.getColumn("standard").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn("standard").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblMain.addKDTResizeListener(new KDTResizeListener(){

            public void tableColumnResize(KDTResizeEvent e) {
                TestPaperScoreUI.this.reSizeTable();
            }

            public void tableRowResize(KDTResizeEvent e) {
            }
        });
    }

    private void reSizeTable() {
        int rows = this.tblMain.getRowCount();
        List columns = this.tblMain.getColumns().getColumns();
        for (int i = 0; i < rows; ++i) {
            IRow row = this.tblMain.getRow(i);
            int rowHeight = this.getRowHeight(row, columns);
            row.setHeight(rowHeight);
        }
        this.tblMain.reLayoutAndPaint();
        this.pnlMain.revalidate();
    }

    private int getRowHeight(IRow row, List columns) {
        int rowHeight = 0;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            KDTColumn column = (KDTColumn)columns.get(i);
            if (column.getStyle().isHided()) continue;
            Object object = row.getCell(i).getValue();
            String value = null;
            if (object != null) {
                value = object.toString();
            }
            int cellHeight = 0;
            if (!StringUtil.isEmptyString((String)value)) {
                cellHeight = this.getCellHeight(value, column.getWidth());
            }
            if (rowHeight >= cellHeight) continue;
            rowHeight = cellHeight;
        }
        return rowHeight;
    }

    private int getCellHeight(String cellComment, int columnWidth) {
        if (columnWidth == -1) {
            columnWidth = 100;
        }
        String[] comment = cellComment.split("\n");
        int rowCount = 0;
        int rowCharSize = columnWidth / 12;
        int len = comment.length;
        for (int i = 0; i < len; ++i) {
            byte[] bytes = comment[i].getBytes();
            rowCount += bytes.length / (2 * rowCharSize) + 1;
        }
        int stripCount = 0;
        char[] chars = cellComment.toCharArray();
        int len2 = chars.length;
        for (int i = 0; i < len2 - 1; ++i) {
            if (chars[i] != '\n' || chars[i + 1] != '\n') continue;
            ++stripCount;
        }
        return 18 * (rowCount + stripCount);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSaveData.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnCommitData.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnAttendData.setIcon(EASResource.getIcon((String)"imgTbtn_newdialog"));
        this.btnAttachment.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnPerfSummary.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
        if (!this.isPerson) {
            this.btnAttendData.setVisible(false);
        }
        super.setButtonDefaultStyl(this.btnSaveData);
    }

    private void fillHead() throws Exception {
        if (this.isPerson) {
            MultiDimentionObjectInfo info = this.editData.getMdEvaluResult().getMdObject();
            this.txtEvaluOjbectName.setText(info.getPerson().getName());
            this.txtPersonNumber.setText(info.getPerson().getNumber());
            if (info.getPosition() != null) {
                this.txtOrgUnit.setText(info.getPosition().getAdminOrgUnit().getName());
                this.txtPosition.setText(info.getPosition().getName());
            }
        } else {
            MultiDimentionObjectInfo info = this.editData.getMdEvaluResult().getMdObject();
            this.txtEvaluOjbectName.setText(this.editData.getMdEvaluResult().getDisplayName());
            this.txtEvaluOjbectName.setToolTipText(this.editData.getMdEvaluResult().getDisplayName());
            this.txtPersonNumber.setText(info.getEvaluOrg().getNumber());
            this.txtOrgUnit.setText(info.getResponser().getName());
            this.txtPosition.setVisible(false);
            this.kDLabelContainer3.setVisible(false);
            this.kDLabelContainer2.setBoundLabelText(EASResource.getString((String)perfRES, (String)"mdorgNumber"));
            this.kDLabelContainer4.setBoundLabelText(EASResource.getString((String)perfRES, (String)"mdOrgResponser"));
        }
        if (this.editData.getTestPaper().getRemark() != null) {
            this.txtDes.setText(this.editData.getTestPaper().getRemark());
        }
    }

    private void fillData() throws Exception {
        if (StringUtils.isEmpty((String)this.testPaperID)) {
            return;
        }
        TestPaperInfo info = this.editData.getTestPaper();
        if (info.getGradeMode() != null) {
            this.txtGradeMode.setText(info.getGradeMode().getName());
            this.minGrade = info.getGradeMode().getMinGrade();
            this.minGrade = this.minGrade.setScale(6, 4);
            this.maxGrade = info.getGradeMode().getMaxGrade();
            this.maxGrade = this.maxGrade.setScale(6, 4);
        }
        if (info.getRankGroup() != null) {
            this.rankGroupID = info.getRankGroup().getId().toString();
        }
        this.lblTitle.setText(info.getName());
        this.fillTable(this.testPaperID);
        MultiDimentionCommentCollection coll = (MultiDimentionCommentCollection)((Object)this.editData.getTestPaper().get("mdColl"));
        KDLabel lbl = null;
        KDScrollPane scroll = null;
        int y = this.tblMain.getY() + this.tblMain.getHeight() + 10;
        if (coll != null && coll.size() > 0) {
            int baseY = 0;
            this.areas = new KDTextArea[coll.size()];
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                int height;
                baseY = y + i * 110;
                lbl = new KDLabel(coll.get(i).getComment() + ":");
                this.pnlMain.add((Component)lbl, (Object)new KDLayout.Constraints(10, baseY, 740, 19, 5));
                this.areas[i] = new KDTextArea();
                this.areas[i].setMaxLength(1000);
                MDCommentDetailCollection mdcdColl = this.editData.getMdCommentDetail();
                int s = mdcdColl.size();
                for (int r = 0; r < s; ++r) {
                    if (!coll.get(i).getId().equals((Object)mdcdColl.get(r).getMdComment().getId())) continue;
                    this.areas[i].setText(mdcdColl.get(r).getEvaluation());
                    this.areas[i].setUserObject((Object)mdcdColl.get(r));
                    break;
                }
                scroll = new KDScrollPane((Component)this.areas[i]);
                scroll.setBounds(new Rectangle(10, baseY + 19, 740, 81));
                this.pnlMain.add((Component)scroll, (Object)new KDLayout.Constraints(10, baseY + 19, 740, 81, 5));
                if (i != n - 1 || !((double)(height = scroll.getY() + scroll.getHeight()) > this.pnlMain.getPreferredSize().getHeight())) continue;
                this.pnlMain.setPreferredSize(new Dimension(750, height + 20));
            }
        } else {
            int height = y;
            if ((double)height > this.pnlMain.getPreferredSize().getHeight()) {
                this.pnlMain.setPreferredSize(new Dimension(750, height + 20));
            }
        }
        this.pnlMain.revalidate();
        this.pnlScroll.revalidate();
    }

    private void setEditor() throws Exception {
        MultiDimentionSolutionPeriodInfo info = this.editData.getMdEvaluResult().getSolutionPeriod();
        if (info != null) {
            if (StringUtils.isEmpty((String)this.testPaperID)) {
                return;
            }
            TestPaperInfo tinfo = this.editData.getTestPaper();
            if (tinfo.getRankGroup() != null) {
                this.rankGroupID = tinfo.getRankGroup().getId().toString();
            }
            this.soluGradeMode = info.getMDSolution().getGradeMode();
            if (this.soluGradeMode != null) {
                this.soluGradeMode.setMaxGrade(this.soluGradeMode.getMaxGrade().setScale(6, 4));
                this.soluGradeMode.setMinGrade(this.soluGradeMode.getMinGrade().setScale(6, 4));
            }
            KDTDefaultCellEditor editor = null;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)this.rankGroupID));
            viewInfo.setFilter(filter);
            viewInfo.getSorter().add(new SorterItemInfo("serial"));
            RankCollection coll = RankFactory.getRemoteInstance().getRankCollection(viewInfo);
            this.rankBox = new KDComboBox();
            if (coll != null && coll.size() > 0) {
                int n = coll.size();
                for (int i = 0; i < n; ++i) {
                    this.rankBox.addItem((Object)coll.get(i));
                }
            }
            this.kdfTextField = new KDFormattedTextField();
            this.kdfTextField.setDataType(1);
            this.kdfTextField.setPrecision(2);
            this.kdfTextField.setRemoveingZeroInDispaly(false);
            this.kdfTextField.setRemoveingZeroInEdit(false);
            editor = EvaluModeEnum.RANK_GROUP.equals((Object)info.getMDSolution().getEvaluModeEnum()) ? new KDTDefaultCellEditor((JComboBox)this.rankBox) : new KDTDefaultCellEditor((JTextField)this.kdfTextField);
            this.tblMain.getColumn("score").setEditor((ICellEditor)editor);
        }
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                TestPaperScoreUI.this.actionTableClicked(e);
            }
        });
    }

    private void actionTableClicked(KDTMouseEvent e) {
        try {
            KDTable table = (KDTable)e.getSource();
            if (e.getType() == 0 || e.getClickCount() != 2 || e.getRowIndex() >= table.getRowCount() - 1) {
                return;
            }
            if (e.getColIndex() != this.tblMain.getColumnIndex("comment")) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"0", (Object)((PaperQueDetailInfo)table.getRow(e.getRowIndex()).getUserObject()).getComment());
            String oprtStateStr = null;
            oprtStateStr = !OprtState.VIEW.equals(this.getOprtState()) ? OprtState.EDIT : OprtState.VIEW;
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MDEvalCommUI.class.getName(), (Map)uiContext, null, oprtStateStr);
            uiWindow.show();
            if (OprtState.VIEW.equals(this.getOprtState())) {
                return;
            }
            MDEvalCommUI ui = (MDEvalCommUI)uiWindow.getUIObject();
            String comment = ui.getComment();
            PaperQueDetailInfo info = (PaperQueDetailInfo)table.getRow(e.getRowIndex()).getUserObject();
            if (comment == null || "".equals(comment.trim())) {
                info.setComment(null);
            } else {
                info.setComment(comment);
            }
            table.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)info.getComment());
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    private void initCondition() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("MDSolution.id"));
        sic.add(new SelectorItemInfo("MDSolution.EvaluModeEnum"));
        sic.add(new SelectorItemInfo("MDSolution.GradeMode.*"));
        sic.add(new SelectorItemInfo("MDSolution.RankGroup.id"));
        sic.add(new SelectorItemInfo("MDSolution.hidePaperWeight"));
        sic.add(new SelectorItemInfo("MDSolution.solutionType"));
        MultiDimentionSolutionPeriodInfo info = MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.solutionPeriodID), sic);
        this.isRank = EvaluModeEnum.RANK_GROUP.equals((Object)info.getMDSolution().getEvaluModeEnum());
        this.isHidePaperWeight = info.getMDSolution().isHidePaperWeight();
        this.isPerson = EvaluSolutionTypeEnum.PERSON.equals((Object)info.getMDSolution().getSolutionType());
    }

    private void fillTable(String id) throws Exception {
        int i;
        PaperQuestionsInfo pqInfo;
        IRow row;
        PaperQuestionsCollection pqColl;
        if (id == null) {
            return;
        }
        this.haveEvals = (Boolean)this.editData.getTestPaper().get("haveEvals");
        boolean isCanComment = this.editData.getMdEvaluResult().getSolutionPeriod().getMDSolution().isCanComment();
        this.tblMain.getColumn("comment").getStyleAttributes().setHided(!isCanComment);
        KDTMergeManager mm = this.tblMain.getMergeManager();
        StringTokenizer tk = null;
        BigDecimal zero = new BigDecimal("0.00000000");
        BigDecimal percent = new BigDecimal("0.01");
        boolean flag = this.isRank;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)id));
        int lineHight = 17;
        if (this.haveEvals) {
            this.tblMain.getColumn("serial").getStyleAttributes().setHided(true);
            pqColl = (PaperQuestionsCollection)((Object)this.editData.getTestPaper().get("pqColl"));
            row = null;
            pqInfo = null;
            int height = 44;
            if (pqColl != null && pqColl.size() > 0) {
                StringBuffer sb = null;
                int count = 0;
                TreeSet<Integer> set = new TreeSet<Integer>();
                int n = pqColl.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    set.add(new Integer(pqColl.get(i2).getEvaluation().getSerial()));
                }
                int serial = 0;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    serial = (Integer)iter.next();
                    int n2 = pqColl.size();
                    block2: for (int i3 = 0; i3 < n2; ++i3) {
                        pqInfo = pqColl.get(i3);
                        if (pqInfo.getEvaluation().getSerial() != serial) continue;
                        row = this.tblMain.addRow();
                        row.getCell("queID").setValue((Object)pqInfo.getId().toString());
                        row.getCell("evalID").setValue((Object)pqInfo.getEvaluation().getId().toString());
                        count = 0;
                        sb = new StringBuffer(pqInfo.getEvaluation().getEvaluation());
                        int j = 1;
                        while (j * 10 + j - 1 < sb.length()) {
                            sb.insert(j * 10 + j - 1, "\n");
                            ++j;
                        }
                        if (sb.length() < 10 && sb.length() > 2) {
                            sb.append("\n");
                        } else if (sb.length() - count * 10 < 9) {
                            sb.append("\n");
                        }
                        if (!this.isHidePaperWeight) {
                            sb.append(" (");
                            sb.append(PFVerifyUtils.formatBigDecimal(pqInfo.getEvaluation().getWeight(), 2) + "%");
                            sb.append(")");
                        }
                        if (sb.toString().endsWith("\n")) {
                            sb.delete(sb.lastIndexOf("\n"), sb.length());
                        }
                        row.getCell("eval").setValue((Object)sb.toString());
                        tk = new StringTokenizer(sb.toString(), "\n");
                        if (tk.countTokens() > count) {
                            count = tk.countTokens();
                        }
                        sb = new StringBuffer(pqInfo.getTestQuestion().getContent());
                        int contentCount = 0;
                        int j2 = 1;
                        while (j2 * 15 + j2 - 1 < sb.length()) {
                            ++contentCount;
                            ++j2;
                        }
                        row.getCell("content").setValue((Object)sb.toString());
                        if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                            count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                        }
                        sb = new StringBuffer(pqInfo.getTestQuestion().getStandard());
                        contentCount = 0;
                        j2 = 1;
                        while (j2 * 14 + j2 - 1 < sb.length()) {
                            ++contentCount;
                            ++j2;
                        }
                        row.getCell("standard").setValue((Object)sb.toString());
                        if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                            count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                        }
                        row.getCell("weight").setValue((Object)(PFVerifyUtils.formatBigDecimal(pqInfo.getWeight(), 2) + "%"));
                        row.getCell("weight").setUserObject((Object)zero.add(pqInfo.getWeight()).multiply(pqInfo.getEvaluation().getWeight()).multiply(percent));
                        row.getCell("evalSumScore").setUserObject((Object)zero.add(pqInfo.getWeight()));
                        height += lineHight * count;
                        row.setHeight(lineHight * count);
                        PaperQueDetailCollection pqdColl = this.editData.getPaperQueDetail();
                        int s = pqdColl.size();
                        for (int r = 0; r < s; ++r) {
                            if (!pqColl.get(i3).getId().equals((Object)pqdColl.get(r).getPaperQue().getId())) continue;
                            if (flag) {
                                row.getCell("score").setValue((Object)pqdColl.get(r).getRank());
                            } else {
                                row.getCell("score").setValue((Object)pqdColl.get(r).getScore());
                            }
                            row.getCell("comment").setValue((Object)pqdColl.get(r).getComment());
                            row.setUserObject((Object)pqdColl.get(r));
                            break;
                        }
                        MDEvalDetailCollection mdedColl = this.editData.getMdEvalDetail();
                        int s2 = mdedColl.size();
                        for (int r = 0; r < s2; ++r) {
                            if (!mdedColl.get(r).getMdEval().getId().equals((Object)pqColl.get(i3).getEvaluation().getId())) continue;
                            row.getCell("evalSumScore").setValue((Object)mdedColl.get(r).getScore());
                            continue block2;
                        }
                    }
                }
                this.tblMain.getColumn("eval").setGroup(true);
                this.tblMain.getColumn("evalSumScore").setGroup(true);
                this.tblMain.getGroupManager().group();
                row = this.tblMain.addRow();
                height += lineHight;
                row.getCell("eval").setValue((Object)EASResource.getString((String)RES, (String)"scoreSumTitle"));
                mm.mergeBlock(row.getRowIndex(), row.getCell("content").getColumnIndex(), row.getRowIndex(), row.getCell("score").getColumnIndex());
                row.getCell("evalSumScore").setValue((Object)this.editData.getScore());
                row.getStyleAttributes().setLocked(true);
            }
            height = height < 500 ? height * 19 / lineHight : (height < 1000 ? height * 19 / 19 : height * lineHight / 19);
            this.tblMain.setBounds(new Rectangle(10, 135, 740, height));
            this.pnlMain.add((Component)this.tblMain, (Object)new KDLayout.Constraints(10, 135, 740, height, 5));
            if (this.pnlMain.getY() > this.pnlMain.getPreferredSize().height) {
                this.pnlMain.setPreferredSize(new Dimension(750, this.pnlMain.getY() + 50));
            }
            this.pnlMain.revalidate();
        } else {
            this.tblMain.getColumn("eval").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setHided(true);
            pqColl = (PaperQuestionsCollection)((Object)this.editData.getTestPaper().get("pqColl"));
            row = null;
            pqInfo = null;
            StringBuffer sb = null;
            int count = 0;
            int height = 44;
            if (pqColl != null && pqColl.size() > 0) {
                int n = pqColl.size();
                block8: for (int i4 = 0; i4 < n; ++i4) {
                    count = 0;
                    pqInfo = pqColl.get(i4);
                    row = this.tblMain.addRow();
                    row.getCell("serial").setValue((Object)new Integer(pqInfo.getSerial()));
                    sb = new StringBuffer(pqInfo.getTestQuestion().getContent());
                    int contentCount = 0;
                    int j = 1;
                    while (j * 22 + j - 1 < sb.length()) {
                        ++contentCount;
                        ++j;
                    }
                    row.getCell("content").setValue((Object)sb.toString());
                    if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                        count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                    }
                    sb = new StringBuffer(pqInfo.getTestQuestion().getStandard());
                    contentCount = 0;
                    j = 1;
                    while (j * 22 + j - 1 < sb.length()) {
                        ++contentCount;
                        ++j;
                    }
                    row.getCell("standard").setValue((Object)sb.toString());
                    if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                        count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                    }
                    row.getCell("weight").setValue((Object)(PFVerifyUtils.formatBigDecimal(pqInfo.getWeight(), 2) + "%"));
                    row.getCell("weight").setUserObject((Object)pqInfo.getWeight());
                    row.setHeight(count * lineHight);
                    height += count * lineHight;
                    PaperQueDetailCollection pqdColl = this.editData.getPaperQueDetail();
                    int s = pqdColl.size();
                    for (int r = 0; r < s; ++r) {
                        if (!pqColl.get(i4).getId().equals((Object)pqdColl.get(r).getPaperQue().getId())) continue;
                        if (flag) {
                            row.getCell("score").setValue((Object)pqdColl.get(r).getRank());
                        } else {
                            row.getCell("score").setValue((Object)pqdColl.get(r).getScore());
                        }
                        row.getCell("comment").setValue((Object)pqdColl.get(r).getComment());
                        row.setUserObject((Object)pqdColl.get(r));
                        continue block8;
                    }
                }
                this.tblMain.getColumn("eval").setGroup(true);
                this.tblMain.getColumn("evalSumScore").setGroup(true);
                this.tblMain.getGroupManager().group();
                row = this.tblMain.addRow();
                height += lineHight;
                row.getCell("serial").setValue((Object)EASResource.getString((String)RES, (String)"scoreSumTitle"));
                mm.mergeBlock(row.getRowIndex(), row.getCell("content").getColumnIndex(), row.getRowIndex(), row.getCell("weight").getColumnIndex());
                row.getCell("score").setValue((Object)this.editData.getScore());
                row.getStyleAttributes().setLocked(true);
            }
            height = height < 500 ? height * 19 / lineHight : (height < 1000 ? height * 19 / 19 : height * 15 / lineHight);
            this.tblMain.setBounds(new Rectangle(10, 135, 740, height));
            this.pnlMain.add((Component)this.tblMain, (Object)new KDLayout.Constraints(10, 135, 740, height, 5));
            if (this.pnlMain.getY() > this.pnlMain.getPreferredSize().height) {
                this.pnlMain.setPreferredSize(new Dimension(750, this.pnlMain.getY() + 50));
            }
            this.pnlMain.revalidate();
        }
        int n = this.tblMain.getColumnCount();
        for (i = 0; i < n; ++i) {
            this.tblMain.getColumn(i).setMoveable(false);
        }
        n = this.tblMain.getRowCount();
        for (i = 0; i < n; ++i) {
            this.tblMain.getRow(i).setResizeable(false);
        }
        this.tblMain.getHeadRow(0).setResizeable(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (StringUtils.isEmpty((String)this.testPaperID)) {
            return;
        }
        if (this.haveEvals) {
            this.tblMain.getColumn("eval").setWidth(145);
            this.tblMain.getColumn("content").setWidth(190);
            this.tblMain.getColumn("standard").setWidth(180);
            this.tblMain.getColumn("weight").setWidth(50);
            this.tblMain.getColumn("score").setWidth(50);
            this.tblMain.getColumn("evalSumScore").setWidth(77);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setBackground(ITEM_SUM_COLOR);
        } else {
            this.tblMain.getColumn("serial").setWidth(60);
            this.tblMain.getColumn("content").setWidth(280);
            this.tblMain.getColumn("standard").setWidth(272);
            this.tblMain.getColumn("weight").setWidth(50);
            this.tblMain.getColumn("score").setWidth(50);
            this.tblMain.getColumn("score").getStyleAttributes().setBackground(ITEM_SUM_COLOR);
        }
        if (this.isHidePaperWeight) {
            this.tblMain.getColumn("weight").getStyleAttributes().setHided(true);
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getStyleAttributes().setBackground(STAT_COLOR);
        this.pnlMain.revalidate();
        this.reSizeTable();
    }

    private TestPageFormInfo getTestPageForm() throws Exception {
        TestPageFormInfo info = TestPageFormFactory.getRemoteInstance().getTestPageForm(this.evalPersonID, this.solutionPeriodID, this.mdObjectID, this.testPaperID);
        if (MultiDimTestPaperStateEnum.SUBMIT.equals((Object)info.getEvalPerson().getPaperState())) {
            this.setOprtState(OprtState.VIEW);
        }
        return info;
    }

    /*
     * Unable to fully structure code
     */
    private void initContextParams() {
        uiContext = this.getUIContext();
        if (uiContext.get("parameters") != null) {
            parameter = String.valueOf(uiContext.get("parameters"));
            paramString = parameter.substring(parameter.indexOf("::") + 2).trim();
            params = paramString.split("_");
            this.mdEvaluatorID = params[0];
            this.solutionPeriodID = params[1];
            this.mdObjectID = params[2];
            this.evalReDetailID = params[3];
            this.testPaperID = params[4];
            this.evalPersonID = params[5];
            try {
                evalDetilInfo = EvalRelationDetailFactory.getRemoteInstance().getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(this.evalReDetailID));
                if (evalDetilInfo != null && evalDetilInfo.getEvalRelation() != null) {
                    this.evalReDetailQuestID = evalDetilInfo.getEvalRelation().getId().toString();
                }
            }
            catch (EASBizException e1) {
                this.handleException((Exception)e1);
            }
            catch (BOSException e1) {
                this.handleException((Exception)e1);
            }
            entityInfo = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)this.solutionPeriodID, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("evalPerson", (Object)this.evalPersonID, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("evaluRelation", (Object)this.evalReDetailQuestID, CompareType.INCLUDE));
            entityInfo.setFilter(fi);
            try {
                collQuest = EvaluRelationDetailQuestFactory.getRemoteInstance().getEvaluRelationDetailQuestCollection(entityInfo);
                if (collQuest == null || collQuest.size() <= 0) ** GOTO lbl48
                n = collQuest.size();
                for (i = 0; i < n; ++i) {
                    this.testPaperID = collQuest.get(0).getPaperQuest().getId().toString();
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)e);
            }
        } else {
            this.evalPersonID = String.valueOf(uiContext.get("evalPersonID"));
            this.testPaperID = String.valueOf(uiContext.get("testPaperID"));
            this.solutionPeriodID = String.valueOf(uiContext.get("solutionPeriodID"));
            this.mdObjectID = String.valueOf(uiContext.get("evaluObjectID"));
            this.mdEvaluatorID = String.valueOf(uiContext.get("mdEvaluatorID"));
            this.evalReDetailID = String.valueOf(uiContext.get("EvalRelationDetailID"));
        }
lbl48:
        // 4 sources

        this.isInitialize = true;
    }

    @Override
    public void actionSaveData_actionPerformed(ActionEvent e) throws Exception {
        boolean complete = false;
        this.checkDataValid(complete);
        if (this.isDataModified()) {
            IObjectPK pk = TestPageFormFactory.getRemoteInstance().save(this.editData);
            this.editData.setId(BOSUuid.read((String)pk.toString()));
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"dataSaveOK"));
            this.oldData = (TestPageFormInfo)this.editData.clone();
        }
    }

    private boolean isDataModified() throws Exception {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        boolean flag = this.isRank;
        PaperQueDetailInfo userObject = null;
        IRow row = null;
        int n = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            if (!this.verifyScoreRange(i)) {
                SysUtil.abort();
                return false;
            }
            row = this.tblMain.getRow(i);
            userObject = (PaperQueDetailInfo)row.getUserObject();
            if (userObject == null) continue;
            if (flag) {
                userObject.setRank((RankInfo)row.getCell("score").getValue());
                continue;
            }
            userObject.setScore((BigDecimal)row.getCell("score").getValue());
        }
        if (this.haveEvals) {
            int i;
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            BigDecimal sum = null;
            BigDecimal weight = null;
            String evalID = null;
            BigDecimal score = null;
            BigDecimal percent = new BigDecimal("0.01");
            int n2 = this.tblMain.getRowCount() - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                evalID = (String)this.tblMain.getRow(i2).getCell("evalID").getValue();
                sum = (BigDecimal)map.get(evalID);
                if (sum == null) {
                    sum = new BigDecimal("0.00000000");
                }
                if ((weight = (BigDecimal)this.tblMain.getRow(i2).getCell("evalSumScore").getUserObject()) == null) {
                    weight = new BigDecimal("0.00000000");
                }
                if (flag) {
                    RankInfo rank = (RankInfo)this.tblMain.getRow(i2).getCell("score").getValue();
                    BigDecimal temp = rank == null ? new BigDecimal("0.00") : rank.getGrade();
                    sum = sum.add(weight.multiply(temp).multiply(percent));
                } else {
                    score = (BigDecimal)this.tblMain.getRow(i2).getCell("score").getValue();
                    if (score == null) {
                        score = new BigDecimal("0.00");
                    }
                    sum = sum.add(weight.multiply(score).multiply(percent));
                }
                map.put(evalID, sum);
            }
            MDEvalDetailCollection mdedColl = this.editData.getMdEvalDetail();
            int n3 = mdedColl.size();
            for (i = 0; i < n3; ++i) {
                mdedColl.get(i).setScore((BigDecimal)map.get(mdedColl.get(i).getMdEval().getId().toString()));
            }
            n3 = this.tblMain.getRowCount() - 1;
            for (i = 0; i < n3; ++i) {
                evalID = (String)this.tblMain.getRow(i).getCell("evalID").getValue();
                if (!this.tblMain.getRow(i).getCell("evalID").getValue().equals(evalID)) continue;
                this.tblMain.getRow(i).getCell("evalSumScore").setValue(map.get(evalID));
            }
        }
        this.calculateTotalScore();
        if (this.haveEvals) {
            row = this.tblMain.getRow(this.tblMain.getRowCount() - 1);
            this.editData.setScore((BigDecimal)row.getCell("evalSumScore").getValue());
        } else if (this.tblMain.getRowCount() > 0 && (row = this.tblMain.getRow(this.tblMain.getRowCount() - 1)) != null) {
            this.editData.setScore((BigDecimal)row.getCell("score").getValue());
        }
        MDCommentDetailInfo mdcdInfo = null;
        if (this.areas != null && this.areas.length > 0) {
            for (int i = 0; i < this.areas.length; ++i) {
                mdcdInfo = (MDCommentDetailInfo)this.areas[i].getUserObject();
                mdcdInfo.setEvaluation(this.areas[i].getText().trim());
            }
        }
        return !ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)this.oldData, (AbstractObjectValue)this.editData);
    }

    @Override
    public void actionCommitData_actionPerformed(ActionEvent e) throws Exception {
        boolean complete = true;
        this.checkDataValid(complete);
        this.isDataModified();
        BigDecimal score = this.editData.getScore();
        score = score.setScale(6, 4);
        BigDecimal soluScore = null;
        BigDecimal zero = new BigDecimal("0.000000");
        soluScore = zero.add(score.subtract(this.minGrade)).divide(this.maxGrade.subtract(this.minGrade), 4);
        soluScore = soluScore.multiply(this.soluGradeMode.getMaxGrade().subtract(this.soluGradeMode.getMinGrade())).add(this.soluGradeMode.getMinGrade());
        String evalPersonID = this.editData.getEvalPerson().getId().toString();
        String rankID = null;
        if (this.editData.getRank() != null) {
            rankID = this.editData.getRank().getId().toString();
        }
        EvalPersonFactory.getRemoteInstance().saveFormData(this.editData, evalPersonID, soluScore, rankID, this.mdEvaluatorID, this.evalReDetailID, this.solutionPeriodID, this.mdObjectID);
        this.oldData = (TestPageFormInfo)this.editData.clone();
        this.setNotEditableUI();
        this.setOprtState(OprtState.VIEW);
        MsgBox.showInfo((String)EASResource.getString((String)perfRES, (String)"dataCommitOK"));
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        if (e.getRowIndex() == this.tblMain.getRowCount() - 1) {
            return;
        }
        if (this.haveEvals) {
            this.calculateSumScore(e.getRowIndex());
        }
        this.calculateTotalScore();
    }

    private boolean verifyScoreRange(int rowIndex) {
        if (this.isRank) {
            return true;
        }
        int columnIndex = this.tblMain.getColumnIndex("score");
        BigDecimal grade = (BigDecimal)this.tblMain.getRow(rowIndex).getCell("score").getValue();
        if (grade != null) {
            KDTEditManager em = this.tblMain.getEditManager();
            if (grade.compareTo(this.maxGrade) > 0) {
                em.editCellAt(rowIndex, columnIndex, true);
                MsgBox.showInfo((String)(EASResource.getString((String)perfRES, (String)"gradeUPIllegal") + PFVerifyUtils.formatBigDecimal(this.maxGrade, 2)));
                return false;
            }
            if (grade.compareTo(this.minGrade) < 0) {
                em.editCellAt(rowIndex, columnIndex, true);
                MsgBox.showInfo((String)(EASResource.getString((String)perfRES, (String)"gradeDownIllegal") + PFVerifyUtils.formatBigDecimal(this.minGrade, 2)));
                return false;
            }
        }
        return true;
    }

    private void calculateSumScore(int rowIndex) {
        int i;
        BigDecimal evalSum = new BigDecimal("0.00000000");
        Object obj = null;
        RankInfo rank = null;
        BigDecimal weight = null;
        BigDecimal percent = new BigDecimal("0.01");
        String evalID = (String)this.tblMain.getRow(rowIndex).getCell("evalID").getValue();
        int n = this.tblMain.getRowCount() - 1;
        for (i = 0; i < n; ++i) {
            if (!this.tblMain.getRow(i).getCell("evalID").getValue().equals(evalID)) continue;
            weight = (BigDecimal)this.tblMain.getRow(i).getCell("evalSumScore").getUserObject();
            obj = this.tblMain.getRow(i).getCell("score").getValue();
            if (obj == null) continue;
            if (obj instanceof BigDecimal) {
                evalSum = evalSum.add(((BigDecimal)obj).multiply(weight).multiply(percent));
                continue;
            }
            rank = (RankInfo)obj;
            evalSum = evalSum.add(rank.getGrade().multiply(weight).multiply(percent));
        }
        n = this.tblMain.getRowCount() - 1;
        for (i = 0; i < n; ++i) {
            if (!this.tblMain.getRow(i).getCell("evalID").getValue().equals(evalID)) continue;
            this.tblMain.getRow(i).getCell("evalSumScore").setValue((Object)evalSum);
        }
    }

    private void calculateTotalScore() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        BigDecimal weight = null;
        BigDecimal sum = new BigDecimal("0.00000000");
        Object obj = null;
        BigDecimal percent = new BigDecimal("0.01");
        RankInfo rank = null;
        int n = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            weight = (BigDecimal)this.tblMain.getRow(i).getCell("weight").getUserObject();
            obj = this.tblMain.getRow(i).getCell("score").getValue();
            if (obj == null) continue;
            if (obj instanceof BigDecimal) {
                sum = sum.add(((BigDecimal)obj).multiply(weight).multiply(percent));
                continue;
            }
            rank = (RankInfo)obj;
            sum = sum.add(rank.getGrade().multiply(weight).multiply(percent));
        }
        if (this.haveEvals) {
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("evalSumScore").setValue((Object)sum);
        } else {
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("score").setValue((Object)sum);
        }
    }

    private void checkInitDataOK() throws Exception {
        if (StringUtils.isEmpty((String)this.solutionPeriodID)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullMDEvaluSolutionID"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.mdObjectID)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullMDObjectID"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.evalPersonID)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullMDEvalPersonID"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.testPaperID)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullMDTestPaperID"));
            SysUtil.abort();
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            if (StringUtils.isEmpty((String)this.evalReDetailID)) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullMDEvalRelationDetailID"));
                SysUtil.abort();
            }
            if (StringUtils.isEmpty((String)this.mdEvaluatorID)) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullMDEvaluatorID"));
                SysUtil.abort();
            }
        }
    }

    private void checkSolutionPeriodAndTestPaper() throws BOSException, EASBizException {
        FilterInfo filter = null;
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.solutionPeriodID));
        filter.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(101)));
        if (!MultiDimentionSolutionPeriodFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"mdPeriodOnEvaluForScore"));
            SysUtil.abort();
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.evalPersonID));
        filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(30)));
        if (EvalPersonFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"testPaperForCancel"));
            SysUtil.abort();
        }
    }

    protected boolean checkBeforeWindowClosing() {
        block6: {
            try {
                if (this.oprtState == OprtState.VIEW) {
                    return true;
                }
                if (!this.isDataModified()) break block6;
                int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
                if (result == 0) {
                    try {
                        this.checkDataValid(true);
                    }
                    catch (Exception e) {
                        return false;
                    }
                    TestPageFormFactory.getRemoteInstance().submit(this.editData);
                    MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"dataSaveOK"));
                    this.oldData = (TestPageFormInfo)this.editData.clone();
                    return true;
                }
                return result == 1;
            }
            catch (Exception ex) {
                super.handleException(ex);
            }
        }
        return true;
    }

    private void checkDataValid(boolean complete) throws Exception {
        Object obj = null;
        BigDecimal grade = null;
        KDTEditManager em = this.tblMain.getEditManager();
        int scoreIndex = this.tblMain.getColumnIndex("score");
        int n = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            obj = this.tblMain.getRow(i).getCell("score").getValue();
            if (complete && obj == null) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"plzInputScore"));
                em.editCellAt(i, this.tblMain.getColumnIndex("score"));
                SysUtil.abort();
                continue;
            }
            if (this.isRank || obj == null) continue;
            grade = (BigDecimal)obj;
            if (grade.compareTo(this.maxGrade) > 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)perfRES, (String)"gradeUPIllegal") + PFVerifyUtils.formatBigDecimal(this.maxGrade, 2)));
                em.editCellAt(i, scoreIndex, false);
                SysUtil.abort();
            }
            if (grade.compareTo(this.minGrade) >= 0) continue;
            MsgBox.showInfo((String)(EASResource.getString((String)perfRES, (String)"gradeDownIllegal") + PFVerifyUtils.formatBigDecimal(this.minGrade, 2)));
            em.editCellAt(i, scoreIndex, false);
            SysUtil.abort();
        }
    }

    private void setNotEditableUI() {
        int i;
        int n = this.tblMain.getColumnCount();
        for (i = 0; i < n; ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setLocked(true);
        }
        if (this.areas != null) {
            for (i = 0; i < this.areas.length; ++i) {
                this.areas[i].setEditable(false);
            }
        }
        this.btnSaveData.setEnabled(false);
        this.btnCommitData.setEnabled(false);
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    @Override
    public void actionWorkPlan_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        PersonInfo person = null;
        person = this.isPerson ? this.editData.getMdEvaluResult().getMdObject().getPerson() : this.editData.getMdEvaluResult().getMdObject().getResponser();
        uiContext.put((Object)"person", (Object)person);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WorkPlanEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionAttendData_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        MultiDimentionObjectInfo info = this.editData.getMdEvaluResult().getMdObject();
        if (info != null && info.getPerson() != null) {
            uiContext.put((Object)"personId", (Object)info.getPerson().getId().toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PerfViewAttendDataUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
    }

    @Override
    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = new AttachmentClientManager();
        String boID = this.editData.getId().toString();
        if (StringUtils.isEmpty((String)boID)) {
            return;
        }
        boolean isExists = TestPageFormFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(boID));
        if (!isExists) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"isNotSaveTestPaperForm"));
            return;
        }
        boolean flag = !OprtState.VIEW.equals(this.getOprtState());
        acm.showAttachmentListUIByBoID(boID, (Object)this, flag);
    }

    @Override
    public void actionPerfSummary_actionPerformed(ActionEvent e) throws Exception {
        String perfSummaryID = this.getPefSummaryID();
        if (StringUtils.isEmpty((String)perfSummaryID)) {
            MsgBox.showInfo((String)EASResource.getString((String)perfRES, (String)"noPerfSummary"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)perfSummaryID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PerfSummaryEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private String getPefSummaryID() throws Exception {
        PerfSummaryInfo perfSummaryInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("AssessPeriod.id"));
        IMultiDimentionSolutionPeriod iMDSolutionPeriod = MultiDimentionSolutionPeriodFactory.getRemoteInstance();
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = iMDSolutionPeriod.getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.editData.getMdEvaluResult().getSolutionPeriod().getId()), sic);
        String assessPeriodID = solutionPeriodInfo.getAssessPeriod().getId().toString();
        PersonInfo person = null;
        person = this.isPerson ? this.editData.getMdEvaluResult().getMdObject().getPerson() : this.editData.getMdEvaluResult().getMdObject().getResponser();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)assessPeriodID));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString()));
        CoreBaseCollection psColl = PerfSummaryFactory.getRemoteInstance().getCollection(viewInfo);
        if (psColl != null && psColl.size() > 0) {
            perfSummaryInfo = (PerfSummaryInfo)psColl.get(0);
            return perfSummaryInfo.getId().toString();
        }
        return null;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        if (!this.isInitialize) {
            this.initContextParams();
        }
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("evalPersonID", (Object)this.evalPersonID);
        request.put("testPaperID", (Object)this.testPaperID);
        request.put("solutionPeriodID", (Object)this.solutionPeriodID);
        request.put("evaluObjectID", (Object)this.mdObjectID);
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }
}

