/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.perf.EvalPersonCollection;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvalPersonInfo;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.MDCommentDetailCollection;
import com.kingdee.eas.hr.perf.MDEvalDetailCollection;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.MultiDimentionCommentCollection;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PaperQueDetailCollection;
import com.kingdee.eas.hr.perf.PaperQueDetailInfo;
import com.kingdee.eas.hr.perf.PaperQuestionsCollection;
import com.kingdee.eas.hr.perf.PaperQuestionsInfo;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.TestPageFormFactory;
import com.kingdee.eas.hr.perf.TestPageFormInfo;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.hr.perf.client.AbstractTestPaperScoreViewUI;
import com.kingdee.eas.hr.perf.client.MDEvalCommUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class TestPaperScoreViewUI
extends AbstractTestPaperScoreViewUI {
    private static final long serialVersionUID = -61166L;
    private static final String RES = "com.kingdee.eas.hr.perf.client.TestQuestion";
    protected static final String perfRES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private boolean haveEvals = false;
    private boolean isRank = false;
    private boolean isHidePaperWeight = false;
    private static Color ITEM_SUM_COLOR = new Color(16119270);
    private static Color STAT_COLOR = new Color(0xF6F6BF);
    private TestPageFormInfo editData = null;
    private KDTextArea[] areas = null;
    private KDLabel[] lbls = null;
    private KDScrollPane[] scrolls = null;
    private BigDecimal maxGrade = null;
    private BigDecimal minGrade = null;
    private IIDList idList = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setQueryPreference(false);
        String mdoObjectID = (String)this.getUIContext().get("evaluObjectID");
        String solutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator.multiDimObject.id", (Object)mdoObjectID));
        filter.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator.solutionPeriod.id", (Object)solutionPeriodID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evalReDetail.id"));
        sic.add(new SelectorItemInfo("evalReDetail.evalRelation.id"));
        sic.add(new SelectorItemInfo("evalReDetail.evalRelation.paper.id"));
        EvalPersonCollection coll = EvalPersonFactory.getRemoteInstance().getEvalPersonCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            this.idList = new RealModeIDList();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                this.idList.add(coll.get(i).getId().toString());
            }
            this.idList.setCurrentIndex(0);
            this.getUIContext().put("evalPersonID", coll.get(0).getId().toString());
            this.getUIContext().put("testPaperID", coll.get(0).getEvalReDetail().getEvalRelation().getPaper().getId().toString());
        }
        this.lblTitle.setHorizontalAlignment(0);
        this.checkInitDataOK();
        this.initCondition();
        this.editData = this.getTestPageForm();
        this.fillHead();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                TestPaperScoreViewUI.this.actionTableClicked(e);
            }
        });
        this.fillData();
        this.setNotEditableUI();
        this.initScrollButtons();
        this.tblMain.getColumn("content").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn("content").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblMain.getColumn("standard").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblMain.getColumn("standard").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblMain.addKDTResizeListener(new KDTResizeListener(){

            public void tableColumnResize(KDTResizeEvent e) {
                TestPaperScoreViewUI.this.reSizeTable();
            }

            public void tableRowResize(KDTResizeEvent e) {
            }
        });
    }

    private void reSizeTable() {
        int rows = this.tblMain.getRowCount();
        List columns = this.tblMain.getColumns().getColumns();
        for (int i = 0; i < rows; ++i) {
            IRow row = this.tblMain.getRow(i);
            int rowHeight = this.getRowHeight(row, columns);
            row.setHeight(rowHeight);
        }
        this.tblMain.reLayoutAndPaint();
        this.pnlMain.revalidate();
    }

    private int getRowHeight(IRow row, List columns) {
        int rowHeight = 0;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            KDTColumn column = (KDTColumn)columns.get(i);
            if (column.getStyle().isHided()) continue;
            Object object = row.getCell(i).getValue();
            String value = null;
            if (object != null) {
                value = object.toString();
            }
            int cellHeight = 0;
            if (!StringUtil.isEmptyString((String)value)) {
                cellHeight = this.getCellHeight(value, column.getWidth());
            }
            if (rowHeight >= cellHeight) continue;
            rowHeight = cellHeight;
        }
        return rowHeight;
    }

    private int getCellHeight(String cellComment, int columnWidth) {
        if (columnWidth == -1) {
            columnWidth = 100;
        }
        String[] comment = cellComment.split("\n");
        int rowCount = 0;
        int rowCharSize = columnWidth / 12;
        int len = comment.length;
        for (int i = 0; i < len; ++i) {
            byte[] bytes = comment[i].getBytes();
            rowCount += bytes.length / (2 * rowCharSize) + 1;
        }
        int stripCount = 0;
        char[] chars = cellComment.toCharArray();
        int len2 = chars.length;
        for (int i = 0; i < len2 - 1; ++i) {
            if (chars[i] != '\n' || chars[i + 1] != '\n') continue;
            ++stripCount;
        }
        return 18 * (rowCount + stripCount);
    }

    private void actionTableClicked(KDTMouseEvent e) {
        try {
            KDTable table = (KDTable)e.getSource();
            if (e.getType() == 0 || e.getClickCount() != 2 || e.getRowIndex() >= table.getRowCount() - 1) {
                return;
            }
            if (e.getColIndex() != this.tblMain.getColumnIndex("comment")) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"0", (Object)((PaperQueDetailInfo)table.getRow(e.getRowIndex()).getUserObject()).getComment());
            String oprtStateStr = null;
            oprtStateStr = !OprtState.VIEW.equals(this.getOprtState()) ? OprtState.EDIT : OprtState.VIEW;
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MDEvalCommUI.class.getName(), (Map)uiContext, null, oprtStateStr);
            uiWindow.show();
            if (OprtState.VIEW.equals(this.getOprtState())) {
                return;
            }
            MDEvalCommUI ui = (MDEvalCommUI)uiWindow.getUIObject();
            String comment = ui.getComment();
            PaperQueDetailInfo info = (PaperQueDetailInfo)table.getRow(e.getRowIndex()).getUserObject();
            if (comment == null || "".equals(comment.trim())) {
                info.setComment(null);
            } else {
                info.setComment(comment);
            }
            table.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)info.getComment());
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFirstData.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPreData.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNextData.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnEndData.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        super.setButtonDefaultStyl(this.btnFirstData);
        super.setButtonDefaultStyl(this.btnPreData);
        super.setButtonDefaultStyl(this.btnNextData);
        super.setButtonDefaultStyl(this.btnEndData);
    }

    private void fillHead() throws Exception {
        String evalPersonID = (String)this.getUIContext().get("evalPersonID");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("evalReDetail.id"));
        sic.add(new SelectorItemInfo("evalReDetail.evalRelation.id"));
        sic.add(new SelectorItemInfo("evalReDetail.evalRelation.name"));
        sic.add(new SelectorItemInfo("evalReDetail.evalRelation.MDEvaluTypeEnum"));
        sic.add(new SelectorItemInfo("evalReDetail.evalRelation.paper.id"));
        EvalPersonInfo evalPerson = EvalPersonFactory.getRemoteInstance().getEvalPersonInfo((IObjectPK)new ObjectUuidPK(evalPersonID), sic);
        this.txtEvalPerson.setText(evalPerson.getPerson().getName());
        if (evalPerson.getPosition() != null) {
            this.txtPosition.setText(evalPerson.getPosition().getName());
            this.txtOrgUnit.setText(evalPerson.getPosition().getAdminOrgUnit().getName());
        }
        String evalRelation = null;
        evalRelation = !MDEvaluTypeEnum.APPOINT.equals((Object)evalPerson.getEvalReDetail().getEvalRelation().getMDEvaluTypeEnum()) ? evalPerson.getEvalReDetail().getEvalRelation().getMDEvaluTypeEnum().toString() : evalPerson.getEvalReDetail().getEvalRelation().getName() + "(" + evalPerson.getEvalReDetail().getEvalRelation().getMDEvaluTypeEnum().toString() + ")";
        this.txtEvalRelation.setText(evalRelation);
        this.txtEvalRelation.setToolTipText(evalRelation);
        this.getUIContext().put("testPaperID", evalPerson.getEvalReDetail().getEvalRelation().getPaper().getId().toString());
    }

    private void fillData() throws Exception {
        TestPaperInfo info;
        String id = (String)this.getUIContext().get("testPaperID");
        if (id == null) {
            return;
        }
        if (this.areas != null && this.areas.length > 0) {
            for (int i = 0; i < this.areas.length; ++i) {
                this.areas[i].setVisible(false);
                this.pnlMain.remove((Component)this.areas[i]);
                this.areas[i] = null;
                this.lbls[i].setVisible(false);
                this.pnlMain.remove((Component)this.lbls[i]);
                this.lbls[i] = null;
                this.scrolls[i].setVisible(false);
                this.pnlMain.remove((Component)this.scrolls[i]);
                this.scrolls[i] = null;
            }
            this.areas = null;
            this.lbls = null;
            this.scrolls = null;
        }
        if ((info = this.editData.getTestPaper()).getGradeMode() != null) {
            this.txtGradeMode.setText(info.getGradeMode().getName());
            this.minGrade = info.getGradeMode().getMinGrade();
            this.maxGrade = info.getGradeMode().getMaxGrade();
        }
        if (info.getRemark() != null) {
            this.txtDes.setText(info.getRemark());
        }
        this.lblTitle.setText(info.getName());
        this.fillTable(id);
        MultiDimentionCommentCollection coll = (MultiDimentionCommentCollection)((Object)this.editData.getTestPaper().get("mdColl"));
        int y = this.tblMain.getY() + this.tblMain.getHeight() + 10;
        if (coll != null && coll.size() > 0) {
            int baseY = 0;
            int size = coll.size();
            this.areas = new KDTextArea[size];
            this.lbls = new KDLabel[size];
            this.scrolls = new KDScrollPane[size];
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                int height;
                baseY = y + i * 110;
                this.lbls[i] = new KDLabel(coll.get(i).getComment() + ":");
                this.pnlMain.add((Component)this.lbls[i], (Object)new KDLayout.Constraints(10, baseY, 740, 19, 5));
                this.areas[i] = new KDTextArea();
                this.areas[i].setMaxLength(255);
                MDCommentDetailCollection mdcdColl = this.editData.getMdCommentDetail();
                int s = mdcdColl.size();
                for (int r = 0; r < s; ++r) {
                    if (!coll.get(i).getId().equals((Object)mdcdColl.get(r).getMdComment().getId())) continue;
                    this.areas[i].setText(mdcdColl.get(r).getEvaluation());
                    this.areas[i].setUserObject((Object)mdcdColl.get(r));
                    break;
                }
                this.scrolls[i] = new KDScrollPane((Component)this.areas[i]);
                this.scrolls[i].setBounds(new Rectangle(10, baseY + 19, 740, 81));
                this.pnlMain.add((Component)this.scrolls[i], (Object)new KDLayout.Constraints(10, baseY + 19, 740, 81, 5));
                if (i != n - 1 || !((double)(height = this.scrolls[i].getY() + this.scrolls[i].getHeight()) > this.pnlMain.getPreferredSize().getHeight())) continue;
                this.pnlMain.setPreferredSize(new Dimension(750, height + 20));
            }
        } else {
            int height = y;
            if ((double)height > this.pnlMain.getPreferredSize().getHeight()) {
                this.pnlMain.setPreferredSize(new Dimension(750, height + 20));
            }
        }
        this.pnlMain.revalidate();
        this.pnlScroll.revalidate();
    }

    private void initCondition() throws Exception {
        String soluPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("MDSolution.id"));
        sic.add(new SelectorItemInfo("MDSolution.EvaluModeEnum"));
        sic.add(new SelectorItemInfo("MDSolution.GradeMode.*"));
        sic.add(new SelectorItemInfo("MDSolution.RankGroup.id"));
        sic.add(new SelectorItemInfo("MDSolution.hidePaperWeight"));
        MultiDimentionSolutionPeriodInfo info = MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(soluPeriodID), sic);
        this.isRank = EvaluModeEnum.RANK_GROUP.equals((Object)info.getMDSolution().getEvaluModeEnum());
        this.isHidePaperWeight = info.getMDSolution().isHidePaperWeight();
    }

    private void fillTable(String id) throws Exception {
        if (id == null) {
            return;
        }
        this.tblMain.removeRows();
        this.haveEvals = (Boolean)this.editData.getTestPaper().get("haveEvals");
        boolean isCanComment = this.editData.getMdEvaluResult().getSolutionPeriod().getMDSolution().isCanComment();
        this.tblMain.getColumn("comment").getStyleAttributes().setHided(!isCanComment);
        KDTMergeManager mm = this.tblMain.getMergeManager();
        StringTokenizer tk = null;
        BigDecimal zero = new BigDecimal("0.00000000");
        BigDecimal percent = new BigDecimal("0.01");
        boolean flag = this.isRank;
        if (this.haveEvals) {
            this.tblMain.getColumn("serial").getStyleAttributes().setHided(true);
            PaperQuestionsCollection pqColl = (PaperQuestionsCollection)((Object)this.editData.getTestPaper().get("pqColl"));
            IRow row = null;
            PaperQuestionsInfo pqInfo = null;
            int height = 44;
            if (pqColl != null && pqColl.size() > 0) {
                StringBuffer sb = null;
                int count = 0;
                TreeSet<Integer> set = new TreeSet<Integer>();
                int n = pqColl.size();
                for (int i = 0; i < n; ++i) {
                    set.add(new Integer(pqColl.get(i).getEvaluation().getSerial()));
                }
                int serial = 0;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    serial = (Integer)iter.next();
                    int n2 = pqColl.size();
                    block2: for (int i = 0; i < n2; ++i) {
                        pqInfo = pqColl.get(i);
                        if (pqInfo.getEvaluation().getSerial() != serial) continue;
                        row = this.tblMain.addRow();
                        row.getCell("queID").setValue((Object)pqInfo.getId().toString());
                        row.getCell("evalID").setValue((Object)pqInfo.getEvaluation().getId().toString());
                        count = 0;
                        sb = new StringBuffer(pqInfo.getEvaluation().getEvaluation());
                        int j = 1;
                        while (j * 10 + j - 1 < sb.length()) {
                            sb.insert(j * 10 + j - 1, "\n");
                            ++j;
                        }
                        if (sb.length() < 10 && sb.length() > 2) {
                            sb.append("\n");
                        } else if (sb.length() - count * 10 < 9) {
                            sb.append("\n");
                        }
                        if (!this.isHidePaperWeight) {
                            sb.append(" (");
                            sb.append(PFVerifyUtils.formatBigDecimal(pqInfo.getEvaluation().getWeight(), 2) + "%");
                            sb.append(")");
                        }
                        row.getCell("eval").setValue((Object)sb.toString());
                        tk = new StringTokenizer(sb.toString(), "\n");
                        if (tk.countTokens() > count) {
                            count = tk.countTokens();
                        }
                        sb = new StringBuffer(pqInfo.getTestQuestion().getContent());
                        int contentCount = 0;
                        int j2 = 1;
                        while (j2 * 15 + j2 - 1 < sb.length()) {
                            ++contentCount;
                            ++j2;
                        }
                        row.getCell("content").setValue((Object)sb.toString());
                        if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                            count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                        }
                        sb = new StringBuffer(pqInfo.getTestQuestion().getStandard());
                        contentCount = 0;
                        j2 = 1;
                        while (j2 * 14 + j2 - 1 < sb.length()) {
                            ++contentCount;
                            ++j2;
                        }
                        row.getCell("standard").setValue((Object)sb.toString());
                        if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                            count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                        }
                        row.getCell("weight").setValue((Object)(PFVerifyUtils.formatBigDecimal(pqInfo.getWeight(), 2) + "%"));
                        row.getCell("weight").setUserObject((Object)zero.add(pqInfo.getWeight()).multiply(pqInfo.getEvaluation().getWeight()).multiply(percent));
                        row.getCell("evalSumScore").setUserObject((Object)zero.add(pqInfo.getWeight()));
                        height += 19 * count;
                        row.setHeight(19 * count);
                        PaperQueDetailCollection pqdColl = this.editData.getPaperQueDetail();
                        int s = pqdColl.size();
                        for (int r = 0; r < s; ++r) {
                            if (!pqColl.get(i).getId().equals((Object)pqdColl.get(r).getPaperQue().getId())) continue;
                            if (flag) {
                                row.getCell("score").setValue((Object)pqdColl.get(r).getRank());
                            } else {
                                row.getCell("score").setValue((Object)pqdColl.get(r).getScore());
                            }
                            row.getCell("comment").setValue((Object)pqdColl.get(r).getComment());
                            row.getCell("score").setUserObject((Object)pqdColl.get(r));
                            row.setUserObject((Object)pqdColl.get(r));
                            break;
                        }
                        MDEvalDetailCollection mdedColl = this.editData.getMdEvalDetail();
                        int s2 = mdedColl.size();
                        for (int r = 0; r < s2; ++r) {
                            if (!mdedColl.get(r).getMdEval().getId().equals((Object)pqColl.get(i).getEvaluation().getId())) continue;
                            row.getCell("evalSumScore").setValue((Object)mdedColl.get(r).getScore());
                            continue block2;
                        }
                    }
                }
                this.tblMain.getColumn("eval").setGroup(true);
                this.tblMain.getColumn("evalSumScore").setGroup(true);
                this.tblMain.getGroupManager().group();
                row = this.tblMain.addRow();
                height += 19;
                row.getCell("eval").setValue((Object)EASResource.getString((String)RES, (String)"scoreSumTitle"));
                mm.mergeBlock(row.getRowIndex(), row.getCell("content").getColumnIndex(), row.getRowIndex(), row.getCell("score").getColumnIndex());
                row.getCell("evalSumScore").setValue((Object)this.editData.getScore());
            }
            this.tblMain.setBounds(new Rectangle(10, 135, 740, height));
            this.pnlMain.add((Component)this.tblMain, (Object)new KDLayout.Constraints(10, 135, 740, height, 5));
            if (this.pnlMain.getY() > this.pnlMain.getPreferredSize().height) {
                this.pnlMain.setPreferredSize(new Dimension(750, this.pnlMain.getY() + 50));
            }
            this.pnlMain.revalidate();
        } else {
            this.tblMain.getColumn("eval").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setHided(true);
            PaperQuestionsCollection pqColl = (PaperQuestionsCollection)((Object)this.editData.getTestPaper().get("pqColl"));
            IRow row = null;
            PaperQuestionsInfo pqInfo = null;
            StringBuffer sb = null;
            int count = 0;
            int height = 44;
            if (pqColl != null && pqColl.size() > 0) {
                int n = pqColl.size();
                block8: for (int i = 0; i < n; ++i) {
                    count = 0;
                    pqInfo = pqColl.get(i);
                    row = this.tblMain.addRow();
                    row.getCell("serial").setValue((Object)new Integer(pqInfo.getSerial()));
                    sb = new StringBuffer(pqInfo.getTestQuestion().getContent());
                    int contentCount = 0;
                    int j = 1;
                    while (j * 22 + j - 1 < sb.length()) {
                        ++contentCount;
                        ++j;
                    }
                    row.getCell("content").setValue((Object)sb.toString());
                    if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                        count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                    }
                    sb = new StringBuffer(pqInfo.getTestQuestion().getStandard());
                    contentCount = 0;
                    j = 1;
                    while (j * 22 + j - 1 < sb.length()) {
                        ++contentCount;
                        ++j;
                    }
                    row.getCell("standard").setValue((Object)sb.toString());
                    if (contentCount + new StringTokenizer(sb.toString(), "\n").countTokens() > count) {
                        count = contentCount + new StringTokenizer(sb.toString(), "\n").countTokens();
                    }
                    row.getCell("weight").setValue((Object)(PFVerifyUtils.formatBigDecimal(pqInfo.getWeight(), 2) + "%"));
                    row.getCell("weight").setUserObject((Object)pqInfo.getWeight());
                    row.setHeight(count * 19);
                    height += count * 19;
                    PaperQueDetailCollection pqdColl = this.editData.getPaperQueDetail();
                    int s = pqdColl.size();
                    for (int r = 0; r < s; ++r) {
                        if (!pqColl.get(i).getId().equals((Object)pqdColl.get(r).getPaperQue().getId())) continue;
                        if (flag) {
                            row.getCell("score").setValue((Object)pqdColl.get(r).getRank());
                        } else {
                            row.getCell("score").setValue((Object)pqdColl.get(r).getScore());
                        }
                        row.getCell("comment").setValue((Object)pqdColl.get(r).getComment());
                        row.getCell("score").setUserObject((Object)pqdColl.get(r));
                        row.setUserObject((Object)pqdColl.get(r));
                        continue block8;
                    }
                }
                this.tblMain.getColumn("eval").setGroup(true);
                this.tblMain.getColumn("evalSumScore").setGroup(true);
                this.tblMain.getGroupManager().group();
                row = this.tblMain.addRow();
                height += 19;
                row.getCell("serial").setValue((Object)EASResource.getString((String)RES, (String)"scoreSumTitle"));
                mm.mergeBlock(row.getRowIndex(), row.getCell("content").getColumnIndex(), row.getRowIndex(), row.getCell("weight").getColumnIndex());
                row.getCell("score").setValue((Object)this.editData.getScore());
            }
            this.tblMain.setBounds(new Rectangle(10, 135, 740, height));
            this.pnlMain.add((Component)this.tblMain, (Object)new KDLayout.Constraints(10, 135, 740, height, 5));
            if (this.pnlMain.getY() > this.pnlMain.getPreferredSize().height) {
                this.pnlMain.setPreferredSize(new Dimension(750, this.pnlMain.getY() + 50));
            }
            this.pnlMain.revalidate();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        String id = (String)this.getUIContext().get("testPaperID");
        if (id == null) {
            return;
        }
        if (this.haveEvals) {
            this.tblMain.getColumn("eval").setWidth(165);
            this.tblMain.getColumn("content").setWidth(190);
            this.tblMain.getColumn("standard").setWidth(180);
            this.tblMain.getColumn("weight").setWidth(50);
            this.tblMain.getColumn("score").setWidth(50);
            this.tblMain.getColumn("evalSumScore").setWidth(77);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setBackground(ITEM_SUM_COLOR);
        } else {
            this.tblMain.getColumn("serial").setWidth(60);
            this.tblMain.getColumn("content").setWidth(280);
            this.tblMain.getColumn("standard").setWidth(272);
            this.tblMain.getColumn("weight").setWidth(50);
            this.tblMain.getColumn("score").setWidth(50);
            this.tblMain.getColumn("score").getStyleAttributes().setBackground(ITEM_SUM_COLOR);
        }
        if (this.isHidePaperWeight) {
            this.tblMain.getColumn("weight").getStyleAttributes().setHided(true);
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getStyleAttributes().setBackground(STAT_COLOR);
        this.pnlMain.revalidate();
        this.reSizeTable();
    }

    private TestPageFormInfo getTestPageForm() throws Exception {
        String evalPersonID = (String)this.getUIContext().get("evalPersonID");
        String testPaperID = (String)this.getUIContext().get("testPaperID");
        String solutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        String mdObjectID = (String)this.getUIContext().get("evaluObjectID");
        TestPageFormInfo info = TestPageFormFactory.getRemoteInstance().getTestPageForm(evalPersonID, solutionPeriodID, mdObjectID, testPaperID);
        if (info.getEvalPerson().getPaperState().equals((Object)MultiDimTestPaperStateEnum.SUBMIT)) {
            this.setOprtState(OprtState.VIEW);
        }
        return info;
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        Object obj;
        BigDecimal grade;
        if (e.getRowIndex() == this.tblMain.getRowCount() - 1) {
            return;
        }
        if (!this.isRank && (grade = (BigDecimal)this.tblMain.getRow(e.getRowIndex()).getCell("score").getValue()) != null) {
            KDTEditManager em = this.tblMain.getEditManager();
            if (grade.compareTo(this.maxGrade) > 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)perfRES, (String)"gradeUPIllegal") + PFVerifyUtils.formatBigDecimal(this.maxGrade, 2)));
                em.editCellAt(e.getRowIndex(), e.getColIndex(), true);
                e.setCancel(true);
                return;
            }
            if (grade.compareTo(this.minGrade) < 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)perfRES, (String)"gradeDownIllegal") + PFVerifyUtils.formatBigDecimal(this.minGrade, 2)));
                em.editCellAt(e.getRowIndex(), e.getColIndex(), true);
                e.setCancel(true);
                return;
            }
        }
        if (this.haveEvals) {
            int i;
            String evalID = (String)this.tblMain.getRow(e.getRowIndex()).getCell("evalID").getValue();
            BigDecimal evalSum = new BigDecimal("0.00");
            obj = null;
            RankInfo rank = null;
            BigDecimal weight = null;
            BigDecimal percent = new BigDecimal("0.01");
            int n = this.tblMain.getRowCount() - 2;
            for (i = 0; i < n; ++i) {
                if (!this.tblMain.getRow(i).getCell("evalID").getValue().equals(evalID)) continue;
                weight = (BigDecimal)this.tblMain.getRow(i).getCell("weight").getUserObject();
                obj = this.tblMain.getRow(i).getCell("score").getValue();
                if (obj == null) continue;
                if (obj instanceof BigDecimal) {
                    evalSum = evalSum.add(((BigDecimal)obj).multiply(weight).multiply(percent));
                    continue;
                }
                rank = (RankInfo)obj;
                evalSum = evalSum.add(rank.getGrade().multiply(weight).multiply(percent));
            }
            n = this.tblMain.getRowCount() - 2;
            for (i = 0; i < n; ++i) {
                if (!this.tblMain.getRow(i).getCell("evalID").getValue().equals(evalID)) continue;
                this.tblMain.getRow(i).getCell("evalSumScore").setValue((Object)evalSum);
            }
        }
        BigDecimal weight = null;
        BigDecimal sum = new BigDecimal("0.00");
        obj = null;
        BigDecimal percent = new BigDecimal("0.01");
        RankInfo rank = null;
        int n = this.tblMain.getRowCount() - 2;
        for (int i = 0; i < n; ++i) {
            weight = (BigDecimal)this.tblMain.getRow(i).getCell("weight").getUserObject();
            obj = this.tblMain.getRow(i).getCell("score").getValue();
            if (obj == null) continue;
            if (obj instanceof BigDecimal) {
                sum = sum.add(((BigDecimal)obj).multiply(weight).multiply(percent));
                continue;
            }
            rank = (RankInfo)obj;
            sum = sum.add(rank.getGrade().multiply(weight).multiply(percent));
        }
        if (this.haveEvals) {
            this.tblMain.getRow(this.tblMain.getRowCount() - 2).getCell("evalSumScore").setValue((Object)sum);
        } else {
            this.tblMain.getRow(this.tblMain.getRowCount() - 2).getCell("score").setValue((Object)sum);
        }
    }

    private void checkInitDataOK() throws Exception {
        Map map = this.getUIContext();
        if (map.get("solutionPeriodID") == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullMDEvaluSolutionID"));
            SysUtil.abort();
        }
        if (map.get("evaluObjectID") == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullMDObjectID"));
            SysUtil.abort();
        }
    }

    private void setNotEditableUI() {
        int i;
        int n = this.tblMain.getColumnCount();
        for (i = 0; i < n; ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("score").getStyleAttributes().setLocked(true);
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("evalSumScore").getStyleAttributes().setLocked(true);
        if (this.areas != null) {
            for (i = 0; i < this.areas.length; ++i) {
                this.areas[i].setEditable(false);
            }
        }
    }

    @Override
    public void actionEndData_actionPerformed(ActionEvent e) throws Exception {
        String evalPersonID = this.idList.getLastID();
        this.getUIContext().put("evalPersonID", evalPersonID);
        this.changeData();
    }

    @Override
    public void actionFirstData_actionPerformed(ActionEvent e) throws Exception {
        String evalPersonID = this.idList.getFirstID();
        this.getUIContext().put("evalPersonID", evalPersonID);
        this.changeData();
    }

    @Override
    public void actionNextData_actionPerformed(ActionEvent e) throws Exception {
        String evalPersonID = this.idList.getNextID();
        this.getUIContext().put("evalPersonID", evalPersonID);
        this.changeData();
    }

    @Override
    public void actionPreData_actionPerformed(ActionEvent e) throws Exception {
        String evalPersonID = this.idList.getPreviousID();
        this.getUIContext().put("evalPersonID", evalPersonID);
        this.changeData();
    }

    private void changeData() throws Exception {
        this.fillHead();
        this.editData = this.getTestPageForm();
        this.fillData();
        if (this.haveEvals) {
            this.tblMain.getColumn("serial").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("eval").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("eval").setWidth(165);
            this.tblMain.getColumn("content").setWidth(190);
            this.tblMain.getColumn("standard").setWidth(180);
            this.tblMain.getColumn("weight").setWidth(50);
            this.tblMain.getColumn("score").setWidth(50);
            this.tblMain.getColumn("evalSumScore").setWidth(77);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setBackground(ITEM_SUM_COLOR);
        } else {
            this.tblMain.getColumn("serial").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("eval").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("evalSumScore").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("serial").setWidth(60);
            this.tblMain.getColumn("content").setWidth(280);
            this.tblMain.getColumn("standard").setWidth(272);
            this.tblMain.getColumn("weight").setWidth(50);
            this.tblMain.getColumn("score").setWidth(50);
            this.tblMain.getColumn("score").getStyleAttributes().setBackground(ITEM_SUM_COLOR);
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getStyleAttributes().setBackground(STAT_COLOR);
        this.tblMain.revalidate();
        this.pnlMain.revalidate();
        this.initScrollButtons();
    }

    protected void initScrollButtons() {
        if (this.idList == null) {
            this.actionFirstData.setEnabled(false);
            this.actionPreData.setEnabled(false);
            this.actionNextData.setEnabled(false);
            this.actionEndData.setEnabled(false);
            return;
        }
        if (this.idList.getCurrentIndex() < 0 || this.idList.isBegin()) {
            this.actionFirstData.setEnabled(false);
            this.actionPreData.setEnabled(false);
        } else {
            this.actionFirstData.setEnabled(true);
            this.actionPreData.setEnabled(true);
        }
        if (this.idList.isEnd()) {
            this.actionNextData.setEnabled(false);
            this.actionEndData.setEnabled(false);
        } else {
            this.actionNextData.setEnabled(true);
            this.actionEndData.setEnabled(true);
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        String mdoObjectID = (String)this.getUIContext().get("evaluObjectID");
        String solutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        String evalPersonID = (String)this.getUIContext().get("evalPersonID");
        String testPaperID = (String)this.getUIContext().get("testPaperID");
        req.put("mdoObjectID", (Object)mdoObjectID);
        req.put("solutionPeriodID", (Object)solutionPeriodID);
        req.put("evalPersonID", (Object)evalPersonID);
        req.put("testPaperID", (Object)testPaperID);
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

