/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.TestQuestionFactory;
import com.kingdee.eas.hr.perf.TestQuestionTreeFactory;
import com.kingdee.eas.hr.perf.TestQuestionTreeInfo;
import com.kingdee.eas.hr.perf.client.AbstractTestQuestionTreeEditUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.TestQuestionEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class TestQuestionTreeEditUI
extends AbstractTestQuestionTreeEditUI {
    private static final String RES = "com.kingdee.eas.hr.perf.client.TestQuestion";

    protected String getEditUIName() {
        return TestQuestionEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TestQuestionTreeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TestQuestionTreeInfo objectValue = new TestQuestionTreeInfo();
        objectValue.setEnabled(true);
        objectValue.setParent(this.getParentType());
        objectValue.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return objectValue;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullTestQuestionTreeNumber"));
            SysUtil.abort();
        }
        if (PFVerifyUtils.objectIsNull(this.txtName.getSelectedItem())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullTestQuestionTreeName"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    private TestQuestionTreeInfo getParentType() {
        Object obj = this.getUIContext().get("ParentNode");
        if (obj == null) {
            return null;
        }
        return (TestQuestionTreeInfo)obj;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.isEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"disableGroupAddNew"));
            SysUtil.abort();
        }
        if (this.editData.getId() != null && this.haveQuestion()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"canNotAddSubType"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.isEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"disableGroupEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        TestQuestionTreeInfo info = (TestQuestionTreeInfo)dataObject;
        try {
            if (info.getId() != null) {
                if (TestQuestionTreeFactory.getRemoteInstance().isQuestionRefered(info.getId().toString())) {
                    this.txtName.setEditable(false);
                    this.txtNumber.setEditable(false);
                } else {
                    this.txtName.setEditable(true);
                    this.txtNumber.setEditable(true);
                }
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.isIsLeaf()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"typeHaveSubType"));
            SysUtil.abort();
        }
        if (this.haveQuestion()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"deleteTestQuestionFirst"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean haveQuestion() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)this.editData.getId(), CompareType.EQUALS));
        return TestQuestionFactory.getRemoteInstance().exists(filter);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("enabled"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("isLeaf"));
        return sic;
    }

    private boolean isRefered() {
        return false;
    }
}

