/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.perf.client.AbstractViewMDEvaluGroupDetailErrorUI;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ViewMDEvaluGroupDetailErrorUI
extends AbstractViewMDEvaluGroupDetailErrorUI {
    private static final Logger logger = CoreUIObject.getLogger(ViewMDEvaluGroupDetailErrorUI.class);
    private String resourcePath = "com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource";
    HashMap personToErrorMap = null;

    private void fetchAndParseString() {
        String errorMsg = this.getUIContext().get("errorMsg").toString();
        if (errorMsg == null) {
            PerfClientUtils.showErrorMessage(this.resourcePath, "noErrorMsg", this);
        }
        this.parseString(errorMsg);
    }

    private void parseString(String errorMsg) {
        this.personToErrorMap = new HashMap();
        String[] str = errorMsg.split("\n");
        if (str.length % 3 != 0) {
            PerfClientUtils.showErrorMessage(this.resourcePath, "errorMsg", this);
        }
        int n = str.length;
        for (int i = 0; i < n; ++i) {
            HashSet set;
            if (i % 3 != 0) continue;
            if (this.personToErrorMap.containsKey(str[i])) {
                set = (HashSet)this.personToErrorMap.get(str[i]);
                set.add(str[i + 1] + "\n" + str[i + 2]);
                continue;
            }
            set = new HashSet();
            set.add(str[i + 1] + "\n" + str[i + 2]);
            this.personToErrorMap.put(str[i], set);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.fetchAndParseString();
        this.loadData();
        this.mergeTable();
        this.detailErrorMsgTable.getSelectManager().setSelectMode(2);
        this.detailErrorMsgTable.getStyleAttributes().setLocked(true);
        this.detailErrorMsgTable.setEnabled(false);
    }

    private void mergeTable() {
        this.detailErrorMsgTable.getColumn("name").setGroup(true);
        this.detailErrorMsgTable.getColumn("ID").setGroup(true);
        this.detailErrorMsgTable.getColumn("position").setGroup(true);
        this.detailErrorMsgTable.getColumn("orgUnit").setGroup(true);
        this.detailErrorMsgTable.getGroupManager().group();
    }

    private void loadData() throws Exception {
        HashSet<String> set = new HashSet<String>();
        Iterator iterator = this.personToErrorMap.keySet().iterator();
        while (iterator.hasNext()) {
            set.add(iterator.next().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "PersonToPositionGradeLevel2Query"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        this.detailErrorMsgTable.checkParsed();
        this.detailErrorMsgTable.removeRows();
        while (rowSet.next()) {
            HashSet detailSet = (HashSet)this.personToErrorMap.get(rowSet.getString("id"));
            Iterator iterator2 = detailSet.iterator();
            while (iterator2.hasNext()) {
                IRow row = this.detailErrorMsgTable.addRow();
                row.getCell("ID").setValue((Object)rowSet.getString("id"));
                row.getCell("name").setValue((Object)rowSet.getString("name"));
                row.getCell("position").setValue((Object)rowSet.getString("position2.name"));
                row.getCell("orgUnit").setValue((Object)rowSet.getString("orgUnit.displayName"));
                String[] str = iterator2.next().toString().split("\n");
                row.getCell("relation").setValue((Object)str[0]);
                row.getCell("errorMsg").setValue((Object)str[1]);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }
}

