/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.hr.perf.SynFlowObjectCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractViewSynEvaluObjectUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.HashSet;

public class ViewSynEvaluObjectUI
extends AbstractViewSynEvaluObjectUI {
    private static final long serialVersionUID = -61166L;
    private SynSolutionPeriodInfo solutionPeriodInfo;
    private HashMap evaluObjectMap = new HashMap();
    String ID = "id";
    String NUMBER = "number";
    String NAME = "name";
    String POSITION = "position";
    String ORGUNIT = "orgunit";
    String JOBGRADE = "jobGrade";

    public void onLoad() throws Exception {
        super.onLoad();
        this.evaluObjectTable.checkParsed();
        int n = this.evaluObjectTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.evaluObjectTable.getColumn(i).getStyleAttributes().setLocked(true);
        }
        SynEvaluFlowInfo wfInfo = (SynEvaluFlowInfo)this.getUIContext().get("workFlowInfo");
        this.initEvaluObject(wfInfo);
    }

    public void initEvaluObject(SynEvaluFlowInfo wfInfo) {
        this.evaluObjectTable.removeRows();
        this.solutionPeriodInfo = wfInfo.getSolutionPeriod();
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SynSolutionPeriodEvaluObjectQuery"));
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = null;
            if (wfInfo.getId() != null) {
                filter = new FilterInfo();
                StringBuffer sql = new StringBuffer("SELECT FEvaluObjectID FROM T_PF_SynFlowObject WHERE FEvalWorkFlowID = ");
                sql.append("'");
                sql.append(wfInfo.getId().toString());
                sql.append("'");
                filter.getFilterItems().add(new FilterItemInfo("EvaluObject.id", (Object)sql.toString(), CompareType.INNER));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.solutionPeriodInfo.getId(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                iqec.setObjectView(viewInfo);
                IRowSet rowSet = iqec.executeQuery();
                this.renderRowSet(rowSet);
            } else {
                int BATCH_SIZE = 500;
                SynFlowObjectCollection coll = wfInfo.getWfObjects();
                HashSet<String> idSet = new HashSet<String>();
                int n = coll.size();
                for (int i = 0; i < n; ++i) {
                    idSet.add(coll.get(i).getEvaluObject().getId().toString());
                    if (i % 500 != 0 && i != n - 1) continue;
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("EvaluObject.id", idSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.solutionPeriodInfo.getId(), CompareType.EQUALS));
                    viewInfo.setFilter(filter);
                    iqec.setObjectView(viewInfo);
                    IRowSet rowSet = iqec.executeQuery();
                    this.renderRowSet(rowSet);
                    idSet.clear();
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void renderRowSet(IRowSet rowSet) throws Exception {
        while (rowSet.next()) {
            IRow row = this.evaluObjectTable.addRow();
            SynEvaluObjectInfo evaluObjectInfo = new SynEvaluObjectInfo();
            evaluObjectInfo.setId(BOSUuid.read((String)rowSet.getString("EvaluObject.id")));
            this.evaluObjectMap.put(evaluObjectInfo.getId(), evaluObjectInfo);
            row.getCell(this.ID).setValue((Object)evaluObjectInfo.getId());
            row.getCell(this.NAME).setValue((Object)rowSet.getString("Person.name"));
            row.getCell(this.NUMBER).setValue((Object)rowSet.getString("Person.number"));
            row.getCell(this.POSITION).setValue((Object)rowSet.getString("Position.name"));
            row.getCell(this.ORGUNIT).setValue((Object)rowSet.getString("AdminOrgUnit.displayName"));
            row.getCell(this.JOBGRADE).setValue((Object)rowSet.getString("JobGrade.name"));
        }
    }
}

