/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.AbstractSynSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluModeEnum;
import com.kingdee.eas.hr.perf.SynConcArgsCollection;
import com.kingdee.eas.hr.perf.SynConcArgsFactory;
import com.kingdee.eas.hr.perf.SynEvaluFlowInfo;
import com.kingdee.eas.hr.perf.SynFlowNodeCollection;
import com.kingdee.eas.hr.perf.SynFlowNodeFactory;
import com.kingdee.eas.hr.perf.SynNodeEvaluItemCollection;
import com.kingdee.eas.hr.perf.SynNodeEvaluItemInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.client.AbstractViewSynFlowUI;
import com.kingdee.eas.hr.perf.client.ViewSynEvaluObjectUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Map;

public class ViewSynFlowUI
extends AbstractViewSynFlowUI {
    private static final long serialVersionUID = -61166L;
    private SynEvaluFlowInfo workFlowInfo = null;
    private static final String RES = "com.kingdee.eas.hr.perf.client.WorkFlowDefineResource";

    public void onLoad() throws Exception {
        super.onLoad();
        String flowID = (String)this.getUIContext().get("flowID");
        this.initViewUI(flowID);
    }

    public void initViewUI(String wfInfoID) throws Exception {
        SynEvaluFlowInfo wfInfo = new SynEvaluFlowInfo();
        wfInfo.setId(BOSUuid.read((String)wfInfoID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("solution.id"));
        sic.add(new SelectorItemInfo("solution.inputMode"));
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        StringBuffer flowSql = new StringBuffer("SELECT FSolutionPeriodID FROM T_PF_SynEvaluFlow WHERE FID = ");
        flowSql.append("'");
        flowSql.append(wfInfoID);
        flowSql.append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)flowSql.toString(), CompareType.INNER));
        viewInfo.setFilter(filter);
        AbstractSynSolutionInfo solution = null;
        try {
            SynSolutionPeriodCollection coll = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodCollection(viewInfo);
            if (coll.size() == 1) {
                wfInfo.setSolutionPeriod(coll.get(0));
                solution = coll.get(0).getSolution();
            }
        }
        catch (Exception ex) {
            return;
        }
        EvaluModeEnum imputMode = solution.getInputMode();
        boolean isGrade = EvaluModeEnum.MANUAL_ENTER.equals((Object)imputMode);
        this.workFlowInfo = wfInfo;
        viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)wfInfoID));
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "SynEvaluFlowFastQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        if (rowSet.next()) {
            wfInfo.setWfLevels(rowSet.getInt("wfLevels"));
            wfInfo.setConcurrenceLevels(rowSet.getInt("concurrenceLevels"));
        }
        this.txtLevels.setText("" + wfInfo.getWfLevels());
        this.txtLevels.setEditable(false);
        this.txtConcs.setText("" + wfInfo.getConcurrenceLevels());
        this.txtConcs.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        wfInfo.put("evaluNodes", (Object)this.getSortedSynFlowNodes(wfInfoID));
        SynFlowNodeCollection nodes = this.getSortedSynFlowNodes(wfInfoID);
        SynNodeEvaluItemInfo[] items = null;
        IRow row = null;
        SynConcArgsCollection concArgs = this.getConcArgs(wfInfoID);
        wfInfo.put("concurArgs", (Object)concArgs);
        SynConcArgsCollection concArgsColl = wfInfo.getConcurArgs();
        boolean flag = false;
        int count = 0;
        int level = -1;
        int itemCount = 0;
        StringBuffer stringBuffer = null;
        String binfa = EASResource.getString((String)RES, (String)"binfaLabel");
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            items = this.getSortedItems(nodes.get(i).getNodeEvaluItems());
            if (level != nodes.get(i).getNodeLevel()) {
                count = 0;
                level = nodes.get(i).getNodeLevel();
            }
            flag = false;
            int cSize = concArgsColl.size();
            for (int c = 0; c < cSize; ++c) {
                if (concArgsColl.get(c).getConcurrenceLevel() != level) continue;
                flag = true;
                break;
            }
            if (flag) {
                ++count;
            }
            itemCount = 0;
            for (int j = 0; j < items.length; ++j) {
                if (!items[j].isCanWrite()) continue;
                ++itemCount;
                row = this.tblMain.addRow();
                stringBuffer = new StringBuffer();
                stringBuffer.append(nodes.get(i).getLevelName());
                if (flag) {
                    stringBuffer.append("[");
                    stringBuffer.append(binfa);
                    stringBuffer.append(count);
                    stringBuffer.append("]");
                }
                stringBuffer.append(" : ");
                stringBuffer.append(nodes.get(i).getNodeName());
                row.getCell("name").setValue((Object)stringBuffer.toString());
                row.getCell("writeComm").setValue((Object)new Boolean(nodes.get(i).isCanComment()));
                row.getCell("grade").setValue((Object)new Boolean(nodes.get(i).isCanGrade()));
                row.getCell("rank").setValue((Object)new Boolean(nodes.get(i).isCanEvaluateLevel()));
                row.getCell("evaluItem").setValue((Object)items[j].getEvaluItem().getContent());
            }
            if (itemCount != 0) continue;
            row = this.tblMain.addRow();
            stringBuffer = new StringBuffer();
            stringBuffer.append(nodes.get(i).getLevelName());
            if (flag) {
                stringBuffer.append("[");
                stringBuffer.append(binfa);
                stringBuffer.append(count);
                stringBuffer.append("]");
            }
            stringBuffer.append(" : ");
            stringBuffer.append(nodes.get(i).getNodeName());
            row.getCell("name").setValue((Object)stringBuffer.toString());
            row.getCell("writeComm").setValue((Object)new Boolean(nodes.get(i).isCanComment()));
            row.getCell("grade").setValue((Object)new Boolean(nodes.get(i).isCanGrade()));
            row.getCell("rank").setValue((Object)new Boolean(nodes.get(i).isCanEvaluateLevel()));
        }
        this.tblMain.getColumn("name").setGroup(true);
        this.tblMain.getColumn("writeComm").setGroup(true);
        this.tblMain.getColumn("grade").setGroup(true);
        this.tblMain.getColumn("rank").setGroup(true);
        this.tblMain.getColumn("evaluItem").setGroup(true);
        if (isGrade) {
            this.tblMain.getColumn("grade").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("rank").getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn("grade").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("rank").getStyleAttributes().setHided(false);
        }
        this.tblMain.getGroupManager().group();
    }

    private SynConcArgsCollection getConcArgs(String wfInfoID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)wfInfoID));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        SynConcArgsCollection result = SynConcArgsFactory.getRemoteInstance().getSynConcArgsCollection(viewInfo);
        return result;
    }

    private SynFlowNodeCollection getSortedSynFlowNodes(String wfInfoID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)wfInfoID));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("nodeEvaluItems.*"));
        sic.add(new SelectorItemInfo("nodeEvaluItems.evaluItem.*"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("seqNumber"));
        SynFlowNodeCollection nodes = SynFlowNodeFactory.getRemoteInstance().getSynFlowNodeCollection(viewInfo);
        return nodes;
    }

    private SynNodeEvaluItemInfo[] getSortedItems(SynNodeEvaluItemCollection items) {
        int i;
        int size = items.size();
        SynNodeEvaluItemInfo[] ret = new SynNodeEvaluItemInfo[size];
        Object[] seqs = new String[size];
        for (i = 0; i < size; ++i) {
            seqs[i] = items.get(i).getEvaluItem().getNumber();
        }
        Arrays.sort(seqs);
        block1: for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (!((String)seqs[i]).equals(items.get(j).getEvaluItem().getNumber())) continue;
                ret[i] = items.get(j);
                continue block1;
            }
        }
        return ret;
    }

    @Override
    protected void lblFlowObj_mouseClicked(MouseEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"workFlowInfo", (Object)this.workFlowInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ViewSynEvaluObjectUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        window.show();
    }
}

