/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.IMultiDimEvaluator;
import com.kingdee.eas.hr.perf.MessageString;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.WorkFlowControlEnum;
import com.kingdee.eas.hr.perf.client.AbstractWorkFlowControlOrgUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WorkFlowControlOrgUI
extends AbstractWorkFlowControlOrgUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkFlowControlOrgUI.class);
    private String RES = "com.kingdee.eas.hr.perf.client.WorkFlowControlResource";
    private static final String RES1 = "com.kingdee.eas.hr.perf.client.PerfResource";
    private String resClass = "com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.";
    String solutionPeriodID;
    String evaluObjectID;
    String evaluObjectName;
    String operatorName;
    HashMap personMap = new HashMap();
    String evalor;

    public WorkFlowControlOrgUI() throws Exception {
        this.btnSendMessage.setEnabled(true);
        this.btnSendMail.setEnabled(true);
        this.btnAddPerson.setEnabled(true);
        this.btnDeletePerson.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSendMessage.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.btnSendMail.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnDeletePerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
    }

    @Override
    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)this.solutionPeriodID);
        filter.getFilterItems().add(filterItem);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodCollection(viewInfo).get(0);
        HashMap<String, MessageString> messageMap = new HashMap<String, MessageString>();
        int n = this.personTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object[] variables;
            String message;
            IRow row = this.personTable.getRow(i);
            if (PFVerifyUtils.objectIsNull(row.getCell("id").getValue())) continue;
            MessageString messageString = new MessageString();
            WorkFlowControlEnum role = (WorkFlowControlEnum)((Object)row.getCell("role").getValue());
            if (WorkFlowControlEnum.PRINCIPLE.equals((Object)role)) {
                message = EASResource.getString((String)this.RES, (String)"evaluObjectMessage");
                variables = new Object[]{solutionPeriodInfo.getName()};
            } else {
                message = EASResource.getString((String)this.RES, (String)"unDisposeMessage");
                variables = new Object[]{this.evaluObjectName, solutionPeriodInfo.getName()};
            }
            messageString.setTitle(MessageFormat.format(message, variables));
            messageString.setSender(EASResource.getString((String)this.RES, (String)"sender"));
            messageMap.put(row.getCell("id").getValue().toString(), messageString);
        }
        EvalWorkFlowFacadeFactory.getRemoteInstance().sendMessage(messageMap);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RES, (String)"sendMessageSuccess"));
    }

    @Override
    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        int rowSize = this.personTable.getRowCount();
        if (rowSize <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES1, (String)"atleastOneEmailAddr"));
            SysUtil.abort();
        }
        StringBuffer to = new StringBuffer();
        StringBuffer toNode = new StringBuffer();
        int badEmailCount = 0;
        StringBuffer badEmailName = new StringBuffer();
        String email = null;
        IRow row = null;
        boolean noRightEmail = true;
        for (int i = 0; i < rowSize; ++i) {
            row = this.personTable.getRow(i);
            email = (String)row.getCell("email").getValue();
            if (StringUtils.isEmpty((String)email) || email.indexOf("@") < 0) {
                if (badEmailCount != 0) {
                    badEmailName.append(",");
                }
                badEmailName.append(row.getCell("name").getValue().toString());
                ++badEmailCount;
                continue;
            }
            noRightEmail = false;
            if (row.getCell("role").getValue().equals((Object)WorkFlowControlEnum.UNDISPOSE)) {
                if (i != 0) {
                    toNode.append(",");
                }
                toNode.append(email);
                continue;
            }
            if (i != 0) {
                to.append(",");
            }
            to.append(email);
        }
        if (noRightEmail) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES1, (String)"noRightEmail"));
            SysUtil.abort();
        }
        if (badEmailCount > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(badEmailName);
            sb.append(EASResource.getString((String)RES1, (String)"etc"));
            sb.append(badEmailCount);
            sb.append(EASResource.getString((String)RES1, (String)"sendMailConfirm"));
            if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
                return;
            }
        }
        try {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.solutionPeriodID));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("evaluSolution.id"));
            sic.add(new SelectorItemInfo("evaluSolution.name"));
            sic.add(new SelectorItemInfo("assessPeriod.id"));
            sic.add(new SelectorItemInfo("assessPeriod.name"));
            SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodCollection(viewInfo).get(0);
            String solutionName = solutionPeriodInfo.getEvaluSolution().getName();
            String assessPeriodName = solutionPeriodInfo.getAssessPeriod().getName();
            String evaluObjectName = (String)this.getUIContext().get("evaluObjectName");
            Object[] variables = new Object[]{this.operatorName, solutionName, assessPeriodName, evaluObjectName};
            Object[] variablesNode = new Object[]{solutionName, assessPeriodName, evaluObjectName};
            String subject = EASResource.getString((String)this.RES, (String)"mailSubject");
            String mailSubjectForNode = EASResource.getString((String)this.RES, (String)"mailSubjectForNode");
            String personID = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
            IMultiDimEvaluator iMDEvaluator = MultiDimEvaluatorFactory.getRemoteInstance();
            if (to != null && !"".equals(to.toString())) {
                iMDEvaluator.sendMail(personID, to.toString(), MessageFormat.format(subject, variables), MessageFormat.format(subject, variables));
            }
            if (toNode != null && !"".equals(toNode.toString())) {
                iMDEvaluator.sendMail(personID, toNode.toString(), MessageFormat.format(mailSubjectForNode, variablesNode), MessageFormat.format(mailSubjectForNode, variablesNode));
            }
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SENDMAIL_FAIL")), (Throwable)err);
            SysUtil.abort();
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SENDMAIL_SUCCESS")));
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddPerson_actionPerformed(e);
        KDPromptBox promptBox = new KDPromptBox();
        EmployeeMultiF7PromptBox box = new EmployeeMultiF7PromptBox((IUIObject)this);
        box.setIsSingleSelect(false);
        promptBox.setSelector((KDPromptSelector)box);
        promptBox.setDataBySelector();
        Object[] objs = (Object[])promptBox.getValue();
        ArrayList<String> idList = new ArrayList<String>();
        if (!PFVerifyUtils.objectIsNull(objs) && !PFVerifyUtils.objectIsNull(objs[0])) {
            int n = objs.length;
            for (int i = 0; i < n; ++i) {
                PersonInfo personInfo = (PersonInfo)objs[i];
                if (this.personMap.containsKey(personInfo.getId().toString())) continue;
                idList.add(personInfo.getId().toString());
            }
        }
        if (idList.size() > 0) {
            String[] ids = new String[idList.size()];
            int n = idList.size();
            for (int i = 0; i < n; ++i) {
                ids[i] = (String)idList.get(i);
                this.personMap.put(ids[i], WorkFlowControlEnum.ASSIGNER);
            }
            IRowSet rowSet = this.getPersonRowSetByPersonIds(ids);
            while (rowSet.next()) {
                IRow row = this.personTable.addRow();
                row.getCell("id").setValue((Object)rowSet.getString("id"));
                row.getCell("name").setValue((Object)rowSet.getString("name"));
                row.getCell("number").setValue((Object)rowSet.getString("number"));
                row.getCell("position").setValue((Object)rowSet.getString("position.name"));
                row.getCell("orgunit").setValue((Object)rowSet.getString("adminOrgUnit.name"));
                row.getCell("role").setValue((Object)((WorkFlowControlEnum)((Object)this.personMap.get(rowSet.getString("id")))));
                row.getCell("email").setValue((Object)rowSet.getString("email"));
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    @Override
    public void actionDeletePerson_actionPerformed(ActionEvent e) throws Exception {
        int top;
        super.actionDeletePerson_actionPerformed(e);
        if (this.personTable.getSelectManager().size() == 0) {
            this.showErrorMessage("noSelectedRecord");
        }
        if (this.personTable.getRow(top = this.personTable.getSelectManager().get().getTop()) == null) {
            this.showErrorMessage("noSelectedRecord");
        }
        HashMap<Object, Object> deleteMap = new HashMap<Object, Object>();
        KDTSelectBlock sb = null;
        int size = this.personTable.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.personTable.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                deleteMap.put(this.personTable.getRow(j).getCell("id").getValue(), this.personTable.getRow(j).getCell("id").getValue());
            }
        }
        if (deleteMap.size() >= this.personMap.size()) {
            this.showErrorMessage("notDeleteAll");
        }
        int n = 0;
        for (int i = this.personTable.getRowCount() - 1; i >= n; --i) {
            IRow row = this.personTable.getRow(i);
            if (PFVerifyUtils.objectIsNull(row.getCell("id").getValue()) || !deleteMap.containsKey(row.getCell("id").getValue())) continue;
            this.personMap.remove(row.getCell("id").getValue().toString());
            this.personTable.removeRow(i);
        }
    }

    private IRowSet getPersonRowSetByPersonIds(String[] ids) throws Exception {
        if (PFVerifyUtils.objectIsNull(ids) || ids.length == 0) {
            return null;
        }
        IRowSet rowSet = null;
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        int i = 0;
        StringBuffer strBuffer = new StringBuffer();
        int n = ids.length;
        for (i = 0; i < n; ++i) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids[i], CompareType.EQUALS));
            if (i == 1) {
                strBuffer.append("( #0 OR #1 ");
                continue;
            }
            if (i <= 1) continue;
            strBuffer.append(" OR #");
            strBuffer.append(i);
        }
        filter.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)new Integer(1), CompareType.EQUALS));
        if (i > 1) {
            strBuffer.append(") AND #");
            strBuffer.append(i);
        } else if (i == 1) {
            strBuffer.append("#0 AND #1 ");
        }
        filter.setMaskString(strBuffer.toString());
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "WorkFlowControlPersonQuery"));
        iqec.setObjectView(viewInfo);
        try {
            rowSet = iqec.executeQuery();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return rowSet;
    }

    public void onLoad() throws Exception {
        EvaluObjectInfo evaluObjectInfo;
        super.onLoad();
        this.personTable.checkParsed();
        this.personTable.getSelectManager().setSelectMode(2);
        this.solutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        this.evaluObjectID = (String)this.getUIContext().get("evaluObjectID");
        this.evaluObjectName = (String)this.getUIContext().get("evaluObjectName");
        if (PFVerifyUtils.objectIsNull(this.evaluObjectID)) {
            this.showErrorMessage("evaluobjectNotNull");
        }
        if (PFVerifyUtils.objectIsNull(this.solutionPeriodID)) {
            this.showErrorMessage("solutionperiodNotNull");
        }
        if (PFVerifyUtils.objectIsNull(this.evaluObjectName)) {
            this.showErrorMessage("evaluObjectNameNotNull");
        }
        this.evalor = EvaluObjectTypeEnum.ORGUNIT.equals((Object)(evaluObjectInfo = EvaluObjectFactory.getRemoteInstance().getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(this.evaluObjectID))).getEvaluObjectType()) ? evaluObjectInfo.getResponser().getId().toString() : evaluObjectInfo.getObjectID();
        String[] persons = EvalWorkFlowFacadeFactory.getRemoteInstance().getPersonIdsFromInst(this.solutionPeriodID, this.evaluObjectID);
        StringBuffer sb = new StringBuffer();
        IPerson ip = PersonFactory.getRemoteInstance();
        PersonInfo person = new PersonInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        String[] ids = new String[persons.length + 1];
        ids[0] = this.evalor;
        this.personMap.put(this.evalor, WorkFlowControlEnum.PRINCIPLE);
        int n = persons.length;
        for (int i = 0; i < n; ++i) {
            ids[i + 1] = persons[i];
            this.personMap.put(persons[i], WorkFlowControlEnum.UNDISPOSE);
            person = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(persons[i]), sic);
            if (i == 0) {
                sb.append(person.getName());
                continue;
            }
            sb.append(",");
            sb.append(person.getName());
        }
        this.operatorName = sb.toString();
        IRowSet rowSet = this.getPersonRowSetByPersonIds(ids);
        while (rowSet.next()) {
            if (this.evalor.equals(rowSet.getString("id")) && !WorkFlowControlEnum.PRINCIPLE.equals((Object)((WorkFlowControlEnum)((Object)this.personMap.get(this.evalor))))) {
                IRow row = this.personTable.addRow();
                row.getCell("id").setValue((Object)this.evalor);
                row.getCell("name").setValue((Object)rowSet.getString("name"));
                row.getCell("number").setValue((Object)rowSet.getString("number"));
                row.getCell("position").setValue((Object)rowSet.getString("position.name"));
                row.getCell("orgunit").setValue((Object)rowSet.getString("adminOrgUnit.name"));
                row.getCell("role").setValue((Object)WorkFlowControlEnum.PRINCIPLE);
                row.getCell("email").setValue((Object)rowSet.getString("email"));
                row.getStyleAttributes().setLocked(true);
            }
            IRow row = this.personTable.addRow();
            row.getCell("id").setValue((Object)rowSet.getString("id"));
            row.getCell("name").setValue((Object)rowSet.getString("name"));
            row.getCell("number").setValue((Object)rowSet.getString("number"));
            row.getCell("position").setValue((Object)rowSet.getString("position.name"));
            row.getCell("orgunit").setValue((Object)rowSet.getString("adminOrgUnit.name"));
            row.getCell("role").setValue((Object)((WorkFlowControlEnum)((Object)this.personMap.get(rowSet.getString("id")))));
            row.getCell("email").setValue((Object)rowSet.getString("email"));
            row.getStyleAttributes().setLocked(true);
        }
    }

    private void showErrorMessage(String message) {
        String s = EASResource.getString((String)this.RES, (String)message);
        MsgBox.showError((Component)((Object)this), (String)s);
        this.setCursorOfDefault();
        SysUtil.abort();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        String asolutionPeriodID = (String)this.getUIContext().get("solutionPeriodID");
        String aevaluObjectID = (String)this.getUIContext().get("evaluObjectID");
        String aevaluObjectName = (String)this.getUIContext().get("evaluObjectName");
        req.put("asolutionPeriodID", (Object)asolutionPeriodID);
        req.put("aevaluObjectID", (Object)aevaluObjectID);
        req.put("aevaluObjectName", (Object)aevaluObjectName);
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

